/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal.tandem6530;

public class Position {
    protected int row;
    protected int col;
    protected boolean wrap;

    public Position(Position position) {
        this(position.getRow(), position.getCol(), false);
    }

    public Position(Position position, boolean bl) {
        this(position.getRow(), position.getCol(), bl);
    }

    public Position(int n, int n2) {
        this(n, n2, false);
    }

    public Position(int n, int n2, boolean bl) {
        this.wrap = bl;
        this.set(n, n2);
    }

    public Position set(Position position) {
        return this.set(position.getRow(), position.getCol());
    }

    public Position set(int n, int n2) {
        this.setRow(n);
        return this.setCol(n2);
    }

    public int getRow() {
        return this.row;
    }

    public Position setRow(int n) {
        this.row = n;
        return this;
    }

    public int getCol() {
        return this.col;
    }

    public Position setCol(int n) {
        this.col = n;
        return this;
    }

    public Position decCol(int n, int n2) {
        if (this.col - 1 < 0) {
            if (this.row - 1 < 0) {
                if (this.wrap) {
                    this.row = n - 1;
                    this.col = n2 - 1;
                } else {
                    this.row = 0;
                    this.col = 0;
                }
            } else {
                --this.row;
                this.col = n2 - 1;
            }
        } else {
            --this.col;
        }
        return this;
    }

    public Position incCol(int n, int n2) {
        if (this.col + 1 >= n2) {
            if (this.row + 1 >= n) {
                if (this.wrap) {
                    this.col = 0;
                    this.row = 0;
                } else {
                    this.col = n2 - 1;
                    this.row = n - 1;
                }
            } else {
                ++this.row;
                this.col = 0;
            }
        } else {
            ++this.col;
        }
        return this;
    }

    public Position decRow(int n, int n2) {
        --this.row;
        if (this.row < 0) {
            this.row = this.wrap ? n - 1 : 0;
        }
        return this;
    }

    public Position incRow(int n, int n2) {
        ++this.row;
        if (this.row >= n) {
            this.row = this.wrap ? 0 : n - 1;
        }
        return this;
    }

    public boolean lt(Position position) {
        if (this.getRow() < position.getRow()) {
            return true;
        }
        return this.getRow() == position.getRow() && this.getCol() < position.getCol();
    }

    public boolean le(Position position) {
        if (this.getRow() < position.getRow()) {
            return true;
        }
        return this.getRow() == position.getRow() && this.getCol() <= position.getCol();
    }

    public int abs(int n) {
        return this.row * n + this.col;
    }

    public boolean equals(Object object) {
        Position position = (Position)object;
        if (position == null) {
            return false;
        }
        return this.getRow() == position.getRow() && this.getCol() == position.getCol();
    }

    public void limit(int n, int n2) {
        if (this.row < 0) {
            this.row = 0;
        }
        if (this.row >= n) {
            this.row = n - 1;
        }
        if (this.col < 0) {
            this.col = 0;
        }
        if (this.col >= n2) {
            this.col = n2 - 1;
        }
    }

    public int hashcode() {
        return this.col ^ this.row;
    }

    public String toString() {
        return this.row + "," + this.col;
    }
}

