/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal;

import com.mindbright.gui.AWTConvenience;
import com.mindbright.gui.BorderDialog;
import com.mindbright.gui.TabPanel;
import com.mindbright.terminal.TerminalMenuHandlerFull;
import com.mindbright.terminal.TerminalOption;
import com.mindbright.terminal.TerminalWin;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class TerminalMenuHandlerFullAWT
extends TerminalMenuHandlerFull {
    private Menu vtOptionsMenu;
    private Component[] vtoptions;
    private TerminalOption[] toptions;
    private Choice choiceTE;
    private Choice choiceEN;
    private Choice choiceFN;
    private Choice choiceSB;
    private Choice choicePB;
    private Choice choiceFG;
    private Choice choiceBG;
    private Choice choiceCC;
    private TextField textFS;
    private TextField textRows;
    private TextField textCols;
    private TextField textInitPos;
    private TextField textSL;
    private TextField textSD;
    private TextField textFG;
    private TextField textBG;
    private TextField textCC;
    private Label lblAlert;
    private Checkbox checkIN;
    private TextField findText;
    private Checkbox dirCheck;
    private Checkbox caseCheck;
    private Button findBut;
    private Button cancBut;
    private PopupMenu popupMenu = null;

    protected void setEnabled(int n, int n2, boolean bl) {
        ((MenuItem)this.menuItems[n][n2]).setEnabled(bl);
    }

    protected void setState(int n, int n2, boolean bl) {
        ((CheckboxMenuItem)this.menuItems[n][n2]).setState(bl);
    }

    protected boolean getState(int n, int n2) {
        return ((CheckboxMenuItem)this.menuItems[n][n2]).getState();
    }

    protected void addBasicMenusInternal(Frame frame) {
        MenuBar menuBar = frame.getMenuBar();
        if (menuBar == null) {
            menuBar = new MenuBar();
            frame.setMenuBar(menuBar);
        }
        menuBar.add((Menu)this.getMenu(0));
        menuBar.add((Menu)this.getMenu(1));
        menuBar.add((Menu)this.getMenu(2));
        frame.addWindowListener(new AWTConvenience.CloseAdapter((MenuItem)this.menuItems[0][6]));
    }

    public Object getMenu(int n) {
        Menu menu = new Menu(TerminalMenuHandlerFull.menuTexts[n][0]);
        int n2 = TerminalMenuHandlerFull.menuTexts[n].length;
        if (this.menuItems == null) {
            this.menuItems = new MenuItem[TerminalMenuHandlerFull.menuTexts.length][];
        }
        if (this.menuItems[n] == null) {
            this.menuItems[n] = new MenuItem[TerminalMenuHandlerFull.menuTexts[n].length];
        }
        for (int i = 1; i < n2; ++i) {
            MenuItem menuItem;
            String string = TerminalMenuHandlerFull.menuTexts[n][i];
            if (string == null) {
                menu.addSeparator();
                continue;
            }
            if (string.charAt(0) == '_') {
                string = string.substring(1);
                menuItem = new CheckboxMenuItem(string);
                ((CheckboxMenuItem)menuItem).addItemListener(this);
            } else {
                menuItem = new MenuItem(string);
                menuItem.addActionListener(this);
            }
            if (TerminalMenuHandlerFull.menuShortCuts[n][i] != -1) {
                menuItem.setShortcut(new MenuShortcut(TerminalMenuHandlerFull.menuShortCuts[n][i], true));
            }
            this.menuItems[n][i] = menuItem;
            menu.add(menuItem);
        }
        return menu;
    }

    private static Component newColorChoice(String string, Choice choice, TextField textField) {
        Panel panel = new Panel(new BorderLayout(0, 2));
        Panel panel2 = new Panel(new FlowLayout(0, 5, 0));
        panel2.add(choice);
        panel2.add(textField);
        panel.add((Component)new Label(string), "North");
        panel.add((Component)panel2, "Center");
        return panel;
    }

    private Component getVTOptionsPanel(boolean bl) {
        int n;
        int n2;
        if (bl) {
            this.toptions = this.term.getOptions();
            this.vtoptions = new Component[this.toptions.length];
            n2 = 0;
            n = this.toptions.length / 2;
        } else {
            n2 = this.toptions.length / 2;
            n = this.toptions.length;
        }
        if (this.toptions == null || this.toptions.length == 0) {
            return null;
        }
        Panel panel = new Panel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        for (int i = n2; i < n; ++i) {
            String[] stringArray = this.toptions[i].getChoices();
            if (stringArray == null) {
                this.vtoptions[i] = new Checkbox(this.toptions[i].getDescription(), this.toptions[i].getValueB());
            } else {
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.fill = 2;
                panel.add((Component)new Label(this.toptions[i].getDescription(), 2), gridBagConstraints);
                this.vtoptions[i] = AWTConvenience.newChoice(stringArray);
                ((Choice)this.vtoptions[i]).select(this.toptions[i].getValue().toLowerCase());
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.fill = 0;
            }
            panel.add(this.vtoptions[i], gridBagConstraints);
        }
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        panel.add((Component)new Panel(), gridBagConstraints);
        return panel;
    }

    private void setVTOptions() {
        if (this.vtoptions == null) {
            return;
        }
        for (int i = 0; i < this.vtoptions.length; ++i) {
            String string = this.vtoptions[i] instanceof Choice ? ((Choice)this.vtoptions[i]).getSelectedItem() : (((Checkbox)this.vtoptions[i]).getState() ? "true" : "false");
            this.setProperty(this.toptions[i].getKey(), string);
        }
        this.vtoptions = null;
        this.toptions = null;
    }

    public void termSettingsDialog(String string) {
        final Dialog dialog = new Dialog(this.term.ownerFrame, string, true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        Panel panel = new Panel(new GridBagLayout());
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.weightx = 1.0;
        this.choiceTE = AWTConvenience.newChoice(TerminalMenuHandlerFull.TERMINAL_TYPES);
        panel.add((Component)new Label("Terminal type", 2), gridBagConstraints);
        panel.add((Component)this.choiceTE, gridBagConstraints2);
        this.textCols = new TextField("", 3);
        panel.add((Component)new Label("Columns", 2), gridBagConstraints);
        panel.add((Component)this.textCols, gridBagConstraints2);
        this.textRows = new TextField("", 3);
        panel.add((Component)new Label("Rows", 2), gridBagConstraints);
        panel.add((Component)this.textRows, gridBagConstraints2);
        this.choiceEN = AWTConvenience.newChoice(TerminalMenuHandlerFull.ENCODINGS);
        panel.add((Component)new Label("Encoding", 2), gridBagConstraints);
        panel.add((Component)this.choiceEN, gridBagConstraints2);
        this.choiceFN = AWTConvenience.newChoice(TerminalMenuHandlerFull.FONT_LIST);
        panel.add((Component)new Label("Font", 2), gridBagConstraints);
        panel.add((Component)this.choiceFN, gridBagConstraints2);
        this.textFS = new TextField("", 3);
        panel.add((Component)new Label("Size", 2), gridBagConstraints);
        panel.add((Component)this.textFS, gridBagConstraints2);
        this.textSL = new TextField("", 4);
        panel.add((Component)new Label("Scrollback buffer", 2), gridBagConstraints);
        panel.add((Component)this.textSL, gridBagConstraints2);
        this.choiceSB = AWTConvenience.newChoice(TerminalMenuHandlerFull.SCROLLBAR_POS);
        panel.add((Component)new Label("Scrollbar position", 2), gridBagConstraints);
        panel.add((Component)this.choiceSB, gridBagConstraints2);
        this.lblAlert = new Label("", 1);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.anchor = 10;
        panel.add((Component)this.lblAlert, gridBagConstraints3);
        TabPanel tabPanel = new TabPanel();
        tabPanel.add("General", panel);
        panel = new Panel(new GridBagLayout());
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.weighty = 0.0;
        gridBagConstraints3.gridwidth = 1;
        gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                TerminalMenuHandlerFullAWT.this.updateColors();
            }
        };
        this.choiceFG = new Choice();
        this.choiceFG.addItemListener(itemListener);
        this.textFG = new TextField("", 10);
        panel.add((Component)new Label("Foreground color", 2), gridBagConstraints3);
        panel.add((Component)this.choiceFG, gridBagConstraints3);
        gridBagConstraints3.gridwidth = 0;
        panel.add((Component)this.textFG, gridBagConstraints3);
        this.choiceBG = new Choice();
        this.choiceBG.addItemListener(itemListener);
        this.textBG = new TextField("", 10);
        gridBagConstraints3.gridwidth = 1;
        panel.add((Component)new Label("Background color", 2), gridBagConstraints3);
        panel.add((Component)this.choiceBG, gridBagConstraints3);
        gridBagConstraints3.gridwidth = 0;
        panel.add((Component)this.textBG, gridBagConstraints3);
        this.choiceCC = new Choice();
        this.choiceCC.addItemListener(itemListener);
        this.textCC = new TextField("", 10);
        gridBagConstraints3.gridwidth = 1;
        panel.add((Component)new Label("Cursor color", 2), gridBagConstraints3);
        panel.add((Component)this.choiceCC, gridBagConstraints3);
        gridBagConstraints3.gridwidth = 0;
        panel.add((Component)this.textCC, gridBagConstraints3);
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        panel.add((Component)new Label(""), gridBagConstraints3);
        tabPanel.add("Colors", panel);
        gridBagConstraints3 = new GridBagConstraints();
        panel = new Panel(new GridBagLayout());
        gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.gridwidth = 1;
        panel.add((Component)new Label("Paste button", 2), gridBagConstraints3);
        this.choicePB = AWTConvenience.newChoice(TerminalMenuHandlerFull.PASTE_BUTTON);
        gridBagConstraints3.gridwidth = 0;
        panel.add((Component)this.choicePB, gridBagConstraints3);
        gridBagConstraints3.gridwidth = 1;
        panel.add((Component)new Label("Select delim.", 2), gridBagConstraints3);
        this.textSD = new TextField("", 8);
        gridBagConstraints3.gridwidth = 0;
        panel.add((Component)this.textSD, gridBagConstraints3);
        gridBagConstraints3.gridwidth = 1;
        panel.add((Component)new Label(), gridBagConstraints3);
        this.checkIN = new Checkbox("Ignore null bytes", Boolean.valueOf(this.getProperty("ignore-null")));
        gridBagConstraints3.gridwidth = 0;
        panel.add((Component)this.checkIN, gridBagConstraints3);
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        panel.add((Component)new Label(""), gridBagConstraints3);
        tabPanel.add("Misc", panel);
        Component component = this.getVTOptionsPanel(true);
        if (component != null) {
            tabPanel.add("VT 1", component);
        }
        if ((component = this.getVTOptionsPanel(false)) != null) {
            tabPanel.add("VT 2", component);
        }
        dialog.add((Component)tabPanel, "Center");
        tabPanel.show("General");
        Button button = new Button("OK");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    TerminalMenuHandlerFullAWT.this.setVTOptions();
                    TerminalMenuHandlerFullAWT.this.setProperty("term-type", TerminalMenuHandlerFull.TERMINAL_TYPES[TerminalMenuHandlerFullAWT.this.choiceTE.getSelectedIndex()]);
                    TerminalMenuHandlerFullAWT.this.setProperty("encoding", TerminalMenuHandlerFull.ENCODINGS[TerminalMenuHandlerFullAWT.this.choiceEN.getSelectedIndex()]);
                    TerminalMenuHandlerFullAWT.this.setProperty("font-name", TerminalMenuHandlerFull.FONT_LIST[TerminalMenuHandlerFullAWT.this.choiceFN.getSelectedIndex()]);
                    TerminalMenuHandlerFullAWT.this.setProperty("font-size", TerminalMenuHandlerFullAWT.this.textFS.getText());
                    TerminalMenuHandlerFullAWT.this.setProperty("scrollbar", TerminalMenuHandlerFull.SCROLLBAR_POS[TerminalMenuHandlerFullAWT.this.choiceSB.getSelectedIndex()]);
                    TerminalMenuHandlerFullAWT.this.setProperty("save-lines", TerminalMenuHandlerFullAWT.this.textSL.getText());
                    TerminalMenuHandlerFullAWT.this.setProperty("geometry", TerminalMenuHandlerFullAWT.this.textCols.getText() + "x" + TerminalMenuHandlerFullAWT.this.textRows.getText());
                    TerminalMenuHandlerFullAWT.this.setProperty("paste-button", TerminalMenuHandlerFull.PASTE_BUTTON[TerminalMenuHandlerFullAWT.this.choicePB.getSelectedIndex()]);
                    TerminalMenuHandlerFullAWT.this.setProperty("select-delim", TerminalMenuHandlerFullAWT.this.textSD.getText());
                    TerminalMenuHandlerFullAWT.this.setProperty("ignore-null", new Boolean(TerminalMenuHandlerFullAWT.this.checkIN.getState()).toString());
                    TerminalMenuHandlerFullAWT.this.setProperty("fg-color", TerminalMenuHandlerFullAWT.getSelectedColor(TerminalMenuHandlerFullAWT.this.choiceFG, TerminalMenuHandlerFullAWT.this.textFG));
                    TerminalMenuHandlerFullAWT.this.setProperty("bg-color", TerminalMenuHandlerFullAWT.getSelectedColor(TerminalMenuHandlerFullAWT.this.choiceBG, TerminalMenuHandlerFullAWT.this.textBG));
                    TerminalMenuHandlerFullAWT.this.setProperty("cursor-color", TerminalMenuHandlerFullAWT.getSelectedColor(TerminalMenuHandlerFullAWT.this.choiceCC, TerminalMenuHandlerFullAWT.this.textCC));
                    dialog.dispose();
                }
                catch (Exception exception) {
                    TerminalMenuHandlerFullAWT.this.lblAlert.setText(exception.getMessage());
                }
            }
        });
        Button button2 = new Button("Cancel");
        button2.addActionListener(new AWTConvenience.CloseAction(dialog));
        Panel panel2 = AWTConvenience.newButtonPanel(new Component[]{button, button2});
        dialog.add((Component)panel2, "South");
        dialog.addWindowListener(new AWTConvenience.CloseAdapter(button2));
        AWTConvenience.setBackgroundOfChildren(dialog);
        this.choiceTE.select(this.getProperty("term-type"));
        this.choiceEN.select(this.getProperty("encoding"));
        this.choiceFN.select(this.getProperty("font-name"));
        this.textFS.setText(this.getProperty("font-size"));
        this.textCols.setText(String.valueOf(this.term.cols()));
        this.textRows.setText(String.valueOf(this.term.rows()));
        this.choiceSB.select(this.getProperty("scrollbar"));
        this.textSL.setText(this.getProperty("save-lines"));
        this.choicePB.select(this.getProperty("paste-button"));
        String string2 = this.getProperty("select-delim");
        if (string2.charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"') {
            string2 = string2.substring(1, string2.length() - 1);
        }
        this.textSD.setText(string2);
        this.choiceBG.add("custom rgb");
        this.choiceFG.add("custom rgb");
        this.choiceCC.add("custom rgb");
        for (int i = 0; i < TerminalWin.termColorNames.length; ++i) {
            this.choiceBG.add(TerminalWin.termColorNames[i]);
            this.choiceFG.add(TerminalWin.termColorNames[i]);
            this.choiceCC.add(TerminalWin.termColorNames[i]);
        }
        TerminalMenuHandlerFullAWT.initColorSelect(this.choiceFG, this.textFG, this.getProperty("fg-color"));
        TerminalMenuHandlerFullAWT.initColorSelect(this.choiceBG, this.textBG, this.getProperty("bg-color"));
        TerminalMenuHandlerFullAWT.initColorSelect(this.choiceCC, this.textCC, this.getProperty("cursor-color"));
        this.updateColors();
        this.lblAlert.setText("");
        dialog.setResizable(true);
        dialog.pack();
        AWTConvenience.placeDialog(dialog);
        this.choiceTE.requestFocus();
        ((Component)dialog).setVisible(true);
    }

    private static void initColorSelect(Choice choice, TextField textField, String string) {
        if (Character.isDigit(string.charAt(0))) {
            choice.select("custom rgb");
            textField.setText(string);
        } else {
            textField.setText("");
            textField.setEnabled(false);
            choice.select(string);
        }
    }

    private static void checkColorSelect(Choice choice, TextField textField) {
        int n = choice.getSelectedIndex();
        if (n == 0) {
            if (!textField.isEnabled()) {
                textField.setEditable(true);
                textField.setEnabled(true);
                textField.setBackground(SystemColor.text);
                textField.requestFocus();
            }
        } else {
            textField.setText("");
            textField.setEditable(false);
            textField.setEnabled(false);
            textField.setBackground(TerminalWin.termColors[n - 1]);
        }
    }

    private void updateColors() {
        TerminalMenuHandlerFullAWT.checkColorSelect(this.choiceFG, this.textFG);
        TerminalMenuHandlerFullAWT.checkColorSelect(this.choiceBG, this.textBG);
        TerminalMenuHandlerFullAWT.checkColorSelect(this.choiceCC, this.textCC);
    }

    private static String getSelectedColor(Choice choice, TextField textField) {
        return choice.getSelectedIndex() == 0 ? textField.getText() : choice.getSelectedItem();
    }

    public final void findDialog(String string) {
        this.lastSearch = null;
        BorderDialog borderDialog = new BorderDialog(this.term.ownerFrame, string, false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        borderDialog.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 0;
        Label label = new Label("Find");
        borderDialog.add((Component)label, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 5;
        this.findText = new TextField("", 26);
        borderDialog.add((Component)this.findText, gridBagConstraints);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.insets = new Insets(6, 3, 3, 6);
        this.findBut = new Button("Find");
        borderDialog.add((Component)this.findBut, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        this.caseCheck = new Checkbox("Case sensitive");
        borderDialog.add((Component)this.caseCheck, gridBagConstraints);
        this.dirCheck = new Checkbox("Find backwards");
        borderDialog.add((Component)this.dirCheck, gridBagConstraints);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.insets = new Insets(3, 3, 6, 6);
        gridBagConstraints.fill = 2;
        this.cancBut = new Button("Cancel");
        borderDialog.add((Component)this.cancBut, gridBagConstraints);
        this.cancBut.addActionListener(new AWTConvenience.CloseAction(borderDialog));
        this.findBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = TerminalMenuHandlerFullAWT.this.findText.getText();
                if (string != null && string.length() > 0) {
                    TerminalMenuHandlerFullAWT.this.doFind(string, TerminalMenuHandlerFullAWT.this.caseCheck.getState(), TerminalMenuHandlerFullAWT.this.dirCheck.getState());
                }
            }
        });
        borderDialog.addWindowListener(new AWTConvenience.CloseAdapter(this.cancBut));
        AWTConvenience.setBackgroundOfChildren(borderDialog);
        AWTConvenience.setKeyListenerOfChildren(borderDialog, new AWTConvenience.OKCancelAdapter(this.findBut, this.cancBut), null);
        borderDialog.setResizable(true);
        borderDialog.pack();
        AWTConvenience.placeDialog(borderDialog);
        this.findText.requestFocus();
        ((Component)borderDialog).setVisible(true);
    }

    public void setPopupMenu(Object object) {
        this.popupMenu = (PopupMenu)object;
        this.term.getDisplay().getAWTComponent().add(this.popupMenu);
    }

    public void showPopupMenu(int n, int n2) {
        if (this.popupMenu != null) {
            this.popupMenu.show(this.term.getDisplay().getAWTComponent(), n, n2);
        }
    }
}

