/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.jce.crypto.Cipher;
import com.mindbright.jce.crypto.Mac;
import com.mindbright.jce.crypto.ShortBufferException;
import com.mindbright.ssh2.SSH2CompressionException;
import com.mindbright.ssh2.SSH2Compressor;
import com.mindbright.ssh2.SSH2CorruptPacketException;
import com.mindbright.ssh2.SSH2DataBuffer;
import com.mindbright.ssh2.SSH2EOFException;
import com.mindbright.ssh2.SSH2Exception;
import com.mindbright.ssh2.SSH2MacCheckException;
import com.mindbright.ssh2.SSH2Transport;
import com.mindbright.ssh2.SSH2TransportPDUPool;
import com.mindbright.util.SecureRandomAndPad;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SSH2TransportPDU
extends SSH2DataBuffer {
    public static final int PACKET_DEFAULT_SIZE = 256;
    public static final int PACKET_MIN_SIZE = 16;
    public static final int PACKET_MAX_SIZE = 35000;
    public static int pktDefaultSize = 256;
    public static SSH2TransportPDU factoryInstance = new SSH2TransportPDUPool();
    byte[] macTmpBuf;
    protected int pktSize;
    protected int padSize;
    protected int pktType;

    protected SSH2TransportPDU() {
    }

    protected SSH2TransportPDU(int n, int n2) {
        super(n2);
        this.pktType = n;
        this.pktSize = 0;
        this.padSize = 0;
        this.macTmpBuf = new byte[128];
    }

    protected SSH2TransportPDU createPDU(int n) {
        return this.createPDU(0, n);
    }

    protected SSH2TransportPDU createPDU(int n, int n2) {
        return new SSH2TransportPDU(n, n2);
    }

    public static final void setFactoryInstance(SSH2TransportPDU sSH2TransportPDU) {
        factoryInstance = sSH2TransportPDU;
    }

    public static final SSH2TransportPDU createIncomingPacket(int n) {
        return factoryInstance.createPDU(n);
    }

    public static final SSH2TransportPDU createIncomingPacket() {
        return SSH2TransportPDU.createIncomingPacket(pktDefaultSize);
    }

    public static final SSH2TransportPDU createOutgoingPacket(int n, int n2) {
        SSH2TransportPDU sSH2TransportPDU = factoryInstance.createPDU(n, n2);
        sSH2TransportPDU.writeInt(0);
        sSH2TransportPDU.writeInt(0);
        sSH2TransportPDU.writeByte(0);
        sSH2TransportPDU.writeByte(n);
        return sSH2TransportPDU;
    }

    public static final SSH2TransportPDU createOutgoingPacket(int n) {
        return SSH2TransportPDU.createOutgoingPacket(n, pktDefaultSize);
    }

    public static final SSH2Transport.TranceiverContext createTranceiverContext(String string, String string2, String string3) throws Exception {
        return factoryInstance.createTranceiverContextImpl(string, string2, string3);
    }

    public void release() {
    }

    public SSH2TransportPDU makeCopy() {
        SSH2TransportPDU sSH2TransportPDU = factoryInstance.createPDU(this.pktType, this.data.length);
        System.arraycopy(this.data, 0, sSH2TransportPDU.data, 0, this.data.length);
        sSH2TransportPDU.pktSize = this.pktSize;
        sSH2TransportPDU.padSize = this.padSize;
        sSH2TransportPDU.rPos = this.rPos;
        sSH2TransportPDU.wPos = this.wPos;
        return sSH2TransportPDU;
    }

    public int getType() {
        return this.pktType;
    }

    public void setType(int n) {
        this.pktType = n;
    }

    public int getPayloadLength() {
        int n = this.pktSize == 0 ? this.wPos - this.getPayloadOffset() : this.pktSize - this.padSize - 1;
        return n;
    }

    public int getPayloadOffset() {
        return 9;
    }

    public void readFrom(InputStream inputStream, int n, SSH2Transport.TranceiverContext tranceiverContext) throws IOException, SSH2Exception, ShortBufferException {
        int n2;
        this.writeInt(n);
        this.rPos = 4;
        int n3 = 8;
        int n4 = 0;
        if (tranceiverContext.cipher != null) {
            n3 = tranceiverContext.cipher.getBlockSize();
            n3 = n3 > 8 ? n3 : 8;
            this.readNextNFrom(inputStream, n3);
            tranceiverContext.cipher.doFinal(this.data, 4, n3, this.data, 4);
        } else {
            this.readNextNFrom(inputStream, 8);
        }
        n3 -= 4;
        this.pktSize = this.readInt();
        if (tranceiverContext.mac != null) {
            n4 = tranceiverContext.mac.getMacLength();
        }
        if ((n2 = this.pktSize + 4 + n4) > 35000 || n2 < 16) {
            throw new SSH2CorruptPacketException("Invalid packet size: " + this.pktSize);
        }
        this.readNextNFrom(inputStream, this.pktSize - n3);
        if (tranceiverContext.cipher != null) {
            tranceiverContext.cipher.doFinal(this.data, 8 + n3, this.pktSize - n3, this.data, 8 + n3);
        }
        if (tranceiverContext.mac != null) {
            this.readNextNFrom(inputStream, n4);
            this.checkMac(tranceiverContext.mac, n4);
        }
        this.padSize = this.readByte();
        if (tranceiverContext.compressor != null) {
            this.pktSize = tranceiverContext.compressor.uncompress(this, this.pktSize - this.padSize - 1);
            this.pktSize += this.padSize + 1;
        }
        this.pktType = this.readByte();
    }

    protected void checkMac(Mac mac, int n) throws SSH2MacCheckException, ShortBufferException {
        mac.update(this.data, 0, 8 + this.pktSize);
        try {
            mac.doFinal(this.macTmpBuf, 0);
        }
        catch (ShortBufferException shortBufferException) {
            throw new ShortBufferException(shortBufferException.getMessage() + " tmp " + this.macTmpBuf.length);
        }
        int n2 = 8 + this.pktSize;
        for (int i = 0; i < n; ++i) {
            if (this.macTmpBuf[i] == this.data[n2++]) continue;
            throw new SSH2MacCheckException("MAC check failed");
        }
    }

    private void ensureSize(int n) {
        if (this.data.length - this.wPos < n) {
            byte[] byArray = this.data;
            int n2 = this.wPos + n < 1024 && this.wPos + n < this.data.length * 2 ? this.data.length * 2 : this.wPos + n + 1024;
            this.data = new byte[n2];
            System.arraycopy(byArray, 0, this.data, 0, byArray.length);
        }
    }

    protected final void readNextNFrom(InputStream inputStream, int n) throws IOException, SSH2EOFException {
        this.ensureSize(n);
        n += this.wPos;
        while (this.wPos < n) {
            int n2 = inputStream.read(this.data, this.wPos, n - this.wPos);
            if (n2 == -1) {
                throw new SSH2EOFException("Server closed connection");
            }
            this.wPos += n2;
        }
    }

    public final void writeByte(int n) {
        this.ensureSize(1);
        this.data[this.wPos++] = (byte)n;
    }

    public final void writeString(byte[] byArray, int n, int n2) {
        this.ensureSize(n2 + 4);
        super.writeString(byArray, n, n2);
    }

    public final void writeRaw(byte[] byArray, int n, int n2) {
        this.ensureSize(n2);
        super.writeRaw(byArray, n, n2);
    }

    public void writeTo(OutputStream outputStream, int n, SSH2Transport.TranceiverContext tranceiverContext, SecureRandomAndPad secureRandomAndPad) throws IOException, ShortBufferException, SSH2CompressionException {
        int n2 = 0;
        int n3 = 8;
        if (tranceiverContext.compressor != null) {
            tranceiverContext.compressor.compress(this);
        }
        if (tranceiverContext.cipher != null) {
            n3 = tranceiverContext.cipher.getBlockSize();
            n3 = n3 > 8 ? n3 : 8;
        }
        this.padSize = n3 - (this.wPos - 4) % n3;
        if (this.padSize < 4) {
            this.padSize += n3;
        }
        this.pktSize = this.wPos + this.padSize - 8;
        this.ensureSize(this.pktSize + 4);
        secureRandomAndPad.nextPadBytes(this.data, this.wPos, this.padSize);
        this.wPos = 0;
        this.writeInt(n);
        this.writeInt(this.pktSize);
        this.writeByte(this.padSize);
        int n4 = this.pktSize + 4;
        if (tranceiverContext.mac != null) {
            int n5 = 4 + n4;
            this.ensureSize(n5 + tranceiverContext.mac.getMacLength());
            tranceiverContext.mac.update(this.data, 0, n5);
            try {
                tranceiverContext.mac.doFinal(this.data, n5);
            }
            catch (ShortBufferException shortBufferException) {
                throw new ShortBufferException(shortBufferException.getMessage() + " data " + this.data.length + " " + n5);
            }
            n2 = tranceiverContext.mac.getMacLength();
        }
        if (tranceiverContext.cipher != null) {
            tranceiverContext.cipher.doFinal(this.data, 4, n4, this.data, 4);
        }
        outputStream.write(this.data, 4, n4 + n2);
        this.release();
    }

    public String toString() {
        return "pdu: buf-sz = " + this.data.length + ", rPos = " + this.rPos + ", wPos = " + this.wPos + ", pktSize = " + this.pktSize + ", padSize = " + this.padSize + ", pktType = " + this.pktType;
    }

    public SSH2Transport.TranceiverContext createTranceiverContextImpl(String string, String string2, String string3) throws Exception {
        SSH2Transport.TranceiverContext tranceiverContext = new SSH2Transport.TranceiverContext();
        if (!"none".equals(string)) {
            tranceiverContext.cipher = Cipher.getInstance(string);
        }
        if (!"none".equals(string2)) {
            tranceiverContext.mac = Mac.getInstance(string2);
        }
        if (!"none".equals(string3)) {
            tranceiverContext.compressor = SSH2Compressor.getInstance(string3);
        }
        return tranceiverContext;
    }
}

