/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.jca.security.SecureRandom;
import com.mindbright.ssh2.SSH2;
import com.mindbright.ssh2.SSH2Channel;
import com.mindbright.ssh2.SSH2ConnectionEventAdapter;
import com.mindbright.ssh2.SSH2ConnectionEventHandler;
import com.mindbright.ssh2.SSH2Connector;
import com.mindbright.ssh2.SSH2InternalChannel;
import com.mindbright.ssh2.SSH2Listener;
import com.mindbright.ssh2.SSH2Preferences;
import com.mindbright.ssh2.SSH2SessionChannel;
import com.mindbright.ssh2.SSH2StreamFilterFactory;
import com.mindbright.ssh2.SSH2TerminalAdapter;
import com.mindbright.ssh2.SSH2Transport;
import com.mindbright.ssh2.SSH2TransportPDU;
import com.mindbright.ssh2.SSH2UserAuth;
import com.mindbright.util.Log;
import com.mindbright.util.SecureRandomAndPad;
import java.io.IOException;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class SSH2Connection
implements Runnable {
    public static final int MAX_ACTIVE_CHANNELS = 1024;
    public static final String GL_REQ_START_FORWARD = "tcpip-forward";
    public static final String GL_REQ_CANCEL_FORWARD = "cancel-tcpip-forward";
    public static final String CH_REQ_PTY = "pty-req";
    public static final String CH_REQ_X11 = "x11-req";
    public static final String CH_REQ_ENV = "env";
    public static final String CH_REQ_SHELL = "shell";
    public static final String CH_REQ_EXEC = "exec";
    public static final String CH_REQ_SUBSYSTEM = "subsystem";
    public static final String CH_REQ_WINCH = "window-change";
    public static final String CH_REQ_XONOFF = "xon-xoff";
    public static final String CH_REQ_SIGNAL = "signal";
    public static final String CH_REQ_EXIT_STAT = "exit-status";
    public static final String CH_REQ_EXIT_SIG = "exit-signal";
    public static final String CH_REQ_AUTH_AGENT = "auth-agent-req";
    public static final String CH_REQ_AUTH_AGENT1 = "auth-ssh1-agent-req";
    public static final String CH_REQ_BREAK = "break";
    public static final String CH_REQ_OPENSSH_KEEPALIVE = "keepalive@openssh.com";
    public static final String CHAN_FORWARDED_TCPIP = "forwarded-tcpip";
    public static final String CHAN_DIRECT_TCPIP = "direct-tcpip";
    public static final String CHAN_SESSION = "session";
    public static final String CHAN_X11 = "x11";
    public static final String CHAN_AUTH_AGENT = "auth-agent";
    public static final int CH_TYPE_FWD_TCPIP = 0;
    public static final int CH_TYPE_DIR_TCPIP = 1;
    public static final int CH_TYPE_SESSION = 2;
    public static final int CH_TYPE_X11 = 3;
    public static final int CH_TYPE_AUTH_AGENT = 4;
    static final String[] channelTypes = new String[]{"forwarded-tcpip", "direct-tcpip", "session", "x11", "auth-agent"};
    private SSH2Transport transport;
    private SSH2UserAuth userAuth;
    private SSH2ConnectionEventHandler eventHandler;
    private SSH2Channel[] channels;
    private int totalChannels;
    private int nextEmptyChan;
    private SSH2Connector connector;
    private Hashtable remoteForwards;
    private Hashtable remoteFilters;
    private Hashtable localForwards;
    private byte[] x11RealCookie;
    private byte[] x11FakeCookie;
    private boolean x11Single;
    private int x11Mappings;
    private Object reqMonitor;
    private boolean reqStatus;
    private Log connLog;
    private Vector life;
    private volatile boolean reaperActive;

    public SSH2Connection(SSH2UserAuth sSH2UserAuth, SSH2Transport sSH2Transport) {
        this(sSH2UserAuth, sSH2Transport, null);
    }

    public SSH2Connection(SSH2UserAuth sSH2UserAuth, SSH2Transport sSH2Transport, SSH2ConnectionEventHandler sSH2ConnectionEventHandler) {
        this.userAuth = sSH2UserAuth;
        this.transport = sSH2Transport;
        this.eventHandler = sSH2ConnectionEventHandler != null ? sSH2ConnectionEventHandler : new SSH2ConnectionEventAdapter();
        this.channels = new SSH2Channel[64];
        this.totalChannels = 0;
        this.nextEmptyChan = 0;
        this.remoteForwards = new Hashtable();
        this.remoteFilters = new Hashtable();
        this.localForwards = new Hashtable();
        this.x11RealCookie = null;
        this.x11FakeCookie = null;
        this.x11Single = false;
        this.x11Mappings = 0;
        this.connLog = sSH2Transport.getLog();
        this.reqMonitor = new Object();
        if (sSH2Transport.incompatibleBuggyChannelClose) {
            this.startChannelReaper();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processGlobalMessage(SSH2TransportPDU sSH2TransportPDU) {
        switch (sSH2TransportPDU.pktType) {
            case 80: {
                String string = sSH2TransportPDU.readJavaString();
                boolean bl = sSH2TransportPDU.readBoolean();
                if (string.equals(GL_REQ_START_FORWARD) || !string.equals(GL_REQ_CANCEL_FORWARD)) break;
                break;
            }
            case 81: {
                Object object = this.reqMonitor;
                synchronized (object) {
                    this.reqStatus = true;
                    this.reqMonitor.notify();
                    break;
                }
            }
            case 82: {
                Object object = this.reqMonitor;
                synchronized (object) {
                    this.reqStatus = false;
                    this.reqMonitor.notify();
                    break;
                }
            }
            case 90: {
                this.getConnector().channelOpen(sSH2TransportPDU);
                sSH2TransportPDU = null;
            }
        }
        if (sSH2TransportPDU != null) {
            sSH2TransportPDU.release();
        }
    }

    void processChannelMessage(SSH2TransportPDU sSH2TransportPDU) {
        int n = sSH2TransportPDU.readInt();
        SSH2Channel sSH2Channel = this.channels[n];
        if (sSH2Channel == null) {
            String string = "Error, received message to non-existent channel";
            this.connLog.error("SSH2Connection", "processChannelMessage", string);
            this.connLog.debug2("SSH2Connection", "processChannelMessage", "got message of type: " + SSH2.msgTypeString(sSH2TransportPDU.pktType), sSH2TransportPDU.getData(), sSH2TransportPDU.getPayloadOffset(), sSH2TransportPDU.getPayloadLength());
            if (!this.transport.incompatibleMayReceiveDataAfterClose) {
                this.fatalDisconnect(2, string);
            }
            return;
        }
        switch (sSH2TransportPDU.pktType) {
            case 91: {
                sSH2Channel.openConfirmation(sSH2TransportPDU);
                break;
            }
            case 92: {
                String string;
                String string2;
                int n2 = sSH2TransportPDU.readInt();
                if (this.transport.incompatibleChannelOpenFail) {
                    string2 = "";
                    string = "";
                } else {
                    string2 = sSH2TransportPDU.readJavaString();
                    string = sSH2TransportPDU.readJavaString();
                }
                sSH2Channel.openFailure(n2, string2, string);
                break;
            }
            case 93: {
                sSH2Channel.windowAdjust(sSH2TransportPDU);
                break;
            }
            case 94: {
                sSH2Channel.data(sSH2TransportPDU);
                sSH2TransportPDU = null;
                break;
            }
            case 95: {
                sSH2Channel.extData(sSH2TransportPDU);
                sSH2TransportPDU = null;
                break;
            }
            case 96: {
                sSH2Channel.recvEOF();
                break;
            }
            case 97: {
                sSH2Channel.recvClose();
                break;
            }
            case 98: {
                sSH2Channel.handleRequest(sSH2TransportPDU);
                break;
            }
            case 99: {
                sSH2Channel.requestSuccess(sSH2TransportPDU);
                break;
            }
            case 100: {
                sSH2Channel.requestFailure(sSH2TransportPDU);
            }
        }
        if (sSH2TransportPDU != null) {
            sSH2TransportPDU.release();
        }
    }

    public SSH2Transport getTransport() {
        return this.transport;
    }

    public void setEventHandler(SSH2ConnectionEventHandler sSH2ConnectionEventHandler) {
        if (sSH2ConnectionEventHandler != null) {
            this.eventHandler = sSH2ConnectionEventHandler;
        }
    }

    public SSH2ConnectionEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public SSH2Preferences getPreferences() {
        return this.transport.getOurPreferences();
    }

    public Log getLog() {
        return this.connLog;
    }

    public void setLog(Log log) {
        this.connLog = log;
    }

    public SecureRandom getSecureRandom() {
        return this.transport.getSecureRandom();
    }

    public void transmit(SSH2TransportPDU sSH2TransportPDU) {
        this.transport.transmit(sSH2TransportPDU);
    }

    public void fatalDisconnect(int n, String string) {
        this.transport.fatalDisconnect(n, string);
    }

    public SSH2Connector getConnector() {
        if (this.connector == null) {
            this.connector = new SSH2Connector(this);
        }
        return this.connector;
    }

    public synchronized String[] getForwardTarget(String string, int n) {
        String[] stringArray = null;
        String string2 = (String)this.remoteForwards.get(string + ":" + n);
        if (string2 != null) {
            stringArray = new String[2];
            int n2 = string2.indexOf(":");
            stringArray[0] = string2.substring(0, n2);
            stringArray[1] = string2.substring(n2 + 1);
        }
        return stringArray;
    }

    public synchronized SSH2StreamFilterFactory getForwardFilterFactory(String string, int n) {
        return (SSH2StreamFilterFactory)this.remoteFilters.get(string + ":" + n);
    }

    public synchronized SSH2Listener getLocalListener(String string, int n) {
        return (SSH2Listener)this.localForwards.get(string + ":" + n);
    }

    public synchronized void newRemoteForward(String string, int n, String string2, int n2) {
        this.newRemoteForward(string, n, string2, n2, null);
    }

    public synchronized void newRemoteForward(String string, int n, String string2, int n2, SSH2StreamFilterFactory sSH2StreamFilterFactory) {
        this.newRemoteForward(string, n, string2, n2, sSH2StreamFilterFactory, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean newRemoteForwardBlocking(String string, int n, String string2, int n2, SSH2StreamFilterFactory sSH2StreamFilterFactory) {
        Object object = this.reqMonitor;
        synchronized (object) {
            this.newRemoteForward(string, n, string2, n2, sSH2StreamFilterFactory, true);
            try {
                this.reqMonitor.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.reqStatus;
        }
    }

    private synchronized void newRemoteForward(String string, int n, String string2, int n2, SSH2StreamFilterFactory sSH2StreamFilterFactory, boolean bl) {
        this.connLog.debug("SSH2Connection", "newRemoteForward", string + ":" + n + "->" + string2 + ":" + n2);
        this.remoteForwards.put(string + ":" + n, string2 + ":" + n2);
        if (sSH2StreamFilterFactory != null) {
            this.remoteFilters.put(string + ":" + n, sSH2StreamFilterFactory);
        }
        SSH2TransportPDU sSH2TransportPDU = SSH2TransportPDU.createOutgoingPacket(80);
        sSH2TransportPDU.writeString(GL_REQ_START_FORWARD);
        sSH2TransportPDU.writeBoolean(bl);
        sSH2TransportPDU.writeString(string);
        sSH2TransportPDU.writeInt(n);
        this.transport.transmit(sSH2TransportPDU);
    }

    public synchronized void deleteRemoteForward(String string, int n) {
        this.connLog.debug("SSH2Connection", "deleteRemoteForward", string + ":" + n);
        String string2 = (String)this.remoteForwards.get(string + ":" + n);
        if (string2 != null) {
            SSH2TransportPDU sSH2TransportPDU = SSH2TransportPDU.createOutgoingPacket(80);
            sSH2TransportPDU.writeString(GL_REQ_CANCEL_FORWARD);
            sSH2TransportPDU.writeBoolean(true);
            sSH2TransportPDU.writeString(string);
            sSH2TransportPDU.writeInt(n);
            this.transport.transmit(sSH2TransportPDU);
            this.remoteForwards.remove(string + ":" + n);
        }
    }

    public synchronized SSH2Listener newLocalForward(String string, int n, String string2, int n2) throws IOException {
        return this.newLocalForward(string, n, string2, n2, null);
    }

    public synchronized SSH2Listener newLocalForward(String string, int n, String string2, int n2, SSH2StreamFilterFactory sSH2StreamFilterFactory) throws IOException {
        this.connLog.debug("SSH2Connection", "newLocalForward", string + ":" + n + "->" + string2 + ":" + n2);
        SSH2Listener sSH2Listener = new SSH2Listener(string, n, string2, n2, this, sSH2StreamFilterFactory);
        this.localForwards.put(string + ":" + n, sSH2Listener);
        return sSH2Listener;
    }

    public synchronized SSH2InternalChannel newLocalInternalForward(String string, int n) {
        return this.newLocalInternalForward(string, n, null);
    }

    public synchronized SSH2InternalChannel newLocalInternalForward(String string, int n, SSH2StreamFilterFactory sSH2StreamFilterFactory) {
        this.connLog.debug("SSH2Connection", "newLocalInternalForward", "->" + string + ":" + n);
        SSH2InternalChannel sSH2InternalChannel = new SSH2InternalChannel(1, this);
        if (sSH2StreamFilterFactory != null) {
            sSH2InternalChannel.applyFilter(sSH2StreamFilterFactory.createFilter(this, sSH2InternalChannel));
        }
        this.connectLocalChannel(sSH2InternalChannel, string, n, "127.0.0.1", n);
        return sSH2InternalChannel;
    }

    public synchronized void deleteLocalForward(String string, int n) {
        this.connLog.debug("SSH2Connection", "deleteLocalForward", string + ":" + n);
        SSH2Listener sSH2Listener = (SSH2Listener)this.localForwards.get(string + ":" + n);
        if (sSH2Listener != null) {
            sSH2Listener.stop();
            this.localForwards.remove(string + ":" + n);
        }
    }

    public synchronized SSH2SessionChannel newSession() {
        return this.newSession(null);
    }

    public synchronized SSH2SessionChannel newSession(SSH2StreamFilterFactory sSH2StreamFilterFactory) {
        if (!this.transport.isConnected()) {
            return null;
        }
        SSH2SessionChannel sSH2SessionChannel = new SSH2SessionChannel(this);
        if (sSH2StreamFilterFactory != null) {
            sSH2SessionChannel.applyFilter(sSH2StreamFilterFactory.createFilter(this, sSH2SessionChannel));
        }
        SSH2TransportPDU sSH2TransportPDU = this.getChannelOpenPDU(sSH2SessionChannel);
        this.transmit(sSH2TransportPDU);
        return sSH2SessionChannel;
    }

    public synchronized SSH2SessionChannel newTerminal(SSH2TerminalAdapter sSH2TerminalAdapter) {
        if (!this.transport.isConnected()) {
            return null;
        }
        SSH2SessionChannel sSH2SessionChannel = new SSH2SessionChannel(this);
        SSH2TransportPDU sSH2TransportPDU = this.getChannelOpenPDU(sSH2SessionChannel);
        sSH2TerminalAdapter.attach(sSH2SessionChannel);
        this.transmit(sSH2TransportPDU);
        return sSH2SessionChannel;
    }

    public void setSocketOptions(String string, Socket socket) throws IOException {
        this.transport.setSocketOptions(string, socket);
    }

    synchronized boolean hasX11Mapping() {
        boolean bl;
        boolean bl2 = bl = this.x11Mappings > 0;
        if (this.x11Single) {
            --this.x11Mappings;
        }
        return bl;
    }

    synchronized void setX11Mapping(boolean bl) {
        this.x11Single = bl;
        ++this.x11Mappings;
    }

    synchronized void clearX11Mapping() {
        if (this.x11Mappings > 0) {
            --this.x11Mappings;
        }
    }

    byte[] getX11FakeCookie() {
        if (this.x11FakeCookie == null) {
            this.x11FakeCookie = new byte[16];
            SecureRandomAndPad secureRandomAndPad = (SecureRandomAndPad)this.transport.getSecureRandom();
            secureRandomAndPad.nextPadBytes(this.x11FakeCookie, 0, 16);
        }
        return this.x11FakeCookie;
    }

    void setX11RealCookie(byte[] byArray) {
        this.x11RealCookie = byArray;
    }

    byte[] getX11RealCookie() {
        if (this.x11RealCookie == null) {
            this.x11RealCookie = this.getX11FakeCookie();
        }
        return this.x11RealCookie;
    }

    synchronized void terminate() {
        if (this.connector != null) {
            this.connector.stop();
        }
        Enumeration enumeration = this.localForwards.elements();
        while (enumeration.hasMoreElements()) {
            ((SSH2Listener)enumeration.nextElement()).stop();
        }
        for (int i = 0; i < this.channels.length; ++i) {
            if (this.channels[i] == null) continue;
            this.channels[i].close();
            this.channels[i] = null;
        }
        if (this.reaperActive) {
            this.stopChannelReaper();
        }
    }

    synchronized void addChannel(SSH2Channel sSH2Channel) {
        int n = this.nextEmptyChan;
        if (this.nextEmptyChan < this.channels.length) {
            int n2;
            for (n2 = this.nextEmptyChan + 1; n2 < this.channels.length && this.channels[n2] != null; ++n2) {
            }
            this.nextEmptyChan = n2;
        } else {
            if (this.channels.length + 16 > 1024) {
                this.fatalDisconnect(12, "Number of channels exceeded maximum");
                return;
            }
            SSH2Channel[] sSH2ChannelArray = new SSH2Channel[this.channels.length + 16];
            System.arraycopy(this.channels, 0, sSH2ChannelArray, 0, this.channels.length);
            this.channels = sSH2ChannelArray;
            ++this.nextEmptyChan;
        }
        sSH2Channel.channelId = n;
        this.channels[n] = sSH2Channel;
        ++this.totalChannels;
        this.eventHandler.channelAdded(this, sSH2Channel);
    }

    synchronized void killChannel(SSH2Channel sSH2Channel) {
        if (sSH2Channel == null || sSH2Channel.channelId == -1 || sSH2Channel.channelId >= this.channels.length || this.channels[sSH2Channel.channelId] == null) {
            this.connLog.error("SSH2Connection", "killChannel", "ch. # " + (sSH2Channel != null ? String.valueOf(sSH2Channel.getChannelId()) : "<null>") + " not present");
            return;
        }
        --this.totalChannels;
        this.channels[sSH2Channel.channelId] = null;
        if (sSH2Channel.channelId < this.nextEmptyChan) {
            this.nextEmptyChan = sSH2Channel.channelId;
        }
        this.eventHandler.channelDeleted(this, sSH2Channel);
    }

    void delChannel(SSH2Channel sSH2Channel) {
        if (this.reaperActive) {
            this.life.addElement(sSH2Channel);
        } else {
            this.killChannel(sSH2Channel);
        }
    }

    SSH2TransportPDU getChannelOpenPDU(SSH2Channel sSH2Channel) {
        SSH2TransportPDU sSH2TransportPDU = SSH2TransportPDU.createOutgoingPacket(90);
        sSH2TransportPDU.writeString(channelTypes[sSH2Channel.channelType]);
        sSH2TransportPDU.writeInt(sSH2Channel.channelId);
        sSH2TransportPDU.writeInt(sSH2Channel.rxInitWinSz);
        sSH2TransportPDU.writeInt(sSH2Channel.rxMaxPktSz);
        return sSH2TransportPDU;
    }

    public void connectLocalChannel(SSH2Channel sSH2Channel, String string, int n, String string2, int n2) {
        SSH2TransportPDU sSH2TransportPDU = this.getChannelOpenPDU(sSH2Channel);
        sSH2TransportPDU.writeString(string);
        sSH2TransportPDU.writeInt(n);
        sSH2TransportPDU.writeString(string2);
        sSH2TransportPDU.writeInt(n2);
        this.transmit(sSH2TransportPDU);
    }

    protected void startChannelReaper() {
        this.life = new Vector();
        this.reaperActive = true;
        Thread thread = new Thread((Runnable)this, "SSH2ChannelReaper");
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
    }

    protected void stopChannelReaper() {
        this.reaperActive = false;
    }

    public void run() {
        Vector vector = new Vector();
        while (this.reaperActive) {
            Object object;
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while (!vector.isEmpty()) {
                object = (SSH2Channel)vector.firstElement();
                this.killChannel((SSH2Channel)object);
                vector.removeElementAt(0);
            }
            object = vector;
            vector = this.life;
            this.life = object;
        }
    }
}

