/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.mindbright.jca.security.interfaces.RSAPrivateCrtKey;
import com.mindbright.security.publickey.RSAPublicKey;
import com.mindbright.ssh.SSH;
import com.mindbright.ssh.SSHCipher;
import com.mindbright.ssh.SSHDataInputStream;
import com.mindbright.ssh.SSHDataOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class SSHRSAKeyFile {
    int cipherType;
    com.mindbright.jca.security.interfaces.RSAPublicKey pubKey;
    String fileComment;
    byte[] encrypted;
    static final String privFileId = "SSH PRIVATE KEY FILE FORMAT 1.1\n";

    public static void createKeyFile(SSH sSH, RSAPrivateCrtKey rSAPrivateCrtKey, String string, String string2, String string3) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        SSHDataOutputStream sSHDataOutputStream = new SSHDataOutputStream(byteArrayOutputStream);
        byte[] byArray = new byte[2];
        sSH.secureRandom().nextBytes(byArray);
        sSHDataOutputStream.writeByte(byArray[0]);
        sSHDataOutputStream.writeByte(byArray[1]);
        sSHDataOutputStream.writeByte(byArray[0]);
        sSHDataOutputStream.writeByte(byArray[1]);
        sSHDataOutputStream.writeBigInteger(rSAPrivateCrtKey.getPrivateExponent());
        sSHDataOutputStream.writeBigInteger(rSAPrivateCrtKey.getCrtCoefficient());
        sSHDataOutputStream.writeBigInteger(rSAPrivateCrtKey.getPrimeQ());
        sSHDataOutputStream.writeBigInteger(rSAPrivateCrtKey.getPrimeP());
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byArray = new byte[8 - byArray2.length % 8 + byArray2.length];
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        byArray2 = byArray;
        int n = 3;
        SSHCipher sSHCipher = SSHCipher.getInstance(SSH.cipherClasses[n][0]);
        sSHCipher.setKey(string);
        byArray2 = sSHCipher.encrypt(byArray2);
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        sSHDataOutputStream = new SSHDataOutputStream(fileOutputStream);
        sSHDataOutputStream.writeBytes(privFileId);
        sSHDataOutputStream.writeByte(0);
        sSHDataOutputStream.writeByte(n);
        sSHDataOutputStream.writeInt(0);
        sSHDataOutputStream.writeInt(0);
        sSHDataOutputStream.writeBigInteger(rSAPrivateCrtKey.getModulus());
        sSHDataOutputStream.writeBigInteger(rSAPrivateCrtKey.getPublicExponent());
        sSHDataOutputStream.writeString(string3);
        sSHDataOutputStream.write(byArray2, 0, byArray2.length);
        sSHDataOutputStream.close();
    }

    public SSHRSAKeyFile(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        SSHDataInputStream sSHDataInputStream = new SSHDataInputStream(fileInputStream);
        byte[] byArray = new byte[privFileId.length()];
        sSHDataInputStream.readFully(byArray);
        String string2 = new String(byArray);
        sSHDataInputStream.readByte();
        if (!string2.equals(privFileId)) {
            throw new IOException("RSA key file corrupt");
        }
        this.cipherType = sSHDataInputStream.readByte();
        if (SSH.cipherClasses[this.cipherType][0] == null) {
            throw new IOException("Ciphertype " + this.cipherType + " in key-file not supported");
        }
        sSHDataInputStream.readInt();
        sSHDataInputStream.readInt();
        BigInteger bigInteger = sSHDataInputStream.readBigInteger();
        BigInteger bigInteger2 = sSHDataInputStream.readBigInteger();
        this.pubKey = new RSAPublicKey(bigInteger, bigInteger2);
        this.fileComment = sSHDataInputStream.readString();
        byte[] byArray2 = new byte[8192];
        int n = sSHDataInputStream.read(byArray2);
        sSHDataInputStream.close();
        this.encrypted = new byte[n];
        System.arraycopy(byArray2, 0, this.encrypted, 0, n);
    }

    public String getComment() {
        return this.fileComment;
    }

    public com.mindbright.jca.security.interfaces.RSAPublicKey getPublic() {
        return this.pubKey;
    }

    public RSAPrivateCrtKey getPrivate(String string) {
        com.mindbright.security.publickey.RSAPrivateCrtKey rSAPrivateCrtKey = null;
        SSHCipher sSHCipher = SSHCipher.getInstance(SSH.cipherClasses[this.cipherType][0]);
        sSHCipher.setKey(string);
        byte[] byArray = sSHCipher.decrypt(this.encrypted);
        SSHDataInputStream sSHDataInputStream = new SSHDataInputStream(new ByteArrayInputStream(byArray));
        try {
            byte by = sSHDataInputStream.readByte();
            byte by2 = sSHDataInputStream.readByte();
            byte by3 = sSHDataInputStream.readByte();
            byte by4 = sSHDataInputStream.readByte();
            if (by != by3 || by2 != by4) {
                return null;
            }
            BigInteger bigInteger = sSHDataInputStream.readBigInteger();
            BigInteger bigInteger2 = sSHDataInputStream.readBigInteger();
            BigInteger bigInteger3 = sSHDataInputStream.readBigInteger();
            BigInteger bigInteger4 = sSHDataInputStream.readBigInteger();
            sSHDataInputStream.close();
            if (bigInteger4.compareTo(bigInteger3) < 0) {
                BigInteger bigInteger5 = bigInteger3;
                bigInteger3 = bigInteger4;
                bigInteger4 = bigInteger5;
            }
            rSAPrivateCrtKey = new com.mindbright.security.publickey.RSAPrivateCrtKey(this.pubKey.getModulus(), this.pubKey.getPublicExponent(), bigInteger, bigInteger4, bigInteger3, bigInteger2);
        }
        catch (IOException iOException) {
            rSAPrivateCrtKey = null;
        }
        return rSAPrivateCrtKey;
    }
}

