/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.mindbright.ssh.SSH;
import com.mindbright.ssh.SSHCipher;
import com.mindbright.ssh.SSHCompressor;
import com.mindbright.ssh.SSHDataOutputStream;
import com.mindbright.ssh.SSHPdu;
import com.mindbright.util.CRC32;
import com.mindbright.util.SecureRandomAndPad;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class SSHPduOutputStream
extends SSHDataOutputStream
implements SSHPdu {
    public static final int SSH_DEFAULT_PKT_LEN = 8192;
    public static int mtu = 8192;
    byte[] readFromRawData;
    int readFromOff;
    int readFromSize;
    public int type;
    public SSHCipher cipher;
    public SSHCompressor compressor;
    public SecureRandomAndPad rand;

    public static synchronized void setMTU(int n) {
        mtu = n;
    }

    SSHPduOutputStream(int n, SSHCipher sSHCipher, SSHCompressor sSHCompressor, SecureRandomAndPad secureRandomAndPad) throws IOException {
        super(new PduByteArrayOutputStream(mtu));
        this.type = n;
        this.cipher = sSHCipher;
        this.compressor = sSHCompressor;
        this.rand = secureRandomAndPad;
        if (sSHCipher != null) {
            PduByteArrayOutputStream pduByteArrayOutputStream = (PduByteArrayOutputStream)this.out;
            secureRandomAndPad.nextPadBytes(pduByteArrayOutputStream.getBuf(), 4, 12);
            pduByteArrayOutputStream.setCount(12);
        } else {
            for (int i = 0; i < 12; ++i) {
                this.write(0);
            }
        }
        this.write(n);
    }

    public SSHPdu createPdu() throws IOException {
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(this.type, this.cipher, this.compressor, this.rand);
        return sSHPduOutputStream;
    }

    public void readFrom(InputStream inputStream) throws IOException {
        if (this.type != 23 && this.type != 16) {
            throw new IOException("Trying to read raw data into non-data PDU");
        }
        PduByteArrayOutputStream pduByteArrayOutputStream = (PduByteArrayOutputStream)this.out;
        this.readFromRawData = pduByteArrayOutputStream.getBuf();
        this.readFromOff = pduByteArrayOutputStream.size() + 4;
        this.readFromSize = inputStream.read(this.readFromRawData, this.readFromOff, mtu - this.readFromOff);
        if (this.readFromSize == -1) {
            throw new IOException("EOF");
        }
        this.writeInt(this.readFromSize);
        pduByteArrayOutputStream.setCount(this.readFromOff + this.readFromSize);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        PduByteArrayOutputStream pduByteArrayOutputStream = (PduByteArrayOutputStream)this.out;
        if (SSH.DEBUGPKG) {
            SSH.logDebug("Writing " + SSH.msgTypeString(this.type));
        }
        if (this.compressor != null) {
            this.compressor.compress(this);
        }
        int n = pduByteArrayOutputStream.size() - 12 + 4;
        int n2 = 8 - n % 8;
        int n3 = 12 - n2;
        int n4 = (int)CRC32.getValue(pduByteArrayOutputStream.getBuf(), n3, n2 + n - 4);
        this.writeInt(n4);
        byte[] byArray = pduByteArrayOutputStream.getBuf();
        if (this.cipher != null) {
            this.cipher.encrypt(byArray, n3, byArray, n3, n2 + n);
        }
        byArray[n3 - 4] = (byte)(n >>> 24 & 0xFF);
        byArray[n3 - 3] = (byte)(n >>> 16 & 0xFF);
        byArray[n3 - 2] = (byte)(n >>> 8 & 0xFF);
        byArray[n3 - 1] = (byte)(n & 0xFF);
        outputStream.write(byArray, n3 - 4, n + n2 + 4);
        outputStream.flush();
    }

    public PduByteArrayOutputStream getOut() {
        return (PduByteArrayOutputStream)this.out;
    }

    public byte[] rawData() {
        return this.readFromRawData;
    }

    public void rawSetData(byte[] byArray) {
    }

    public int rawOffset() {
        return this.readFromOff;
    }

    public int rawSize() {
        byte[] byArray = this.readFromRawData;
        int n = this.readFromOff - 4;
        int n2 = byArray[n++] + 256 & 0xFF;
        int n3 = byArray[n++] + 256 & 0xFF;
        int n4 = byArray[n++] + 256 & 0xFF;
        int n5 = byArray[n] + 256 & 0xFF;
        return (n2 << 24) + (n3 << 16) + (n4 << 8) + (n5 << 0);
    }

    public void rawAdjustSize(int n) {
        PduByteArrayOutputStream pduByteArrayOutputStream = (PduByteArrayOutputStream)this.out;
        pduByteArrayOutputStream.setCount(n);
    }

    public static final class PduByteArrayOutputStream
    extends ByteArrayOutputStream {
        PduByteArrayOutputStream() {
        }

        PduByteArrayOutputStream(int n) {
            super(n);
        }

        PduByteArrayOutputStream(byte[] byArray) {
            this.buf = byArray;
        }

        public byte[] getBuf() {
            return this.buf;
        }

        public int getCount() {
            return this.count;
        }

        public void setBuf(byte[] byArray) {
            this.buf = byArray;
        }

        public void setCount(int n) {
            this.count = n;
        }
    }
}

