/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.mindbright.gui.AWTConvenience;
import com.mindbright.gui.GUI;
import com.mindbright.gui.Logo;
import com.mindbright.gui.SwingConvenience;
import com.mindbright.ssh.SSH;
import com.mindbright.ssh.SSHClient;
import com.mindbright.ssh.SSHInteractiveClient;
import com.mindbright.ssh.SSHKeyGenerationDialogSwing;
import com.mindbright.ssh.SSHMenuHandlerFull;
import com.mindbright.ssh.SSHTunnelDialogSwing;
import com.mindbright.ssh2.SSH2Preferences;
import com.mindbright.terminal.TerminalMenuHandlerFull;
import com.mindbright.util.Util;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class SSHMenuHandlerFullSwing
extends SSHMenuHandlerFull {
    private Object[][] menuItems;
    private JMenuItem[] modMenuItems;
    private JComboBox comboAuthTyp;
    private JComboBox comboSrv;
    private JCheckBox cbSaveAlias;
    private JTextField textPort;
    private JTextField textUser;
    private JTextField textAlias;
    private JTextField textPrivateKey;
    private JTextField textPrivateHostKey;
    private JPasswordField textPwd;
    private JButton customBtn;
    private CardLayout authLabelCL;
    private CardLayout authCL;
    private JPanel authLabelCP;
    private JPanel authCP;
    private String customAuth;
    private JComboBox comboPrxType;
    private JCheckBox cbNeedAuth;
    private JTextField textPrxHost;
    private JTextField textPrxPort;
    private JTextField textPrxUser;
    private JPasswordField textPrxPasswd;
    private JCheckBox cbProto1;
    private JCheckBox cbProto2;
    private JCheckBox cbKeyTypeDSS;
    private JCheckBox cbKeyTypeRSA;
    private JComboBox comboCipherC2S;
    private JComboBox comboCipherS2C;
    private JComboBox comboMacC2S;
    private JComboBox comboMacS2C;
    private JComboBox comboCompC2S;
    private JComboBox comboCompS2C;
    private JCheckBox cbX11;
    private JCheckBox cbIdHost;
    private JCheckBox cbKeyNoise;
    private JCheckBox cbAlive;
    private JCheckBox cbForcPty;
    private JTextField textDisp;
    private JTextField textMtu;
    private JTextField textAlive;
    private boolean ignoreEvents = false;
    private JCheckBox[] authMethod;
    private JList currList;

    public void setupMenuBar(boolean bl) {
        if (bl) {
            JPopupMenu jPopupMenu = new JPopupMenu("MindTerm Menu");
            this.preparePopupMenu(jPopupMenu);
        } else {
            JMenuBar jMenuBar = new JMenuBar();
            this.prepareMenuBar(jMenuBar);
            ((JFrame)this.parent).setJMenuBar(jMenuBar);
        }
    }

    private void prepareMenuBar(JMenuBar jMenuBar) {
        jMenuBar.add(this.getMenu(0));
        jMenuBar.add((JMenuItem)((TerminalMenuHandlerFull)this.term.getMenus()).getMenu(1));
        jMenuBar.add(this.getMenu(1));
        JMenu jMenu = this.getPluginMenu();
        if (jMenu != null) {
            jMenuBar.add(jMenu);
        }
        jMenuBar.add(this.getMenu(2));
        jMenuBar.add(this.getMenu(3));
        this.term.updateMenus();
    }

    private void preparePopupMenu(JPopupMenu jPopupMenu) {
        this.havePopupMenu = true;
        jPopupMenu.add(this.getMenu(0));
        jPopupMenu.add((JMenuItem)((TerminalMenuHandlerFull)this.term.getMenus()).getMenu(1));
        jPopupMenu.add(this.getMenu(1));
        JMenu jMenu = this.getPluginMenu();
        if (jMenu != null) {
            jPopupMenu.add(jMenu);
        }
        jPopupMenu.add(this.getMenu(2));
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.getMenu(3));
        this.term.getMenus().setPopupMenu(jPopupMenu);
        this.update();
    }

    private JMenu getMenu(int n) {
        JMenu jMenu = new JMenu(SSHMenuHandlerFull.menuTexts[n][0]);
        int n2 = SSHMenuHandlerFull.menuTexts[n].length;
        if (this.menuItems == null) {
            this.menuItems = new Object[SSHMenuHandlerFull.menuTexts.length][];
        }
        if (this.menuItems[n] == null) {
            this.menuItems[n] = new Object[SSHMenuHandlerFull.menuTexts[n].length];
        }
        for (int i = 1; i < n2; ++i) {
            JMenuItem jMenuItem;
            String string = SSHMenuHandlerFull.menuTexts[n][i];
            if (string == null) {
                jMenu.addSeparator();
                continue;
            }
            if (string.charAt(0) == '_') {
                string = string.substring(1);
                jMenuItem = new JCheckBoxMenuItem(string);
                ((JCheckBoxMenuItem)jMenuItem).addActionListener(this);
            } else {
                jMenuItem = new JMenuItem(string);
                jMenuItem.addActionListener(this);
            }
            int n3 = SSHMenuHandlerFull.getMenuShortCut(n, i);
            if (n3 != -1) {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n3, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
            }
            this.menuItems[n][i] = jMenuItem;
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    private JMenu getPluginMenu() {
        this.modMenuItems = null;
        JMenu jMenu = null;
        if (this.modCnt > 0) {
            int n;
            this.modMenuItems = new JMenuItem[this.modCnt];
            jMenu = new JMenu("Plugins");
            for (n = 0; n < this.modCnt; ++n) {
                JMenuItem jMenuItem;
                String string = this.getModuleLabel(n);
                if (string == null) continue;
                this.modMenuItems[n] = jMenuItem = new JMenuItem(string);
                jMenuItem.addActionListener(new SSHMenuHandlerFull.Actions(0 + n));
                jMenu.add(jMenuItem);
            }
            if (n == 0) {
                jMenu = null;
            }
        }
        return jMenu;
    }

    protected void setEnabled(int n, int n2, boolean bl) {
        ((JMenuItem)this.menuItems[n][n2]).setEnabled(bl);
    }

    protected void setState(int n, int n2, boolean bl) {
        ((JCheckBoxMenuItem)this.menuItems[n][n2]).setSelected(bl);
    }

    protected boolean getState(int n, int n2) {
        return ((JCheckBoxMenuItem)this.menuItems[n][n2]).isSelected();
    }

    protected void updatePluginMenu() {
        for (int i = 0; i < this.modCnt; ++i) {
            if (this.getModuleLabel(i) == null) continue;
            this.modMenuItems[i].setEnabled(this.modules[i].isAvailable(this.client));
        }
    }

    protected String getMenuLabel(Object object) {
        return ((JMenuItem)object).getText();
    }

    public void connectDialog(String string) {
        this.sshConfigDialog(string, SSHMenuHandlerFull.IDX_TAB_GENERAL);
    }

    public void keyGenerationDialogCreate(String string) {
        SSHKeyGenerationDialogSwing.show(string, this.parent, this.client);
    }

    public void keyGenerationDialogEdit(String string) {
        SSHKeyGenerationDialogSwing.editKeyDialog(string, this.parent, this.client);
    }

    protected void sshNewServerDialog(String string) {
        this.sshConfigDialog(string, SSHMenuHandlerFull.IDX_TAB_GENERAL);
    }

    public void sshPreferencesDialog(String string) {
        this.sshConfigDialog(string, SSHMenuHandlerFull.IDX_TAB_SECURITY);
    }

    protected void sshConfigDialog(String string, int n) {
        final JDialog jDialog = new JDialog(this.parent, string, true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JTabbedPane jTabbedPane = new JTabbedPane();
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (!SSHMenuHandlerFullSwing.this.ignoreEvents) {
                    SSHMenuHandlerFullSwing.this.serverSelected();
                }
            }
        };
        ItemListener itemListener2 = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SSHMenuHandlerFullSwing.this.updateChoicesGeneral();
            }
        };
        ItemListener itemListener3 = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SSHMenuHandlerFullSwing.this.updateChoicesProxy(itemEvent);
            }
        };
        ItemListener itemListener4 = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SSHMenuHandlerFullSwing.this.updateChoicesSecurity(itemEvent);
            }
        };
        ItemListener itemListener5 = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SSHMenuHandlerFullSwing.this.updateChoicesFeatures();
            }
        };
        JPanel jPanel = new JPanel(gridBagLayout);
        JLabel jLabel = new JLabel(SSHMenuHandlerFull.LBL_SERVER, 4);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.comboSrv = new JComboBox<String>(this.getAvailableAliases());
        this.comboSrv.setEditable(true);
        this.comboSrv.addItemListener(itemListener);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.comboSrv, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        jLabel = new JLabel(SSHMenuHandlerFull.LBL_USERNAME, 4);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.textUser = new JTextField("", 12);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.textUser, gridBagConstraints);
        jLabel = new JLabel(SSHMenuHandlerFull.LBL_AUTH, 4);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.comboAuthTyp = new JComboBox<String>(SSHMenuHandlerFull.AUTH_METHODS);
        this.comboAuthTyp.addItemListener(itemListener2);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.comboAuthTyp, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.getAuthLabel(), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.getAuth(), gridBagConstraints);
        this.cbSaveAlias = new JCheckBox(SSHMenuHandlerFull.LBL_SAVE_AS_ALIAS);
        this.cbSaveAlias.addItemListener(itemListener2);
        gridBagConstraints.insets = new Insets(10, 2, 2, 2);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.cbSaveAlias, gridBagConstraints);
        this.textAlias = new JTextField("", 12);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.textAlias, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        jTabbedPane.addTab(SSHMenuHandlerFull.LBL_TAB_GENERAL, jPanel);
        jPanel = new JPanel(gridBagLayout);
        jLabel = new JLabel(SSHMenuHandlerFull.LBL_PROXY_TYPE, 4);
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.comboPrxType = new JComboBox<String>(SSH.getProxyTypes());
        this.comboPrxType.addItemListener(itemListener3);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.comboPrxType, gridBagConstraints);
        gridBagConstraints.fill = 2;
        jLabel = new JLabel(SSHMenuHandlerFull.LBL_SERVER, 4);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.textPrxHost = new JTextField("", 12);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.textPrxHost, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        jLabel = new JLabel(SSHMenuHandlerFull.LBL_PORT, 4);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.textPrxPort = new JTextField("", 12);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.textPrxPort, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder());
        titledBorder.setTitle(SSHMenuHandlerFull.LBL_AUTH_REQ);
        jPanel2.setBorder(titledBorder);
        this.cbNeedAuth = new JCheckBox(SSHMenuHandlerFull.LBL_AUTH);
        this.cbNeedAuth.addItemListener(itemListener3);
        jPanel2.add((Component)this.cbNeedAuth, gridBagConstraints);
        jLabel = new JLabel(SSHMenuHandlerFull.LBL_USERNAME, 4);
        gridBagConstraints.gridwidth = 1;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.textPrxUser = new JTextField("", 12);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.textPrxUser, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        jLabel = new JLabel(SSHMenuHandlerFull.LBL_PASSWORD, 4);
        gridBagConstraints.gridwidth = 1;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.textPrxPasswd = new JPasswordField("", 12);
        gridBagConstraints.gridwidth = 0;
        jPanel2.add((Component)this.textPrxPasswd, gridBagConstraints);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        jTabbedPane.addTab(SSHMenuHandlerFull.LBL_TAB_PROXY, jPanel);
        jPanel = new JPanel(gridBagLayout);
        jLabel = new JLabel(SSHMenuHandlerFull.LBL_PROTOCOL, 4);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.cbProto2 = new JCheckBox(SSHMenuHandlerFull.LBL_PROTO_SSH2);
        this.cbProto2.addItemListener(itemListener4);
        jPanel.add((Component)this.cbProto2, gridBagConstraints);
        this.cbProto1 = new JCheckBox(SSHMenuHandlerFull.LBL_PROTO_SSH1);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.cbProto1, gridBagConstraints);
        jLabel = new JLabel(SSHMenuHandlerFull.LBL_HKEY_TYPE, 4);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.cbKeyTypeDSS = new JCheckBox(SSHMenuHandlerFull.LBL_HKEY_DSS);
        jPanel.add((Component)this.cbKeyTypeDSS, gridBagConstraints);
        this.cbKeyTypeRSA = new JCheckBox(SSHMenuHandlerFull.LBL_HKEY_RSA);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.cbKeyTypeRSA, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)new JLabel(SSHMenuHandlerFull.LBL_C2S), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)new JLabel(SSHMenuHandlerFull.LBL_S2C), gridBagConstraints);
        this.comboCipherC2S = new JComboBox<String>(SSHMenuHandlerFull.ciphers);
        this.comboCipherS2C = new JComboBox<String>(SSHMenuHandlerFull.ciphers);
        this.comboMacC2S = new JComboBox<String>(SSHMenuHandlerFull.macs);
        this.comboMacS2C = new JComboBox<String>(SSHMenuHandlerFull.macs);
        this.comboCompC2S = new JComboBox<String>(SSHMenuHandlerFull.compc2s);
        this.comboCompS2C = new JComboBox<String>(SSHMenuHandlerFull.comps2c);
        this.comboCipherC2S.insertItemAt(SSHMenuHandlerFull.LBL_ANY_STANDARD, 0);
        this.comboCipherS2C.insertItemAt(SSHMenuHandlerFull.LBL_ANY_STANDARD, 0);
        this.comboMacC2S.insertItemAt(SSHMenuHandlerFull.LBL_ANY_STANDARD, 0);
        this.comboMacS2C.insertItemAt(SSHMenuHandlerFull.LBL_ANY_STANDARD, 0);
        this.comboCipherC2S.addItemListener(itemListener4);
        this.comboMacC2S.addItemListener(itemListener4);
        this.comboCompC2S.addItemListener(itemListener4);
        jLabel = new JLabel(SSHMenuHandlerFull.LBL_CIPHER, 4);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.comboCipherC2S, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.comboCipherS2C, gridBagConstraints);
        jLabel = new JLabel(SSHMenuHandlerFull.LBL_MAC, 4);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.comboMacC2S, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.comboMacS2C, gridBagConstraints);
        jLabel = new JLabel(SSHMenuHandlerFull.LBL_COMP, 4);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.comboCompC2S, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.comboCompS2C, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        jTabbedPane.addTab(SSHMenuHandlerFull.LBL_TAB_SECURITY, jPanel);
        jPanel = new JPanel(gridBagLayout);
        jLabel = new JLabel(SSHMenuHandlerFull.LBL_X11_FORWARD, 4);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 0, 0));
        this.cbX11 = new JCheckBox();
        this.cbX11.addItemListener(itemListener5);
        this.textDisp = new JTextField("", 12);
        jPanel3.add(this.cbX11);
        jPanel3.add(new JLabel(SSHMenuHandlerFull.LBL_LOCAL_DISP));
        jPanel3.add(Box.createRigidArea(new Dimension(4, 0)));
        jPanel3.add(this.textDisp);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        jLabel = new JLabel(SSHMenuHandlerFull.LBL_SEND_KEEP, 4);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        jPanel3 = new JPanel(new FlowLayout(0, 0, 0));
        this.cbAlive = new JCheckBox();
        this.cbAlive.addItemListener(itemListener5);
        this.textAlive = new JTextField("", 12);
        jPanel3.add(this.cbAlive);
        jPanel3.add(new JLabel(SSHMenuHandlerFull.LBL_INTERVAL));
        jPanel3.add(Box.createRigidArea(new Dimension(4, 0)));
        jPanel3.add(this.textAlive);
        jPanel3.add(new JLabel(SSHMenuHandlerFull.LBL_SECONDS));
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        this.cbIdHost = new JCheckBox(SSHMenuHandlerFull.LBL_STRICT);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.cbIdHost, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        this.cbKeyNoise = new JCheckBox(SSHMenuHandlerFull.LBL_KEY_NOISE);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.cbKeyNoise, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        this.cbForcPty = new JCheckBox(SSHMenuHandlerFull.LBL_ALLOC_PTY);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.cbForcPty, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        jTabbedPane.addTab(SSHMenuHandlerFull.LBL_TAB_FEATURES, jPanel);
        jDialog.getContentPane().add((Component)jTabbedPane, "Center");
        jTabbedPane.setSelectedIndex(n);
        JButton jButton = new JButton();
        if (this.client.isConnected()) {
            jButton.setText(SSHMenuHandlerFull.LBL_BTN_OK);
        } else {
            jButton.setText(SSHMenuHandlerFull.LBL_BTN_CONNECT);
        }
        JButton jButton2 = new JButton(SSHMenuHandlerFull.LBL_BTN_CANCEL);
        JPanel jPanel4 = SwingConvenience.newButtonPanel(new JButton[]{jButton, jButton2});
        jDialog.getContentPane().add((Component)jPanel4, "South");
        jDialog.getRootPane().setDefaultButton(jButton);
        jDialog.setResizable(true);
        jDialog.pack();
        AWTConvenience.placeDialog(jDialog);
        jDialog.addWindowListener(SwingConvenience.getWindowDisposer());
        this.ph.clearAllForwards();
        this.populate();
        this.updateChoicesGeneral();
        this.updateChoicesProxy(null);
        this.updateChoicesSecurity(null);
        this.updateChoicesFeatures();
        if (this.comboSrv.isEnabled()) {
            this.comboSrv.requestFocus();
        } else {
            this.textUser.requestFocus();
        }
        jButton2.addActionListener(new AWTConvenience.CloseAction(jDialog));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SSHMenuHandlerFullSwing.this.okPressed(jDialog);
                }
                catch (Exception exception) {
                    SSHMenuHandlerFullSwing.this.alertDialog("Error: " + exception.getMessage());
                }
            }
        });
        ((Component)jDialog).setVisible(true);
    }

    private void serverSelected() {
        Object object = this.comboSrv.getModel().getSelectedItem();
        if (object == null) {
            return;
        }
        String string = object.toString().trim();
        if (string.length() == 0) {
            return;
        }
        int n = Util.getPort(string, 22);
        string = Util.getHost(string);
        this.ph.setProperty("server", string);
        this.ph.setProperty("port", n);
        try {
            String string2 = "";
            while (true) {
                try {
                    if (-1 != this.comboSrv.getSelectedIndex()) {
                        this.cbSaveAlias.setSelected(true);
                        this.textAlias.setText(string);
                    }
                    this.ph.setPropertyPassword(string2);
                    this.ph.loadAliasFile(string, false);
                    try {
                        this.ph.saveAsCurrentFile(this.ph.getSSHHomeDir() + string + ".mtp");
                    }
                    catch (IOException iOException) {
                        System.err.println("Failed to save");
                    }
                    this.populate();
                }
                catch (SSHClient.AuthFailException authFailException) {
                    if ((string2 = this.passwordDialog("Please give file password for " + string, "MindTerm - File Password")) != null) continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            System.err.println("Got exception: " + throwable);
        }
    }

    private void okPressed(JDialog jDialog) throws Exception {
        if (!this.client.isConnected()) {
            if (!this.extractDataFromGeneral()) {
                return;
            }
            this.extractDataFromProxy();
        }
        this.extractDataFromSecurity();
        this.extractDataFromFeatures();
        jDialog.dispose();
    }

    private boolean extractDataFromGeneral() {
        String string;
        String string2;
        String string3 = null;
        string3 = this.comboSrv.getModel().getSelectedItem().toString().trim();
        if (string3.length() == 0) {
            this.alertDialog("Please specify a server to connect to");
            return false;
        }
        int n = Util.getPort(string3, 22);
        string3 = Util.getHost(string3);
        this.ph.setProperty("server", string3);
        this.ph.setProperty("port", n);
        this.ph.setProperty("usrname", this.textUser.getText());
        if (this.cbSaveAlias.isSelected()) {
            string2 = this.textAlias.getText();
            if (string2 == null || string2.trim().length() == 0) {
                this.alertDialog("Please specify an alias name for these settings");
                return false;
            }
            if (this.ph.savePasswords) {
                string = this.setPasswordDialog("Please set password for alias " + string3, "MindTerm - Set File Password");
                if (string == null) {
                    return false;
                }
                this.ph.setPropertyPassword(string);
            }
            this.ph.setAlias(string2);
        }
        this.client.quiet = true;
        string2 = this.ph.getProperty("prxpassword");
        this.ph.clearPasswords();
        if (string2 != null) {
            this.ph.setProperty("prxpassword", string2);
        }
        if ((string = (String)this.comboAuthTyp.getSelectedItem()).equals(SSHMenuHandlerFull.LBL_CUSTOM_LIST)) {
            this.ph.setProperty("authtyp", this.customAuth);
        } else {
            this.ph.setProperty("authtyp", string);
        }
        String string4 = null;
        char[] cArray = this.textPwd.getPassword();
        if (cArray != null && cArray.length > 0) {
            string4 = new String(cArray);
        }
        this.ph.setProperty("password", string4);
        this.ph.setProperty("private-key", this.textPrivateKey.getText());
        this.ph.setProperty("private-host-key", this.textPrivateHostKey.getText());
        try {
            this.ph.saveAsCurrentFile(this.ph.getSSHHomeDir() + string3 + ".mtp");
        }
        catch (IOException iOException) {
            System.err.println("Failed to save");
        }
        this.client.sshStdIO.breakPromptLine();
        return true;
    }

    private void extractDataFromProxy() {
        String string = (String)this.comboPrxType.getSelectedItem();
        this.ph.setProperty("proxytype", string);
        if (!"none".equalsIgnoreCase(string)) {
            this.ph.setProperty("proxyhost", this.textPrxHost.getText());
            this.ph.setProperty("proxyport", this.textPrxPort.getText());
        }
        if (this.cbNeedAuth.isSelected()) {
            this.ph.setProperty("proxyuser", this.textPrxUser.getText());
            String string2 = null;
            char[] cArray = this.textPrxPasswd.getPassword();
            if (cArray != null && cArray.length > 0) {
                string2 = new String(cArray);
            }
            this.ph.setProperty("prxpassword", string2);
        } else if ("socks4".equals(string)) {
            this.ph.setProperty("proxyuser", this.textPrxUser.getText());
        }
    }

    private void extractDataFromSecurity() throws Exception {
        boolean bl;
        String string = (String)this.comboCipherC2S.getSelectedItem();
        String string2 = (String)this.comboCipherS2C.getSelectedItem();
        boolean bl2 = bl = this.client.isConnected() && this.client.isSSH2 && !this.client.transport.incompatibleCantReKey;
        if (bl) {
            this.checkSupportedByPeer();
        }
        if (this.cbProto1.isSelected() && this.cbProto2.isSelected()) {
            this.ph.setProperty("protocol", "auto");
        } else if (this.cbProto1.isSelected()) {
            this.ph.setProperty("protocol", "ssh1");
        } else if (this.cbProto2.isSelected()) {
            this.ph.setProperty("protocol", "ssh2");
        } else {
            throw new Exception(SSHMenuHandlerFull.ERR_NO_PROTOCOL);
        }
        if (this.cbKeyTypeDSS.isSelected() && this.cbKeyTypeRSA.isSelected()) {
            this.ph.setProperty("server-host-key-algorithms", "ssh-rsa,ssh-dss");
        } else if (this.cbKeyTypeDSS.isSelected()) {
            this.ph.setProperty("server-host-key-algorithms", "ssh-dss");
        } else if (this.cbKeyTypeRSA.isSelected()) {
            this.ph.setProperty("server-host-key-algorithms", "ssh-rsa");
        } else {
            throw new Exception(SSHMenuHandlerFull.ERR_NO_KEYTYPE);
        }
        if (this.comboCipherC2S.getSelectedIndex() > 0) {
            this.ph.setProperty("enc-algorithms-cli2srv", string);
            this.ph.setProperty("cipher", string);
        } else {
            this.ph.resetProperty("enc-algorithms-cli2srv");
            this.ph.resetProperty("cipher");
        }
        if (this.comboCipherS2C.getSelectedIndex() > 0) {
            this.ph.setProperty("enc-algorithms-srv2cli", string2);
        } else {
            this.ph.resetProperty("enc-algorithms-srv2cli");
        }
        if (this.comboMacC2S.getSelectedIndex() > 0) {
            this.ph.setProperty("mac-algorithms-cli2srv", (String)this.comboMacC2S.getSelectedItem());
        } else {
            this.ph.resetProperty("mac-algorithms-cli2srv");
        }
        if (this.comboMacS2C.getSelectedIndex() > 0) {
            this.ph.setProperty("mac-algorithms-srv2cli", (String)this.comboMacS2C.getSelectedItem());
        } else {
            this.ph.resetProperty("mac-algorithms-srv2cli");
        }
        int n = SSHMenuHandlerFull.comp2lvl[this.comboCompC2S.getSelectedIndex()];
        if (n > 0) {
            this.ph.setProperty("comp-algorithms-cli2srv", "zlib,zlib@openssh.com");
        } else {
            this.ph.setProperty("comp-algorithms-cli2srv", "none");
        }
        this.ph.setProperty("compression", n);
        n = this.comboCompS2C.getSelectedIndex();
        if (n > 0) {
            this.ph.setProperty("comp-algorithms-srv2cli", "zlib,zlib@openssh.com");
        } else {
            this.ph.setProperty("comp-algorithms-srv2cli", "none");
        }
        if (bl) {
            SSH2Preferences sSH2Preferences = new SSH2Preferences(this.ph.getProperties());
            this.client.transport.startKeyExchange(sSH2Preferences);
        }
    }

    private void extractDataFromFeatures() {
        if (this.cbX11.isSelected()) {
            this.ph.setProperty("display", this.textDisp.getText());
        } else {
            this.ph.setProperty("display", "");
        }
        this.ph.setProperty("x11fwd", this.cbX11.isSelected());
        this.ph.setProperty("stricthostid", this.cbIdHost.isSelected());
        this.ph.setProperty("key-timing-noise", this.cbKeyNoise.isSelected());
        this.ph.setProperty("forcpty", this.cbForcPty.isSelected());
        if (this.cbAlive.isSelected()) {
            this.ph.setProperty("alive", this.textAlive.getText());
        } else {
            this.ph.setProperty("alive", "0");
        }
    }

    private JPanel getAuthLabel() {
        this.authLabelCP = new JPanel();
        this.authLabelCL = new CardLayout();
        this.authLabelCP.setLayout(this.authLabelCL);
        int n = 4;
        this.authLabelCP.add((Component)new JLabel(SSHMenuHandlerFull.LBL_PASSWORD, n), "password");
        this.authLabelCP.add((Component)new JPanel(), SSHMenuHandlerFull.LBL_CUSTOM_LIST);
        this.authLabelCP.add((Component)new JLabel(SSHMenuHandlerFull.LBL_IDENTITY, n), "publickey");
        this.authLabelCP.add((Component)new JPanel(), "securid");
        this.authLabelCP.add((Component)new JPanel(), "tis");
        this.authLabelCP.add((Component)new JPanel(), "kbd-interact");
        this.authLabelCP.add((Component)new JLabel(SSHMenuHandlerFull.LBL_HOST_KEY, n), "hostbased");
        return this.authLabelCP;
    }

    private Component makeCenter(Component component) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add(component, gridBagConstraints);
        return jPanel;
    }

    private JPanel getAuth() {
        this.authCP = new JPanel();
        this.authCL = new CardLayout();
        this.authCP.setLayout(this.authCL);
        this.textPwd = new JPasswordField("", 12);
        this.textPwd.setEchoChar('*');
        this.customBtn = new JButton(SSHMenuHandlerFull.LBL_MODIFY_LIST);
        this.customBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SSHMenuHandlerFullSwing.this.customAuthDialog();
            }
        });
        this.textPrivateKey = new JTextField("", 12);
        JButton jButton = new JButton(SSHMenuHandlerFull.LBL_BTN_BROWSE);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file = GUI.selectFile(SSHMenuHandlerFullSwing.this.parent, "MindTerm - Select file with identity (private)", SSHMenuHandlerFullSwing.this.ph.getSSHHomeDir(), false);
                if (file != null) {
                    SSHMenuHandlerFullSwing.this.textPrivateKey.setText(file.getAbsolutePath());
                }
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.textPrivateKey, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jButton, gridBagConstraints);
        this.authCP.add(this.makeCenter(this.textPwd), "password");
        this.authCP.add(this.makeCenter(this.customBtn), SSHMenuHandlerFull.LBL_CUSTOM_LIST);
        this.authCP.add((Component)jPanel, "publickey");
        this.authCP.add((Component)new JLabel(), "tis");
        this.authCP.add((Component)new JLabel(), "kbd-interact");
        this.authCP.add((Component)new JPanel(), "securid");
        this.authCP.add((Component)new JPanel(), "tis");
        this.authCP.add((Component)new JPanel(), "kbd-interact");
        this.textPrivateHostKey = new JTextField("", 12);
        jButton = new JButton(SSHMenuHandlerFull.LBL_BTN_BROWSE);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file = GUI.selectFile(SSHMenuHandlerFullSwing.this.parent, "MindTerm - Select file with private host key", SSHMenuHandlerFullSwing.this.ph.getSSHHomeDir(), false);
                if (file != null) {
                    SSHMenuHandlerFullSwing.this.textPrivateHostKey.setText(file.getAbsolutePath());
                }
            }
        });
        jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.textPrivateHostKey, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jButton, gridBagConstraints);
        this.authCP.add((Component)jPanel, "hostbased");
        return this.authCP;
    }

    private void updateChoicesGeneral() {
        this.comboSrv.setEnabled(!this.client.isOpened());
        this.textUser.setEnabled(!this.client.isOpened());
        this.cbSaveAlias.setEnabled(!this.client.isOpened());
        this.textAlias.setEnabled(!this.client.isOpened());
        this.comboAuthTyp.setEnabled(!this.client.isOpened());
        this.textPwd.setEnabled(!this.client.isOpened());
        this.customBtn.setEnabled(!this.client.isOpened());
        this.textPrivateKey.setEnabled(!this.client.isOpened());
        this.textPrivateHostKey.setEnabled(!this.client.isOpened());
        String string = (String)this.comboAuthTyp.getSelectedItem();
        this.authLabelCL.show(this.authLabelCP, string);
        this.authCL.show(this.authCP, string);
        if (this.cbSaveAlias.isSelected()) {
            this.textAlias.setEnabled(true);
            String string2 = this.textAlias.getText();
            if (!(this.textAlias.isEnabled() || string2 != null && string2.trim().length() != 0)) {
                this.textAlias.setText(this.comboSrv.getModel().getSelectedItem().toString().trim());
                this.textAlias.requestFocus();
            }
        } else {
            this.textAlias.setText("");
            this.textAlias.setEnabled(false);
        }
    }

    private void updateChoicesProxy(ItemEvent itemEvent) {
        boolean bl;
        if (itemEvent == null || itemEvent.getSource() == this.comboPrxType) {
            int bl2 = SSH.getProxyType((String)this.comboPrxType.getSelectedItem());
            this.textPrxPort.setText(String.valueOf(SSH.defaultProxyPorts[bl2]));
        }
        boolean bl3 = true;
        boolean bl4 = true;
        String string = (String)this.comboPrxType.getSelectedItem();
        int n = 0;
        try {
            n = SSH.getProxyType(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            boolean bl5 = false;
        }
        if (n == 0 || n == 2) {
            bl4 = false;
        }
        if (this.client.isConnected()) {
            bl = false;
            this.comboPrxType.setEnabled(false);
        } else {
            this.comboPrxType.setEnabled(true);
        }
        this.textPrxHost.setEnabled(bl);
        this.textPrxPort.setEnabled(bl);
        this.cbNeedAuth.setEnabled(bl4);
        if (!bl4) {
            this.cbNeedAuth.setSelected(false);
        }
        this.textPrxUser.setEnabled(this.cbNeedAuth.isSelected());
        this.textPrxPasswd.setEnabled(this.cbNeedAuth.isSelected());
    }

    private void updateChoicesSecurity(ItemEvent itemEvent) {
        boolean bl = this.client.isOpened();
        boolean bl2 = bl ? this.client.isSSH2 : this.cbProto2.isSelected();
        this.cbProto1.setEnabled(!bl);
        this.cbProto2.setEnabled(!bl);
        this.cbKeyTypeDSS.setEnabled(!bl);
        this.cbKeyTypeRSA.setEnabled(!bl);
        boolean bl3 = false;
        if (this.client.transport != null) {
            bl3 = this.client.transport.incompatibleCantReKey;
        }
        boolean bl4 = !bl || bl2 && bl && !bl3;
        this.comboCipherS2C.setEnabled(bl4 && bl2);
        this.comboMacS2C.setEnabled(bl4 && bl2);
        this.comboCompS2C.setEnabled(bl4 && bl2);
        this.comboCipherC2S.setEnabled(bl4);
        this.comboMacC2S.setEnabled(bl4 && bl2);
        this.comboCompC2S.setEnabled(bl4);
        if (itemEvent != null && itemEvent.getSource() == this.comboCipherC2S) {
            this.comboCipherS2C.setSelectedItem((String)itemEvent.getItem());
        } else if (itemEvent != null && itemEvent.getSource() == this.comboMacS2C) {
            this.comboMacS2C.setSelectedItem((String)itemEvent.getItem());
        } else if (itemEvent != null && itemEvent.getSource() == this.comboCompS2C) {
            if ("none".equals(itemEvent.getItem())) {
                this.comboCompS2C.setSelectedItem("none");
            } else {
                this.comboCompS2C.setSelectedItem("medium");
            }
        }
    }

    private void updateChoicesFeatures() {
        boolean bl = this.client.isOpened();
        this.cbX11.setEnabled(!bl);
        this.cbIdHost.setEnabled(!bl);
        this.cbForcPty.setEnabled(!bl);
        this.textAlive.setEnabled(this.cbAlive.isSelected());
        this.textDisp.setEnabled(this.cbX11.isSelected());
    }

    private void populate() {
        this.ignoreEvents = true;
        String string = this.ph.getProperty("port");
        String string2 = string.length() > 0 && !string.equals("22") ? this.ph.getProperty("server") + ":" + string : this.ph.getProperty("server");
        if (string2 != null) {
            this.comboSrv.getModel().setSelectedItem(string2);
        }
        this.textUser.setText(this.ph.getProperty("username"));
        this.textPrivateKey.setText(this.ph.getProperty("private-key"));
        this.textPrivateHostKey.setText(this.ph.getProperty("private-host-key"));
        this.customAuth = this.ph.getProperty("auth-method");
        if (-1 == this.customAuth.indexOf(44)) {
            this.comboAuthTyp.setSelectedItem(this.customAuth);
        } else {
            this.comboAuthTyp.setSelectedItem(SSHMenuHandlerFull.LBL_CUSTOM_LIST);
        }
        this.comboPrxType.getModel().setSelectedItem(this.ph.getProperty("proxytype"));
        this.textPrxHost.setText(this.ph.getProperty("proxyhost"));
        this.textPrxPort.setText(this.ph.getProperty("proxyport"));
        this.textPrxUser.setText(this.ph.getProperty("proxyuser"));
        this.cbKeyTypeDSS.setSelected(true);
        this.cbKeyTypeRSA.setSelected(true);
        this.comboCipherC2S.setSelectedIndex(0);
        this.comboCipherS2C.setSelectedIndex(0);
        this.comboMacC2S.setSelectedIndex(0);
        this.comboMacS2C.setSelectedIndex(0);
        this.cbProto1.setSelected(!this.ph.getProperty("protocol").equals("ssh2"));
        this.cbProto2.setSelected(!this.ph.getProperty("protocol").equals("ssh1"));
        this.cbKeyTypeDSS.setSelected(-1 != this.ph.getProperty("server-host-key-algorithms").indexOf("ssh-dss"));
        this.cbKeyTypeRSA.setSelected(-1 != this.ph.getProperty("server-host-key-algorithms").indexOf("ssh-rsa"));
        this.comboCipherC2S.setSelectedItem(this.ph.getProperty("enc-algorithms-cli2srv"));
        this.comboCipherS2C.setSelectedItem(this.ph.getProperty("enc-algorithms-srv2cli"));
        this.comboMacC2S.setSelectedItem(this.ph.getProperty("mac-algorithms-cli2srv"));
        this.comboMacS2C.setSelectedItem(this.ph.getProperty("mac-algorithms-srv2cli"));
        int n = this.ph.getCompressionLevel();
        this.comboCompC2S.setSelectedItem(SSHMenuHandlerFull.lvl2comp[n]);
        String string3 = this.ph.getProperty("comp-algorithms-srv2cli");
        if ("none".equals(string3)) {
            this.comboCompS2C.setSelectedItem("none");
        } else {
            this.comboCompS2C.setSelectedItem("medium");
        }
        this.textDisp.setText(this.ph.getProperty("display"));
        this.textAlive.setText(this.ph.getProperty("alive"));
        this.cbX11.setSelected(this.ph.getPropertyB("x11fwd"));
        this.cbAlive.setSelected(!this.ph.getProperty("alive").equals("0"));
        this.cbIdHost.setSelected(this.ph.getPropertyB("stricthostid"));
        this.cbKeyNoise.setSelected(this.ph.getPropertyB("key-timing-noise"));
        this.cbForcPty.setSelected(this.ph.getPropertyB("forcpty"));
        this.ignoreEvents = false;
    }

    private void checkSupportedByPeer() throws Exception {
        this.checkSupportedByPeer("enc-algorithms-cli2srv", this.comboCipherC2S);
        this.checkSupportedByPeer("enc-algorithms-srv2cli", this.comboCipherS2C);
        this.checkSupportedByPeer("mac-algorithms-cli2srv", this.comboMacC2S);
        this.checkSupportedByPeer("mac-algorithms-srv2cli", this.comboMacS2C);
        if (!((String)this.comboCompC2S.getSelectedItem()).equals("none") && !this.client.transport.getPeerPreferences().isSupported("comp-algorithms-cli2srv", "zlib") || !((String)this.comboCompS2C.getSelectedItem()).equals("none") && !this.client.transport.getPeerPreferences().isSupported("comp-algorithms-srv2cli", "zlib")) {
            throw new Exception("Peer doesn't support 'zlib'");
        }
    }

    private void checkSupportedByPeer(String string, JComboBox jComboBox) throws Exception {
        if (jComboBox.getSelectedIndex() == 0) {
            return;
        }
        String string2 = (String)jComboBox.getSelectedItem();
        if (!this.client.transport.getPeerPreferences().isSupported(string, string2)) {
            throw new Exception("Peer doesn't support: " + string2);
        }
    }

    private void customAuthDialog() {
        final JDialog jDialog = SwingConvenience.newBorderJDialog(this.parent, SSHMenuHandlerFull.LBL_CUSTOM_LIST, true);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.authMethod = new JCheckBox[SSHMenuHandlerFull.AUTH_METHODS.length];
        for (int i = 0; i < this.authMethod.length - 1; ++i) {
            this.authMethod[i] = new JCheckBox(SSHMenuHandlerFull.AUTH_METHODS[i]);
            this.authMethod[i].setSelected(-1 != this.customAuth.indexOf(SSHMenuHandlerFull.AUTH_METHODS[i]));
            jPanel.add((Component)this.authMethod[i], gridBagConstraints);
        }
        jDialog.getContentPane().add((Component)jPanel, "Center");
        JButton jButton = new JButton(SSHMenuHandlerFull.LBL_BTN_OK);
        JButton jButton2 = new JButton(SSHMenuHandlerFull.LBL_BTN_CANCEL);
        JPanel jPanel2 = SwingConvenience.newButtonPanel(new JButton[]{jButton, jButton2});
        jDialog.getContentPane().add((Component)jPanel2, "South");
        jDialog.getRootPane().setDefaultButton(jButton);
        jDialog.setResizable(true);
        jDialog.pack();
        AWTConvenience.placeDialog(jDialog);
        jDialog.addWindowListener(SwingConvenience.getWindowDisposer());
        jButton2.addActionListener(new AWTConvenience.CloseAction(jDialog));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < SSHMenuHandlerFullSwing.this.authMethod.length - 1; ++i) {
                    if (!SSHMenuHandlerFullSwing.this.authMethod[i].isSelected()) continue;
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(SSHMenuHandlerFull.AUTH_METHODS[i]);
                }
                SSHMenuHandlerFullSwing.this.customAuth = stringBuffer.toString();
                System.err.println(SSHMenuHandlerFullSwing.this.customAuth);
                jDialog.dispose();
            }
        });
        ((Component)jDialog).setVisible(true);
    }

    public final void currentTunnelsDialog(String string) {
        JDialog jDialog = SwingConvenience.newBorderJDialog(this.parent, string, false);
        jDialog.getContentPane().add((Component)new JLabel(SSHMenuHandlerFull.LBL_CURR_TUNNELS), "North");
        this.currList = new JList();
        this.currList.setVisibleRowCount(8);
        this.currList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.currList);
        jDialog.getContentPane().add((Component)jScrollPane, "Center");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if ("close".equals(string)) {
                    int n = SSHMenuHandlerFullSwing.this.currList.getSelectedIndex();
                    if (n == -1) {
                        SSHMenuHandlerFullSwing.this.term.ringBell();
                        return;
                    }
                    SSHMenuHandlerFullSwing.this.client.closeTunnelFromList(n);
                    Thread.yield();
                } else if ("refresh".equals(string)) {
                    // empty if block
                }
                SSHMenuHandlerFullSwing.this.refreshCurrList();
            }
        };
        final JButton jButton = new JButton(SSHMenuHandlerFull.LBL_BTN_CLOSE_TUNNEL);
        JButton jButton2 = new JButton(SSHMenuHandlerFull.LBL_BTN_REFRESH);
        JButton jButton3 = new JButton(SSHMenuHandlerFull.LBL_BTN_DISMISS);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = SSHMenuHandlerFullSwing.this.currList.getSelectedIndex();
                jButton.setEnabled(n >= 0);
            }
        };
        this.currList.addListSelectionListener(listSelectionListener);
        jButton.setActionCommand("close");
        jButton.addActionListener(actionListener);
        jButton.setEnabled(false);
        jButton2.setActionCommand("refresh");
        jButton2.addActionListener(actionListener);
        jDialog.getContentPane().add((Component)SwingConvenience.newButtonPanel(new JButton[]{jButton, jButton2, jButton3}), "South");
        jButton3.addActionListener(new AWTConvenience.CloseAction(jDialog));
        jDialog.setResizable(true);
        jDialog.pack();
        this.refreshCurrList();
        AWTConvenience.placeDialog(jDialog);
        this.currList.requestFocus();
        jDialog.addWindowListener(SwingConvenience.getWindowDisposer());
        ((Component)jDialog).setVisible(true);
    }

    private void refreshCurrList() {
        this.currList.setListData(this.client.listTunnels());
        this.currList.setSelectedIndex(0);
    }

    protected void setupTunnelsDialog(String string) {
        SSHTunnelDialogSwing.show(string, this.client, this.ph, this.parent);
    }

    protected void aboutDialog(Frame frame, SSHInteractiveClient sSHInteractiveClient, String string, String string2) {
        JComponent jComponent;
        JDialog jDialog = SwingConvenience.newBorderJDialog(frame, string, true);
        Logo logo = sSHInteractiveClient.getLogo();
        if (logo != null) {
            jComponent = new JPanel();
            jComponent.add(logo);
            jDialog.getContentPane().add((Component)jComponent, "North");
        }
        jComponent = new JTextArea(string2, 12, 40);
        ((JTextComponent)jComponent).setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jComponent, 20, 31);
        jDialog.getContentPane().add((Component)jScrollPane, "Center");
        JButton jButton = new JButton(SSHMenuHandlerFull.LBL_BTN_OK);
        jButton.addActionListener(new AWTConvenience.CloseAction(jDialog));
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(jButton);
        jDialog.getContentPane().add((Component)jPanel, "South");
        jDialog.setResizable(true);
        jDialog.pack();
        AWTConvenience.placeDialog(jDialog);
        jButton.requestFocus();
        jDialog.addWindowListener(SwingConvenience.getWindowDisposer());
        ((Component)jDialog).setVisible(true);
    }

    private String[] getAvailableAliases() {
        Object[] objectArray = this.ph.availableAliases();
        if (objectArray != null) {
            Arrays.sort(objectArray);
        } else {
            objectArray = new String[]{};
        }
        return objectArray;
    }
}

