/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.digest;

import com.mindbright.jca.security.DigestException;
import com.mindbright.security.digest.MD512BitBlock;

public final class RIPEMD160
extends MD512BitBlock {
    public static final int DIGEST_LENGTH = 20;
    private int[] x;
    private int[] hash = new int[5];
    private static final int[] r1 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 7, 4, 13, 1, 10, 6, 15, 3, 12, 0, 9, 5, 2, 14, 11, 8, 3, 10, 14, 4, 9, 15, 8, 1, 2, 7, 0, 6, 13, 11, 5, 12, 1, 9, 11, 10, 0, 8, 12, 4, 13, 3, 7, 15, 14, 5, 6, 2, 4, 0, 5, 9, 7, 12, 2, 10, 14, 1, 3, 8, 11, 6, 15, 13};
    private static final int[] r2 = new int[]{5, 14, 7, 0, 9, 2, 11, 4, 13, 6, 15, 8, 1, 10, 3, 12, 6, 11, 3, 7, 0, 13, 5, 10, 14, 15, 8, 12, 4, 9, 1, 2, 15, 5, 1, 3, 7, 14, 6, 9, 11, 8, 12, 2, 10, 0, 4, 13, 8, 6, 4, 1, 3, 11, 15, 0, 5, 12, 2, 13, 9, 7, 10, 14, 12, 15, 10, 4, 1, 5, 8, 7, 6, 2, 13, 14, 0, 3, 9, 11};
    private static final int[] s1 = new int[]{11, 14, 15, 12, 5, 8, 7, 9, 11, 13, 14, 15, 6, 7, 9, 8, 7, 6, 8, 13, 11, 9, 7, 15, 7, 12, 15, 9, 11, 7, 13, 12, 11, 13, 6, 7, 14, 9, 13, 15, 14, 8, 13, 6, 5, 12, 7, 5, 11, 12, 14, 15, 14, 15, 9, 8, 9, 14, 5, 6, 8, 6, 5, 12, 9, 15, 5, 11, 6, 8, 13, 12, 5, 12, 13, 14, 11, 8, 5, 6};
    private static final int[] s2 = new int[]{8, 9, 9, 11, 13, 15, 15, 5, 7, 7, 8, 11, 14, 14, 12, 6, 9, 13, 15, 7, 12, 8, 9, 11, 7, 7, 12, 7, 6, 15, 13, 11, 9, 7, 15, 11, 8, 6, 6, 14, 12, 13, 5, 14, 13, 13, 7, 5, 15, 5, 8, 11, 14, 14, 6, 14, 6, 9, 12, 9, 12, 5, 15, 8, 8, 5, 12, 9, 12, 5, 14, 6, 8, 13, 6, 5, 15, 13, 11, 11};

    private static int F00_15(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        n = n + (n2 ^ n3 ^ n4) + n6;
        return MD512BitBlock.rotateLeft(n, n7) + n5;
    }

    private static int F16_31(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        n = n + (n2 & n3 | ~n2 & n4) + n6 + n8;
        return MD512BitBlock.rotateLeft(n, n7) + n5;
    }

    private static int F32_47(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        n = n + ((n2 | ~n3) ^ n4) + n6 + n8;
        return MD512BitBlock.rotateLeft(n, n7) + n5;
    }

    private static int F48_63(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        n = n + (n2 & n4 | n3 & ~n4) + n6 + n8;
        return MD512BitBlock.rotateLeft(n, n7) + n5;
    }

    private static int F64_79(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        n = n + (n2 ^ (n3 | ~n4)) + n6 + n8;
        return MD512BitBlock.rotateLeft(n, n7) + n5;
    }

    protected void transform(byte[] byArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = n8 = this.hash[0];
        int n10 = n7 = this.hash[1];
        int n11 = n6 = this.hash[2];
        int n12 = n5 = this.hash[3];
        int n13 = n4 = this.hash[4];
        for (n3 = 0; n3 < 16; ++n3) {
            this.x[n3] = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        }
        for (n3 = 0; n3 < 16; ++n3) {
            n2 = RIPEMD160.F00_15(n9, n10, n11, n12, n13, this.x[n3], s1[n3]);
            n9 = n13;
            n13 = n12;
            n12 = n11 << 10 | n11 >>> 22;
            n11 = n10;
            n10 = n2;
            n2 = RIPEMD160.F64_79(n8, n7, n6, n5, n4, this.x[r2[n3]], s2[n3], 1352829926);
            n8 = n4;
            n4 = n5;
            n5 = n6 << 10 | n6 >>> 22;
            n6 = n7;
            n7 = n2;
        }
        for (n3 = 16; n3 < 32; ++n3) {
            n2 = RIPEMD160.F16_31(n9, n10, n11, n12, n13, this.x[r1[n3]], s1[n3], 1518500249);
            n9 = n13;
            n13 = n12;
            n12 = n11 << 10 | n11 >>> 22;
            n11 = n10;
            n10 = n2;
            n2 = RIPEMD160.F48_63(n8, n7, n6, n5, n4, this.x[r2[n3]], s2[n3], 1548603684);
            n8 = n4;
            n4 = n5;
            n5 = n6 << 10 | n6 >>> 22;
            n6 = n7;
            n7 = n2;
        }
        for (n3 = 32; n3 < 48; ++n3) {
            n2 = RIPEMD160.F32_47(n9, n10, n11, n12, n13, this.x[r1[n3]], s1[n3], 1859775393);
            n9 = n13;
            n13 = n12;
            n12 = n11 << 10 | n11 >>> 22;
            n11 = n10;
            n10 = n2;
            n2 = RIPEMD160.F32_47(n8, n7, n6, n5, n4, this.x[r2[n3]], s2[n3], 1836072691);
            n8 = n4;
            n4 = n5;
            n5 = n6 << 10 | n6 >>> 22;
            n6 = n7;
            n7 = n2;
        }
        for (n3 = 48; n3 < 64; ++n3) {
            n2 = RIPEMD160.F48_63(n9, n10, n11, n12, n13, this.x[r1[n3]], s1[n3], -1894007588);
            n9 = n13;
            n13 = n12;
            n12 = n11 << 10 | n11 >>> 22;
            n11 = n10;
            n10 = n2;
            n2 = RIPEMD160.F16_31(n8, n7, n6, n5, n4, this.x[r2[n3]], s2[n3], 2053994217);
            n8 = n4;
            n4 = n5;
            n5 = n6 << 10 | n6 >>> 22;
            n6 = n7;
            n7 = n2;
        }
        for (n3 = 64; n3 < 80; ++n3) {
            n2 = RIPEMD160.F64_79(n9, n10, n11, n12, n13, this.x[r1[n3]], s1[n3], -1454113458);
            n9 = n13;
            n13 = n12;
            n12 = n11 << 10 | n11 >>> 22;
            n11 = n10;
            n10 = n2;
            n2 = RIPEMD160.F00_15(n8, n7, n6, n5, n4, this.x[r2[n3]], s2[n3]);
            n8 = n4;
            n4 = n5;
            n5 = n6 << 10 | n6 >>> 22;
            n6 = n7;
            n7 = n2;
        }
        this.hash[1] = this.hash[2] + n12 + n4;
        this.hash[2] = this.hash[3] + n13 + n8;
        this.hash[3] = this.hash[4] + n9 + n7;
        this.hash[4] = this.hash[0] + n10 + n6;
        this.hash[0] = n5 += n11 + this.hash[1];
    }

    public RIPEMD160() {
        super("RIPEMD160", 20);
        this.x = new int[16];
    }

    protected MD512BitBlock cloneInternal() {
        RIPEMD160 rIPEMD160 = new RIPEMD160();
        rIPEMD160.hash[0] = this.hash[0];
        rIPEMD160.hash[1] = this.hash[1];
        rIPEMD160.hash[2] = this.hash[2];
        rIPEMD160.hash[3] = this.hash[3];
        rIPEMD160.hash[4] = this.hash[4];
        return rIPEMD160;
    }

    protected void engineReset() {
        this.hash[0] = 1732584193;
        this.hash[1] = -271733879;
        this.hash[2] = -1732584194;
        this.hash[3] = 271733878;
        this.hash[4] = -1009589776;
        this.count = 0L;
        this.rest = 0;
    }

    protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        int n3;
        int n4 = n3 = this.rest < 56 ? 56 - this.rest : 120 - this.rest;
        if (n2 < 20) {
            throw new DigestException("RIPEMD160, output buffer too short");
        }
        this.count *= 8L;
        byte[] byArray2 = new byte[]{(byte)this.count, (byte)(this.count >>> 8), (byte)(this.count >>> 16), (byte)(this.count >>> 24), (byte)(this.count >>> 32), (byte)(this.count >>> 40), (byte)(this.count >>> 58), (byte)(this.count >>> 56)};
        this.engineUpdate(MD512BitBlock.md4_padding, 0, n3);
        this.engineUpdate(byArray2, 0, 8);
        for (int i = 0; i < 5; ++i) {
            int n5 = this.hash[i];
            byArray[n++] = (byte)(n5 & 0xFF);
            byArray[n++] = (byte)(n5 >>> 8 & 0xFF);
            byArray[n++] = (byte)(n5 >>> 16 & 0xFF);
            byArray[n++] = (byte)(n5 >>> 24 & 0xFF);
        }
        this.engineReset();
        return 20;
    }
}

