/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.net.telnet;

import com.mindbright.net.telnet.TelnetEventHandler;
import com.mindbright.net.telnet.TelnetNVT;
import com.mindbright.terminal.TerminalInputChaff;
import com.mindbright.terminal.TerminalWindow;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;

public class TelnetTerminalAdapter
extends TerminalInputChaff
implements TelnetEventHandler {
    private TelnetNVT telnet;
    private TerminalWindow terminal;
    private StringBuffer lineBuffer;
    private boolean bufferedInput;
    private boolean doNAWS;
    private boolean doBinary = false;
    private boolean crmod;
    private boolean crlf = false;

    public TelnetTerminalAdapter(InputStream inputStream, OutputStream outputStream, TerminalWindow terminalWindow) {
        this.telnet = new TelnetNVT(this, inputStream, outputStream);
        this.terminal = terminalWindow;
        this.lineBuffer = new StringBuffer();
        this.bufferedInput = true;
        terminalWindow.addInputListener(this);
        try {
            this.crmod = true;
            terminalWindow.setProperty("auto-linefeed", "true");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            this.crlf = Boolean.getBoolean(terminalWindow.getProperty("crlf"));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.telnet.start();
    }

    public TelnetNVT getTelnetNVT() {
        return this.telnet;
    }

    public boolean isBuffered() {
        return this.bufferedInput;
    }

    public void interpretAsCommand(int n) {
    }

    public void optionSubNegotiation(int n, byte[] byArray) throws IOException {
        byte[] byArray2 = null;
        if (byArray[0] == 1) {
            switch (n) {
                case 24: {
                    byArray2 = this.terminal.terminalType().getBytes();
                    break;
                }
                case 32: {
                    byArray2 = "38400,38400".getBytes();
                }
            }
        }
        if (byArray2 != null) {
            byte[] byArray3 = byArray2;
            int n2 = byArray3.length;
            byArray2 = new byte[n2 + 1];
            byArray2[0] = 0;
            System.arraycopy(byArray3, 0, byArray2, 1, n2);
            this.telnet.sendOptionSubNegotiation(n, byArray2);
        }
    }

    public boolean optionNegotiation(int n, int n2) throws IOException {
        boolean bl = false;
        switch (n) {
            case 1: 
            case 3: 
            case 5: {
                if (n2 != 251) break;
                bl = true;
                this.telnet.doOption(n);
                if (n != 1) break;
                this.bufferedInput = false;
                try {
                    this.crmod = false;
                    this.terminal.setProperty("auto-linefeed", "false");
                }
                catch (NoSuchElementException noSuchElementException) {}
                break;
            }
            case 0: {
                if (n2 == 251) {
                    bl = true;
                    this.telnet.doOption(n);
                    break;
                }
                if (n2 != 253) break;
                bl = true;
                this.doBinary = true;
                this.telnet.willOption(n);
                break;
            }
            case 24: 
            case 31: 
            case 32: 
            case 33: {
                if (n2 != 253) break;
                bl = true;
                this.telnet.willOption(n);
                if (n != 31) break;
                this.doNAWS = true;
                this.signalWindowChanged(this.terminal.rows(), this.terminal.cols(), this.terminal.vpixels(), this.terminal.hpixels());
            }
        }
        return bl;
    }

    public void receiveData(byte by) {
        this.terminal.write(by);
    }

    protected void sendTypedChar(int n) {
        try {
            if (this.bufferedInput) {
                if (n == 127 || n == 8) {
                    if (this.lineBuffer.length() > 0) {
                        boolean bl = false;
                        if (this.lineBuffer.charAt(this.lineBuffer.length() - 1) < ' ') {
                            bl = true;
                        }
                        this.lineBuffer.setLength(this.lineBuffer.length() - 1);
                        this.terminal.write('\b');
                        if (bl) {
                            this.terminal.write('\b');
                        }
                        this.terminal.write(' ');
                        if (bl) {
                            this.terminal.write(' ');
                        }
                        this.terminal.write('\b');
                        if (bl) {
                            this.terminal.write('\b');
                        }
                    } else {
                        this.terminal.ringBell();
                    }
                } else if (n == 10) {
                    this.terminal.write((char)n);
                    if (this.doBinary) {
                        this.lineBuffer.append((char)n);
                    } else {
                        if (this.crmod) {
                            this.lineBuffer.append('\r');
                        }
                        this.lineBuffer.append('\n');
                    }
                    byte[] byArray = this.lineBuffer.toString().getBytes();
                    this.telnet.sendData(byArray, 0, byArray.length);
                    this.lineBuffer.setLength(0);
                } else if (n == 13) {
                    this.lineBuffer.append('\r');
                    if (!this.crlf) {
                        this.lineBuffer.append('\u0000');
                    } else {
                        this.lineBuffer.append('\n');
                    }
                } else {
                    this.lineBuffer.append((char)n);
                    this.terminal.write((char)n);
                }
            } else if (n == 10 && !this.doBinary) {
                if (this.crmod) {
                    byte[] byArray = new byte[2];
                    byArray[0] = 13;
                    byArray[1] = 10;
                    this.telnet.sendData(byArray);
                } else {
                    this.telnet.sendData(10);
                }
            } else if (n == 13 && !this.doBinary) {
                int n2 = !this.crlf ? 0 : 10;
                byte[] byArray = new byte[2];
                byArray[0] = 13;
                byArray[1] = n2;
                this.telnet.sendData(byArray);
            } else {
                this.telnet.sendData(n);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void sendFakeChar() {
    }

    public void sendBytes(byte[] byArray) {
        if (this.isChaffActive() || this.bufferedInput) {
            for (int i = 0; i < byArray.length; ++i) {
                this.typedChar((char)byArray[i]);
            }
        } else {
            try {
                this.telnet.sendData(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void sendBytesDirect(byte[] byArray) {
        try {
            this.telnet.sendData(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void signalWindowChanged(int n, int n2, int n3, int n4) {
        if (this.doNAWS) {
            byte[] byArray = new byte[]{(byte)(n2 >>> 8 & 0xFF), (byte)(n2 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n & 0xFF)};
            try {
                this.telnet.sendOptionSubNegotiation(31, byArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void sendBreak() {
        try {
            this.telnet.sendBreak();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

