/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.asn1;

import com.mindbright.asn1.ASN1String;
import com.mindbright.util.HexDump;

public class ASN1BitString
extends ASN1String {
    public ASN1BitString() {
        super(3);
    }

    public int getBitCount() {
        return (this.value.length - 1) * 8 - this.value[0];
    }

    public byte[] getBitArray() {
        byte[] byArray = new byte[this.value.length - 1];
        System.arraycopy(this.value, 1, byArray, 0, byArray.length);
        return byArray;
    }

    public void setBitArray(byte[] byArray, int n, int n2) {
        int n3 = (8 - n2 % 8) % 8;
        int n4 = n2 / 8 + 1;
        byte[] byArray2 = new byte[n4 + 1];
        byArray2[0] = (byte)n3;
        System.arraycopy(byArray, n, byArray2, 1, n4);
        this.setRaw(byArray2);
    }

    public boolean[] getBooleanArray() {
        int n = (this.value.length - 1) * 8 - this.value[0];
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            int n2 = 128 >>> i % 8;
            blArray[i] = (this.value[i / 8 + 1] & 0xFF & n2) == n2;
        }
        return blArray;
    }

    public void setBooleanArray(boolean[] blArray) {
        int n = blArray.length;
        int n2 = (8 - n % 8) % 8;
        int n3 = n / 8 + 1;
        byte[] byArray = new byte[n3 + 1];
        byArray[0] = (byte)n2;
        for (int i = 0; i < n; ++i) {
            int n4 = 128 >>> i % 8;
            int n5 = i / 8 + 1;
            byArray[n5] = (byte)(byArray[n5] | (blArray[i] ? n4 : 0));
        }
        this.setRaw(byArray);
    }

    public String toPrintableString() {
        for (int i = 0; i < this.value.length; ++i) {
            if (this.value[i] >= 10 && this.value[i] <= 127) continue;
            return "0x" + HexDump.toString(this.value);
        }
        return new String(this.value);
    }
}

