/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.x509;

import com.mindbright.asn1.i;
import com.mindbright.asn1.k;
import com.mindbright.asn1.p;
import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.jca.security.KeyFactory;
import com.mindbright.jca.security.NoSuchAlgorithmException;
import com.mindbright.jca.security.NoSuchProviderException;
import com.mindbright.jca.security.PublicKey;
import com.mindbright.jca.security.SignatureException;
import com.mindbright.jca.security.cert.CertificateEncodingException;
import com.mindbright.jca.security.cert.CertificateException;
import com.mindbright.jca.security.spec.DSAPublicKeySpec;
import com.mindbright.jca.security.spec.RSAPublicKeySpec;
import com.mindbright.security.pkcs1.DSAParams;
import com.mindbright.security.pkcs1.RSAPublicKey;
import com.mindbright.security.x509.Certificate;
import com.mindbright.security.x509.Extension;
import com.mindbright.security.x509.Extensions;
import com.mindbright.security.x509.SubjectPublicKeyInfo;
import com.mindbright.security.x509.a;
import com.mindbright.security.x509.b;
import com.mindbright.security.x509.c;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class X509Certificate
extends com.mindbright.jca.security.cert.Certificate {
    private byte[] a;
    private Certificate a;
    static Class b;
    static Class a;
    static Class c;

    public X509Certificate(byte[] byArray) {
        super("X.509");
        this.a = byArray;
        this.a = new Certificate();
        k.a("com.mindbright.security.x509");
        k.a("com.mindbright.security.pkcs1");
        try {
            i i2 = new i();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            i2.a((InputStream)byteArrayInputStream, (p)this.a);
        }
        catch (IOException iOException) {
            throw new Error("Internal error decoding DER encoded X.509 cert: " + iOException.getMessage());
        }
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        return this.a;
    }

    public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
    }

    public void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
    }

    public String toString() {
        return "X509 Certificate: \n  subject: " + this.getSubjectDN() + "\n" + "  issuer: " + this.getIssuerDN() + "\n" + "  version: " + (this.getVersion() + 1) + "\n" + "  pubalg: " + this.getPubAlgName() + "\n" + "  serialNo: " + this.getSerialNumber() + "\n\n" + " Extensions:\n\n" + this.getExtensions();
    }

    public String getIssuerDN() {
        return this.a.tbsCertificate.issuer.getRFC2253Value();
    }

    public String getSubjectDN() {
        return this.a.tbsCertificate.subject.getRFC2253Value();
    }

    public BigInteger getSerialNumber() {
        return this.a.tbsCertificate.serialNumber.getValue();
    }

    public String getPubAlgName() {
        return this.a.tbsCertificate.subjectPublicKeyInfo.algorithm.algorithmName();
    }

    private p a(String string, Class clazz) {
        try {
            Extensions extensions = this.a.tbsCertificate.extensions;
            for (int i2 = 0; i2 < extensions.a(); ++i2) {
                Extension extension = (Extension)extensions.b(i2);
                if (!extension.extnID.getString().equals(string)) continue;
                i i3 = new i();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extension.extnValue.a());
                p p2 = (p)clazz.newInstance();
                i3.a((InputStream)byteArrayInputStream, p2);
                return p2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public b getSubjectKeyIdentifier() {
        return (b)this.a("2.5.29.14", b == null ? (b = X509Certificate.a("com.mindbright.security.x509.b")) : b);
    }

    public a getKeyUsage() {
        return (a)this.a("2.5.29.15", a == null ? (a = X509Certificate.a("com.mindbright.security.x509.a")) : a);
    }

    public c getBasicConstraints() {
        return (c)this.a("2.5.29.19", c == null ? (c = X509Certificate.a("com.mindbright.security.x509.c")) : c);
    }

    public String getExtensions() {
        String string = "";
        try {
            Extensions extensions = this.a.tbsCertificate.extensions;
            for (int i2 = 0; i2 < extensions.a(); ++i2) {
                String string2;
                Extension extension = (Extension)extensions.b(i2);
                String string3 = extension.extnID.getString();
                String string4 = string2 = extension.critical.getValue() ? "yes" : "no ";
                String string5 = string3.equals("2.5.29.14") ? this.getKeyUsage().toString() : (string3.equals("2.5.29.15") ? this.getSubjectKeyIdentifier().toString() : (string3.equals("2.5.29.19") ? this.getBasicConstraints().toString() : string3));
                string = string + "  critical: " + string2 + " " + string5 + "\n";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    public int getVersion() {
        int n2 = 0;
        try {
            n2 = this.a.tbsCertificate.version.getValue().intValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return n2;
    }

    public PublicKey getPublicKey() {
        SubjectPublicKeyInfo subjectPublicKeyInfo = this.a.tbsCertificate.subjectPublicKeyInfo;
        String string = subjectPublicKeyInfo.algorithm.algorithmName().toUpperCase();
        i i2 = new i();
        if (string.startsWith("RSA")) {
            RSAPublicKey rSAPublicKey = new RSAPublicKey();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(subjectPublicKeyInfo.subjectPublicKey.getBitArray());
            try {
                i2.a((InputStream)byteArrayInputStream, (p)rSAPublicKey);
            }
            catch (Exception exception) {
                throw new Error("Internal error decoding SubjectPublicKeyInfo.subjectPublicKey: " + exception.getMessage());
            }
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(rSAPublicKey.modulus.getValue(), rSAPublicKey.publicExponent.getValue());
                return keyFactory.generatePublic(rSAPublicKeySpec);
            }
            catch (Exception exception) {
                throw new Error("Error creating RSA key: " + exception.getMessage());
            }
        }
        if (string.startsWith("DSA")) {
            com.mindbright.security.pkcs1.a a2 = new com.mindbright.security.pkcs1.a();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(subjectPublicKeyInfo.subjectPublicKey.getBitArray());
            try {
                i2.a((InputStream)byteArrayInputStream, (p)a2);
            }
            catch (Exception exception) {
                throw new Error("Internal error decoding SubjectPublicKeyInfo.subjectPublicKey: " + exception.getMessage());
            }
            BigInteger bigInteger = a2.getValue();
            DSAParams dSAParams = (DSAParams)subjectPublicKeyInfo.algorithm.parameters.a();
            BigInteger bigInteger2 = dSAParams.p.getValue();
            BigInteger bigInteger3 = dSAParams.q.getValue();
            BigInteger bigInteger4 = dSAParams.g.getValue();
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("DSA");
                DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(bigInteger, bigInteger2, bigInteger3, bigInteger4);
                return keyFactory.generatePublic(dSAPublicKeySpec);
            }
            catch (Exception exception) {
                throw new Error("Error creating DSA key: " + exception.getMessage());
            }
        }
        throw new Error("Internal error decoding publicKey: unknown algorithm");
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

