/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.publickey;

import com.mindbright.jca.security.InvalidAlgorithmParameterException;
import com.mindbright.jca.security.KeyPair;
import com.mindbright.jca.security.KeyPairGenerator;
import com.mindbright.jca.security.SecureRandom;
import com.mindbright.jca.security.spec.AlgorithmParameterSpec;
import com.mindbright.jca.security.spec.DSAParameterSpec;
import com.mindbright.security.publickey.DSAAlgorithm;
import com.mindbright.security.publickey.DSAPrivateKey;
import com.mindbright.security.publickey.DSAPublicKey;
import java.math.BigInteger;

public class DSAKeyPairGenerator
extends KeyPairGenerator {
    protected SecureRandom random;
    protected int keysize;
    protected DSAParameterSpec params;

    public DSAKeyPairGenerator() {
        super("DSA");
    }

    public void initialize(int n2, SecureRandom secureRandom) {
        this.random = secureRandom;
        this.keysize = n2;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Invalid params: " + algorithmParameterSpec);
        }
        this.params = (DSAParameterSpec)algorithmParameterSpec;
        this.random = secureRandom;
    }

    public KeyPair generateKeyPair() {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        if (this.params == null) {
            this.params = DSAAlgorithm.generateParams(this.keysize, 160, this.random);
        }
        BigInteger bigInteger = this.params.getP();
        BigInteger bigInteger2 = this.params.getQ();
        BigInteger bigInteger3 = this.params.getG();
        BigInteger bigInteger4 = DSAAlgorithm.generatePrivateKey(bigInteger2, this.random);
        BigInteger bigInteger5 = DSAAlgorithm.generatePublicKey(bigInteger3, bigInteger, bigInteger4);
        return new KeyPair(new DSAPublicKey(bigInteger5, bigInteger, bigInteger2, bigInteger3), new DSAPrivateKey(bigInteger4, bigInteger, bigInteger2, bigInteger3));
    }
}

