/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.publickey;

import com.mindbright.jca.security.InvalidAlgorithmParameterException;
import com.mindbright.jca.security.KeyPair;
import com.mindbright.jca.security.KeyPairGenerator;
import com.mindbright.jca.security.SecureRandom;
import com.mindbright.jca.security.spec.AlgorithmParameterSpec;
import com.mindbright.jce.crypto.spec.DHParameterSpec;
import com.mindbright.security.publickey.DHPrivateKey;
import com.mindbright.security.publickey.DHPublicKey;
import com.mindbright.security.publickey.DiffieHellman;
import java.math.BigInteger;

public class DHKeyPairGenerator
extends KeyPairGenerator {
    protected DHParameterSpec params;
    protected SecureRandom random;

    public DHKeyPairGenerator() {
        super("DH");
    }

    public void initialize(int n2, SecureRandom secureRandom) {
        throw new Error("Not implemented: 'DHKeyPairGenerator.initialize(int, SecureRandom)'");
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Invalid params: " + algorithmParameterSpec);
        }
        this.params = (DHParameterSpec)algorithmParameterSpec;
        this.random = secureRandom;
    }

    public KeyPair generateKeyPair() {
        BigInteger bigInteger = this.params.getG();
        BigInteger bigInteger2 = this.params.getP();
        int n2 = this.params.getL();
        if (n2 == 0) {
            n2 = bigInteger2.bitLength();
        }
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        BigInteger bigInteger3 = DiffieHellman.generateX(bigInteger2, n2, this.random);
        BigInteger bigInteger4 = DiffieHellman.generateY(bigInteger3, bigInteger, bigInteger2);
        return new KeyPair(new DHPublicKey(bigInteger4, bigInteger2, bigInteger), new DHPrivateKey(bigInteger3, bigInteger2, bigInteger));
    }
}

