/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.keystore;

import com.mindbright.asn1.ASN1Integer;
import com.mindbright.asn1.ASN1OctetString;
import com.mindbright.asn1.a;
import com.mindbright.asn1.i;
import com.mindbright.asn1.k;
import com.mindbright.asn1.p;
import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.jca.security.Key;
import com.mindbright.jca.security.KeyFactory;
import com.mindbright.jca.security.KeyStoreException;
import com.mindbright.jca.security.KeyStoreSpi;
import com.mindbright.jca.security.MessageDigest;
import com.mindbright.jca.security.NoSuchAlgorithmException;
import com.mindbright.jca.security.PrivateKey;
import com.mindbright.jca.security.UnrecoverableKeyException;
import com.mindbright.jca.security.cert.Certificate;
import com.mindbright.jca.security.cert.CertificateException;
import com.mindbright.jca.security.spec.DSAPrivateKeySpec;
import com.mindbright.jca.security.spec.RSAPrivateCrtKeySpec;
import com.mindbright.jce.crypto.Cipher;
import com.mindbright.jce.crypto.Mac;
import com.mindbright.jce.crypto.spec.IvParameterSpec;
import com.mindbright.jce.crypto.spec.SecretKeySpec;
import com.mindbright.security.keystore.d;
import com.mindbright.security.pkcs1.DSAParams;
import com.mindbright.security.pkcs1.RSAPrivateKey;
import com.mindbright.security.pkcs12.AuthenticatedSafe;
import com.mindbright.security.pkcs12.CertBag;
import com.mindbright.security.pkcs12.PFX;
import com.mindbright.security.pkcs12.PKCS12PbeParams;
import com.mindbright.security.pkcs12.SafeBag;
import com.mindbright.security.pkcs12.SafeContents;
import com.mindbright.security.pkcs7.ContentInfo;
import com.mindbright.security.pkcs7.EncryptedData;
import com.mindbright.security.pkcs8.EncryptedPrivateKeyInfo;
import com.mindbright.security.pkcs8.PrivateKeyInfo;
import com.mindbright.security.x509.Attribute;
import com.mindbright.security.x509.X509Certificate;
import com.mindbright.util.e;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class PKCS12KeyStore
extends KeyStoreSpi {
    private Hashtable b;
    private Hashtable c;
    private Hashtable a;
    private Vector a;

    public PKCS12KeyStore() {
        k.a("com.mindbright.security.pkcs12");
        k.b("1.3.6.1.4.1.311.17.1", "ASN1BMPString");
        this.b = new Hashtable();
        this.c = new Hashtable();
        this.a = new Vector();
        this.a = new Hashtable();
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        String string2 = (String)this.a.get(string);
        if (string2 == null) {
            return null;
        }
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = (EncryptedPrivateKeyInfo)this.b.get(string2);
        return PKCS12KeyStore.a(encryptedPrivateKeyInfo, cArray);
    }

    public Certificate[] engineGetCertificateChain(String string) {
        return null;
    }

    public Certificate engineGetCertificate(String string) {
        if (string == null) {
            return null;
        }
        X509Certificate x509Certificate = null;
        byte[] byArray = null;
        String string2 = (String)this.a.get(string);
        if (string2 == null) {
            string2 = string;
        }
        if ((byArray = (byte[])this.c.get(string2)) != null) {
            x509Certificate = new X509Certificate(byArray);
        }
        return x509Certificate;
    }

    public Date engineGetCreationDate(String string) {
        return null;
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
    }

    public Enumeration engineAliases() {
        return this.a.elements();
    }

    public boolean engineContainsAlias(String string) {
        return this.a.contains(string);
    }

    public int engineSize() {
        return this.a.size();
    }

    public boolean engineIsKeyEntry(String string) {
        return this.a.get(string) != null;
    }

    public boolean engineIsCertificateEntry(String string) {
        return !this.engineIsKeyEntry(string) && this.c.get(string) != null;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        return null;
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        try {
            i i2 = new i();
            PFX pFX = new PFX();
            i2.a(inputStream, (p)pFX);
            this.a(pFX, cArray);
            AuthenticatedSafe authenticatedSafe = new AuthenticatedSafe();
            ASN1OctetString aSN1OctetString = pFX.getDataContent();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(aSN1OctetString.a());
            i2.a((InputStream)byteArrayInputStream, (p)authenticatedSafe);
            for (int i3 = 0; i3 < authenticatedSafe.a(); ++i3) {
                ContentInfo contentInfo = authenticatedSafe.getContentInfo(i3);
                String string = contentInfo.contentType.getString();
                if (string.equals("1.2.840.113549.1.7.1")) {
                    aSN1OctetString = (ASN1OctetString)contentInfo.content.a();
                    this.a(aSN1OctetString.a());
                    continue;
                }
                if (string.equals("1.2.840.113549.1.7.6")) {
                    EncryptedData encryptedData = (EncryptedData)contentInfo.content.a();
                    String string2 = encryptedData.encryptedContentInfo.contentEncryptionAlgorithm.algorithmName();
                    byte[] byArray = encryptedData.encryptedContentInfo.encryptedContent.a();
                    PKCS12PbeParams pKCS12PbeParams = (PKCS12PbeParams)encryptedData.encryptedContentInfo.contentEncryptionAlgorithm.parameters.a();
                    byte[] byArray2 = pKCS12PbeParams.salt.a();
                    int n2 = pKCS12PbeParams.iterations.getValue().intValue();
                    byte[] byArray3 = new byte[byArray.length];
                    PKCS12KeyStore.a(1, cArray, byArray, byArray.length, byArray3, byArray2, n2, string2);
                    this.a(byArray3);
                    continue;
                }
                throw new IOException("ContentInfo type not supported: " + string);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
    }

    private void a(PFX pFX, char[] cArray) throws CertificateException {
        if (!pFX.macData.a()) {
            return;
        }
        try {
            String string = pFX.macData.mac.digestAlgorithm.algorithm.getString();
            Mac mac = Mac.getInstance(string);
            byte[] byArray = pFX.getDataContent().a();
            byte[] byArray2 = pFX.macData.mac.digest.a();
            byte[] byArray3 = pFX.macData.macSalt.a();
            int n2 = pFX.macData.getIterations();
            byte[] byArray4 = PKCS12KeyStore.a(cArray, 20, byArray3, n2, 3, string);
            mac.init(new SecretKeySpec(byArray4, mac.getAlgorithm()));
            mac.update(byArray);
            byte[] byArray5 = mac.doFinal();
            for (int i2 = 0; i2 < byArray2.length; ++i2) {
                if (byArray5[i2] == byArray2[i2]) continue;
                throw new CertificateException("MAC check failed");
            }
        }
        catch (Exception exception) {
            throw new CertificateException("Error when verifying MAC: " + exception.getMessage());
        }
    }

    private void a(byte[] byArray) throws IOException, NoSuchAlgorithmException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        SafeContents safeContents = new SafeContents();
        i i2 = new i();
        i2.a((InputStream)byteArrayInputStream, (p)safeContents);
        block4: for (int i3 = 0; i3 < safeContents.a(); ++i3) {
            SafeBag safeBag = safeContents.getSafeBag(i3);
            String string = this.a(safeBag, "1.2.840.113549.1.9.20");
            String string2 = this.a(safeBag, "1.2.840.113549.1.9.21");
            if (string != null) {
                if (string2 != null) {
                    this.a.put(string, string2);
                }
                if (!this.a.contains(string)) {
                    this.a.addElement(string);
                }
            } else if (string2 != null) {
                this.a.put(string2, string2);
                if (!this.a.contains(string2)) {
                    this.a.addElement(string2);
                }
            }
            switch (safeBag.getBagType()) {
                case 2: {
                    EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = (EncryptedPrivateKeyInfo)safeBag.bagValue.a();
                    this.b.put(string2, encryptedPrivateKeyInfo);
                    continue block4;
                }
                case 3: {
                    CertBag certBag = (CertBag)safeBag.bagValue.a();
                    byte[] byArray2 = ((ASN1OctetString)certBag.certValue.a()).a();
                    if (string2 == null) {
                        string2 = string;
                    }
                    if (string2 == null) continue block4;
                    this.c.put(string2, byArray2);
                    continue block4;
                }
                default: {
                    throw new IOException("SafeBag type not supported: " + safeBag.bagId.getString());
                }
            }
        }
    }

    private static PrivateKey a(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        i i2 = new i();
        PKCS12PbeParams pKCS12PbeParams = (PKCS12PbeParams)encryptedPrivateKeyInfo.encryptionAlgorithm.parameters.a();
        String string = encryptedPrivateKeyInfo.encryptionAlgorithm.algorithmName();
        byte[] byArray = encryptedPrivateKeyInfo.encryptedData.a();
        byte[] byArray2 = pKCS12PbeParams.salt.a();
        int n2 = pKCS12PbeParams.iterations.getValue().intValue();
        byte[] byArray3 = new byte[byArray.length];
        PKCS12KeyStore.a(1, cArray, byArray, byArray.length, byArray3, byArray2, n2, string);
        return PKCS12KeyStore.extractPrivateKey(byArray3);
    }

    public static PrivateKey extractPrivateKey(byte[] byArray) throws UnrecoverableKeyException {
        i i2 = new i();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo();
        try {
            p p2;
            Object object;
            i2.a((InputStream)byteArrayInputStream, (p)privateKeyInfo);
            boolean bl2 = true;
            try {
                object = privateKeyInfo.privateKeyAlgorithm.algorithmName().toLowerCase();
                if (((String)object).indexOf("dsa") >= 0) {
                    bl2 = false;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            byteArrayInputStream = new ByteArrayInputStream(privateKeyInfo.privateKey.a());
            if (bl2) {
                object = new RSAPrivateKey();
                i2.a((InputStream)byteArrayInputStream, (p)object);
                BigInteger bigInteger = ((RSAPrivateKey)object).modulus.getValue();
                BigInteger bigInteger2 = ((RSAPrivateKey)object).publicExponent.getValue();
                BigInteger bigInteger3 = ((RSAPrivateKey)object).privateExponent.getValue();
                BigInteger bigInteger4 = ((RSAPrivateKey)object).prime1.getValue();
                BigInteger bigInteger5 = ((RSAPrivateKey)object).prime2.getValue();
                BigInteger bigInteger6 = ((RSAPrivateKey)object).exponent1.getValue();
                BigInteger bigInteger7 = ((RSAPrivateKey)object).exponent2.getValue();
                BigInteger bigInteger8 = ((RSAPrivateKey)object).coefficient.getValue();
                RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                return keyFactory.generatePrivate(rSAPrivateCrtKeySpec);
            }
            object = null;
            try {
                p2 = new ASN1Integer();
                i2.a((InputStream)byteArrayInputStream, p2);
                object = p2.getValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (object == null) {
                p2 = new d();
                i2.a((InputStream)new ByteArrayInputStream(privateKeyInfo.privateKey.a()), p2);
                object = ((d)p2).b.getValue();
            }
            p2 = (DSAParams)privateKeyInfo.privateKeyAlgorithm.parameters.a();
            DSAPrivateKeySpec dSAPrivateKeySpec = new DSAPrivateKeySpec((BigInteger)object, ((DSAParams)p2).p.getValue(), ((DSAParams)p2).q.getValue(), ((DSAParams)p2).g.getValue());
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            return keyFactory.generatePrivate(dSAPrivateKeySpec);
        }
        catch (Exception exception) {
            throw new UnrecoverableKeyException(exception.getMessage());
        }
    }

    private String a(SafeBag safeBag, String string) {
        int n2 = safeBag.bagAttributes.a();
        String string2 = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            Attribute attribute = (Attribute)safeBag.bagAttributes.b(i2);
            if (!string.equals(attribute.type.getString())) continue;
            p p2 = attribute.values.b(0);
            string2 = p2 instanceof a ? ((a)p2).getValue() : (p2 instanceof ASN1OctetString ? e.a(((ASN1OctetString)p2).a()) : p2.toString());
        }
        return string2;
    }

    private static byte[] a(char[] cArray, int n2, byte[] byArray, int n3, int n4, String string) {
        try {
            int n5;
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            int n6 = messageDigest.getDigestLength();
            byte[] byArray2 = new byte[n6];
            byte[] byArray3 = new byte[n2];
            int n7 = 64;
            byte[] byArray4 = new byte[cArray.length * 2 + 2];
            int n8 = (byArray.length + n7 - 1) / n7 * n7;
            int n9 = (byArray4.length + n7 - 1) / n7 * n7;
            byte[] byArray5 = new byte[n7];
            byte[] byArray6 = new byte[n8 + n9];
            byte[] byArray7 = new byte[n7];
            for (n5 = 0; n5 < cArray.length; ++n5) {
                byArray4[n5 * 2] = (byte)(cArray[n5] >>> 8);
                byArray4[n5 * 2 + 1] = (byte)(cArray[n5] & 0xFF);
            }
            for (n5 = 0; n5 < n7; ++n5) {
                byArray5[n5] = (byte)n4;
            }
            for (n5 = 0; n5 < n8; ++n5) {
                byArray6[n5] = byArray[n5 % byArray.length];
            }
            for (n5 = 0; n5 < n9; ++n5) {
                byArray6[n8 + n5] = byArray4[n5 % byArray4.length];
            }
            int n10 = 0;
            BigInteger bigInteger = BigInteger.valueOf(1L);
            byte[] byArray8 = new byte[n7];
            block6: while (true) {
                messageDigest.update(byArray5);
                messageDigest.update(byArray6);
                messageDigest.digest(byArray2, 0, n6);
                for (n5 = 1; n5 < n3; ++n5) {
                    messageDigest.update(byArray2);
                    messageDigest.digest(byArray2, 0, n6);
                }
                int n11 = n6 > n2 - n10 ? n2 - n10 : n6;
                System.arraycopy(byArray2, 0, byArray3, n10, n11);
                if ((n10 += n11) >= n2) break;
                for (n5 = 0; n5 < n7; ++n5) {
                    byArray7[n5] = byArray2[n5 % n6];
                }
                BigInteger bigInteger2 = new BigInteger(1, byArray7).add(bigInteger);
                n5 = 0;
                while (true) {
                    if (n5 >= byArray6.length) continue block6;
                    System.arraycopy(byArray6, n5, byArray8, 0, n7);
                    BigInteger bigInteger3 = new BigInteger(1, byArray8);
                    bigInteger3 = bigInteger3.add(bigInteger2);
                    byArray8 = PKCS12KeyStore.a(bigInteger3, n7);
                    System.arraycopy(byArray8, 0, byArray6, n5, n7);
                    n5 += n7;
                }
                break;
            }
            return byArray3;
        }
        catch (Exception exception) {
            throw new Error("Error in PKCS12.deriveKey: " + exception);
        }
    }

    private static byte[] a(BigInteger bigInteger, int n2) {
        byte[] byArray = bigInteger.toByteArray();
        byte[] byArray2 = null;
        if (byArray.length > n2) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, byArray.length - n2, byArray2, 0, n2);
        } else if (byArray.length < n2) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, n2 - byArray.length, byArray.length);
        } else {
            byArray2 = byArray;
        }
        return byArray2;
    }

    private static byte[] a(char[] cArray, byte[] byArray, int n2, int n3, String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            byte[] byArray2 = new byte[cArray.length];
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                byArray2[i2] = (byte)(cArray[i2] & 0xFF);
            }
            messageDigest.update(byArray2);
            messageDigest.update(byArray);
            byte[] byArray3 = messageDigest.digest();
            int n4 = byArray3.length;
            for (int i3 = 1; i3 < n2; ++i3) {
                messageDigest.update(byArray3);
                messageDigest.digest(byArray3, 0, n4);
            }
            byte[] byArray4 = new byte[n3];
            System.arraycopy(byArray3, 0, byArray4, 0, n3);
            return byArray4;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private static void a(int n2, char[] cArray, byte[] byArray, int n3, byte[] byArray2, byte[] byArray3, int n4, String string) throws NoSuchAlgorithmException {
        try {
            byte[] byArray4;
            byte[] byArray5;
            int n5 = 40;
            boolean bl2 = false;
            String string2 = "SHA";
            if (string.equals("pbeWithSHAAnd3-KeyTripleDES-CBC")) {
                n5 = 192;
                string = "3DES/CBC/PKCS5Padding";
            } else if (string.equals("pbeWithSHAAnd2-KeyTripleDES-CBC")) {
                n5 = 128;
                string = "3DES/CBC/PKCS5Padding";
            } else if (string.equals("pbeWithSHAAnd40BitRC2-CBC")) {
                string = "RC2/CBC/PKCS5Padding";
            } else if (string.equals("pbeWithSHAAnd128BitRC2-CBC")) {
                n5 = 128;
                string = "RC2/CBC/PKCS5Padding";
            } else if (string.equals("pbeWithSHAAnd40BitRC4")) {
                string = "RC4/OFB/PKCS5Padding";
            } else if (string.equals("pbeWithSHAAnd128BitRC4")) {
                n5 = 128;
                string = "RC4/OFB/PKCS5Padding";
            } else if (string.equals("pbeWithSHA1AndRC2-CBC")) {
                bl2 = true;
                n5 = 64;
                string = "RC2/CBC/PKCS5Padding";
                string2 = "SHA1";
            } else if (string.equals("pbeWithMD2AndRC2-CBC")) {
                bl2 = true;
                n5 = 64;
                string = "RC2/CBC/PKCS5Padding";
                string2 = "MD2";
            } else if (string.equals("pbeWithMD5AndRC2-CBC")) {
                bl2 = true;
                n5 = 64;
                string = "RC2/CBC/PKCS5Padding";
                string2 = "MD5";
            } else if (string.equals("pbeWithMD2AndDES-CBC")) {
                bl2 = true;
                n5 = 64;
                string = "DES/CBC/PKCS5Padding";
                string2 = "MD2";
            } else if (string.equals("pbeWithMD5AndDES-CBC")) {
                bl2 = true;
                n5 = 64;
                string = "DES/CBC/PKCS5Padding";
                string2 = "MD5";
            } else if (string.equals("pbeWithSHA1AndDES-CBC")) {
                bl2 = true;
                n5 = 64;
                string = "DES/CBC/PKCS5Padding";
                string2 = "SHA1";
            }
            n5 /= 8;
            Cipher cipher = Cipher.getInstance(string);
            string = cipher.getAlgorithm();
            if (bl2) {
                byte[] byArray6 = PKCS12KeyStore.a(cArray, byArray3, n4, 16, string2);
                byArray5 = new byte[8];
                System.arraycopy(byArray6, 0, byArray5, 0, 8);
                byArray4 = new byte[8];
                System.arraycopy(byArray6, 8, byArray4, 0, 8);
            } else {
                byArray5 = PKCS12KeyStore.a(cArray, n5, byArray3, n4, 1, string2);
                byArray4 = PKCS12KeyStore.a(cArray, 8, byArray3, n4, 2, string2);
            }
            cipher.init(n2, new SecretKeySpec(byArray5, string), new IvParameterSpec(byArray4));
            cipher.doFinal(byArray, 0, n3, byArray2, 0);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new Error("Invalid key derived in PKCS12KeyStore.doCipher: " + invalidKeyException);
        }
    }
}

