/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.digest;

import com.mindbright.jca.security.DigestException;
import com.mindbright.security.digest.MD512BitBlock;

public final class RIPEMD160
extends MD512BitBlock {
    public static final int DIGEST_LENGTH = 20;
    private int[] f;
    private int[] e = new int[5];
    private static final int[] d = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 7, 4, 13, 1, 10, 6, 15, 3, 12, 0, 9, 5, 2, 14, 11, 8, 3, 10, 14, 4, 9, 15, 8, 1, 2, 7, 0, 6, 13, 11, 5, 12, 1, 9, 11, 10, 0, 8, 12, 4, 13, 3, 7, 15, 14, 5, 6, 2, 4, 0, 5, 9, 7, 12, 2, 10, 14, 1, 3, 8, 11, 6, 15, 13};
    private static final int[] b = new int[]{5, 14, 7, 0, 9, 2, 11, 4, 13, 6, 15, 8, 1, 10, 3, 12, 6, 11, 3, 7, 0, 13, 5, 10, 14, 15, 8, 12, 4, 9, 1, 2, 15, 5, 1, 3, 7, 14, 6, 9, 11, 8, 12, 2, 10, 0, 4, 13, 8, 6, 4, 1, 3, 11, 15, 0, 5, 12, 2, 13, 9, 7, 10, 14, 12, 15, 10, 4, 1, 5, 8, 7, 6, 2, 13, 14, 0, 3, 9, 11};
    private static final int[] c = new int[]{11, 14, 15, 12, 5, 8, 7, 9, 11, 13, 14, 15, 6, 7, 9, 8, 7, 6, 8, 13, 11, 9, 7, 15, 7, 12, 15, 9, 11, 7, 13, 12, 11, 13, 6, 7, 14, 9, 13, 15, 14, 8, 13, 6, 5, 12, 7, 5, 11, 12, 14, 15, 14, 15, 9, 8, 9, 14, 5, 6, 8, 6, 5, 12, 9, 15, 5, 11, 6, 8, 13, 12, 5, 12, 13, 14, 11, 8, 5, 6};
    private static final int[] a = new int[]{8, 9, 9, 11, 13, 15, 15, 5, 7, 7, 8, 11, 14, 14, 12, 6, 9, 13, 15, 7, 12, 8, 9, 11, 7, 7, 12, 7, 6, 15, 13, 11, 9, 7, 15, 11, 8, 6, 6, 14, 12, 13, 5, 14, 13, 13, 7, 5, 15, 5, 8, 11, 14, 14, 6, 14, 6, 9, 12, 9, 12, 5, 15, 8, 8, 5, 12, 9, 12, 5, 14, 6, 8, 13, 6, 5, 15, 13, 11, 11};

    private static int a(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        n2 = n2 + (n3 ^ n4 ^ n5) + n7;
        return MD512BitBlock.rotateLeft(n2, n8) + n6;
    }

    private static int d(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        n2 = n2 + (n3 & n4 | ~n3 & n5) + n7 + n9;
        return MD512BitBlock.rotateLeft(n2, n8) + n6;
    }

    private static int a(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        n2 = n2 + ((n3 | ~n4) ^ n5) + n7 + n9;
        return MD512BitBlock.rotateLeft(n2, n8) + n6;
    }

    private static int b(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        n2 = n2 + (n3 & n5 | n4 & ~n5) + n7 + n9;
        return MD512BitBlock.rotateLeft(n2, n8) + n6;
    }

    private static int c(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        n2 = n2 + (n3 ^ (n4 | ~n5)) + n7 + n9;
        return MD512BitBlock.rotateLeft(n2, n8) + n6;
    }

    protected void transform(byte[] byArray, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = n9 = this.e[0];
        int n11 = n8 = this.e[1];
        int n12 = n7 = this.e[2];
        int n13 = n6 = this.e[3];
        int n14 = n5 = this.e[4];
        for (n4 = 0; n4 < 16; ++n4) {
            this.f[n4] = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24;
        }
        for (n4 = 0; n4 < 16; ++n4) {
            n3 = RIPEMD160.a(n10, n11, n12, n13, n14, this.f[n4], c[n4]);
            n10 = n14;
            n14 = n13;
            n13 = n12 << 10 | n12 >>> 22;
            n12 = n11;
            n11 = n3;
            n3 = RIPEMD160.c(n9, n8, n7, n6, n5, this.f[b[n4]], a[n4], 1352829926);
            n9 = n5;
            n5 = n6;
            n6 = n7 << 10 | n7 >>> 22;
            n7 = n8;
            n8 = n3;
        }
        for (n4 = 16; n4 < 32; ++n4) {
            n3 = RIPEMD160.d(n10, n11, n12, n13, n14, this.f[d[n4]], c[n4], 1518500249);
            n10 = n14;
            n14 = n13;
            n13 = n12 << 10 | n12 >>> 22;
            n12 = n11;
            n11 = n3;
            n3 = RIPEMD160.b(n9, n8, n7, n6, n5, this.f[b[n4]], a[n4], 1548603684);
            n9 = n5;
            n5 = n6;
            n6 = n7 << 10 | n7 >>> 22;
            n7 = n8;
            n8 = n3;
        }
        for (n4 = 32; n4 < 48; ++n4) {
            n3 = RIPEMD160.a(n10, n11, n12, n13, n14, this.f[d[n4]], c[n4], 1859775393);
            n10 = n14;
            n14 = n13;
            n13 = n12 << 10 | n12 >>> 22;
            n12 = n11;
            n11 = n3;
            n3 = RIPEMD160.a(n9, n8, n7, n6, n5, this.f[b[n4]], a[n4], 1836072691);
            n9 = n5;
            n5 = n6;
            n6 = n7 << 10 | n7 >>> 22;
            n7 = n8;
            n8 = n3;
        }
        for (n4 = 48; n4 < 64; ++n4) {
            n3 = RIPEMD160.b(n10, n11, n12, n13, n14, this.f[d[n4]], c[n4], -1894007588);
            n10 = n14;
            n14 = n13;
            n13 = n12 << 10 | n12 >>> 22;
            n12 = n11;
            n11 = n3;
            n3 = RIPEMD160.d(n9, n8, n7, n6, n5, this.f[b[n4]], a[n4], 2053994217);
            n9 = n5;
            n5 = n6;
            n6 = n7 << 10 | n7 >>> 22;
            n7 = n8;
            n8 = n3;
        }
        for (n4 = 64; n4 < 80; ++n4) {
            n3 = RIPEMD160.c(n10, n11, n12, n13, n14, this.f[d[n4]], c[n4], -1454113458);
            n10 = n14;
            n14 = n13;
            n13 = n12 << 10 | n12 >>> 22;
            n12 = n11;
            n11 = n3;
            n3 = RIPEMD160.a(n9, n8, n7, n6, n5, this.f[b[n4]], a[n4]);
            n9 = n5;
            n5 = n6;
            n6 = n7 << 10 | n7 >>> 22;
            n7 = n8;
            n8 = n3;
        }
        this.e[1] = this.e[2] + n13 + n5;
        this.e[2] = this.e[3] + n14 + n9;
        this.e[3] = this.e[4] + n10 + n8;
        this.e[4] = this.e[0] + n11 + n7;
        this.e[0] = n6 += n12 + this.e[1];
    }

    public RIPEMD160() {
        super("RIPEMD160", 20);
        this.f = new int[16];
    }

    protected MD512BitBlock cloneInternal() {
        RIPEMD160 rIPEMD160 = new RIPEMD160();
        rIPEMD160.e[0] = this.e[0];
        rIPEMD160.e[1] = this.e[1];
        rIPEMD160.e[2] = this.e[2];
        rIPEMD160.e[3] = this.e[3];
        rIPEMD160.e[4] = this.e[4];
        return rIPEMD160;
    }

    protected void engineReset() {
        this.e[0] = 1732584193;
        this.e[1] = -271733879;
        this.e[2] = -1732584194;
        this.e[3] = 271733878;
        this.e[4] = -1009589776;
        this.count = 0L;
        this.rest = 0;
    }

    protected int engineDigest(byte[] byArray, int n2, int n3) throws DigestException {
        int n4;
        int n5 = n4 = this.rest < 56 ? 56 - this.rest : 120 - this.rest;
        if (n3 < 20) {
            throw new DigestException("RIPEMD160, output buffer too short");
        }
        this.count *= 8L;
        byte[] byArray2 = new byte[]{(byte)this.count, (byte)(this.count >>> 8), (byte)(this.count >>> 16), (byte)(this.count >>> 24), (byte)(this.count >>> 32), (byte)(this.count >>> 40), (byte)(this.count >>> 58), (byte)(this.count >>> 56)};
        this.engineUpdate(MD512BitBlock.md4_padding, 0, n4);
        this.engineUpdate(byArray2, 0, 8);
        for (int i2 = 0; i2 < 5; ++i2) {
            int n6 = this.e[i2];
            byArray[n2++] = (byte)(n6 & 0xFF);
            byArray[n2++] = (byte)(n6 >>> 8 & 0xFF);
            byArray[n2++] = (byte)(n6 >>> 16 & 0xFF);
            byArray[n2++] = (byte)(n6 >>> 24 & 0xFF);
        }
        this.engineReset();
        return 20;
    }
}

