/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.digest;

import com.mindbright.jca.security.DigestException;
import com.mindbright.jca.security.MessageDigest;

public abstract class MD512BitBlock
extends MessageDigest
implements Cloneable {
    protected long count = 0L;
    protected int rest = 0;
    protected byte[] buffer = new byte[64];
    protected int digestLength;
    protected static final byte[] md4_padding = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    protected static final int rotateLeft(int n2, int n3) {
        return n2 << n3 | n2 >>> 32 - n3;
    }

    protected MD512BitBlock(String string, int n2) {
        super(string);
        this.digestLength = n2;
    }

    public final Object clone() {
        MD512BitBlock mD512BitBlock = this.cloneInternal();
        System.arraycopy(mD512BitBlock.buffer, 0, this.buffer, 0, this.rest);
        mD512BitBlock.count = this.count;
        mD512BitBlock.rest = this.rest;
        return mD512BitBlock;
    }

    protected final void engineUpdate(byte by2) {
        this.engineUpdate(new byte[]{by2}, 0, 1);
    }

    protected final void engineUpdate(byte[] byArray, int n2, int n3) {
        int n4 = 64 - this.rest;
        this.count += (long)n3;
        if (this.rest > 0 && n3 >= n4) {
            System.arraycopy(byArray, n2, this.buffer, this.rest, n4);
            this.transform(this.buffer, 0);
            n2 += n4;
            n3 -= n4;
            this.rest = 0;
        }
        while (n3 > 63) {
            this.transform(byArray, n2);
            n2 += 64;
            n3 -= 64;
        }
        if (n3 > 0) {
            System.arraycopy(byArray, n2, this.buffer, this.rest, n3);
            this.rest += n3;
        }
    }

    protected final byte[] engineDigest() {
        byte[] byArray = new byte[this.digestLength];
        try {
            this.engineDigest(byArray, 0, byArray.length);
        }
        catch (DigestException digestException) {
            // empty catch block
        }
        return byArray;
    }

    protected final int engineGetDigestLength() {
        return this.digestLength;
    }

    protected abstract void transform(byte[] var1, int var2);

    protected abstract MD512BitBlock cloneInternal();
}

