/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.jce.crypto;

import com.mindbright.jca.security.InvalidAlgorithmParameterException;
import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.jca.security.Key;
import com.mindbright.jca.security.NoSuchAlgorithmException;
import com.mindbright.jca.security.NoSuchProviderException;
import com.mindbright.jca.security.Provider;
import com.mindbright.jca.security.ProviderLookup;
import com.mindbright.jca.security.spec.AlgorithmParameterSpec;
import com.mindbright.jce.crypto.MacSpi;
import com.mindbright.jce.crypto.ShortBufferException;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Mac
implements Cloneable {
    private Provider a;
    private MacSpi a;
    private String a;
    private boolean a;
    private int a;

    protected Mac(MacSpi macSpi, Provider provider, String string) {
        this.a = provider;
        this.a = macSpi;
        this.a = string;
        this.a = false;
    }

    public Object clone() throws CloneNotSupportedException {
        Mac mac = new Mac((MacSpi)this.a.clone(), this.a, this.a);
        mac.a = this.a;
        return mac;
    }

    public final byte[] doFinal() throws IllegalStateException {
        if (this.a) {
            byte[] byArray = this.a.engineDoFinal();
            this.a.engineReset();
            return byArray;
        }
        throw new IllegalStateException(this.a + " not initialized");
    }

    public final byte[] doFinal(byte[] byArray) throws IllegalStateException {
        if (this.a) {
            this.a.engineUpdate(byArray, 0, byArray.length);
            return this.doFinal();
        }
        throw new IllegalStateException(this.a + " not initialized");
    }

    public final void doFinal(byte[] byArray, int n2) throws ShortBufferException, IllegalStateException {
        if (this.a) {
            if (byArray.length - n2 < this.a) {
                throw new ShortBufferException("Output buffer is too small for " + this.a);
            }
        } else {
            throw new IllegalStateException(this.a + " not initialized");
        }
        System.arraycopy(this.a.engineDoFinal(), 0, byArray, n2, this.a);
    }

    public final String getAlgorithm() {
        return this.a;
    }

    public static final Mac getInstance(String string) throws NoSuchAlgorithmException {
        try {
            String string2 = ProviderLookup.findImplementingProvider("Mac", string);
            return Mac.getInstance(string, string2);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new Error("Error in Mac: " + noSuchProviderException);
        }
    }

    public static final Mac getInstance(String string, String string2) throws NoSuchProviderException, NoSuchAlgorithmException {
        ProviderLookup providerLookup = ProviderLookup.getImplementation("Mac", string, string2);
        return new Mac((MacSpi)providerLookup.getImpl(), providerLookup.getProvider(), string);
    }

    public final int getMacLength() {
        int n2 = this.a;
        if (!this.a) {
            n2 = this.a.engineGetMacLength();
        }
        return n2;
    }

    public final void init(Key key) throws InvalidKeyException {
        try {
            this.init(key, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new Error("Error in Mac: " + invalidAlgorithmParameterException);
        }
    }

    public final void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.a.engineInit(key, algorithmParameterSpec);
        this.a = this.a.engineGetMacLength();
        this.a = true;
    }

    public final void reset() {
        this.a.engineReset();
    }

    public final void update(byte by2) throws IllegalStateException {
        if (!this.a) {
            throw new IllegalStateException(this.a + " not initialized");
        }
        this.a.engineUpdate(by2);
    }

    public final void update(byte[] byArray) throws IllegalStateException {
        this.update(byArray, 0, byArray.length);
    }

    public final void update(byte[] byArray, int n2, int n3) throws IllegalStateException {
        if (!this.a) {
            throw new IllegalStateException(this.a + " not initialized");
        }
        this.a.engineUpdate(byArray, n2, n3);
    }
}

