/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.jca.security;

import com.mindbright.jca.security.Key;
import com.mindbright.jca.security.KeyStoreException;
import com.mindbright.jca.security.KeyStoreSpi;
import com.mindbright.jca.security.NoSuchAlgorithmException;
import com.mindbright.jca.security.NoSuchProviderException;
import com.mindbright.jca.security.Provider;
import com.mindbright.jca.security.ProviderLookup;
import com.mindbright.jca.security.UnrecoverableKeyException;
import com.mindbright.jca.security.cert.Certificate;
import com.mindbright.jca.security.cert.CertificateException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class KeyStore {
    private KeyStoreSpi a;
    private Provider a;
    private String a;

    protected KeyStore(KeyStoreSpi keyStoreSpi, Provider provider, String string) {
        this.a = keyStoreSpi;
        this.a = provider;
        this.a = string;
    }

    public static KeyStore getInstance(String string) throws KeyStoreException {
        try {
            String string2 = ProviderLookup.findImplementingProvider("KeyStore", string);
            return KeyStore.getInstance(string, string2);
        }
        catch (Exception exception) {
            throw new KeyStoreException("KeyStore " + string + " not found");
        }
    }

    public static KeyStore getInstance(String string, String string2) throws KeyStoreException, NoSuchProviderException {
        try {
            ProviderLookup providerLookup = ProviderLookup.getImplementation("KeyStore", string, string2);
            return new KeyStore((KeyStoreSpi)providerLookup.getImpl(), providerLookup.getProvider(), string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreException("KeyStore " + string + " not found in provider " + string2);
        }
    }

    public final Provider getProvider() {
        return this.a;
    }

    public final String getType() {
        return this.a;
    }

    public final Key getKey(String string, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.a.engineGetKey(string, cArray);
    }

    public final Certificate[] getCertificateChain(String string) throws KeyStoreException {
        return this.a.engineGetCertificateChain(string);
    }

    public final Certificate getCertificate(String string) throws KeyStoreException {
        return this.a.engineGetCertificate(string);
    }

    public final Date getCreationDate(String string) throws KeyStoreException {
        return this.a.engineGetCreationDate(string);
    }

    public final void setKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        this.a.engineSetKeyEntry(string, key, cArray, certificateArray);
    }

    public final void setKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        this.a.engineSetKeyEntry(string, byArray, certificateArray);
    }

    public final void setCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        this.a.engineSetCertificateEntry(string, certificate);
    }

    public final void deleteEntry(String string) throws KeyStoreException {
        this.a.engineDeleteEntry(string);
    }

    public final Enumeration aliases() throws KeyStoreException {
        return this.a.engineAliases();
    }

    public final boolean containsAlias(String string) throws KeyStoreException {
        return this.a.engineContainsAlias(string);
    }

    public final int size() throws KeyStoreException {
        return this.a.engineSize();
    }

    public final boolean isKeyEntry(String string) throws KeyStoreException {
        return this.a.engineIsKeyEntry(string);
    }

    public final boolean isCertificateEntry(String string) throws KeyStoreException {
        return this.a.engineIsCertificateEntry(string);
    }

    public final String getCertificateAlias(Certificate certificate) throws KeyStoreException {
        return this.a.engineGetCertificateAlias(certificate);
    }

    public final void store(OutputStream outputStream, char[] cArray) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        this.a.engineStore(outputStream, cArray);
    }

    public final void load(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.a.engineLoad(inputStream, cArray);
    }

    public static final String getDefaultType() {
        return "PKCS12";
    }
}

