/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.util;

import com.mindbright.util.HexDump;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class Log {
    public static final int LEVEL_EMERG = 0;
    public static final int LEVEL_ALERT = 1;
    public static final int LEVEL_ERROR = 2;
    public static final int LEVEL_WARNING = 3;
    public static final int LEVEL_NOTICE = 4;
    public static final int LEVEL_INFO = 5;
    public static final int LEVEL_DEBUG = 6;
    public static final int LEVEL_DEBUG2 = 7;
    volatile int currentLevel = 0;
    private OutputStream logOut = null;

    public Log(int n) {
        this(System.err, n);
    }

    public Log(OutputStream outputStream, int n) {
        this.logOut = outputStream;
        this.currentLevel = n;
    }

    public void setLogOutputStream(OutputStream outputStream) {
        this.logOut = outputStream;
    }

    public void close() {
        if (this.logOut != null && this.logOut != System.err) {
            try {
                this.logOut.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void message(int n, String string, String string2) {
        this.message(n, string, null, string2);
    }

    public synchronized void message(int n, String string, String string2, String string3) {
        block4: {
            if (n <= this.currentLevel) {
                String string4 = string2 != null ? "." + string2 + "()" : "";
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
                simpleDateFormat.setTimeZone(TimeZone.getDefault());
                String string5 = "** " + simpleDateFormat.format(new Date()) + " " + string + string4 + " : '" + string3 + "'" + "\n";
                byte[] byArray = string5.getBytes();
                try {
                    if (this.logOut != null) {
                        this.logOut.write(byArray, 0, byArray.length);
                        this.logOut.flush();
                    }
                }
                catch (IOException iOException) {
                    if (System.err.equals(this.logOut)) break block4;
                    System.err.println("ERROR: Couldn't write to log");
                    System.err.println(string5);
                }
            }
        }
    }

    public void error(String string, String string2, String string3) {
        this.message(2, string, string2, string3);
    }

    public void warning(String string, String string2) {
        this.message(2, string, null, string2);
    }

    public void notice(String string, String string2) {
        this.message(4, string, null, string2);
    }

    public void info(String string, String string2) {
        this.message(5, string, null, string2);
    }

    public void debug(String string, String string2, String string3) {
        this.message(6, string, string2, string3);
    }

    public void debug(String string, String string2) {
        this.message(6, string, null, string2);
    }

    public void debug2(String string, String string2, String string3) {
        this.message(7, string, string2, string3);
    }

    public synchronized void debug2(String string, String string2, String string3, byte[] byArray, int n, int n2) {
        this.message(7, string, string2, string3);
        if (this.currentLevel >= 7) {
            HexDump.print(this.logOut, byArray, n, n2);
            try {
                this.logOut.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void debug2(String string, String string2, String string3, byte[] byArray) {
        this.debug2(string, string2, string3, byArray, 0, byArray.length);
    }

    public void setLevel(int n) {
        this.currentLevel = n;
    }
}

