/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal.tandem6530;

public class DataType {
    public static final int FREE = 0;
    public static final int ALPHA = 1;
    public static final int NUM = 2;
    public static final int ALPHA_NUM = 3;
    public static final int FULL_NUM = 4;
    public static final int FULL_NUM_WITH_SPACE = 5;
    public static final int ALPHA_WITH_SPACE = 6;
    public static final int ALPHA_NUM_WITH_SPACE = 7;
    public static final byte TYPE_0 = 1;
    public static final byte TYPE_1 = 2;
    public static final byte TYPE_2 = 4;
    public static final byte TYPE_3 = 8;
    public static final byte TYPE_4 = 16;
    public static final byte TYPE_5 = 32;
    public static final byte TYPE_6 = 64;
    public static final byte TYPE_7 = -128;
    protected byte[] dataTypes = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};
    protected byte[] table;
    protected byte[] defaultTable = new byte[]{-31, 1, 1, 1, 49, 1, 1, 1, 1, 1, 1, 49, 49, 49, 49, 1, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, 1, 1, 1, 1, 1, 1, 1, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, 1, 1, 1, 1, 1, 1, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, 1, 1, 1, 1, 1};

    public DataType() {
        this.reset();
    }

    public void reset() {
        byte[] byArray = new byte[this.defaultTable.length];
        System.arraycopy(this.defaultTable, 0, byArray, 0, this.defaultTable.length);
        this.table = byArray;
    }

    protected boolean isInsideTable(char c) {
        return c >= ' ' && c <= '\u007f';
    }

    public void set(int n, byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return;
        }
        if (!this.isInsideTable((char)n)) {
            return;
        }
        if (!this.isInsideTable((char)(byArray.length + n))) {
            return;
        }
        System.arraycopy(byArray, 0, this.table, n, byArray.length);
    }

    public boolean isOK(char c, int n) {
        if (n < 0 || n > 7) {
            return false;
        }
        if (!this.isInsideTable(c)) {
            return false;
        }
        return (this.table[c - 32] & this.dataTypes[n]) != 0;
    }
}

