/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal;

import com.mindbright.terminal.DisplayModel;
import com.mindbright.terminal.DisplayUtil;
import com.mindbright.terminal.DisplayView;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;

public class TerminalPrintable
implements Printable {
    public static int SCREEN = 1;
    public static int BUFFER = 2;
    private static Color BG_COLOR = Color.white;
    private static Color FG_COLOR = Color.black;
    private DisplayModel model;
    private int topLine;
    private int fontSize;
    private String fontName;
    private int lineSpaceDelta;
    private boolean fontMetricsInitialized;
    private int charWidth;
    private int charHeight;
    private int baselineIndex;
    private Font plainFont;
    private Font boldFont;

    public TerminalPrintable(DisplayModel displayModel, int n, String string, int n2) {
        this.lineSpaceDelta = this.fontSize / 10;
        this.fontMetricsInitialized = false;
        this.model = displayModel;
        this.fontName = string;
        this.fontSize = n2;
        this.topLine = n == SCREEN ? displayModel.getBufferRows() - displayModel.getDisplayRows() : 0;
        this.plainFont = new Font(string, 0, n2);
        this.boldFont = new Font(string, 1, n2);
    }

    private void initFontMetrics(Graphics graphics) {
        graphics.setFont(this.plainFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this.charWidth = fontMetrics.charWidth('W');
        this.charHeight = fontMetrics.getHeight() + this.lineSpaceDelta;
        this.baselineIndex = fontMetrics.getMaxAscent() + fontMetrics.getLeading() - 1;
        this.fontMetricsInitialized = true;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        int n2;
        int n3;
        int n4;
        if (!this.fontMetricsInitialized) {
            this.initFontMetrics(graphics);
        }
        if ((n4 = (n3 = (n2 = (int)(pageFormat.getImageableHeight() - pageFormat.getImageableY() * 2.0)) / this.fontSize) * n + this.topLine) > this.model.getBufferRows()) {
            return 1;
        }
        int n5 = n4 + n3;
        if (n5 > this.model.getBufferRows()) {
            n5 = this.model.getBufferRows();
        }
        graphics.setFont(this.plainFont);
        for (int i = n4; i < n5; ++i) {
            int n6 = (int)pageFormat.getImageableY() + (i - n4) * this.fontSize;
            int[] nArray = this.model.getAttribs(0, i);
            char[] cArray = this.model.getChars(0, i);
            for (int j = 0; j < this.model.getDisplayCols(); ++j) {
                Color color = BG_COLOR;
                Color color2 = FG_COLOR;
                int n7 = nArray[j];
                int n8 = n7 & 0xFFFF;
                boolean bl = false;
                int n9 = (int)pageFormat.getImageableX() + this.charWidth * j;
                if ((n7 & 0x10) != 0) {
                    color = (n7 & 0x40) != 0 ? DisplayView.termColors[(n7 & 0xFF0000) >>> 16] : FG_COLOR;
                    color2 = (n7 & 0x80) != 0 ? DisplayView.termColors[(n7 & 0xFF000000) >>> 24] : BG_COLOR;
                    if ((n7 & 2) != 0) {
                        color = DisplayUtil.makeDimmerColor(color);
                    }
                    bl = true;
                } else {
                    if ((n7 & 0x80) != 0) {
                        color = DisplayView.termColors[(n7 & 0xFF000000) >>> 24];
                        bl = true;
                    }
                    if ((n7 & 0x40) != 0) {
                        color2 = DisplayView.termColors[(n7 & 0xFF0000) >>> 16];
                    }
                    if ((n7 & 2) != 0) {
                        color2 = DisplayUtil.makeDimmerColor(color2);
                    }
                }
                if (bl) {
                    graphics.setColor(color);
                    graphics.fillRect(n9, n6, this.charWidth, this.charHeight);
                }
                graphics.setColor(color2);
                if ((n8 & 0x8000) == 0) continue;
                if ((n7 & 0x20) == 0) {
                    if ((n7 & 0x100) != 0) {
                        DisplayUtil.drawLineDrawChar(graphics, n9, n6, this.baselineIndex, cArray[j], this.charWidth, this.charHeight);
                    } else if ((n7 & 1) != 0 || (n7 & 8) != 0) {
                        graphics.setFont(this.boldFont);
                        graphics.drawChars(cArray, j, 1, n9, n6 + this.baselineIndex);
                        graphics.setFont(this.plainFont);
                    } else if (cArray[j] != ' ') {
                        graphics.drawChars(cArray, j, 1, n9, n6 + this.baselineIndex);
                    }
                }
                if ((n7 & 4) == 0) continue;
                graphics.drawLine(n9, n6 + this.baselineIndex, n9 + this.charWidth, n6 + this.baselineIndex);
            }
        }
        return 0;
    }
}

