/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Hashtable;

public class DisplayUtil {
    private static Hashtable dimmmedColors = new Hashtable();

    protected static Color makeDimmerColor(Color color) {
        if (color == null) {
            return null;
        }
        Color color2 = (Color)dimmmedColors.get(color);
        if (color2 != null) {
            return color2;
        }
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        if ((double)(f2 * f2 + f3 * f3) < 0.1) {
            f2 = 0.3f;
            f3 = 0.3f;
        } else {
            f3 = (float)((double)f3 * 0.5);
        }
        color2 = Color.getHSBColor(f, f2, f3);
        dimmmedColors.put(color, color2);
        return color2;
    }

    private static void drawTuplet(Graphics graphics, int n, int n2, int n3, int n4, int n5, String string, String string2) {
        Font font = graphics.getFont();
        graphics.setFont(new Font(font.getName(), font.getStyle(), font.getSize() / 2));
        graphics.drawString(string, n + 1, n2 + 1 + n5 / 2);
        graphics.drawString(string2, n3, n4 + n5 / 2);
        graphics.setFont(font);
    }

    protected static void drawLineDrawChar(Graphics graphics, int n, int n2, int n3, char c, int n4, int n5) {
        int n6 = n + n4 / 2;
        int n7 = n2 + n5 / 2;
        int n8 = n + n4;
        int n9 = n2 + n5;
        switch (c) {
            case ' ': 
            case '_': {
                break;
            }
            case '`': {
                int[] nArray = new int[4];
                int[] nArray2 = new int[4];
                nArray[0] = n6;
                nArray2[0] = n2;
                nArray[1] = n8;
                nArray2[1] = n7;
                nArray[2] = n6;
                nArray2[2] = n9;
                nArray[3] = n;
                nArray2[3] = n7;
                graphics.fillPolygon(nArray, nArray2, 4);
                break;
            }
            case 'a': {
                for (int i = n; i < n8; ++i) {
                    for (int j = n2; j < n9; ++j) {
                        if ((i + j) % 2 != 0) continue;
                        graphics.fillRect(i, j, 1, 1);
                    }
                }
                break;
            }
            case 'b': {
                DisplayUtil.drawTuplet(graphics, n, n2, n6, n7, n3, "H", "T");
                break;
            }
            case 'c': {
                DisplayUtil.drawTuplet(graphics, n, n2, n6, n7, n3, "F", "F");
                break;
            }
            case 'd': {
                DisplayUtil.drawTuplet(graphics, n, n2, n6, n7, n3, "C", "R");
                break;
            }
            case 'e': {
                DisplayUtil.drawTuplet(graphics, n, n2, n6, n7, n3, "L", "F");
                break;
            }
            case 'f': {
                char[] cArray = new char[]{'\u00b0'};
                graphics.drawChars(cArray, 0, 1, n, n2 + n3);
                break;
            }
            case 'g': {
                char[] cArray = new char[]{'\u00b1'};
                graphics.drawChars(cArray, 0, 1, n, n2 + n3);
                break;
            }
            case 'h': {
                DisplayUtil.drawTuplet(graphics, n, n2, n6, n7, n3, "N", "L");
                break;
            }
            case 'i': {
                DisplayUtil.drawTuplet(graphics, n, n2, n6, n7, n3, "V", "T");
                break;
            }
            case 'j': {
                graphics.drawLine(n6, n2, n6, n7);
                graphics.drawLine(n6, n7, n, n7);
                break;
            }
            case 'k': {
                graphics.drawLine(n, n7, n6, n7);
                graphics.drawLine(n6, n7, n6, n9);
                break;
            }
            case 'l': {
                graphics.drawLine(n6, n9, n6, n7);
                graphics.drawLine(n6, n7, n8, n7);
                break;
            }
            case 'm': {
                graphics.drawLine(n6, n2, n6, n7);
                graphics.drawLine(n6, n7, n8, n7);
                break;
            }
            case 'n': {
                graphics.drawLine(n6, n2, n6, n9);
                graphics.drawLine(n, n7, n8, n7);
                break;
            }
            case 'o': {
                graphics.drawLine(n, n2, n8, n2);
                break;
            }
            case 'p': {
                graphics.drawLine(n, (n2 + n7) / 2, n8, (n2 + n7) / 2);
                break;
            }
            case 'q': {
                graphics.drawLine(n, n7, n8, n7);
                break;
            }
            case 'r': {
                graphics.drawLine(n, (n9 + n7) / 2, n8, (n9 + n7) / 2);
                break;
            }
            case 's': {
                graphics.drawLine(n, n9, n8, n9);
                break;
            }
            case 't': {
                graphics.drawLine(n6, n2, n6, n9);
                graphics.drawLine(n6, n7, n8, n7);
                break;
            }
            case 'u': {
                graphics.drawLine(n6, n2, n6, n9);
                graphics.drawLine(n, n7, n6, n7);
                break;
            }
            case 'v': {
                graphics.drawLine(n, n7, n8, n7);
                graphics.drawLine(n6, n7, n6, n2);
                break;
            }
            case 'w': {
                graphics.drawLine(n, n7, n8, n7);
                graphics.drawLine(n6, n7, n6, n9);
                break;
            }
            case 'x': {
                graphics.drawLine(n6, n2, n6, n9);
                break;
            }
            case 'y': {
                int n10 = n4 / 5;
                int n11 = n5 / 5;
                graphics.drawLine(n + n10, n7, n8 - n10, n2 + 2 * n11);
                graphics.drawLine(n + n10, n7, n8 - n10, n9 - 2 * n11);
                graphics.drawLine(n + n10, n7 + n11, n8 - n10, n9 - n11);
                break;
            }
            case 'z': {
                int n12 = n4 / 5;
                int n13 = n5 / 5;
                graphics.drawLine(n8 - n12, n7, n + n12, n2 + 2 * n13);
                graphics.drawLine(n8 - n12, n7, n + n12, n9 - 2 * n13);
                graphics.drawLine(n8 - n12, n7 + n13, n + n12, n9 - n13);
                break;
            }
            case '{': {
                char[] cArray = new char[]{'\u03c0'};
                graphics.drawChars(cArray, 0, 1, n, n2 + n3);
                break;
            }
            case '|': {
                char[] cArray = new char[]{'\u2260'};
                graphics.drawChars(cArray, 0, 1, n, n2 + n3);
                break;
            }
            case '}': {
                char[] cArray = new char[]{'\u00a3'};
                graphics.drawChars(cArray, 0, 1, n, n2 + n3);
                break;
            }
            case '~': {
                char[] cArray = new char[]{'\u00b7'};
                graphics.drawChars(cArray, 0, 1, n, n2 + n3);
                break;
            }
        }
    }

    public static boolean isBoxOrBlockChar(char c) {
        return c >= '\u2500' && c < '\u25a0';
    }

    public static void drawBoxOrBlockChar(Graphics graphics, int n, int n2, int n3, char c, int n4, int n5) {
        int n6 = n + n4 / 2;
        int n7 = n2 + n5 / 2;
        int n8 = n + n4;
        int n9 = n2 + n5;
        int[] nArray = new int[]{5, 15, 80, 240, 5, 15, 80, 240, 5, 15, 80, 240, 68, 76, 196, 204, 65, 67, 193, 195, 20, 28, 52, 60, 17, 19, 49, 51, 84, 92, 116, 212, 244, 124, 220, 252, 81, 83, 113, 209, 241, 115, 211, 243, 69, 75, 77, 79, 197, 203, 205, 207, 21, 27, 29, 31, 53, 59, 61, 63, 85, 87, 93, 95, 117, 213, 245, 119, 125, 215, 221, 127, 223, 247, 253, 255, 5, 15, 80, 240, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 16, 4, 64, 3, 48, 12, 192, 13, 208, 7, 112};
        if (c <= '\u254f' || c >= '\u2574' && c <= '\u257f') {
            int n10 = nArray[c - 9472];
            if ((n10 & 1) != 0) {
                graphics.drawLine(n, n7, n6, n7);
            }
            if ((n10 & 2) != 0) {
                graphics.drawLine(n, n7 + 1, n6, n7 + 1);
            }
            if ((n10 & 4) != 0) {
                graphics.drawLine(n6, n7, n8, n7);
            }
            if ((n10 & 8) != 0) {
                graphics.drawLine(n6, n7 + 1, n8, n7 + 1);
            }
            if ((n10 & 0x10) != 0) {
                graphics.drawLine(n6, n2, n6, n7);
            }
            if ((n10 & 0x20) != 0) {
                graphics.drawLine(n6 - 1, n2, n6 - 1, n7);
            }
            if ((n10 & 0x40) != 0) {
                graphics.drawLine(n6, n7, n6, n9);
            }
            if ((n10 & 0x80) != 0) {
                graphics.drawLine(n6 - 1, n7, n6 - 1, n9);
            }
            return;
        }
        switch (c) {
            case '\u2550': {
                graphics.drawLine(n, n7 - 1, n8, n7 - 1);
                graphics.drawLine(n, n7 + 1, n8, n7 + 1);
                break;
            }
            case '\u2551': {
                graphics.drawLine(n6 - 1, n2, n6 - 1, n9);
                graphics.drawLine(n6 + 1, n2, n6 + 1, n9);
                break;
            }
            case '\u2552': {
                graphics.drawLine(n6, n7 - 1, n8, n7 - 1);
                graphics.drawLine(n6, n7 + 1, n8, n7 + 1);
                graphics.drawLine(n6, n7 - 1, n6, n9);
                break;
            }
            case '\u2553': {
                graphics.drawLine(n6 - 1, n7, n8, n7);
                graphics.drawLine(n6 - 1, n7, n6 - 1, n9);
                graphics.drawLine(n6 + 1, n7, n6 + 1, n9);
                break;
            }
            case '\u2554': {
                graphics.drawLine(n6 - 1, n7 - 1, n8, n7 - 1);
                graphics.drawLine(n6 + 1, n7 + 1, n8, n7 + 1);
                graphics.drawLine(n6 - 1, n7 - 1, n6 - 1, n9);
                graphics.drawLine(n6 + 1, n7 + 1, n6 + 1, n9);
                break;
            }
            case '\u2555': {
                graphics.drawLine(n, n7 - 1, n6, n7 - 1);
                graphics.drawLine(n, n7 + 1, n6, n7 + 1);
                graphics.drawLine(n6, n7 - 1, n6, n9);
                break;
            }
            case '\u2556': {
                graphics.drawLine(n, n7, n6 + 1, n7);
                graphics.drawLine(n6 - 1, n7, n6 - 1, n9);
                graphics.drawLine(n6 + 1, n7, n6 + 1, n9);
                break;
            }
            case '\u2557': {
                graphics.drawLine(n, n7 - 1, n6 + 1, n7 - 1);
                graphics.drawLine(n, n7 + 1, n6 - 1, n7 + 1);
                graphics.drawLine(n6 + 1, n7 - 1, n6 + 1, n9);
                graphics.drawLine(n6 - 1, n7 + 1, n6 - 1, n9);
                break;
            }
            case '\u2558': {
                graphics.drawLine(n6, n2, n6, n7 + 1);
                graphics.drawLine(n6, n7 - 1, n8, n7 - 1);
                graphics.drawLine(n6, n7 + 1, n8, n7 + 1);
                break;
            }
            case '\u2559': {
                graphics.drawLine(n6 - 1, n2, n6 - 1, n7);
                graphics.drawLine(n6 + 1, n2, n6 + 1, n7);
                graphics.drawLine(n6 - 1, n7, n8, n7);
                break;
            }
            case '\u255a': {
                graphics.drawLine(n6 - 1, n2, n6 - 1, n7 + 1);
                graphics.drawLine(n6 + 1, n2, n6 + 1, n7 - 1);
                graphics.drawLine(n6 - 1, n7 + 1, n8, n7 + 1);
                graphics.drawLine(n6 + 1, n7 - 1, n8, n7 - 1);
                break;
            }
            case '\u255b': {
                graphics.drawLine(n6, n2, n6, n7 + 1);
                graphics.drawLine(n, n7 - 1, n6, n7 - 1);
                graphics.drawLine(n, n7 + 1, n6, n7 + 1);
                break;
            }
            case '\u255c': {
                graphics.drawLine(n6 - 1, n2, n6 - 1, n7);
                graphics.drawLine(n6 + 1, n2, n6 + 1, n7);
                graphics.drawLine(n, n7, n6 + 1, n7);
                break;
            }
            case '\u255d': {
                graphics.drawLine(n6 - 1, n2, n6 - 1, n7 - 1);
                graphics.drawLine(n6 + 1, n2, n6 + 1, n7 + 1);
                graphics.drawLine(n6 - 1, n7 - 1, n, n7 - 1);
                graphics.drawLine(n6 + 1, n7 + 1, n, n7 + 1);
                break;
            }
            case '\u255e': {
                graphics.drawLine(n6, n2, n6, n9);
                graphics.drawLine(n6, n7 - 1, n8, n7 - 1);
                graphics.drawLine(n6, n7 + 1, n8, n7 + 1);
                break;
            }
            case '\u255f': {
                graphics.drawLine(n6 + 1, n7, n8, n7);
                graphics.drawLine(n6 - 1, n2, n6 - 1, n9);
                graphics.drawLine(n6 + 1, n2, n6 + 1, n9);
                break;
            }
            case '\u2560': {
                graphics.drawLine(n6 - 1, n2, n6 - 1, n9);
                graphics.drawLine(n6 + 1, n2, n6 + 1, n7 - 1);
                graphics.drawLine(n6 + 1, n7 - 1, n8, n7 - 1);
                graphics.drawLine(n6 + 1, n7 + 1, n6 + 1, n9);
                graphics.drawLine(n6 + 1, n7 + 1, n8, n7 + 1);
                break;
            }
            case '\u2561': {
                graphics.drawLine(n6, n2, n6, n9);
                graphics.drawLine(n, n7 - 1, n6, n7 - 1);
                graphics.drawLine(n, n7 + 1, n6, n7 + 1);
                break;
            }
            case '\u2562': {
                graphics.drawLine(n6 + 1, n2, n6 + 1, n9);
                graphics.drawLine(n6 - 1, n2, n6 - 1, n9);
                graphics.drawLine(n, n7, n6 - 1, n7);
                break;
            }
            case '\u2563': {
                graphics.drawLine(n6 + 1, n2, n6 + 1, n9);
                graphics.drawLine(n6 - 1, n2, n6 - 1, n7 - 1);
                graphics.drawLine(n, n7 - 1, n6 - 1, n7 - 1);
                graphics.drawLine(n, n7 + 1, n6 - 1, n7 + 1);
                graphics.drawLine(n6 - 1, n7 + 1, n6 - 1, n9);
                break;
            }
            case '\u2564': {
                graphics.drawLine(n, n7 - 1, n8, n7 - 1);
                graphics.drawLine(n, n7 + 1, n8, n7 + 1);
                graphics.drawLine(n6, n7 + 1, n6, n9);
                break;
            }
            case '\u2565': {
                graphics.drawLine(n, n7, n8, n7);
                graphics.drawLine(n6 - 1, n7, n6 - 1, n9);
                graphics.drawLine(n6 + 1, n7, n6 + 1, n9);
                break;
            }
            case '\u2566': {
                graphics.drawLine(n, n7 - 1, n8, n7 - 1);
                graphics.drawLine(n, n7 + 1, n6 - 1, n7 + 1);
                graphics.drawLine(n6 + 1, n7 + 1, n8, n7 + 1);
                graphics.drawLine(n6 - 1, n7 + 1, n6 - 1, n9);
                graphics.drawLine(n6 + 1, n7 + 1, n6 + 1, n9);
                break;
            }
            case '\u2567': {
                graphics.drawLine(n, n7 + 1, n8, n7 + 1);
                graphics.drawLine(n, n7 - 1, n8, n7 - 1);
                graphics.drawLine(n6, n2, n6, n7 - 1);
                break;
            }
            case '\u2568': {
                graphics.drawLine(n, n7, n8, n7);
                graphics.drawLine(n6 - 1, n2, n6 - 1, n7);
                graphics.drawLine(n6 + 1, n2, n6 + 1, n7);
                break;
            }
            case '\u2569': {
                graphics.drawLine(n, n7 + 1, n8, n7 + 1);
                graphics.drawLine(n, n7 - 1, n6 - 1, n7 - 1);
                graphics.drawLine(n6 + 1, n7 - 1, n8, n7 - 1);
                graphics.drawLine(n6 - 1, n2, n6 - 1, n7 - 1);
                graphics.drawLine(n6 + 1, n2, n6 + 1, n7 - 1);
                break;
            }
            case '\u256a': {
                graphics.drawLine(n6, n2, n6, n9);
                graphics.drawLine(n, n7 - 1, n8, n7 - 1);
                graphics.drawLine(n, n7 + 1, n8, n7 + 1);
                break;
            }
            case '\u256b': {
                graphics.drawLine(n, n7, n8, n7);
                graphics.drawLine(n6 - 1, n2, n6 - 1, n9);
                graphics.drawLine(n6 + 1, n2, n6 + 1, n9);
                break;
            }
            case '\u256c': {
                graphics.drawLine(n, n7 - 1, n6 - 1, n7 - 1);
                graphics.drawLine(n6 - 1, n7 - 1, n6 - 1, n2);
                graphics.drawLine(n6 + 1, n2, n6 + 1, n7 - 1);
                graphics.drawLine(n6 + 1, n7 - 1, n8, n7 - 1);
                graphics.drawLine(n, n7 + 1, n6 - 1, n7 + 1);
                graphics.drawLine(n6 - 1, n7 + 1, n6 - 1, n9);
                graphics.drawLine(n6 + 1, n9, n6 + 1, n7 + 1);
                graphics.drawLine(n6 + 1, n7 + 1, n8, n7 + 1);
                break;
            }
            case '\u256d': {
                graphics.drawArc(n6, n7, n4, n5, 90, 90);
                break;
            }
            case '\u256e': {
                graphics.drawArc(n - n4 / 2, n7, n4, n5, 0, 90);
                break;
            }
            case '\u256f': {
                graphics.drawArc(n - n4 / 2, n2 - n5 / 2, n4, n5, 0, -90);
                break;
            }
            case '\u2570': {
                graphics.drawArc(n6, n2 - n5 / 2, n4, n5, 180, 90);
                break;
            }
            case '\u2571': {
                graphics.drawLine(n, n9, n6, n2);
                break;
            }
            case '\u2572': {
                graphics.drawLine(n, n2, n6, n9);
                break;
            }
            case '\u2573': {
                graphics.drawLine(n, n9, n6, n2);
                graphics.drawLine(n, n2, n6, n9);
                break;
            }
            case '\u2580': {
                graphics.fillRect(n, n2, n4, n5 / 2);
                break;
            }
            case '\u2581': {
                graphics.fillRect(n, n2 + n5 * 7 / 8, n4, n5 - n5 * 7 / 8);
                break;
            }
            case '\u2582': {
                graphics.fillRect(n, n2 + n5 * 3 / 4, n4, n5 - n5 * 3 / 4);
                break;
            }
            case '\u2583': {
                graphics.fillRect(n, n2 + n5 * 5 / 8, n4, n5 - n5 * 5 / 8);
                break;
            }
            case '\u2584': {
                graphics.fillRect(n, n7, n4, n5 / 2);
                break;
            }
            case '\u2585': {
                graphics.fillRect(n, n2 + n5 * 3 / 8, n4, n5 - n5 * 3 / 8);
                break;
            }
            case '\u2586': {
                graphics.fillRect(n, n2 + n5 / 4, n4, n5 - n5 / 4);
                break;
            }
            case '\u2587': {
                graphics.fillRect(n, n2 + n5 / 8, n4, n5 - n5 / 8);
                break;
            }
            case '\u2588': {
                graphics.fillRect(n, n2, n4, n5);
                break;
            }
            case '\u2589': {
                graphics.fillRect(n, n2, n4 * 7 / 8, n5);
                break;
            }
            case '\u258a': {
                graphics.fillRect(n, n2, n4 * 3 / 4, n5);
                break;
            }
            case '\u258b': {
                graphics.fillRect(n, n2, n4 * 5 / 8, n5);
                break;
            }
            case '\u258c': {
                graphics.fillRect(n, n2, n4 / 2, n5);
                break;
            }
            case '\u258d': {
                graphics.fillRect(n, n2, n4 * 3 / 8, n5);
                break;
            }
            case '\u258e': {
                graphics.fillRect(n, n2, n4 / 4, n5);
                break;
            }
            case '\u258f': {
                graphics.fillRect(n, n2, n4 / 8, n5);
                break;
            }
            case '\u2590': {
                graphics.fillRect(n6, n2, n4 - n4 / 2, n5);
                break;
            }
            case '\u2591': 
            case '\u2592': 
            case '\u2593': {
                DisplayUtil.drawLineDrawChar(graphics, n, n2, n3, 'a', n4, n5);
                break;
            }
            case '\u2594': {
                graphics.fillRect(n, n2, n4, n5 / 8);
                break;
            }
            case '\u2595': {
                graphics.fillRect(n8 - n4 / 8, n2, n4 / 8, n5);
                break;
            }
            case '\u2596': {
                graphics.fillRect(n, n7, n4 / 2, n9 - n7);
                break;
            }
            case '\u2597': {
                graphics.fillRect(n6, n7, n8 - n6, n9 - n7);
                break;
            }
            case '\u2599': {
                graphics.fillRect(n, n7, n4 / 2, n9 - n7);
            }
            case '\u259a': {
                graphics.fillRect(n6, n7, n8 - n6, n9 - n7);
            }
            case '\u2598': {
                graphics.fillRect(n, n2, n4 / 2, n5 / 2);
                break;
            }
            case '\u259b': {
                graphics.fillRect(n, n2, n4, n7 - n2);
                graphics.fillRect(n, n7, n6 - n, n9 - n7);
                break;
            }
            case '\u259c': {
                graphics.fillRect(n, n2, n4, n7 - n2);
                graphics.fillRect(n6, n7, n8 - n6, n9 - n7);
                break;
            }
            case '\u259f': {
                graphics.fillRect(n6, n7, n8 - n6, n9 - n7);
            }
            case '\u259e': {
                graphics.fillRect(n, n7, n4 / 2, n9 - n7);
            }
            case '\u259d': {
                graphics.fillRect(n6, n2, n8 - n6, n7 - n2);
                break;
            }
        }
    }
}

