/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import java.math.BigInteger;

public class SSH2DataBuffer {
    public static final int BOOLEAN_TRUE = 1;
    public static final int BOOLEAN_FALSE = 0;
    private static int UTF8_TWO_BYTE_ENCODING = 192;
    private static int UTF8_THREE_BYTE_ENCODING = 224;
    private static int UTF8_FOUR_BYTE_ENCODING = 240;
    private static int UTF8_FIVE_BYTE_ENCODING = 248;
    private static int UTF8_SIX_BYTE_ENCODING = 252;
    private static int UTF8_EXTENDED_BYTE_ENCODING = 128;
    protected byte[] data;
    protected int rPos;
    protected int wPos;

    protected SSH2DataBuffer() {
        this(0);
    }

    public SSH2DataBuffer(int n) {
        this.data = new byte[n];
        this.reset();
    }

    public final void reset() {
        this.rPos = 0;
        this.wPos = 0;
    }

    public final int getMaxSize() {
        return this.data.length;
    }

    public final byte[] getData() {
        return this.data;
    }

    public final void setData(byte[] byArray) {
        this.data = byArray;
    }

    public final void setWPos(int n) {
        this.wPos = n;
    }

    public final int getWPos() {
        return this.wPos;
    }

    public final void setRPos(int n) {
        this.rPos = n;
    }

    public final int getRPos() {
        return this.rPos;
    }

    public final int getMaxReadSize() {
        return this.wPos - this.rPos;
    }

    public final int getMaxWriteSize() {
        return this.data.length - this.wPos;
    }

    public final int readByte() {
        return this.data[this.rPos++] & 0xFF;
    }

    public void writeByte(int n) {
        this.data[this.wPos++] = (byte)n;
    }

    public final boolean readBoolean() {
        return this.readByte() != 0;
    }

    public final void writeBoolean(boolean bl) {
        if (bl) {
            this.writeByte(1);
        } else {
            this.writeByte(0);
        }
    }

    public final int readInt() {
        int n = this.readByte();
        int n2 = this.readByte();
        int n3 = this.readByte();
        int n4 = this.readByte();
        return (n << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0);
    }

    public final void writeInt(int n) {
        this.writeByte(n >>> 24 & 0xFF);
        this.writeByte(n >>> 16 & 0xFF);
        this.writeByte(n >>> 8 & 0xFF);
        this.writeByte(n >>> 0 & 0xFF);
    }

    public final long readLong() {
        long l = this.readByte();
        long l2 = this.readByte();
        long l3 = this.readByte();
        long l4 = this.readByte();
        long l5 = this.readByte();
        long l6 = this.readByte();
        long l7 = this.readByte();
        long l8 = this.readByte();
        return (l << 56) + (l2 << 48) + (l3 << 40) + (l4 << 32) + (l5 << 24) + (l6 << 16) + (l7 << 8) + (l8 << 0);
    }

    public final void writeLong(long l) {
        this.writeByte((int)(l >>> 56 & 0xFFL));
        this.writeByte((int)(l >>> 48 & 0xFFL));
        this.writeByte((int)(l >>> 40 & 0xFFL));
        this.writeByte((int)(l >>> 32 & 0xFFL));
        this.writeByte((int)(l >>> 24 & 0xFFL));
        this.writeByte((int)(l >>> 16 & 0xFFL));
        this.writeByte((int)(l >>> 8 & 0xFFL));
        this.writeByte((int)(l >>> 0 & 0xFFL));
    }

    public final BigInteger readBigInt() {
        byte[] byArray = this.readString();
        if (byArray.length > 0) {
            return new BigInteger(byArray);
        }
        return BigInteger.valueOf(0L);
    }

    public final BigInteger readBigIntBits() {
        int n = this.readInt();
        byte[] byArray = new byte[(n + 7) / 8 + 1];
        byArray[0] = 0;
        this.readRaw(byArray, 1, byArray.length - 1);
        return new BigInteger(byArray);
    }

    public final void writeBigInt(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length == 1 && byArray[0] == 0) {
            byArray = new byte[]{};
        }
        this.writeString(byArray);
    }

    public final void writeBigIntBits(BigInteger bigInteger) {
        int n = (bigInteger.bitLength() + 7) / 8;
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length == 1 && byArray[0] == 0) {
            this.writeInt(0);
            return;
        }
        this.writeInt(bigInteger.bitLength());
        if (byArray[0] == 0) {
            this.writeRaw(byArray, 1, n);
        } else {
            this.writeRaw(byArray, 0, n);
        }
    }

    public final String readJavaString() {
        int n = this.readInt();
        if (n < 0 || n > this.data.length - this.rPos) {
            throw new Error("Error in SSH2DataBuffer, corrupt string on read");
        }
        String string = new String(this.data, this.rPos, n);
        this.rPos += n;
        return string;
    }

    public final byte[] readString() {
        int n = this.readInt();
        if (n < 0 || n > this.data.length - this.rPos) {
            throw new Error("Error in SSH2DataBuffer, corrupt string on read");
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.data, this.rPos, byArray, 0, n);
        this.rPos += n;
        return byArray;
    }

    public final int readString(byte[] byArray, int n) {
        int n2 = this.readInt();
        System.arraycopy(this.data, this.rPos, byArray, n, n2);
        this.rPos += n2;
        return n2;
    }

    public final void writeString(String string) {
        this.writeString(string.getBytes());
    }

    public final void writeString(byte[] byArray) {
        this.writeString(byArray, 0, byArray.length);
    }

    public void writeString(byte[] byArray, int n, int n2) {
        this.writeInt(n2);
        System.arraycopy(byArray, n, this.data, this.wPos, n2);
        this.wPos += n2;
    }

    public final void writeUTF8String(String string) {
        int n = string.length();
        int n2 = 0;
        byte[] byArray = new byte[6 * n];
        for (int i = 0; i < n; ++i) {
            long l = string.charAt(i);
            if (l >= 0L && l <= 127L) {
                byArray[n2++] = (byte)l;
                continue;
            }
            if (l >= 128L && l <= 2047L) {
                byArray[n2++] = (byte)((long)UTF8_TWO_BYTE_ENCODING | l >> 6 & 0x1FL);
                byArray[n2++] = (byte)((long)UTF8_EXTENDED_BYTE_ENCODING | l & 0x3FL);
                continue;
            }
            if (l >= 2048L && l <= 65535L) {
                byArray[n2++] = (byte)((long)UTF8_THREE_BYTE_ENCODING | l >> 12 & 0xFL);
                byArray[n2++] = (byte)((long)UTF8_EXTENDED_BYTE_ENCODING | l >> 6 & 0x3FL);
                byArray[n2++] = (byte)((long)UTF8_EXTENDED_BYTE_ENCODING | l & 0x3FL);
                continue;
            }
            if (l >= 65536L && l <= 0x1FFFFFL) {
                byArray[n2++] = (byte)((long)UTF8_FOUR_BYTE_ENCODING | l >> 18 & 7L);
                byArray[n2++] = (byte)((long)UTF8_EXTENDED_BYTE_ENCODING | l >> 12 & 0x3FL);
                byArray[n2++] = (byte)((long)UTF8_EXTENDED_BYTE_ENCODING | l >> 6 & 0x3FL);
                byArray[n2++] = (byte)((long)UTF8_EXTENDED_BYTE_ENCODING | l & 0x3FL);
                continue;
            }
            if (l >= 0x200000L && l <= 0x3FFFFFFL) {
                byArray[n2++] = (byte)((long)UTF8_FIVE_BYTE_ENCODING | l >> 24 & 3L);
                byArray[n2++] = (byte)((long)UTF8_EXTENDED_BYTE_ENCODING | l >> 18 & 0x3FL);
                byArray[n2++] = (byte)((long)UTF8_EXTENDED_BYTE_ENCODING | l >> 12 & 0x3FL);
                byArray[n2++] = (byte)((long)UTF8_EXTENDED_BYTE_ENCODING | l >> 6 & 0x3FL);
                byArray[n2++] = (byte)((long)UTF8_EXTENDED_BYTE_ENCODING | l & 0x3FL);
                continue;
            }
            if (l < 0x4000000L || l > Integer.MAX_VALUE) continue;
            byArray[n2++] = (byte)((long)UTF8_SIX_BYTE_ENCODING | l >> 30 & 1L);
            byArray[n2++] = (byte)((long)UTF8_EXTENDED_BYTE_ENCODING | l >> 24 & 0x3FL);
            byArray[n2++] = (byte)((long)UTF8_EXTENDED_BYTE_ENCODING | l >> 18 & 0x3FL);
            byArray[n2++] = (byte)((long)UTF8_EXTENDED_BYTE_ENCODING | l >> 12 & 0x3FL);
            byArray[n2++] = (byte)((long)UTF8_EXTENDED_BYTE_ENCODING | l >> 6 & 0x3FL);
            byArray[n2++] = (byte)((long)UTF8_EXTENDED_BYTE_ENCODING | l & 0x3FL);
        }
        this.writeString(byArray, 0, n2);
    }

    public final byte[] readRestRaw() {
        return this.readRaw(this.wPos - this.rPos);
    }

    public final byte[] readRaw(int n) {
        byte[] byArray = new byte[n];
        this.readRaw(byArray, 0, n);
        return byArray;
    }

    public final void readRaw(byte[] byArray, int n, int n2) {
        System.arraycopy(this.data, this.rPos, byArray, n, n2);
        this.rPos += n2;
    }

    public final void writeRaw(byte[] byArray) {
        this.writeRaw(byArray, 0, byArray.length);
    }

    public void writeRaw(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this.data, this.wPos, n2);
        this.wPos += n2;
    }
}

