/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.mindbright.security.publickey.RSAPublicKey;
import com.mindbright.ssh.SSHRSAPublicKeyString;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Vector;

public class SSHRSAPublicKeyFile {
    Vector pubKeyList;

    public SSHRSAPublicKeyFile(InputStream inputStream, String string, boolean bl) throws IOException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        this.pubKeyList = new Vector();
        while ((string2 = bufferedReader.readLine()) != null) {
            String string3;
            if ((string2 = string2.trim()).equals("") || string2.charAt(0) == '#') continue;
            if (bl) {
                int n = string2.indexOf(32);
                string3 = string2.substring(0, n);
                string2 = string2.substring(n);
            } else {
                string3 = "";
            }
            try {
                SSHRSAPublicKeyString sSHRSAPublicKeyString = SSHRSAPublicKeyString.createKey(string3, string2);
                this.pubKeyList.addElement(sSHRSAPublicKeyString);
            }
            catch (Exception exception) {
                throw new IOException("Corrupt public keys file: " + string);
            }
        }
    }

    public static SSHRSAPublicKeyFile loadFromFile(String string, boolean bl) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        SSHRSAPublicKeyFile sSHRSAPublicKeyFile = new SSHRSAPublicKeyFile(fileInputStream, string, bl);
        fileInputStream.close();
        return sSHRSAPublicKeyFile;
    }

    public void saveToFile(String string) throws IOException {
        FileWriter fileWriter = new FileWriter(string);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        SSHRSAPublicKeyString sSHRSAPublicKeyString = null;
        Enumeration enumeration = this.elements();
        try {
            while (enumeration.hasMoreElements()) {
                sSHRSAPublicKeyString = (SSHRSAPublicKeyString)enumeration.nextElement();
                String string2 = sSHRSAPublicKeyString.toString();
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.newLine();
            }
        }
        catch (Exception exception) {
            throw new IOException("Error while writing public-keys-file: " + string);
        }
        bufferedWriter.flush();
        bufferedWriter.close();
        fileWriter.close();
    }

    public Enumeration elements() {
        return this.pubKeyList.elements();
    }

    public RSAPublicKey getPublic(BigInteger bigInteger, String string) {
        SSHRSAPublicKeyString sSHRSAPublicKeyString = null;
        Enumeration enumeration = this.pubKeyList.elements();
        while (enumeration.hasMoreElements() && !(sSHRSAPublicKeyString = (SSHRSAPublicKeyString)enumeration.nextElement()).getModulus().equals(bigInteger)) {
            sSHRSAPublicKeyString = null;
        }
        return sSHRSAPublicKeyString;
    }

    public int checkPublic(BigInteger bigInteger, String string) {
        SSHRSAPublicKeyString sSHRSAPublicKeyString = null;
        int n = 1;
        Enumeration enumeration = this.pubKeyList.elements();
        while (enumeration.hasMoreElements()) {
            sSHRSAPublicKeyString = (SSHRSAPublicKeyString)enumeration.nextElement();
            if (!sSHRSAPublicKeyString.getOpts().equals(string)) continue;
            if (sSHRSAPublicKeyString.getModulus().equals(bigInteger)) {
                n = 0;
                break;
            }
            n = 2;
            break;
        }
        return n;
    }

    public void addPublic(String string, String string2, BigInteger bigInteger, BigInteger bigInteger2) {
        SSHRSAPublicKeyString sSHRSAPublicKeyString = new SSHRSAPublicKeyString(string, string2, bigInteger, bigInteger2);
        this.pubKeyList.addElement(sSHRSAPublicKeyString);
    }

    public void removePublic(String string) {
        SSHRSAPublicKeyString sSHRSAPublicKeyString = null;
        Enumeration enumeration = this.pubKeyList.elements();
        while (enumeration.hasMoreElements()) {
            sSHRSAPublicKeyString = (SSHRSAPublicKeyString)enumeration.nextElement();
            if (!sSHRSAPublicKeyString.getOpts().equals(string)) continue;
            this.pubKeyList.removeElement(sSHRSAPublicKeyString);
            break;
        }
    }
}

