/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.mindbright.gui.GUI;
import com.mindbright.jca.security.KeyPair;
import com.mindbright.jca.security.KeyPairGenerator;
import com.mindbright.jca.security.NoSuchAlgorithmException;
import com.mindbright.jca.security.SecureRandom;
import com.mindbright.jca.security.interfaces.RSAPrivateCrtKey;
import com.mindbright.ssh.SSH;
import com.mindbright.ssh.SSHInteractiveClient;
import com.mindbright.ssh.SSHMiscDialogs;
import com.mindbright.ssh.SSHRSAKeyFile;
import com.mindbright.ssh.SSHRSAPublicKeyString;
import com.mindbright.ssh2.SSH2Exception;
import com.mindbright.ssh2.SSH2KeyPairFile;
import com.mindbright.ssh2.SSH2PublicKeyFile;
import com.mindbright.terminal.TerminalWin;
import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SSHKeyGenerationDialog {
    protected static final String EDIT_TITLE = "MindTerm - Select key file to edit";
    protected static final String PASS_TITLE = "MindTerm - File Password";
    protected static final String[] KEY_TYPES = new String[]{"DSA (ssh2)", "RSA (ssh2)", "RSA (ssh1)"};
    protected static final String[] KEY_LENGTHS = new String[]{"768", "1024", "1536", "2048", "4096", "8192", "16384", "32768"};
    protected static final String LBL_BTN_GENERATE = "Generate";
    protected static final String LBL_BTN_CLOSE = "Close";
    protected static final String LBL_BTN_BACK = "Back";
    protected static final String LBL_BTN_SAVE = "Save";
    protected static final String LBL_BTN_CANCEL = "Cancel";
    protected static final String LBL_KEY_TYPE = "Key type/format";
    protected static final String LBL_KEY_LENGTH = "Key length (bits)";
    protected static final String LBL_IDENTITY = "Identity file";
    protected static final String LBL_DOT_DOT_DOT = "...";
    protected static final String LBL_PASSWORD = "Password";
    protected static final String LBL_PASSWORD_AGAIN = "Password again";
    protected static final String LBL_COMMENT = "Comment";
    protected static final String LBL_SUBJECT = "Subject";
    protected static final String LBL_OPENSSH = "OpenSSH .pub format";
    protected static final String LBL_DSA = "DSA";
    protected static final String LBL_1024 = "1024";
    protected static final String LBL_SSHCOM = "SSH Comm. private file format";
    protected static final String TEXT_GENERATING = "Generating keypair, please wait...";
    protected static final String keyGenerationHelp = "The key is generated using a random number generator, which is seeded by mouse movement in the field containing this text. Please move the mouse around in here until the progress bar below registers 100%.\n\nThis will create a publickey identity which can be used with the publickey authentication method. Your identity will consist of two parts: public and private keys. Your private key will be saved in the location which you specify; the corresponding public key is saved in a file with an identical name but with an extension of '.pub' added to it.\n\nYour private key is protected by encryption, if you entered a password. If you left the password field blank, the key will not be encrypted. This should only be used in protected environments where unattended logins are desired. The contents of the 'comment' field are stored with your key, and displayed each time you are prompted for the key's password.";
    protected static final String keyGenerationComplete = "Key Generation Complete\n\nTo use the key, you must transfer the '.pub' public key file to an SSH server and add it to the set of authorized keys. See your server documentation for details on this.\n\nFor convenience, your public key has been copied to the clipboard.\n\nExamples:\nIn ssh2 the '.pub' file should be pointed out in the file 'authorization' in the config directory (e.g. ~/.ssh2)\n\nIn OpenSSH's ssh2 the contents of the '.pub' file should be added to the file 'authorized_keys2' in your config directory (e.g. ~/.ssh) on the server.\n\nIn ssh1 the contents of the '.pub' file should be added to the file 'authorized_keys' in your ssh directory (e.g. ~/.ssh).\n\nPress 'Back' to generate a new keypair.";
    protected static SSHInteractiveClient client;
    protected static Frame parent;

    protected static File getSaveFile() {
        return GUI.selectFile(parent, "MindTerm - Select file to save identity to", SSHKeyGenerationDialog.client.propsHandler.getSSHHomeDir(), true);
    }

    protected static void alert(String string) {
        SSHMiscDialogs.alert("MindTerm - Alert", string, parent);
    }

    protected static String getDefaultFileName() {
        try {
            String string = SSHKeyGenerationDialog.client.propsHandler.getSSHHomeDir() + "identity";
            File file = new File(string);
            int n = 0;
            while (file.exists()) {
                string = SSHKeyGenerationDialog.client.propsHandler.getSSHHomeDir() + "identity" + n;
                file = new File(string);
                ++n;
            }
            return "identity" + (--n >= 0 ? String.valueOf(n) : "");
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public static KeyPair generateKeyPair(String string, int n) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(string);
        keyPairGenerator.initialize(n, (SecureRandom)client.secureRandom());
        return keyPairGenerator.generateKeyPair();
    }

    protected static void saveKeyPair(KeyPair keyPair, String string, String string2, String string3, String string4, boolean bl) throws IOException, SSH2Exception, NoSuchAlgorithmException {
        Object object;
        String string5 = SSHKeyGenerationDialog.client.propsHandler.getProperty("usrname");
        String string6 = null;
        if (string5 == null) {
            string5 = SSH.VER_MINDTERM;
        }
        if ("RSA (ssh1)".equals(string4)) {
            object = (RSAPrivateCrtKey)keyPair.getPrivate();
            SSHRSAKeyFile.createKeyFile(client, (RSAPrivateCrtKey)object, string, SSHKeyGenerationDialog.expandFileName(string2), string3);
            SSHRSAPublicKeyString sSHRSAPublicKeyString = new SSHRSAPublicKeyString("", string3, object.getPublicExponent(), object.getModulus());
            sSHRSAPublicKeyString.toFile(SSHKeyGenerationDialog.expandFileName(string2) + ".pub");
            string6 = sSHRSAPublicKeyString.toString();
        } else {
            object = new SSH2PublicKeyFile(keyPair.getPublic(), string5, string3);
            if (string == null || string.length() == 0) {
                string5 = null;
                string3 = null;
            }
            SSH2KeyPairFile sSH2KeyPairFile = new SSH2KeyPairFile(keyPair, string5, string3);
            sSH2KeyPairFile.store(SSHKeyGenerationDialog.expandFileName(string2), client.secureRandom(), string);
            string6 = ((SSH2PublicKeyFile)object).store(SSHKeyGenerationDialog.expandFileName(string2 + ".pub"), !bl);
        }
        object = SSHKeyGenerationDialog.client.sshStdIO.getTerminal();
        if (object instanceof TerminalWin) {
            ((TerminalWin)object).getClipboard().setSelection(string6);
        }
    }

    protected static boolean checkValues(String string, String string2, String string3) {
        if (!string.equals(string2)) {
            SSHKeyGenerationDialog.alert("Please give same password twice");
            return false;
        }
        if (string3.length() == 0) {
            SSHKeyGenerationDialog.alert("Filename can't be empty");
            return false;
        }
        OutputStream outputStream = SSHKeyGenerationDialog.getOutput(string3);
        if (outputStream == null) {
            SSHKeyGenerationDialog.alert("Can't open '" + string3 + "' for saving.");
            return false;
        }
        try {
            outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    protected static OutputStream getOutput(String string) {
        try {
            return new FileOutputStream(SSHKeyGenerationDialog.expandFileName(string));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected static String expandFileName(String string) {
        if (string.indexOf(File.separator) == -1) {
            string = SSHKeyGenerationDialog.client.propsHandler.getSSHHomeDir() + string;
        }
        return string;
    }
}

