/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.asn1;

import com.mindbright.asn1.ASN1Decoder;
import com.mindbright.asn1.ASN1Encoder;
import com.mindbright.asn1.ASN1Object;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class ASN1Integer
extends ASN1Object {
    private BigInteger value;

    public ASN1Integer() {
        super(2);
    }

    public int encodeValue(ASN1Encoder aSN1Encoder, OutputStream outputStream) throws IOException {
        return aSN1Encoder.encodeInteger(outputStream, this.value);
    }

    public void decodeValue(ASN1Decoder aSN1Decoder, InputStream inputStream, int n) throws IOException {
        this.setValue(aSN1Decoder.decodeInteger(inputStream, n));
    }

    public void setValue(BigInteger bigInteger) {
        this.setValue();
        this.value = bigInteger;
    }

    public void setValue(long l) {
        this.setValue(BigInteger.valueOf(l));
    }

    public BigInteger getValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ASN1Integer)) {
            return false;
        }
        ASN1Integer aSN1Integer = (ASN1Integer)object;
        return this.value.equals(aSN1Integer);
    }

    public int hashCode() {
        int n = super.hashCode();
        if (this.value != null) {
            n = this.value.hashCode();
        }
        return n;
    }
}

