/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal.tandem6530;

import com.mindbright.terminal.tandem6530.ActionHandler;
import com.mindbright.terminal.tandem6530.AsciiCodes;
import com.mindbright.terminal.tandem6530.BadColorException;
import com.mindbright.terminal.tandem6530.ConfigParameter;
import com.mindbright.terminal.tandem6530.FieldAttributes;
import com.mindbright.terminal.tandem6530.IBM3270FieldAttributes;
import com.mindbright.terminal.tandem6530.ParseException;

public class Parser
implements AsciiCodes {
    public static final char IGNORE = '\u0100';
    public static final int ROWS = 24;
    public static final int COLS = 80;
    private static final int NOT_DEF = -1;
    private boolean isShifted = false;
    private boolean blockMode = false;
    private boolean DEBUG = false;
    private static final int SMAJOR_GROUND = 1;
    private static final int SMAJOR_VAR_COLLECT = 2;
    private static final int SMAJOR_ESC = 3;
    private static final int SMAJOR_ESC_DASH = 4;
    private static final int SMAJOR_ESC_SPACE = 5;
    private static final int SMINOR_NONE = 1;
    private static final int SMINOR_SET_BUFFER_ADDR = 2;
    private static final int SMINOR_EXT_DATA_COMPR = 3;
    private static final int SMINOR_SET_CURSOR_ADDR = 4;
    private static final int SMINOR_LIMITED_DATA_COMPR = 5;
    private static final int SMINOR_DEFINE_FIELD_ATTRIB = 6;
    private static final int SMINOR_START_FIELD = 7;
    private static final int SMINOR_SET_VIDEO_ATTRIB = 8;
    private static final int SMINOR_SET_VIDEO_PRIOR_REG = 9;
    private static final int SMINOR_DISPLAY_PAGE = 10;
    private static final int SMINOR_SELECT_PAGE = 11;
    private static final int SMINOR_SET_MAX_PAGE = 12;
    private static final int SMINOR_READ_WITH_ADDRESS = 13;
    private static final int SMINOR_READ_WITH_ADDRESS_ALL = 14;
    private static final int SMINOR_READ_SCREEN_WITH_ATTRIBS = 15;
    private static final int SMINOR_READ_IO_CONF = 16;
    private static final int SMINOR_GET_DIR_INFO = 17;
    private static final int SMINOR_START_FIELD_EXT = 18;
    private static final int SMINOR_DEFINE_ENTER_KEY = 19;
    private static final int SMINOR_STRING_CONFIG_PARAMS = 20;
    private static final int SMINOR_WRITE_MSG_FIELD = 21;
    private static final int SMINOR_SET_COLOR_MAP = 22;
    private static final int SMINOR_DEFINE_DATA_TYPES = 23;
    private static final int SMINOR_DEFINE_VARIABLE_TABLE = 24;
    private static final int SMINOR_SET_COLOR_CONFIG = 25;
    private static final int SMINOR_SET_TERM_CONF = 26;
    private static final int SMINOR_SET_IO_CONF = 27;
    private static final int SMINOR_EXEC_PROGRAM = 28;
    private static final int SMINOR_WRITE_TO_FILE = 29;
    private static final int SMINOR_WRITE_READ_TO_FILE = 30;
    private static final int SMINOR_START_ENHANCED_FIELD = 31;
    private static final int SMINOR_CLEAR_MEMORY = 32;
    private static final int SMINOR_MODE_SWITCH = 33;
    private static final int SMINOR_SIMULATE_FKEY = 34;
    private int majorState = 1;
    private int minorState = 1;
    private Collector coll = new Collector();
    private int[] params = new int[12];
    private int paramsIndex = 0;
    private int defineEnterCount = -1;
    private static final int ALL_STRINGS = 0;
    private String[] stringParams = null;
    private int stringParamsType = -1;
    private int setColorMapStart = -1;
    private int setColorMapLen = -1;
    private boolean defineDataTypesExt = false;
    private int defineDataTypesStart = -1;
    private int defineDataTypesLen = -1;
    private int defineVariableTableStart = -1;
    private int defineVariableTableLen = -1;
    private int setColorConfigStart = -1;
    private int setColorConfigLen = -1;
    private boolean execGoETX = false;
    private boolean writeToFileBin = false;
    private boolean writeToFileEsc = false;
    private char[] writeToFileCharArray = new char[2];
    private boolean startEnhancedGotCount = false;
    private int startEnhancedPairCount;
    private char startEnhancedVideo;
    private char startEnhancedData;
    private char startEnhancedExtData;
    private ActionHandler ah;

    public void setActionHandler(ActionHandler actionHandler) {
        this.ah = actionHandler;
    }

    public ActionHandler getActionHandler() {
        return this.ah;
    }

    public void setBlockMode() {
        this.blockMode = true;
    }

    public void setConversationalMode() {
        this.blockMode = false;
    }

    public void reset() {
        this.isShifted = false;
        this.setState(1);
    }

    public char parse(char c) throws ParseException {
        if (this.DEBUG) {
            if (c >= ' ' && c <= '~') {
                System.err.println("Parsing 0x" + Integer.toHexString(c) + " " + c);
            } else {
                System.err.println("Parsing 0x" + Integer.toHexString(c));
            }
        }
        if (c == '\u000e') {
            this.isShifted = true;
            return '\u0100';
        }
        if (c == '\u000f') {
            this.isShifted = false;
            return '\u0100';
        }
        block6 : switch (this.majorState) {
            case 1: {
                if (this.isG0(c) || this.isG1(c)) {
                    return this.shiftChar(c);
                }
                switch (c) {
                    case '\u0000': 
                    case '\u0004': 
                    case '\u0005': {
                        break;
                    }
                    case '\u0001': {
                        this.setState(2, 33);
                        break;
                    }
                    case '\u0007': {
                        if (this.ah == null) break block6;
                        this.ah.doBell();
                        break;
                    }
                    case '\b': {
                        if (this.ah == null) break block6;
                        this.ah.doBackspace();
                        break;
                    }
                    case '\t': {
                        if (this.ah == null) break block6;
                        this.ah.doHTab();
                        break;
                    }
                    case '\n': {
                        if (this.ah == null) break block6;
                        this.ah.doLineFeed();
                        break;
                    }
                    case '\r': {
                        if (this.ah == null) break block6;
                        this.ah.doCarriageReturn();
                        break;
                    }
                    case '\u0011': {
                        this.setState(2, 2);
                        break;
                    }
                    case '\u0012': {
                        this.setState(2, 3);
                        break;
                    }
                    case '\u0013': {
                        this.setState(2, 4);
                        break;
                    }
                    case '\u0014': {
                        this.setState(2, 5);
                        break;
                    }
                    case '\u001c': {
                        this.setState(2, 6);
                        break;
                    }
                    case '\u001d': {
                        this.setState(2, 7);
                        break;
                    }
                    case '\u001b': {
                        this.setState(3);
                        break;
                    }
                    default: {
                        this.error("Unknown control character 0x" + Integer.toHexString(c));
                        break;
                    }
                }
                break;
            }
            case 3: {
                switch (c) {
                    case '0': {
                        if (this.ah != null) {
                            this.ah.doPrintScreenOrPage();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case '1': {
                        if (this.ah != null) {
                            this.ah.doSetTab();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case '2': {
                        if (this.ah != null) {
                            this.ah.doClearTab();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case '3': {
                        if (this.ah != null) {
                            this.ah.doClearAllTabs();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case '8': {
                        if (this.ah != null) {
                            this.ah.doSet40CharLineWidth();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case '9': {
                        if (this.ah != null) {
                            this.ah.doSet80CharLineWidth();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case '<': {
                        if (this.ah != null) {
                            this.ah.doReadWholePageOrBuffer();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case '>': {
                        if (this.ah != null) {
                            this.ah.doResetModifiedDataTags();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case '@': {
                        if (this.ah != null) {
                            this.ah.doDelayOneSecond();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'A': {
                        if (this.ah != null) {
                            this.ah.doCursorUp();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'C': {
                        if (this.ah != null) {
                            this.ah.doCursorRight();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'F': {
                        if (this.ah != null) {
                            this.ah.doCursorHomeDown();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'H': {
                        if (this.ah != null) {
                            this.ah.doCursorHome();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'J': {
                        if (this.ah != null) {
                            this.ah.doEraseToEndOfPageOrMemory();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'K': {
                        if (this.ah != null) {
                            this.ah.doEraseToEndOfLineOrField();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'L': {
                        if (this.ah != null) {
                            this.ah.doInsertLine();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'M': {
                        if (this.ah != null) {
                            this.ah.doDeleteLine();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'N': {
                        if (this.ah != null) {
                            this.ah.doDisableLocalLineEditing();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'O': {
                        if (this.ah != null) {
                            this.ah.doInsertCharacter();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'P': {
                        if (this.ah != null) {
                            this.ah.doDeleteCharacter();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'S': {
                        if (this.ah != null) {
                            this.ah.doRollUp();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'T': {
                        if (this.ah != null) {
                            this.ah.doRollDown();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'U': {
                        if (this.ah != null) {
                            this.ah.doPageDown();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'V': {
                        if (this.ah != null) {
                            this.ah.doPageUp();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'W': {
                        if (this.ah != null) {
                            this.ah.doEnterProtectedSubmode();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'X': {
                        if (this.ah != null) {
                            this.ah.doExitProtectedSubmode();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case '^': {
                        if (this.ah != null) {
                            this.ah.doReadTerminalStatus();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case '_': {
                        if (this.ah != null) {
                            this.ah.doReadFullRevisionLevel();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'a': {
                        if (this.ah != null) {
                            this.ah.doReadCursorAddress();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'b': {
                        if (this.ah != null) {
                            this.ah.doUnlockKeyboard();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'c': {
                        if (this.ah != null) {
                            this.ah.doLockKeyboard();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'd': {
                        this.setState(2, 34);
                        break block6;
                    }
                    case 'f': {
                        if (this.ah != null) {
                            this.ah.doDisconnectModem();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'i': {
                        if (this.ah != null) {
                            this.ah.doBackTab();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'q': {
                        if (this.ah != null) {
                            this.ah.doReinitialize();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 't': {
                        if (this.ah != null) {
                            this.ah.doSet40CharactersScreenWidth();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case '?': {
                        if (this.ah != null) {
                            this.ah.doReadTerminalConfiguration();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'u': {
                        this.defineEnterCount = 0;
                        this.setState(2, 19);
                        break block6;
                    }
                    case '6': {
                        this.setState(2, 8);
                        break block6;
                    }
                    case '7': {
                        this.setState(2, 9);
                        break block6;
                    }
                    case ';': {
                        this.setState(2, 10);
                        break block6;
                    }
                    case ':': {
                        this.setState(2, 11);
                        break block6;
                    }
                    case 'o': {
                        this.setState(2, 21);
                        break block6;
                    }
                    case 'p': {
                        this.setState(2, 12);
                        break block6;
                    }
                    case '=': {
                        this.setState(2, 13);
                        break block6;
                    }
                    case 'I': {
                        if (this.blockMode) {
                            this.setState(2, 32);
                            break block6;
                        }
                        if (this.ah != null) {
                            this.ah.doClearMemoryToSpaces();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case ']': {
                        this.setState(2, 14);
                        break block6;
                    }
                    case '[': {
                        this.setState(2, 18);
                        break block6;
                    }
                    case 'Q': {
                        this.setState(2, 15);
                        break block6;
                    }
                    case 'y': {
                        this.setState(2, 16);
                        break block6;
                    }
                    case 'v': {
                        this.setState(2, 26);
                        break block6;
                    }
                    case 'x': {
                        this.setState(2, 27);
                        break block6;
                    }
                    case 'r': {
                        this.defineDataTypesStart = 1;
                        this.defineDataTypesLen = 96;
                        this.defineDataTypesExt = false;
                        this.setState(2, 23);
                        break block6;
                    }
                    case '-': {
                        this.setState(4);
                        break block6;
                    }
                    case ' ': {
                        this.setState(5);
                        break block6;
                    }
                    case '{': {
                        this.writeToFileBin = false;
                        this.setState(2, 29);
                        break block6;
                    }
                    case '}': {
                        this.writeToFileBin = false;
                        this.setState(2, 30);
                        break block6;
                    }
                    case '`': {
                        this.startEnhancedGotCount = false;
                        this.setState(2, 31);
                        break block6;
                    }
                }
                this.setState(1);
                this.error("Unknown escape sequence Esc 0x" + Integer.toHexString(c));
                break;
            }
            case 5: {
                switch (c) {
                    case 'v': {
                        if (this.ah != null) {
                            this.ah.doRead6530ColorMappingTable();
                        }
                        this.setState(1);
                        break block6;
                    }
                }
                this.setState(1);
                this.error("Unknown escape space sequence Esc 0x" + Integer.toHexString(c));
                break;
            }
            case 4: {
                switch (c) {
                    case 'e': {
                        if (this.ah != null) {
                            this.ah.doGetMachineName();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'f': {
                        this.setState(2, 17);
                        break block6;
                    }
                    case 'o': {
                        if (this.ah != null) {
                            this.ah.doReadKeyboardLatch();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'u': {
                        if (this.ah != null) {
                            this.ah.doReadColorConfiguration();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'v': {
                        if (this.ah != null) {
                            this.ah.doReadColorMappingTable();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'W': {
                        if (this.ah != null) {
                            this.ah.doReportExecReturnCode();
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'C': {
                        this.getNextParam();
                        int n = this.getExtendedRow("Esc-C", this.getParam(0));
                        int n2 = this.getExtendedColumn("Esc-C", this.getParam(1));
                        if (this.ah != null) {
                            this.ah.doSetBufferAddress(n, n2);
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'D': {
                        this.getNextParam();
                        int n = this.getExtendedRow("Esc-D", this.getParam(0));
                        int n3 = this.getExtendedColumn("Esc-D", this.getParam(1));
                        if (this.ah != null) {
                            this.ah.doSetCursorAddress(n, n3);
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'I': {
                        int n = 1;
                        int n4 = 1;
                        int n5 = 24;
                        int n6 = 80;
                        this.getNextParam();
                        if (this.getNumParams() > 0) {
                            n = this.getExtendedRow("Esc-I", this.getParam(0));
                            n4 = this.getExtendedColumn("Esc-I", this.getParam(1));
                            n5 = this.getExtendedRow("Esc-I", this.getParam(2));
                            n6 = this.getExtendedColumn("Esc-I", this.getParam(3));
                        }
                        if (this.ah != null) {
                            this.ah.doClearMemoryToSpaces(n, n4, n5, n6);
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'J': {
                        int n = 1;
                        int n7 = 1;
                        int n8 = 24;
                        int n9 = 80;
                        this.getNextParam();
                        if (this.getNumParams() > 0) {
                            n = this.getExtendedRow("Esc-J", this.getParam(0));
                            n7 = this.getExtendedColumn("Esc-J", this.getParam(1));
                            n8 = this.getExtendedRow("Esc-J", this.getParam(2));
                            n9 = this.getExtendedColumn("Esc-J", this.getParam(3));
                        }
                        if (this.ah != null) {
                            this.ah.doReadWithAddress(n, n7, n8, n9);
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'K': {
                        int n = 1;
                        int n10 = 1;
                        int n11 = 24;
                        int n12 = 80;
                        this.getNextParam();
                        if (this.getNumParams() > 0) {
                            n = this.getExtendedRow("Esc-K", this.getParam(0));
                            n10 = this.getExtendedColumn("Esc-K", this.getParam(1));
                            n11 = this.getExtendedRow("Esc-K", this.getParam(2));
                            n12 = this.getExtendedColumn("Esc-K", this.getParam(3));
                        }
                        if (this.ah != null) {
                            this.ah.doReadWithAddressAll(n, n10, n11, n12);
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'g': {
                        this.getNextParam();
                        int n = this.getParam(0);
                        if ((n == 2 || n == 3) && this.ah != null) {
                            this.ah.doReadVTLAUNCHConfigurationParameter(n);
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'i': {
                        this.getNextParam();
                        int n = this.getParam(0);
                        if (n == -1 || n != 1 && n != 2) {
                            this.setState(1);
                            break block6;
                        }
                        int n13 = this.getParam(1);
                        if (n13 == -1 || n13 < 1 || n13 > 10) {
                            this.setState(1);
                            break block6;
                        }
                        int n14 = this.getNumParams() - 2;
                        if (n13 == 1 && n14 == 0) {
                            if (this.ah != null) {
                                this.ah.doRTMControl(n, null);
                            }
                            this.setState(1);
                            break block6;
                        }
                        if (n13 - 1 != n14) {
                            this.setState(1);
                            break block6;
                        }
                        int[] nArray = new int[n14];
                        for (int i = 0; i < n14; ++i) {
                            nArray[i] = this.getParam(2 + i);
                        }
                        if (this.ah != null) {
                            this.ah.doRTMControl(n, nArray);
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'j': {
                        int n;
                        this.getNextParam();
                        if (this.getNumParams() != 4) {
                            this.setState(1);
                            break block6;
                        }
                        int[] nArray = new int[4];
                        for (n = 0; n < nArray.length; ++n) {
                            nArray[n] = this.getParam(n);
                            if (nArray[n] == -1 || nArray[n] < 0 || nArray[n] > 255) break;
                        }
                        if (n == nArray.length && this.ah != null) {
                            this.ah.doRTMDataUpload(nArray);
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'm': {
                        int n;
                        this.getNextParam();
                        if (this.getNumParams() != 1) {
                            this.setState(1);
                            this.error("Esc-m", "One parameter expected");
                        }
                        if ((n = this.getParam(0)) < 0 || n > 3) {
                            this.setState(1);
                            this.error("Esc-m", "Bad parameter " + n);
                        }
                        if (this.ah != null) {
                            this.ah.doSetEM3270Mode(n);
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'O': {
                        int n;
                        int n15;
                        this.getNextParam();
                        if (this.getNumParams() != 2) {
                            this.setState(1);
                            this.error("Esc-O", "Two parameters expected");
                        }
                        if ((n15 = this.getParam(0)) != 2) {
                            n15 = 1;
                        }
                        if ((n = this.getParam(1)) < 3 || n > 127) {
                            n = 18;
                        }
                        if (this.ah != null) {
                            this.ah.doWriteToAux1OrAux2Device(n15, (char)n);
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'z': {
                        this.getNextParam();
                        if (this.getNumParams() != 1) {
                            this.setState(1);
                            this.error("Esc-z", "One parameters expected");
                        }
                        if (this.ah != null) {
                            this.ah.doTerminateRemote6530Operation(this.getParam(0));
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'd': {
                        this.getNextParam();
                        int n = 0;
                        if (this.getNumParams() == 0) {
                            n = 0;
                        } else if (this.getNumParams() == 1) {
                            n = this.getParam(0);
                            if (n <= 0 || n > 7) {
                                n = 0;
                            }
                        } else {
                            this.setState(1);
                            this.error("Esc-d", "Bad format");
                        }
                        if (this.ah != null) {
                            this.ah.doReadStringConfigurationParameter(n);
                        }
                        this.setState(1);
                        break block6;
                    }
                    case 'c': {
                        this.getNextParam();
                        int n = 0;
                        if (this.getNumParams() == 0) {
                            n = 0;
                        } else if (this.getNumParams() == 1) {
                            n = this.getParam(0);
                            if (n <= 0 || n > 7) {
                                n = 0;
                            }
                        } else {
                            this.setState(1);
                            this.stringParams = null;
                            this.error("Esc-c", "Bad format");
                        }
                        this.stringParams = new String[7];
                        this.stringParamsType = n;
                        this.setState(2, 20);
                        break block6;
                    }
                    case 'q': {
                        int n;
                        this.getNextParam();
                        if (this.getNumParams() < 3) {
                            this.setState(1);
                            this.error("Esc-q", "Too few arguments");
                        }
                        if (this.getNumParams() > 3) {
                            this.setState(1);
                            this.error("Esc-q", "Too many arguments");
                        }
                        if ((n = this.getParam(0)) == 1) {
                            if (this.ah != null) {
                                this.ah.doResetColorMapTable();
                            }
                            this.setState(1);
                            break block6;
                        }
                        if (n == 0) {
                            int n16;
                            int n17 = this.getParam(1);
                            if (n17 == -1 || n17 < 1 || n17 > 32) {
                                n17 = 1;
                            }
                            if ((n16 = this.getParam(2)) == -1 || n16 < 1 || n16 > 32) {
                                n16 = 32;
                            }
                            this.setColorMapStart = n17;
                            this.setColorMapLen = n16 - n17 + 1;
                            this.setState(2, 22);
                            break block6;
                        }
                        this.setState(1);
                        this.error("Esc-q", "Invalid mode");
                        break block6;
                    }
                    case 'r': {
                        int n;
                        int n18;
                        this.getNextParam();
                        if (this.getNumParams() < 2) {
                            this.setState(1);
                            this.error("Esc-r", "Too few arguments");
                        }
                        if (this.getNumParams() > 2) {
                            this.setState(1);
                            this.error("Esc-r", "Too many arguments");
                        }
                        if ((n18 = this.getParam(0)) == -1 || n18 < 1 || n18 > 192) {
                            n18 = 1;
                        }
                        if ((n = this.getParam(1)) == -1 || n < 1 || n > 192) {
                            n = 192;
                        }
                        this.defineDataTypesStart = n18;
                        this.defineDataTypesLen = n - n18 + 1;
                        this.defineDataTypesExt = true;
                        this.setState(2, 23);
                        break block6;
                    }
                    case 's': {
                        int n;
                        int n19;
                        this.getNextParam();
                        if (this.getNumParams() < 1) {
                            this.setState(1);
                            this.error("Esc-s", "Too few arguments");
                        }
                        if (this.getNumParams() > 3) {
                            this.setState(1);
                            this.error("Esc-s", "Too many arguments");
                        }
                        if ((n19 = this.getParam(0)) != 0 && n19 != 1) {
                            this.setState(1);
                            this.error("Esc-s", "Invalid mode");
                        }
                        if (n19 == 1) {
                            if (this.ah != null) {
                                this.ah.doResetVariableTable();
                            }
                            this.setState(1);
                            break block6;
                        }
                        int n20 = this.getParam(1);
                        if (n20 == -1 || n20 < 1 || n20 > 32) {
                            n20 = 1;
                        }
                        if ((n = this.getParam(2)) == -1 || n < 1 || n > 32) {
                            n = 32;
                        }
                        this.defineVariableTableStart = n20;
                        this.defineVariableTableLen = n - n20 + 1;
                        this.setState(2, 24);
                        break block6;
                    }
                    case 't': {
                        int n;
                        int n21;
                        this.getNextParam();
                        if (this.getNumParams() < 1) {
                            this.setState(1);
                            this.error("Esc-t", "Too few arguments");
                        }
                        if (this.getNumParams() > 3) {
                            this.setState(1);
                            this.error("Esc-t", "Too many arguments");
                        }
                        if ((n21 = this.getParam(0)) != 0 && n21 != 1) {
                            this.setState(1);
                            this.error("Esc-t", "Invalid mode");
                        }
                        if (n21 == 1) {
                            if (this.ah != null) {
                                this.ah.doResetColorConfiguration();
                            }
                            this.setState(1);
                            break block6;
                        }
                        int n22 = this.getParam(1);
                        if (n22 == -1 || n22 < 1 || n22 > 16) {
                            n22 = 1;
                        }
                        if ((n = this.getParam(2)) == -1 || n < 1 || n > 16) {
                            n = 16;
                        }
                        this.setColorConfigStart = n22;
                        this.setColorConfigLen = n - n22 + 1;
                        this.setState(2, 25);
                        break block6;
                    }
                    case 'V': {
                        this.getNextParam();
                        if (this.getNumParams() != 0) {
                            this.setState(1);
                            this.error("Esc-V: Parameters not expected");
                        }
                        this.execGoETX = false;
                        this.setState(2, 28);
                        break block6;
                    }
                    case 'x': {
                        this.getNextParam();
                        if (this.getNumParams() != 1) {
                            this.setState(1);
                            this.error("Esc-x: Wrong number of arguments");
                        }
                        if (this.getParam(0) != 0 && this.getParam(0) != 1) {
                            this.setState(1);
                            this.error("Esc-x: Invalid mode");
                        }
                        if (this.ah != null) {
                            this.ah.doSet6530ColorMapping(this.getParam(0) == 1);
                        }
                        this.setState(1);
                        break block6;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.coll.addChar(c);
                        break block6;
                    }
                    case ';': {
                        this.getNextParam();
                        break block6;
                    }
                }
                this.setState(1);
                this.error("Unknown escape sequence Esc - 0x" + Integer.toHexString(c));
                break;
            }
            case 2: {
                switch (this.minorState) {
                    case 2: {
                        this.coll.addChar(c);
                        if (this.coll.size() != 2) break block6;
                        int n = this.getNormalRow("DC1", this.coll.getCharAt(0));
                        int n23 = this.getNormalColumn("DC1", this.coll.getCharAt(1));
                        if (this.ah != null) {
                            this.ah.doSetBufferAddress(n, n23);
                        }
                        this.setState(1);
                        break;
                    }
                    case 4: {
                        this.coll.addChar(c);
                        if (this.coll.size() != 2) break block6;
                        int n = this.getNormalRow("DC3", this.coll.getCharAt(0));
                        int n24 = this.getNormalColumn("DC3", this.coll.getCharAt(1));
                        if (this.ah != null) {
                            this.ah.doSetCursorAddress(n, n24);
                        }
                        this.setState(1);
                        break;
                    }
                    case 5: {
                        int n;
                        char c2;
                        this.coll.addChar(c);
                        if (this.coll.size() != 1) break block6;
                        if ((c & 0x40) != 0) {
                            c2 = ' ';
                            n = c & 0x3F;
                        } else {
                            c2 = '0';
                            n = c & 0x1F;
                        }
                        if (this.ah != null) {
                            this.ah.doDataCompression(n, c2);
                        }
                        this.setState(1);
                        break;
                    }
                    case 3: {
                        int n;
                        this.coll.addChar(c);
                        if (this.coll.size() != 2) break block6;
                        char c3 = this.coll.getCharAt(1);
                        if ((this.isG0(c3) || this.isG1(c3)) && (n = (this.coll.getCharAt(0) & 0x7F) - 32) > 0 && this.ah != null) {
                            this.ah.doDataCompression(n, this.shiftChar(c3));
                        }
                        this.setState(1);
                        break;
                    }
                    case 6: {
                        this.coll.addChar(c);
                        if (this.coll.size() != 3) break block6;
                        int n = this.getNormalRow("FS", this.coll.getCharAt(0));
                        int n25 = this.getNormalColumn("FS", this.coll.getCharAt(1));
                        boolean bl = (this.coll.getCharAt(2) & 0x40) != 0;
                        int n26 = bl ? this.coll.getCharAt(2) & 0x3F : this.coll.getCharAt(2) & 0x1F;
                        if (this.ah != null) {
                            this.ah.doDefineFieldAttribute(n, n25, bl, n26);
                        }
                        this.setState(1);
                        break;
                    }
                    case 7: {
                        this.coll.addChar(c);
                        if (this.coll.size() != 2) break block6;
                        FieldAttributes fieldAttributes = null;
                        try {
                            fieldAttributes = new FieldAttributes(this.coll.getCharAt(0), this.coll.getCharAt(1));
                        }
                        catch (ParseException parseException) {
                            this.error("GS", parseException.getMessage());
                        }
                        if (this.ah != null) {
                            this.ah.doStartField(fieldAttributes);
                        }
                        this.setState(1);
                        break;
                    }
                    case 8: {
                        this.coll.addChar(c);
                        if (this.coll.size() != 1) break block6;
                        char c4 = (char)(this.coll.getCharAt(0) & 0x1F);
                        if (this.ah != null) {
                            this.ah.doSetVideoAttributes(c4);
                        }
                        this.setState(1);
                        break;
                    }
                    case 9: {
                        this.coll.addChar(c);
                        if (this.coll.size() != 1) break block6;
                        char c5 = (char)(this.coll.getCharAt(0) & 0x1F);
                        if (this.ah != null) {
                            this.ah.doSetVideoPriorConditionRegister(c5);
                        }
                        this.setState(1);
                        break;
                    }
                    case 10: {
                        this.coll.addChar(c);
                        if (this.coll.size() != 1) break block6;
                        int n = this.coll.getCharAt(0) - 32;
                        if (n >= 0 && this.ah != null) {
                            this.ah.doDisplayPage(n);
                        }
                        this.setState(1);
                        break;
                    }
                    case 11: {
                        this.coll.addChar(c);
                        if (this.coll.size() != 1) break block6;
                        int n = this.coll.getCharAt(0) - 32;
                        if (n >= 1 && this.ah != null) {
                            this.ah.doSelectPage(n);
                        }
                        this.setState(1);
                        break;
                    }
                    case 12: {
                        this.coll.addChar(c);
                        if (this.coll.size() != 1) break block6;
                        int n = this.coll.getCharAt(0) - 48;
                        if (n >= 1 && this.ah != null) {
                            this.ah.doSetMaxPageNumber(n);
                        }
                        this.setState(1);
                        break;
                    }
                    case 13: {
                        this.coll.addChar(c);
                        if (this.coll.size() != 4) break block6;
                        int n = this.getNormalRow("Esc=", this.coll.getCharAt(0));
                        int n27 = this.getNormalColumn("Esc=", this.coll.getCharAt(1));
                        int n28 = this.getNormalRow("Esc=", this.coll.getCharAt(2));
                        int n29 = this.getNormalColumn("Esc=", this.coll.getCharAt(3));
                        if (this.ah != null) {
                            this.ah.doReadWithAddress(n, n27, n28, n29);
                        }
                        this.setState(1);
                        break;
                    }
                    case 32: {
                        this.coll.addChar(c);
                        if (this.coll.size() != 4) break block6;
                        int n = this.getNormalRow("EscI", this.coll.getCharAt(0));
                        int n30 = this.getNormalColumn("EscI", this.coll.getCharAt(1));
                        int n31 = this.getNormalRow("EscI", this.coll.getCharAt(2));
                        int n32 = this.getNormalColumn("EscI", this.coll.getCharAt(3));
                        if (this.ah != null) {
                            this.ah.doClearMemoryToSpaces(n, n30, n31, n32);
                        }
                        this.setState(1);
                        break;
                    }
                    case 14: {
                        this.coll.addChar(c);
                        if (this.coll.size() != 4) break block6;
                        int n = this.getNormalRow("Esc]", this.coll.getCharAt(0));
                        int n33 = this.getNormalColumn("Esc]", this.coll.getCharAt(1));
                        int n34 = this.getNormalRow("Esc]", this.coll.getCharAt(2));
                        int n35 = this.getNormalColumn("Esc]", this.coll.getCharAt(3));
                        if (this.ah != null) {
                            this.ah.doReadWithAddressAll(n, n33, n34, n35);
                        }
                        this.setState(1);
                        break;
                    }
                    case 15: {
                        this.coll.addChar(c);
                        if (this.coll.size() != 4) break block6;
                        int n = this.getNormalRow("EscQ", this.coll.getCharAt(0));
                        int n36 = this.getNormalColumn("EscQ", this.coll.getCharAt(1));
                        int n37 = this.getNormalRow("EscQ", this.coll.getCharAt(2));
                        int n38 = this.getNormalColumn("EscQ", this.coll.getCharAt(3));
                        if (this.ah != null) {
                            this.ah.doReadScreenWithAllAttributes(n, n36, n37, n38);
                        }
                        this.setState(1);
                        break;
                    }
                    case 16: {
                        int n;
                        this.coll.addChar(c);
                        if (this.coll.size() != 2) break block6;
                        if (this.coll.getCharAt(0) != 'T') {
                            this.setState(1);
                            this.error("Escy", "Bad format");
                        }
                        if ((n = this.coll.getCharAt(1) - 49) != 1 && n != 2) {
                            this.setState(1);
                            this.error("Escy", "Bad device number");
                        }
                        if (this.ah != null) {
                            this.ah.doReadIODeviceConfiguration(n);
                        }
                        this.setState(1);
                        break;
                    }
                    case 17: {
                        this.coll.addChar(c);
                        if (this.coll.size() != 1) break block6;
                        if ('@' > this.coll.getCharAt(0) || 'Z' < this.coll.getCharAt(0)) {
                            this.setState(1);
                            this.error("Esc-f", "Bad drive");
                        }
                        if (this.ah != null) {
                            this.ah.doGetCurrentDirectoryAndRedirectionInformation(this.coll.getCharAt(0));
                        }
                        this.setState(1);
                        break;
                    }
                    case 18: {
                        this.coll.addChar(c);
                        if (this.coll.size() != 3) break block6;
                        FieldAttributes fieldAttributes = null;
                        try {
                            fieldAttributes = new FieldAttributes(this.coll.getCharAt(0), this.coll.getCharAt(1), this.coll.getCharAt(2));
                        }
                        catch (ParseException parseException) {
                            this.setState(1);
                            this.error("Esc[", parseException.getMessage());
                        }
                        if (this.ah != null) {
                            this.ah.doStartFieldExtended(fieldAttributes);
                        }
                        this.setState(1);
                        break;
                    }
                    case 19: {
                        this.coll.addChar(c);
                        if (this.defineEnterCount == 0 && this.coll.size() == 1) {
                            this.defineEnterCount = this.coll.getCharAt(0) - 32;
                            if (this.defineEnterCount < 1 || this.defineEnterCount > 8) {
                                this.setState(1);
                                this.error("Escu", "Wrong character count");
                            }
                            this.coll.reset();
                            break;
                        }
                        if (this.defineEnterCount != this.coll.size()) break block6;
                        char[] cArray = this.coll.getArray();
                        for (int i = 0; i < cArray.length; ++i) {
                            if (cArray[i] != '\u0000' && cArray[i] != '\u0005') continue;
                            this.setState(1);
                            this.error("Escu", "Invalid character");
                        }
                        if (this.ah != null) {
                            this.ah.doDefineEnterKeyFunction(cArray);
                        }
                        this.setState(1);
                        break;
                    }
                    case 20: {
                        if (c == '\u0012' || c == '\r') {
                            if (this.stringParams == null) {
                                this.setState(1);
                                this.error("Esc-c", "Internal error. stringParams == null");
                            }
                            if (c == '\u0012' && this.stringParamsType != 0) {
                                this.setState(1);
                                this.error("Esc-c", "Too many strings");
                            }
                            int n = -1;
                            if (this.stringParamsType == 0) {
                                for (int i = 0; i < this.stringParams.length; ++i) {
                                    if (this.stringParams[i] != null) continue;
                                    n = i;
                                    break;
                                }
                                if (n == -1) {
                                    this.setState(1);
                                    this.error("Esc-c", "Too many strings");
                                }
                            } else {
                                n = this.stringParamsType - 1;
                            }
                            if (c == '\r' && this.stringParamsType == 0 && n < this.stringParams.length - 1) {
                                this.setState(1);
                                this.error("Esc-c", "Too few strings");
                            }
                            int[] nArray = new int[]{26, 34, 8, 128, 80, 8, 16};
                            String string = new String(this.coll.getArray());
                            if (string.length() > nArray[n]) {
                                string = string.substring(0, nArray[n]);
                            }
                            this.stringParams[n] = string;
                            if (c == '\r') {
                                if (this.ah != null) {
                                    this.ah.doSetStringConfigurationParameter(this.stringParams);
                                }
                                this.setState(1);
                                this.stringParams = null;
                                this.stringParamsType = -1;
                                break;
                            }
                            this.coll.reset();
                            break;
                        }
                        this.coll.addChar(c);
                        break;
                    }
                    case 21: {
                        if (c == '\r') {
                            char c6 = ' ';
                            StringBuffer stringBuffer = new StringBuffer();
                            StringBuffer stringBuffer2 = new StringBuffer();
                            for (int i = 0; i < this.coll.size(); ++i) {
                                if (this.coll.getCharAt(i) == '\u001b' && i + 2 < this.coll.size() && this.coll.getCharAt(i + 1) == '6') {
                                    c6 = this.coll.getCharAt(i + 2);
                                    i += 2;
                                    continue;
                                }
                                stringBuffer.append(this.coll.getCharAt(i));
                                stringBuffer2.append(c6);
                            }
                            if (this.ah != null) {
                                String string = stringBuffer.toString();
                                String string2 = stringBuffer2.toString();
                                if (string.length() > 63) {
                                    string = string.substring(0, 63);
                                }
                                if (string2.length() > 63) {
                                    string2 = string2.substring(0, 63);
                                }
                                this.ah.doWriteToMessageField(string.toCharArray(), string2.toCharArray());
                            }
                            this.setState(1);
                            break;
                        }
                        this.coll.addChar(this.shiftChar(c));
                        break;
                    }
                    case 22: {
                        this.coll.addChar(c);
                        if (this.coll.size() != this.setColorMapLen * 2) break block6;
                        byte[] byArray = this.getByteArray(this.coll.getArray());
                        if (byArray == null) {
                            this.setState(1);
                            this.error("Esc-q", "Not hex digits");
                        }
                        if (this.ah != null) {
                            this.ah.doSetColorMapTable(this.setColorMapStart, byArray);
                        }
                        this.setState(1);
                        break;
                    }
                    case 23: {
                        this.coll.addChar(c);
                        if (this.coll.size() != this.defineDataTypesLen * 2) break block6;
                        byte[] byArray = this.getByteArray(this.coll.getArray());
                        if (byArray == null) {
                            this.setState(1);
                            this.error("Esc" + (this.defineDataTypesExt ? "-r" : "r"), "Not hex digits");
                        }
                        if (this.ah != null) {
                            this.ah.doDefineDataTypeTable(this.defineDataTypesStart, byArray);
                        }
                        this.setState(1);
                        break;
                    }
                    case 24: {
                        this.coll.addChar(c);
                        if (this.coll.size() != this.defineVariableTableLen * 2 * 3) break block6;
                        char[] cArray = this.fromAsciiHex(this.coll.getArray());
                        if (cArray == null) {
                            this.setState(1);
                            this.error("Esc-s", "Not hex digits");
                        }
                        FieldAttributes[] fieldAttributesArray = new FieldAttributes[this.defineVariableTableLen];
                        for (int i = 0; i < this.defineVariableTableLen; ++i) {
                            fieldAttributesArray[i] = new FieldAttributes(cArray[i * 3], cArray[i * 3 + 1], cArray[i * 3 + 2]);
                        }
                        if (this.ah != null) {
                            this.ah.doDefineVariableTable(this.defineVariableTableStart, fieldAttributesArray);
                        }
                        this.setState(1);
                        break;
                    }
                    case 25: {
                        this.coll.addChar(c);
                        if (this.coll.size() != this.setColorConfigLen * 2) break block6;
                        byte[] byArray = this.getByteArray(this.coll.getArray());
                        if (byArray == null) {
                            this.setState(1);
                            this.error("Esc-t", "Not hex digits");
                        }
                        if (this.ah != null) {
                            this.ah.doSetColorConfiguration(this.setColorConfigStart, byArray);
                        }
                        this.setState(1);
                        break;
                    }
                    case 26: {
                        if (c == '\r') {
                            ConfigParameter[] configParameterArray = null;
                            try {
                                configParameterArray = ConfigParameter.parse(new String(this.coll.getArray()));
                            }
                            catch (ParseException parseException) {
                                this.setState(1);
                                this.error("Escv", parseException.getMessage());
                            }
                            if (configParameterArray.length <= 0 || configParameterArray[configParameterArray.length - 1].hasStringValue()) {
                                // empty if block
                            }
                            if (this.ah != null) {
                                this.ah.doSetTerminalConfiguration(configParameterArray);
                            }
                            this.setState(1);
                            break;
                        }
                        this.coll.addChar(c);
                        break;
                    }
                    case 27: {
                        if (c == '\r') {
                            if (this.coll.size() < 2 || this.coll.getCharAt(0) != 'T' || this.coll.getCharAt(1) != '2' && this.coll.getCharAt(1) != '3') {
                                this.setState(1);
                                this.error("Escx", "Invalid device");
                            }
                            int n = 0;
                            n = this.coll.getCharAt(1) == '2' ? 1 : 2;
                            char[] cArray = new char[this.coll.size() - 2];
                            System.arraycopy(this.coll.getArray(), 2, cArray, 0, cArray.length);
                            ConfigParameter[] configParameterArray = null;
                            try {
                                configParameterArray = ConfigParameter.parse(new String(cArray));
                            }
                            catch (ParseException parseException) {
                                this.setState(1);
                                this.error("Escx", parseException.getMessage());
                            }
                            if (this.ah != null) {
                                this.ah.doSetIODeviceConfiguration(n, configParameterArray);
                            }
                            this.setState(1);
                            break;
                        }
                        this.coll.addChar(c);
                        break;
                    }
                    case 28: {
                        if (c == '\u0003') {
                            this.execGoETX = true;
                            break;
                        }
                        if (this.execGoETX) {
                            char[] cArray = this.coll.getArray();
                            if (cArray.length <= 1) {
                                this.setState(1);
                                this.error("Esc-V", "Filename missing");
                            }
                            String string = new String(cArray, 0, cArray.length - 1);
                            if (this.ah != null) {
                                this.ah.doLoadAndExecuteAnOperatingSystemProgram(string);
                            }
                            this.setState(1);
                            break;
                        }
                        this.coll.addChar(c);
                        break;
                    }
                    case 31: {
                        this.coll.addChar(c);
                        if (this.startEnhancedGotCount) {
                            if (this.coll.size() != this.startEnhancedPairCount * 4) break block6;
                            char[] cArray = this.fromAsciiHex(this.coll.getArray());
                            if (cArray == null) {
                                this.setState(1);
                                this.error("Esc`", "Not a hex digit");
                            }
                            IBM3270FieldAttributes iBM3270FieldAttributes = null;
                            try {
                                iBM3270FieldAttributes = new IBM3270FieldAttributes(this.startEnhancedVideo, this.startEnhancedData, this.startEnhancedExtData);
                            }
                            catch (ParseException parseException) {
                                this.setState(1);
                                this.error("Esc`", parseException.getMessage());
                            }
                            try {
                                for (int i = 0; i < cArray.length; i += 2) {
                                    if (cArray[i] == 'B') {
                                        iBM3270FieldAttributes.setFgColor(cArray[i + 1] - 32);
                                        continue;
                                    }
                                    if (cArray[i] == 'E') {
                                        iBM3270FieldAttributes.setBgColor(cArray[i + 1] - 32);
                                        continue;
                                    }
                                    this.setState(1);
                                    this.error("Esc`", "Invalid color selector");
                                }
                            }
                            catch (BadColorException badColorException) {
                                this.setState(1);
                                this.error("Esc`", "Bad color");
                            }
                            if (this.ah != null) {
                                this.ah.doStartEnhancedColorField(iBM3270FieldAttributes);
                            }
                            this.setState(1);
                            break;
                        }
                        if (this.coll.size() != 5) break block6;
                        this.startEnhancedVideo = this.coll.getCharAt(0);
                        this.startEnhancedData = this.coll.getCharAt(1);
                        this.startEnhancedExtData = this.coll.getCharAt(2);
                        this.startEnhancedPairCount = this.coll.getCharAt(4) - 48;
                        if (this.startEnhancedPairCount < 1 || this.startEnhancedPairCount > 2) {
                            this.setState(1);
                            this.error("Esc`: Bad pair count value");
                        }
                        this.startEnhancedGotCount = true;
                        this.coll.reset();
                        break;
                    }
                    case 29: 
                    case 30: {
                        String string = null;
                        string = this.minorState == 29 ? "Esc{" : "Esc}";
                        if (c == '\r') {
                            char c7;
                            int n;
                            String string3;
                            int n39;
                            if (this.writeToFileBin && this.writeToFileCharArray[0] != '\u0000') {
                                this.setState(1);
                                this.error(string, "Uneven number of data characters");
                            }
                            if ((n39 = (string3 = new String(this.coll.getArray())).indexOf(34, 1)) == -1) {
                                this.setState(1);
                                this.error(string, "Bad format");
                            }
                            if ((n = string3.indexOf(32, n39)) == -1) {
                                this.setState(1);
                                this.error(string, "Bad format");
                            }
                            String string4 = string3.substring(1, n39);
                            char[] cArray = this.fromAsciiHex(string3.substring(n39 + 1, n));
                            if (cArray == null) {
                                this.setState(1);
                                this.error(string, "Invalid opcode");
                            }
                            if ((c7 = cArray[0]) < '<' || 'C' < c7 || c7 == 'A') {
                                this.setState(1);
                                this.error(string, "Invalid opcode");
                            }
                            int n40 = this.coll.size() - (n + 1);
                            byte[] byArray = new byte[n40];
                            int n41 = n + 1;
                            int n42 = 0;
                            while (n41 < this.coll.size()) {
                                byArray[n42] = (byte)this.coll.getCharAt(n41);
                                ++n41;
                                ++n42;
                            }
                            if (this.ah != null) {
                                if (this.minorState == 29) {
                                    this.ah.doWriteToFileOrDeviceName(string4, c7, byArray);
                                } else {
                                    this.ah.doWriteOrReadToFileOrDeviceName(string4, c7, byArray);
                                }
                            }
                            this.setState(1);
                            break;
                        }
                        if (c == '\u001b') {
                            this.writeToFileEsc = true;
                            break;
                        }
                        if (this.writeToFileEsc) {
                            if (c == 'a') {
                                this.writeToFileBin = false;
                            } else if (c == 'b') {
                                this.writeToFileBin = true;
                                this.writeToFileCharArray[0] = '\u0000';
                                this.writeToFileCharArray[1] = '\u0000';
                            } else {
                                this.setState(1);
                            }
                            this.writeToFileEsc = false;
                            break;
                        }
                        if (this.writeToFileBin) {
                            if (this.writeToFileCharArray[0] == '\u0000') {
                                this.writeToFileCharArray[0] = c;
                                break;
                            }
                            this.writeToFileCharArray[1] = c;
                            char[] cArray = this.fromAsciiHex(this.writeToFileCharArray);
                            if (cArray == null) {
                                this.setState(1);
                                this.error(string, "Invalid data character");
                            }
                            this.coll.addChar(cArray[0]);
                            this.writeToFileCharArray[0] = '\u0000';
                            this.writeToFileCharArray[1] = '\u0000';
                            break;
                        }
                        this.coll.addChar(c);
                        break;
                    }
                    case 33: {
                        this.coll.addChar(c);
                        if (this.coll.size() == 1) {
                            if (c == 'C' || c == 'B') break block6;
                            this.setState(1);
                            this.error("Mode switch", "Unknown mode '" + c + "'");
                            break;
                        }
                        if (this.coll.size() != 2) break block6;
                        if (c != '\u0003') {
                            this.setState(1);
                            this.error("Mode switch", "Bad sequence");
                        }
                        this.setState(1);
                        if (this.ah != null) {
                            if (this.coll.getCharAt(0) == 'C') {
                                this.ah.doSetConversationalMode();
                            } else {
                                this.ah.doSetBlockMode();
                            }
                        }
                        this.setState(1);
                        break;
                    }
                    case 34: {
                        this.coll.addChar(c);
                        if (this.coll.size() != 1) break block6;
                        if (this.ah != null) {
                            this.ah.doSimulateFunctionKey(c);
                        }
                        this.setState(1);
                        break;
                    }
                    default: {
                        this.setState(1);
                        this.error("Internal", "Unknown minor state");
                        break;
                    }
                }
                break;
            }
            default: {
                this.setState(1);
                this.error("Internal", "Unknown major state");
            }
        }
        return '\u0100';
    }

    private void getNextParam() throws ParseException {
        if (this.getNumParams() == 25) {
            this.setState(1);
            this.error("Esc-: Too many parameters, aborting sequence");
        }
        if (this.getNumParams() == this.params.length) {
            int[] nArray = new int[this.params.length * 2];
            System.arraycopy(this.params, 0, nArray, 0, this.params.length);
            this.params = nArray;
        }
        this.params[this.paramsIndex++] = this.getNextNumber();
    }

    private int getParam(int n) {
        return this.params[n];
    }

    private int getNumParams() {
        if (this.paramsIndex == 1 && this.getParam(0) == -1) {
            return 0;
        }
        return this.paramsIndex;
    }

    private int getNormalRow(String string, char c) throws ParseException {
        return this.getNormalParam(string, "Row", c, 24);
    }

    private int getNormalColumn(String string, char c) throws ParseException {
        return this.getNormalParam(string, "Column", c, 80);
    }

    private int getNormalParam(String string, String string2, char c, int n) throws ParseException {
        int n2 = c - 31;
        if (n2 < 1 || n2 > n) {
            this.setState(1);
            this.error(string, string2 + " argument was out of range");
        }
        return n2;
    }

    private int getExtendedRow(String string, int n) throws ParseException {
        return this.getExtendedParam(string, "Row", n, 24);
    }

    private int getExtendedColumn(String string, int n) throws ParseException {
        return this.getExtendedParam(string, "Column", n, 80);
    }

    private int getExtendedParam(String string, String string2, int n, int n2) throws ParseException {
        if (n == -1) {
            this.setState(1);
            this.error(string, string2 + " argument is missing");
        }
        if (n < 1) {
            this.setState(1);
            this.error(string, string2 + " argument is too low");
        }
        if (n > n2) {
            n = n2;
        }
        return n;
    }

    private void error(String string, String string2) throws ParseException {
        this.error(string + ": " + string2);
    }

    private void error(String string) throws ParseException {
        throw new ParseException(string);
    }

    private int getNextNumber() {
        if (this.coll.size() == 0) {
            return -1;
        }
        String string = new String(this.coll.getArray());
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.coll.reset();
        return n;
    }

    private char[] fromAsciiHex(String string) {
        return this.fromAsciiHex(string.toCharArray());
    }

    private char[] fromAsciiHex(char[] cArray) {
        if (cArray == null || cArray.length % 2 != 0) {
            return null;
        }
        char[] cArray2 = new char[cArray.length / 2];
        for (int i = 0; i < cArray2.length; ++i) {
            int n = Character.digit(cArray[i * 2], 16);
            int n2 = Character.digit(cArray[i * 2 + 1], 16);
            if (n == -1 || n2 == -1) {
                return null;
            }
            cArray2[i] = (char)(n << 4 & 0xF0 | n2 & 0xF);
        }
        return cArray2;
    }

    private byte[] getByteArray(char[] cArray) {
        char[] cArray2 = this.fromAsciiHex(cArray);
        if (cArray2 == null) {
            return null;
        }
        byte[] byArray = new byte[cArray2.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)cArray2[i];
        }
        return byArray;
    }

    private void setState(int n) {
        this.setState(n, 1);
    }

    private void setState(int n, int n2) {
        this.majorState = n;
        this.minorState = n2;
        this.coll.reset();
        for (int i = 0; i < this.paramsIndex; ++i) {
            this.params[i] = -1;
        }
        this.paramsIndex = 0;
    }

    private boolean isG0(char c) {
        return ' ' <= c && c <= '\u007f';
    }

    private boolean isG1(char c) {
        return '\u00a0' <= c && c <= '\u00ff';
    }

    private char shiftChar(char c) {
        if (this.isShifted && this.isG0(c)) {
            return (char)(c + 128);
        }
        return c;
    }

    private class Collector {
        private char[] a = new char[10];
        private int index = 0;

        private Collector() {
        }

        void addChar(char c) {
            if (this.size() == this.a.length) {
                char[] cArray = new char[this.a.length * 2];
                System.arraycopy(this.a, 0, cArray, 0, this.a.length);
                this.a = cArray;
            }
            this.a[this.index++] = c;
        }

        char getCharAt(int n) {
            return this.a[n];
        }

        int size() {
            return this.index;
        }

        void reset() {
            this.index = 0;
        }

        char[] getArray() {
            if (this.size() == 0) {
                return new char[0];
            }
            char[] cArray = new char[this.size()];
            System.arraycopy(this.a, 0, cArray, 0, this.size());
            return cArray;
        }
    }
}

