/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal.tandem6530;

import com.mindbright.terminal.tandem6530.AsciiCodes;
import com.mindbright.terminal.tandem6530.DataType;
import com.mindbright.terminal.tandem6530.FieldAttributes;
import com.mindbright.terminal.tandem6530.FieldVideoAttributeMap;
import com.mindbright.terminal.tandem6530.Position;

public class Field
implements AsciiCodes {
    protected Position start;
    protected Position end;
    protected FieldAttributes attribs;
    protected int cols;
    protected DataType dataTypeTable;
    protected boolean mdt;
    protected int len;
    protected StringBuffer buf = new StringBuffer();
    protected FieldVideoAttributeMap map;

    public Field(Position position, Position position2, Field field) {
        this(field.cols, position, position2, field.attribs, field.dataTypeTable);
    }

    public Field(int n, Position position, Position position2, FieldAttributes fieldAttributes, DataType dataType) {
        this.cols = n;
        this.map = new FieldVideoAttributeMap(fieldAttributes.getVideoAttrib() & 0x1F);
        this.setStart(position, false);
        this.setEnd(position2);
        this.redefine(fieldAttributes);
        this.dataTypeTable = dataType;
    }

    public void redefine(FieldAttributes fieldAttributes) {
        this.attribs = fieldAttributes;
        this.mdt = fieldAttributes.getMdt();
        this.map.setDefaultAttrib(fieldAttributes.getVideoAttrib() & 0x1F);
    }

    public void setPosition(Position position, Position position2, boolean bl) {
        this.end = new Position(position2);
        this.setStart(position, bl);
        this.len = this.calcLen();
    }

    public void setStart(Position position, boolean bl) {
        if (this.start == null || !this.start.equals(position)) {
            if (!bl && this.start != null && this.start.getRow() != position.getRow() && this.buf.length() > 0) {
                if (position.le(this.start)) {
                    int n = this.start.getRow() - position.getRow();
                    for (int i = 0; i < n * this.cols; ++i) {
                        this.buf.insert(0, ' ');
                    }
                } else {
                    this.buf.delete(0, (position.getRow() - this.start.getRow()) * this.cols);
                }
            }
            this.start = new Position(position);
            if (this.end == null) {
                return;
            }
            this.len = this.calcLen();
        }
    }

    public Position getStart() {
        return this.start;
    }

    public void setEnd(Position position) {
        if (this.end == null || !this.end.equals(position)) {
            this.end = new Position(position);
            if (this.start == null) {
                return;
            }
            this.len = this.calcLen();
        }
    }

    public Position getEnd() {
        return this.end;
    }

    public String getContents() {
        int n = -1;
        for (int i = this.buf.length() - 1; i >= 0; --i) {
            if ((this.buf.charAt(i) == '\u0000' || this.buf.charAt(i) == ' ') && !this.map.isAttrib(i)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i <= n; ++i) {
            if (this.buf.charAt(i) == '\u0000') {
                if (this.map.isAttrib(i)) {
                    stringBuffer.append('\u001b');
                    stringBuffer.append('6');
                    stringBuffer.append((char)(32 + this.map.get(i)));
                    continue;
                }
                stringBuffer.append(' ');
                continue;
            }
            stringBuffer.append(this.buf.charAt(i));
        }
        return stringBuffer.toString();
    }

    public void resetMdt() {
        this.mdt = false;
    }

    public boolean getMdt() {
        return this.mdt;
    }

    public boolean isProtected() {
        return this.attribs.getProtect();
    }

    public boolean hasAutoTab() {
        return this.attribs.getAutoTab();
    }

    protected int calcOffset(Position position) {
        return this.calcOffset(position, false);
    }

    protected int calcOffset(Position position, boolean bl) {
        if (!bl && position.equals(this.start)) {
            return -1;
        }
        int n = this.start.abs(this.cols);
        int n2 = position.abs(this.cols);
        int n3 = n2 - n;
        if (n3 < 0 || n3 >= this.len) {
            return -1;
        }
        return n3;
    }

    public boolean writeCursorChar(Position position, char c) {
        return this.writeCursorChar(position, c, false);
    }

    public boolean writeCursorChar(Position position, char c, boolean bl) {
        int n = this.calcOffset(position);
        if (n < 0) {
            return false;
        }
        if (!this.dataTypeTable.isOK(c, this.attribs.getDataType())) {
            return false;
        }
        if (this.attribs.getUpShift()) {
            c = Character.toUpperCase(c);
        }
        if (bl) {
            this.insertChar(position);
        }
        this.buf.setCharAt(n, c);
        this.map.clearAt(n);
        this.mdt = true;
        return true;
    }

    public boolean writeBufferChar(Position position, char c) {
        int n = this.calcOffset(position, true);
        if (n < 0) {
            return false;
        }
        this.buf.setCharAt(n, c);
        this.map.clearAt(n);
        return true;
    }

    public void setAttrib(Position position, int n) {
        int n2 = this.calcOffset(position, true);
        if (n2 < 0) {
            return;
        }
        this.buf.setCharAt(n2, '\u0000');
        this.map.set(n2, n);
    }

    public void clearField() {
        this.buf.setLength(0);
        this.buf.setLength(this.len);
        this.map.clearFrom(0);
    }

    public void clearAt(Position position) {
        int n = this.calcOffset(position);
        if (n < 0) {
            return;
        }
        this.buf.setCharAt(n, '\u0000');
        this.map.clearAt(n);
    }

    public void clearToEnd(Position position) {
        int n = this.calcOffset(position);
        if (n < 0) {
            return;
        }
        for (int i = n; i < this.len; ++i) {
            this.buf.setCharAt(i, '\u0000');
        }
        this.map.clearFrom(n);
    }

    public char[] getChars(int n) {
        int n2;
        int n3;
        if (n < this.start.getRow() || n > this.end.getRow()) {
            return null;
        }
        if (n == this.start.getRow()) {
            n3 = 0;
            n2 = n == this.end.getRow() ? this.end.getCol() - this.start.getCol() + 1 : this.cols - this.start.getCol();
        } else {
            n3 = this.cols - this.start.getCol() + (n - 1 - this.start.getRow()) * this.cols;
            n2 = n == this.end.getRow() ? this.end.getCol() + 1 : this.cols;
        }
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            int n4 = this.buf.charAt(n3 + i);
            if (n4 == 0) {
                n4 = 32;
            }
            cArray[i] = n4;
        }
        return cArray;
    }

    public int[] getAttribs(int n) {
        int n2;
        int n3;
        if (n < this.start.getRow() || n > this.end.getRow()) {
            return null;
        }
        if (n == this.start.getRow()) {
            n3 = 0;
            n2 = n == this.end.getRow() ? this.end.getCol() - this.start.getCol() + 1 : this.cols - this.start.getCol();
        } else {
            n3 = this.cols - this.start.getCol() + (n - 1 - this.start.getRow()) * this.cols;
            n2 = n == this.end.getRow() ? this.end.getCol() + 1 : this.cols;
        }
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this.map.get(n3 + i);
        }
        return nArray;
    }

    public void insertChar(Position position) {
        int n = this.calcOffset(position);
        if (n < 0) {
            return;
        }
        this.buf.insert(n, '\u0000');
        this.map.insertAt(n);
        this.buf.setLength(this.len);
    }

    public void deleteChar(Position position) {
        int n;
        int n2 = this.calcOffset(position);
        if (n2 < 0) {
            return;
        }
        for (n = n2; n < this.len - 1; ++n) {
            this.buf.setCharAt(n, this.buf.charAt(n + 1));
        }
        this.buf.setCharAt(n, '\u0000');
        this.map.deleteAt(n2);
    }

    protected int calcLen() {
        int n = this.start.abs(this.cols);
        int n2 = this.end.abs(this.cols);
        int n3 = n2 - n + 1;
        this.buf.setLength(n3);
        this.map.clearFrom(n3);
        return n3;
    }

    public String toString() {
        return "Field[start=" + this.start + ",end=" + this.end + "]";
    }
}

