/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal;

import com.mindbright.terminal.CompatTerminal;
import com.mindbright.terminal.DisplayModel;
import com.mindbright.terminal.DisplayView;
import com.mindbright.terminal.Screen;
import com.mindbright.terminal.SearchContext;
import com.mindbright.terminal.Terminal;
import com.mindbright.terminal.TerminalCharsetException;
import com.mindbright.terminal.TerminalCharsetFactory;
import com.mindbright.terminal.TerminalCharsetTranslator;
import com.mindbright.terminal.TerminalDefProps;
import com.mindbright.terminal.TerminalInterpreter;
import com.mindbright.terminal.TerminalOption;
import com.mindbright.terminal.TerminalWindow;
import com.mindbright.terminal.TerminalXTerm;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class TerminalVT100Style
implements Terminal,
CompatTerminal,
DisplayModel {
    private static TerminalOption optRevVideo = new TerminalOption("rev-video", "Reverse Video", "false");
    private static TerminalOption optAutoWrap = new TerminalOption("autowrap", "Auto Wraparound", "true");
    private static TerminalOption optRevAutoWrap = new TerminalOption("rev-autowrap", "Reverse Wraparound", "false");
    private static TerminalOption optInsertMode = new TerminalOption("insert-mode", "Insert mode", "false");
    private static TerminalOption optAutoLF = new TerminalOption("auto-linefeed", "Auto Linefeed", "false");
    private static TerminalOption optReposInput = new TerminalOption("repos-input", "Scroll to Bottom On Key Press", "true");
    private static TerminalOption optRposOutput = new TerminalOption("repos-output", "Scroll to Bottom On Tty Output", "true");
    private static TerminalOption optVisCursor = new TerminalOption("visible-cursor", "Visible Cursor", "true");
    private static TerminalOption optLocalEcho = new TerminalOption("local-echo", "Local Echo", "false");
    private static TerminalOption optVisBell = new TerminalOption("visual-bell", "Visual Bell", "false");
    private static TerminalOption optMapCtrlSpace = new TerminalOption("map-ctrl-space", "Map <CTRL>+<SPC> To ^@", "true");
    private static TerminalOption opt80x132Toggle = new TerminalOption("80x132-toggle", "80/132 Columns", "false");
    private static TerminalOption optLocalPgKeys = new TerminalOption("local-pgkeys", "Local PgUp/PgDown", "false");
    private static TerminalOption optAsciiLine = new TerminalOption("ascii-line", "Use ASCII for line draw", "false");
    private static TerminalOption optBackspaceSend = new TerminalOption("backspace-send", "Backspace sends", "del", new String[]{"del", "bs", "erase"});
    private static TerminalOption optDeleteSend = new TerminalOption("delete-send", "Delete sends", "bs", new String[]{"del", "bs", "erase"});
    private static TerminalOption[] optionsDef = new TerminalOption[]{optRevVideo, optAutoWrap, optRevAutoWrap, optInsertMode, optAutoLF, optReposInput, optRposOutput, optVisCursor, optLocalEcho, optVisBell, optMapCtrlSpace, optLocalPgKeys, optAsciiLine, optBackspaceSend, optDeleteSend};
    private static String[] terminalTypes = new String[]{"xterm", "linux", "scoansi", "att6386", "sun", "aixterm", "vt220", "vt100", "ansi", "vt52", "xterm-color", "linux-lat", "at386", "vt320", "vt102"};
    private static int[] personalities = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 17, 16};
    private static Properties defaultProperties = new Properties();
    private Properties props;
    private boolean propsChanged;
    private DisplayView display;
    private Screen screen;
    private boolean[] termOptions;
    private TerminalInterpreter interpreter;
    private TerminalCharsetTranslator translator;
    private TerminalWindow termWin;
    private String bsString;
    private String delString;
    private boolean doupdate = true;

    public static String[] getTerminalTypes() {
        return terminalTypes;
    }

    public static Terminal getTerminal(String string) {
        for (int i = 0; i < terminalTypes.length; ++i) {
            if (!terminalTypes[i].equals(string)) continue;
            TerminalXTerm terminalXTerm = new TerminalXTerm(personalities[i]);
            return new TerminalVT100Style(terminalXTerm);
        }
        return null;
    }

    public static TerminalOption[] getTerminalOptions() {
        return optionsDef;
    }

    public TerminalVT100Style(TerminalInterpreter terminalInterpreter) {
        this.interpreter = terminalInterpreter;
        terminalInterpreter.setTerminal(this);
        this.termOptions = new boolean[18];
        this.screen = new Screen(24, 80);
        this.props = new Properties(defaultProperties);
    }

    public String terminalType() {
        return this.interpreter.terminalType();
    }

    public boolean setTerminalType(String string) {
        for (int i = 0; i < terminalTypes.length; ++i) {
            if (!terminalTypes[i].equals(string)) continue;
            TerminalXTerm terminalXTerm = (TerminalXTerm)this.interpreter;
            terminalXTerm.setTerminalType(personalities[i]);
            return true;
        }
        return false;
    }

    public void setDumbMode(boolean bl) {
        this.interpreter.setDumbMode(bl);
    }

    public void close() {
        this.display = null;
        if (this.interpreter != null) {
            this.interpreter.setTerminal(null);
        }
        this.interpreter = null;
        this.termWin = null;
        if (this.screen != null) {
            this.screen.setDisplay(null);
        }
        this.screen = null;
    }

    public void reset() {
        this.interpreter.vtReset();
    }

    public int getRows() {
        return this.screen.getRows();
    }

    public int getCols() {
        return this.screen.getCols();
    }

    private void repaint() {
        if (this.display != null && this.doupdate) {
            this.display.repaint();
        }
    }

    private void localPageCtrlKeys(int n) {
        switch (n) {
            case 33: {
                if (this.display == null) break;
                this.display.setVisTopDelta(-this.screen.getRows(), true);
                break;
            }
            case 34: {
                if (this.display == null) break;
                this.display.setVisTopDelta(this.screen.getRows(), true);
                break;
            }
            case 36: {
                if (this.display == null) break;
                this.display.setVisTop(0, true);
                break;
            }
            case 35: {
                if (this.display == null) break;
                this.display.setVisTop(this.screen.getVisTop(), true);
            }
        }
    }

    public void paste(String string) {
        if (string == null) {
            return;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            this.keyHandler(cArray[i], 0, 0);
        }
    }

    private void simulateKeys(String string, int n) {
        for (int i = 0; i < string.length(); ++i) {
            this.keyHandler(string.charAt(i), 0, n);
        }
    }

    public void keyHandler(char c, int n, int n2) {
        boolean bl = false;
        switch (n) {
            case 8: {
                if (this.bsString.length() == 1) {
                    c = this.bsString.charAt(0);
                    break;
                }
                this.simulateKeys(this.bsString, n2);
                bl = true;
                break;
            }
            case 127: {
                if (this.delString.length() == 1) {
                    c = this.delString.charAt(0);
                    break;
                }
                this.simulateKeys(this.delString, n2);
                bl = true;
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                if ((n2 & 1) == 0 && !this.termOptions[14]) break;
                this.localPageCtrlKeys(n);
                bl = true;
                break;
            }
            case 32: {
                if ((n2 & 2) == 0 || !this.termOptions[10]) break;
                c = '\u0000';
                break;
            }
            case 19: {
                this.termWin.sendBreak();
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        if (this.termOptions[8]) {
            this.write(c);
        }
        if (this.termOptions[5] && this.display != null) {
            this.display.setVisTop(this.screen.getVisTop());
        }
        this.interpreter.keyHandler(c, n, n2);
    }

    public void mouseHandler(int n, int n2, int n3, boolean bl, int n4) {
        if (n + n2 >= this.screen.getVisTop()) {
            this.interpreter.mouseHandler(n2, n3, bl, n4);
        }
    }

    public void setInputCharset(String string) throws IllegalArgumentException {
        try {
            this.translator = TerminalCharsetFactory.create(string);
        }
        catch (TerminalCharsetException terminalCharsetException) {
            throw new IllegalArgumentException("unknown input-charset '" + string + "'");
        }
    }

    public void setUpdate(boolean bl) {
        this.doupdate = bl;
        if (bl) {
            this.display.repaint();
        }
    }

    public void fromHost(char c) {
        int n = this.interpreter.interpretChar(c);
        if (n != -1) {
            char c2 = this.translator == null ? (char)n : this.translator.translate((char)n);
            this.screen.writeChar(c2);
        }
        this.repaint();
    }

    public boolean setSize(int n, int n2) {
        this.screen.resize(n, n2);
        if (this.display != null) {
            this.display.setGeometry(this.getRows(), this.getCols());
        }
        return true;
    }

    public boolean setSaveLines(int n) {
        return this.screen.setSaveLines(n);
    }

    public void clearSaveLines() {
        this.screen.clearSaveLines();
    }

    public void doClickSelect(int n, int n2, int n3, String string) {
        this.screen.doClickSelect(n + n2, n3, string);
    }

    public String getSelection(String string) {
        return this.screen.getSelection(string);
    }

    public void setSelection(int n, int n2, int n3, int n4, int n5) {
        this.setSelection(n + n2, n3, n + n4, n5);
    }

    public void setSelection(int n, int n2, int n3, int n4) {
        this.screen.setSelection(n, n2, n3, n4);
    }

    public void selectAll() {
        this.screen.selectAll();
    }

    public void resetSelection() {
        this.screen.resetSelection();
    }

    public void resetClickSelect() {
        this.screen.resetClickSelect();
    }

    public void setTerminalWindow(TerminalWindow terminalWindow) {
        this.termWin = terminalWindow;
    }

    public void setDisplay(DisplayView displayView) {
        this.display = displayView;
        this.screen.setDisplay(displayView);
        this.screen.clearSaveLines();
        this.screen.clearScreen();
        displayView.setModel(this);
        displayView.updateScrollbarValues();
    }

    public void setProperties(Properties properties) {
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            string = TerminalDefProps.backwardCompatProp(string);
            this.setProperty(string, string2);
        }
    }

    public boolean setProperty(String string, String string2) {
        return this.setProperty(string, string2, false);
    }

    public boolean setProperty(String string, String string2, boolean bl) {
        boolean bl2 = false;
        String string3 = this.getProperty(string);
        boolean bl3 = Boolean.valueOf(string2);
        if (string3 != null && string3.equals(string2)) {
            bl2 = true;
            if (!bl) {
                return true;
            }
        }
        if (optRevVideo.getKey().equals(string)) {
            if (!string2.equals(string3) && this.display != null) {
                this.display.reverseColors();
            }
            this.termOptions[0] = bl3;
        } else if (string.equals(optAutoWrap.getKey())) {
            this.screen.setAutoWrap(bl3);
            this.termOptions[1] = bl3;
        } else if (string.equals(optRevAutoWrap.getKey())) {
            this.screen.setAutoReverseWrap(bl3);
            this.termOptions[2] = bl3;
        } else if (string.equals(optInsertMode.getKey())) {
            this.screen.setInsertMode(bl3);
            this.termOptions[3] = bl3;
        } else if (string.equals(optAutoLF.getKey())) {
            this.screen.setAutoLF(bl3);
            this.termOptions[4] = bl3;
        } else if (string.equals(optReposInput.getKey())) {
            this.termOptions[5] = bl3;
        } else if (string.equals(optRposOutput.getKey())) {
            if (this.display != null) {
                this.display.setVisTopChangeAllowed(bl3);
            }
            this.termOptions[6] = bl3;
        } else if (string.equals(optVisCursor.getKey())) {
            if (this.display != null) {
                this.repaint();
            }
            this.termOptions[7] = bl3;
        } else if (string.equals(optLocalEcho.getKey())) {
            this.termOptions[8] = bl3;
        } else if (string.equals(optVisBell.getKey())) {
            this.termOptions[9] = bl3;
        } else if (string.equals(optMapCtrlSpace.getKey())) {
            this.termOptions[10] = bl3;
        } else if (string.equals(opt80x132Toggle.getKey())) {
            this.cursorSetPos(0, 0, false);
            this.setSize(this.screen.getRows(), bl3 ? 132 : 80);
            this.clearScreen();
        } else if (string.equals(optLocalPgKeys.getKey())) {
            this.termOptions[14] = bl3;
        } else if (string.equals(optAsciiLine.getKey())) {
            this.termOptions[16] = bl3;
        } else if (string.equals(optBackspaceSend.getKey())) {
            this.bsString = string2.equalsIgnoreCase("del") ? "\u007f" : (string2.equalsIgnoreCase("erase") ? "\u001b[3~" : "\b");
        } else if (string.equals(optDeleteSend.getKey())) {
            this.delString = string2.equalsIgnoreCase("bs") ? "\b" : (string2.equalsIgnoreCase("erase") ? "\u001b[3~" : "\u007f");
        } else {
            return false;
        }
        ((Hashtable)this.props).put(string, string2);
        if (!bl2) {
            this.propsChanged = true;
        }
        return true;
    }

    public Properties getProperties() {
        return this.props;
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    public boolean getPropsChanged() {
        return this.propsChanged;
    }

    public void setPropsChanged(boolean bl) {
        this.propsChanged = bl;
    }

    public String getDefaultProperty(String string) {
        return defaultProperties.getProperty(string);
    }

    public TerminalOption[] getOptions() {
        return optionsDef;
    }

    public void setAttributeBold(boolean bl) {
        this.screen.setAttribute(1, bl);
    }

    public void ringBell() {
        this.doBell();
    }

    public void setCursorPos(int n, int n2) {
        this.screen.cursorSetPos(n, n2, false);
    }

    public char[] getChars(int n, int n2) {
        return this.screen.getCharsAt(n + n2);
    }

    public int[] getAttribs(int n, int n2) {
        return this.screen.getAttribsAt(n + n2);
    }

    public int getDisplayRows() {
        return this.screen.getRows();
    }

    public int getDisplayCols() {
        return this.screen.getCols();
    }

    public int getBufferRows() {
        return this.screen.getVisTop() + this.screen.getRows();
    }

    public void setTitle(String string) {
        if (this.termWin != null) {
            this.termWin.setTitle(string);
        }
    }

    public int rows() {
        return this.getRows();
    }

    public int cols() {
        return this.getCols();
    }

    public void fillScreen(char c) {
        this.screen.fillScreen(c);
        this.repaint();
    }

    public void write(char c) {
        if (this.termWin != null) {
            this.termWin.write(c);
        }
    }

    public void write(char[] cArray, int n, int n2) {
        if (this.termWin != null) {
            this.termWin.write(cArray, n, n2);
        }
    }

    public void write(String string) {
        if (this.termWin != null) {
            this.termWin.write(string);
        }
    }

    public void writeLineDrawChar(char c) {
        this.screen.writeLineDrawChar(c);
        this.repaint();
    }

    public void typedChar(char c) {
        if (this.termWin != null) {
            this.termWin.typedChar(c);
        }
    }

    public void sendBytes(byte[] byArray) {
        if (this.termWin != null) {
            this.termWin.sendBytes(byArray);
        }
    }

    public void doBell() {
        if (this.display != null) {
            this.display.doBell(this.termOptions[9]);
        }
    }

    public void doBS() {
        this.screen.doBS();
        this.repaint();
    }

    public void doTab() {
        this.screen.doTab();
        this.repaint();
    }

    public void doTabs(int n) {
        this.screen.doTabs(n);
        this.repaint();
    }

    public void doBackTabs(int n) {
        this.screen.doBackTabs(n);
        this.repaint();
    }

    public void setTab(int n) {
        this.screen.setTab(n);
        this.repaint();
    }

    public void clearTab(int n) {
        this.screen.clearTab(n);
        this.repaint();
    }

    public void resetTabs() {
        this.screen.resetTabs();
        this.repaint();
    }

    public void clearAllTabs() {
        this.screen.clearAllTabs();
        this.repaint();
    }

    public void doCR() {
        this.screen.doCR();
        this.repaint();
    }

    public void doLF() {
        this.screen.doLF();
        this.repaint();
    }

    public void resetInterpreter() {
        this.interpreter.vtReset();
    }

    public void resetWindow() {
        this.screen.resetWindow();
        this.repaint();
    }

    public void setWindow(int n, int n2) {
        this.screen.setWindow(n, n2);
    }

    public void setWindow(int n, int n2, int n3, int n4) {
        this.screen.setWindow(n, n2, n3, n4);
        this.repaint();
    }

    public int getWindowTop() {
        return this.screen.getWindowTop();
    }

    public int getWindowBottom() {
        return this.screen.getWindowBottom();
    }

    public int getWindowLeft() {
        return this.screen.getWindowLeft();
    }

    public int getWindowRight() {
        return this.screen.getWindowRight();
    }

    public int getCursorV() {
        return this.screen.getCursorV();
    }

    public int getCursorH() {
        return this.screen.getCursorH();
    }

    public void cursorSetPos(int n, int n2, boolean bl) {
        this.screen.cursorSetPos(n, n2, bl);
        this.repaint();
    }

    public void cursorUp(int n) {
        this.screen.cursorUp(n);
        this.repaint();
    }

    public void cursorDown(int n) {
        this.screen.cursorDown(n);
        this.repaint();
    }

    public void cursorForward(int n) {
        this.screen.cursorForward(n);
        this.repaint();
    }

    public void cursorBackward(int n) {
        this.screen.cursorBackward(n);
        this.repaint();
    }

    public void cursorIndex(int n) {
        this.screen.cursorIndex(n);
        this.repaint();
    }

    public void cursorIndexRev(int n) {
        this.screen.cursorIndexRev(n);
        this.repaint();
    }

    public void cursorSave() {
        this.screen.cursorSave();
        this.repaint();
    }

    public void cursorRestore() {
        this.screen.cursorRestore();
        this.repaint();
    }

    public void scrollUp(int n) {
        this.screen.scrollUp(n);
        this.repaint();
    }

    public void scrollDown(int n) {
        this.screen.scrollDown(n);
        this.repaint();
    }

    public void clearBelow() {
        this.screen.clearBelow();
        this.repaint();
    }

    public void clearAbove() {
        this.screen.clearAbove();
        this.repaint();
    }

    public void clearScreen() {
        this.screen.clearScreen();
        this.repaint();
    }

    public void clearRight() {
        this.screen.clearRight();
        this.repaint();
    }

    public void clearLeft() {
        this.screen.clearLeft();
        this.repaint();
    }

    public void clearLine() {
        this.screen.clearLine();
        this.repaint();
    }

    public void eraseChars(int n) {
        this.screen.eraseChars(n);
        this.repaint();
    }

    public void insertChars(int n) {
        this.screen.insertChars(n);
        this.repaint();
    }

    public void insertLines(int n) {
        this.screen.insertLines(n);
        this.repaint();
    }

    public void deleteChars(int n) {
        this.screen.deleteChars(n);
        this.repaint();
    }

    public void deleteLines(int n) {
        this.screen.deleteLines(n);
        this.repaint();
    }

    public void printScreen() {
        if (this.termWin != null) {
            this.termWin.printScreen();
        }
    }

    public void startPrinter() {
        if (this.termWin != null) {
            this.termWin.startPrinter();
        }
    }

    public void stopPrinter() {
        if (this.termWin != null) {
            this.termWin.stopPrinter();
        }
    }

    private String mapToOptionKey(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = optRevVideo.getKey();
                break;
            }
            case 1: {
                string = optAutoWrap.getKey();
                break;
            }
            case 2: {
                string = optRevAutoWrap.getKey();
                break;
            }
            case 3: {
                string = optInsertMode.getKey();
                break;
            }
            case 4: {
                string = optAutoLF.getKey();
                break;
            }
            case 5: {
                string = optReposInput.getKey();
                break;
            }
            case 6: {
                string = optRposOutput.getKey();
                break;
            }
            case 7: {
                string = optVisCursor.getKey();
                break;
            }
            case 8: {
                string = optLocalEcho.getKey();
                break;
            }
            case 9: {
                string = optVisBell.getKey();
                break;
            }
            case 10: {
                string = optMapCtrlSpace.getKey();
                break;
            }
            case 11: {
                string = opt80x132Toggle.getKey();
                break;
            }
            case 14: {
                string = optLocalPgKeys.getKey();
                break;
            }
            case 16: {
                string = optAsciiLine.getKey();
            }
        }
        return string;
    }

    public void setOption(int n, boolean bl) {
        String string = String.valueOf(bl);
        String string2 = this.mapToOptionKey(n);
        if (string2 == null) {
            return;
        }
        this.setProperty(string2, string);
    }

    public boolean getOption(int n) {
        String string = this.mapToOptionKey(n);
        if (string == null) {
            return false;
        }
        return Boolean.valueOf(this.getProperty(string));
    }

    public SearchContext search(SearchContext searchContext, String string, boolean bl, boolean bl2) {
        SearchContext searchContext2 = this.screen.search(searchContext, string, bl, bl2);
        if (searchContext2 != null) {
            this.display.setVisTop(searchContext2.getStartRow());
            this.screen.setSelection(searchContext2.getStartRow(), searchContext2.getStartCol(), searchContext2.getEndRow(), searchContext2.getEndCol());
            this.display.repaint(true);
        }
        return searchContext2;
    }

    public void setAttribute(int n, boolean bl) {
        this.screen.setAttribute(n, bl);
    }

    public boolean getAttribute(int n) {
        return this.screen.getAttribute(n);
    }

    public void setForegroundColor(int n) {
        this.screen.setForegroundColor(n);
    }

    public void setBackgroundColor(int n) {
        this.screen.setBackgroundColor(n);
    }

    public void clearAllAttributes() {
        this.screen.clearAllAttributes();
    }

    static {
        for (int i = 0; i < optionsDef.length; ++i) {
            ((Hashtable)defaultProperties).put(optionsDef[i].getKey(), optionsDef[i].getDefault());
        }
    }
}

