/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.sshcommon;

import com.mindbright.application.MindTermApp;
import com.mindbright.gui.AWTConvenience;
import com.mindbright.gui.SwingConvenience;
import com.mindbright.sshcommon.SSHFileTransfer;
import com.mindbright.sshcommon.SSHFileTransferDialogControl;
import com.mindbright.sshcommon.SSHFileTransferProgress;
import com.mindbright.util.Progress;
import com.mindbright.util.StringUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public final class SSHFileTransferGUIThreadSwing
extends Thread
implements SSHFileTransferProgress,
ActionListener {
    boolean recursive;
    boolean background;
    boolean toRemote;
    SSHFileTransferDialogControl xferDialog;
    MindTermApp client;
    String[] localFileList;
    String[] remoteFileList;
    JDialog copyIndicator;
    ProgressBar progress;
    SSHFileTransfer fileXfer;
    Thread copyThread;
    JLabel srcLbl;
    JLabel dstLbl;
    JLabel sizeLbl;
    JLabel nameLbl;
    JLabel speedLbl;
    JButton cancB;
    long startTime;
    long lastTime;
    long totTransSize;
    long fileTransSize;
    long curFileSize;
    long lastSize;
    int fileCnt;
    boolean doneCopying;
    volatile boolean userCancel;
    boolean isCopyThread;

    public SSHFileTransferGUIThreadSwing(MindTermApp mindTermApp, SSHFileTransfer sSHFileTransfer, String[] stringArray, String[] stringArray2, boolean bl, boolean bl2, boolean bl3, SSHFileTransferDialogControl sSHFileTransferDialogControl) throws Exception {
        this.setName("SSHFileTransferGUIThreadSwing1");
        this.isCopyThread = false;
        this.localFileList = stringArray;
        this.remoteFileList = stringArray2;
        if (!bl3) {
            if (stringArray.length > 1) {
                throw new Exception("Ambiguous local target");
            }
        } else if (stringArray2.length > 1) {
            throw new Exception("Ambiguous remote target");
        }
        this.client = mindTermApp;
        this.fileXfer = sSHFileTransfer;
        this.recursive = bl;
        this.background = bl2;
        this.toRemote = bl3;
        this.fileCnt = 0;
        this.doneCopying = false;
        this.startTime = 0L;
        this.lastTime = 0L;
        this.totTransSize = 0L;
        this.fileTransSize = 0L;
        this.lastSize = 0L;
        this.xferDialog = sSHFileTransferDialogControl;
        this.start();
    }

    public void run() {
        if (this.isCopyThread) {
            this.copyThreadMain();
        } else {
            this.createGUIAndCopyThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyThreadMain() {
        try {
            this.nameLbl.setText("...connected");
            this.fileXfer.setProgress(this);
            if (this.toRemote) {
                this.fileXfer.copyToRemote(this.localFileList, this.remoteFileList[0], this.recursive);
            } else {
                this.fileXfer.copyToLocal(this.localFileList[0], this.remoteFileList, this.recursive);
            }
            this.copyThread.setPriority(5);
        }
        catch (Exception exception) {
            if (!this.userCancel) {
                this.client.alert("File Transfer Error: " + exception.getMessage());
            }
        }
        finally {
            try {
                Toolkit.getDefaultToolkit().beep();
            }
            catch (Throwable throwable) {}
        }
        this.nameLbl.setText("Copied " + this.fileCnt + " file" + (this.fileCnt != 1 ? "s" : "") + ".");
        this.sizeLbl.setText(StringUtil.nBytesToString(this.totTransSize, 4));
        this.doneCopying = true;
        if (this.fileXfer != null) {
            this.fileXfer.abort();
        }
        this.cancB.setLabel("Done");
        this.xferDialog.refresh();
    }

    private void createGUIAndCopyThread() {
        Object object;
        String string = "localhost:" + SSHFileTransferGUIThreadSwing.unQuote(this.localFileList[0]);
        String string2 = this.client.getHost() + ":" + SSHFileTransferGUIThreadSwing.unQuote(this.remoteFileList[0]);
        if (!this.toRemote) {
            object = string;
            string = string2;
            string2 = object;
        }
        this.copyIndicator = SwingConvenience.newBorderJDialog(this.client.getParentFrame(), "MindTerm - File Transfer", false);
        object = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 13;
        ((Container)object).add((Component)new JLabel("Source:"), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.srcLbl = new JLabel(SSHFileTransferGUIThreadSwing.cutName(string, 48));
        ((Container)object).add((Component)this.srcLbl, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 13;
        ((Container)object).add((Component)new JLabel("Destination:"), gridBagConstraints);
        this.dstLbl = new JLabel(SSHFileTransferGUIThreadSwing.cutName(string2, 48));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        ((Container)object).add((Component)this.dstLbl, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 13;
        ((Container)object).add((Component)new JLabel("Current:"), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.nameLbl = new JLabel("connecting...");
        ((Container)object).add((Component)this.nameLbl, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 13;
        ((Container)object).add((Component)new JLabel("Size:"), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.sizeLbl = new JLabel("");
        ((Container)object).add((Component)this.sizeLbl, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.progress = new ProgressBar(512L, 160, 20);
        ((Container)object).add((Component)this.progress, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        this.speedLbl = new JLabel("0.0 kB/sec");
        ((Container)object).add((Component)this.speedLbl, gridBagConstraints);
        this.copyIndicator.getContentPane().add((Component)object, "Center");
        this.cancB = new JButton("Cancel");
        this.cancB.addActionListener(this);
        this.copyIndicator.getContentPane().add((Component)SwingConvenience.newButtonPanel(new JButton[]{this.cancB}), "South");
        this.copyIndicator.setResizable(true);
        this.copyIndicator.pack();
        AWTConvenience.placeDialog(this.copyIndicator);
        this.isCopyThread = true;
        this.copyThread = new Thread((Runnable)this, "SSHFileTransferGUIThreadSwing2");
        if (this.background) {
            this.copyThread.setPriority(1);
        }
        this.copyThread.start();
        ((Component)this.copyIndicator).setVisible(true);
    }

    public void startFile(String string, long l) {
        this.sizeLbl.setText(l >= 0L ? StringUtil.nBytesToString(l, 4) : "unknown");
        this.nameLbl.setText(SSHFileTransferGUIThreadSwing.unQuote(string));
        this.progress.setMaximum(l);
        this.lastTime = System.currentTimeMillis();
        if (this.startTime == 0L) {
            this.startTime = this.lastTime;
        }
        this.curFileSize = l;
        this.fileTransSize = 0L;
        ++this.fileCnt;
    }

    public void startDir(String string) {
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        if (this.toRemote) {
            this.srcLbl.setText(SSHFileTransferGUIThreadSwing.cutName("localhost:" + SSHFileTransferGUIThreadSwing.unQuote(string), 48));
        } else {
            this.dstLbl.setText(SSHFileTransferGUIThreadSwing.cutName("localhost:" + SSHFileTransferGUIThreadSwing.unQuote(string), 48));
        }
    }

    public void endFile() {
        if (this.curFileSize >= 0L) {
            this.progress.setValue(this.curFileSize >= 0L ? this.curFileSize : this.fileTransSize);
        }
    }

    public void endDir() {
    }

    public void progress(long l) {
        this.totTransSize += l;
        this.fileTransSize += l;
        long l2 = System.currentTimeMillis();
        if (this.curFileSize > 0L && (this.totTransSize - this.lastSize) * 100L / this.curFileSize >= 1L || l2 - this.lastTime > 1000L) {
            this.progress.setValue(this.fileTransSize);
            long l3 = l2 - this.startTime;
            if (l3 > 0L) {
                long l4 = (long)((double)this.totTransSize / ((double)l3 / 1000.0));
                l3 = l2 - this.lastTime;
                if (l3 == 0L) {
                    l3 = 1L;
                }
                l4 += (long)((double)(this.totTransSize - this.lastSize) / ((double)l3 / 1000.0));
                this.speedLbl.setText(StringUtil.nBytesToString(l4 >>>= 1, 4) + "/sec");
            }
            this.lastSize = this.totTransSize;
            this.lastTime = l2;
        }
    }

    private static String cutName(String string, int n) {
        if (string.length() > n) {
            String string2 = string.substring(0, (n -= 3) / 2);
            String string3 = string.substring(string.length() - n / 2);
            string = string2 + "..." + string3;
        }
        return string;
    }

    private static String unQuote(String string) {
        if (string.charAt(0) == '\"') {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.doneCopying) {
            this.userCancel = true;
            if (this.fileXfer != null) {
                this.fileXfer.abort();
            }
            Thread.yield();
            if (this.copyThread != null) {
                this.copyThread.stop();
            }
        }
        this.copyIndicator.dispose();
    }

    private static class ProgressBar
    extends JProgressBar
    implements Progress {
        private static final int STEPS = 2048;
        private long max;

        ProgressBar(long l, int n, int n2) {
            super(0, 2048);
            this.max = l;
        }

        public void progress(long l) {
            this.setValueL(l);
        }

        private void setValueL(long l) {
            super.setValue((int)((double)l / (double)this.max * 2048.0));
        }

        public void setValue(long l) {
            this.setValueL(l);
        }

        public void setMaximum(long l) {
            this.max = l;
        }
    }
}

