/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.sshcommon;

import com.isnetworks.ssh.FileBrowser;
import com.isnetworks.ssh.FileDisplayControl;
import com.isnetworks.ssh.FileDisplaySwing;
import com.isnetworks.ssh.FileListItem;
import com.mindbright.application.MindTermApp;
import com.mindbright.gui.SwingConvenience;
import com.mindbright.sshcommon.SSHChdirEventHandler;
import com.mindbright.sshcommon.SSHFileTransfer;
import com.mindbright.sshcommon.SSHFileTransferDialogControl;
import com.mindbright.sshcommon.SSHFileTransferFactory;
import com.mindbright.sshcommon.SSHFileTransferGUIThreadSwing;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class SSHFileTransferDialogSwing
extends JDialog
implements ActionListener,
SSHFileTransferDialogControl,
DropTargetListener {
    private JButton mUploadButton;
    private JButton mDownloadButton;
    private JPanel mFileDisplayPanel;
    private JPanel mMainBottomSectionPanel;
    private JButton closeButton;
    private FileDisplaySwing mLocalFileDisplay;
    private FileDisplaySwing mRemoteFileDisplay;
    private FileBrowser mRemoteFileBrowser;
    private FileBrowser mLocalFileBrowser;
    private MindTermApp client;
    private SSHFileTransferFactory fileXferFactory;
    private DropTarget dropTarget;
    private DataFlavor uriListFlavor;
    private DataFlavor fileListFlavor;
    private SSHChdirEventHandler chdirEventHandler = null;

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        int n = dropTargetDragEvent.getDropTargetContext().getDropTarget().getDefaultActions();
        if ((dropTargetDragEvent.isDataFlavorSupported(this.uriListFlavor) || dropTargetDragEvent.isDataFlavorSupported(this.fileListFlavor)) && (dropTargetDragEvent.getSourceActions() & n) != 0) {
            dropTargetDragEvent.acceptDrag(1);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Object object;
        Object object2;
        String[] stringArray;
        List<File> list = new ArrayList();
        dropTargetDropEvent.acceptDrop(1);
        try {
            stringArray = dropTargetDropEvent.getTransferable();
            if (stringArray.isDataFlavorSupported(this.uriListFlavor)) {
                object2 = new BufferedReader((Reader)stringArray.getTransferData(this.uriListFlavor));
                while ((object = ((BufferedReader)object2).readLine()) != null) {
                    if (((String)object).charAt(0) == '#' || ((String)object).charAt(0) == '\u0000') continue;
                    list.add(new File(new URI((String)object)));
                }
            } else {
                list = (List)stringArray.getTransferData(this.fileListFlavor);
            }
            dropTargetDropEvent.dropComplete(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            dropTargetDropEvent.dropComplete(false);
            list = null;
        }
        if (list != null) {
            try {
                Object object3;
                object2 = ((File)list.get(0)).getParentFile();
                stringArray = new String[list.size()];
                object = list.iterator();
                int n = 0;
                while (object.hasNext()) {
                    object3 = (File)object.next();
                    stringArray[n++] = ((File)object3).getPath();
                }
                object3 = this.fileXferFactory.create(this.client, (File)object2);
                String[] stringArray2 = new String[]{this.mRemoteFileDisplay.getFileSystemLocationLabelText()};
                new SSHFileTransferGUIThreadSwing(this.client, (SSHFileTransfer)object3, stringArray, stringArray2, true, false, true, this);
            }
            catch (Exception exception) {
                this.logError(exception);
            }
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        int n = dropTargetDragEvent.getDropTargetContext().getDropTarget().getDefaultActions();
        if ((dropTargetDragEvent.isDataFlavorSupported(this.uriListFlavor) || dropTargetDragEvent.isDataFlavorSupported(this.fileListFlavor)) && (dropTargetDragEvent.getSourceActions() & 1) != 0) {
            dropTargetDragEvent.acceptDrag(1);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("close".equals(string)) {
            this.dispose();
            this.mRemoteFileBrowser.disconnect();
            if (this.chdirEventHandler != null) {
                this.chdirEventHandler.chdir(this.mLocalFileDisplay.getFileSystemLocationLabelText());
            }
        } else {
            boolean bl = "toremote".equals(string);
            try {
                Object object;
                String string2;
                String string3;
                FileListItem[] fileListItemArray;
                String string4 = this.mLocalFileDisplay.getFileSystemLocationLabelText();
                String string5 = this.mRemoteFileDisplay.getFileSystemLocationLabelText();
                if (bl) {
                    fileListItemArray = this.mLocalFileDisplay.getSelectedFiles();
                    string3 = string4;
                    string2 = string5;
                } else {
                    fileListItemArray = this.mRemoteFileDisplay.getSelectedFiles();
                    string3 = string5;
                    string2 = string4;
                }
                String[] stringArray = new String[fileListItemArray.length];
                if (fileListItemArray.length == 0) {
                    throw new Exception("Please select file(s) to transfer");
                }
                for (int i = 0; i < fileListItemArray.length; ++i) {
                    stringArray[i] = string3 + fileListItemArray[i].getName();
                }
                String[] stringArray2 = new String[]{string2};
                if (!bl) {
                    object = stringArray2;
                    stringArray2 = stringArray;
                    stringArray = object;
                }
                object = this.fileXferFactory.create(this.client, new File(string4));
                new SSHFileTransferGUIThreadSwing(this.client, (SSHFileTransfer)object, stringArray, stringArray2, true, false, bl, this);
            }
            catch (Exception exception) {
                this.logError(exception);
            }
        }
    }

    public SSHFileTransferDialogSwing(String string, MindTermApp mindTermApp, SSHFileTransferFactory sSHFileTransferFactory) {
        super(mindTermApp.getParentFrame(), string, false);
        this.client = mindTermApp;
        this.fileXferFactory = sSHFileTransferFactory;
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        ((JComponent)this.getContentPane()).setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add("South", this.getMainBottomSectionPanel());
        this.getContentPane().add("Center", this.getFileDisplayPanel());
        this.addWindowListener(SwingConvenience.getWindowDisposer());
        this.pack();
        try {
            this.uriListFlavor = new DataFlavor("text/uri-list; class=java.io.Reader; charset=Unicode");
            this.fileListFlavor = new DataFlavor("application/x-java-file-list; class=java.util.List");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        Component component = this.getRootPane().getGlassPane();
        component.setVisible(true);
        this.dropTarget = new DropTarget(component, 1, this);
    }

    public void setLocalFileBrowser(FileBrowser fileBrowser) {
        this.mLocalFileBrowser = fileBrowser;
    }

    public void setRemoteFileBrowser(FileBrowser fileBrowser) {
        this.mRemoteFileBrowser = fileBrowser;
    }

    private JPanel getMainBottomSectionPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.closeButton = new JButton("Close");
        this.closeButton.setActionCommand("close");
        this.closeButton.addActionListener(this);
        jPanel.add(this.closeButton);
        return jPanel;
    }

    private JPanel getFileDisplayPanel() {
        JPanel jPanel = new JPanel(new SpecialLayout());
        jPanel.add((FileDisplaySwing)this.getLocalFileDisplay());
        this.mDownloadButton = new JButton("<--");
        this.mDownloadButton.setActionCommand("tolocal");
        this.mDownloadButton.addActionListener(this);
        this.mUploadButton = new JButton("-->");
        this.mUploadButton.setActionCommand("toremote");
        this.mUploadButton.addActionListener(this);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel2.add((Component)this.mDownloadButton, gridBagConstraints);
        jPanel2.add((Component)this.mUploadButton, gridBagConstraints);
        jPanel.add(jPanel2);
        jPanel.add((FileDisplaySwing)this.getRemoteFileDisplay());
        return jPanel;
    }

    public FileDisplayControl getLocalFileDisplay() {
        if (this.mLocalFileDisplay == null) {
            this.mLocalFileDisplay = this.newFileDisplay("Local System");
        }
        return this.mLocalFileDisplay;
    }

    public FileDisplayControl getRemoteFileDisplay() {
        if (this.mRemoteFileDisplay == null) {
            this.mRemoteFileDisplay = this.newFileDisplay("Remote System");
        }
        return this.mRemoteFileDisplay;
    }

    private FileDisplaySwing newFileDisplay(String string) {
        return new FileDisplaySwing(this.client.getParentFrame(), string, this);
    }

    public void refresh() {
        try {
            this.mRemoteFileBrowser.refresh();
            this.mLocalFileBrowser.refresh();
        }
        catch (Exception exception) {
            this.logError(exception);
        }
    }

    public void doShow() {
        this.setVisible(true);
    }

    public void setVisible(boolean bl) {
        if (!bl) {
            super.setVisible(false);
            return;
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.width > 600 ? 600 : dimension.width;
        int n2 = dimension.height > 400 ? 400 : dimension.height;
        ((Component)this).setSize(n, n2);
        try {
            this.mRemoteFileBrowser.initialize();
            this.mLocalFileBrowser.initialize();
        }
        catch (Exception exception) {
            this.logError(exception);
        }
        super.setVisible(true);
    }

    public void logError(Exception exception) {
        this.client.alert(exception.getMessage());
    }

    public void setLocalChdirCallback(SSHChdirEventHandler sSHChdirEventHandler) {
        this.chdirEventHandler = sSHChdirEventHandler;
    }

    private class SpecialLayout
    implements LayoutManager {
        private int minWidth = 0;
        private int minHeight = 0;
        private int preferredWidth = 0;
        private int preferredHeight = 0;
        private boolean sizeUnknown = true;

        private SpecialLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.getSize(container, this.minWidth, this.minHeight);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.getSize(container, this.preferredWidth, this.preferredHeight);
        }

        public void layoutContainer(Container container) {
            Component component;
            int n;
            Insets insets = container.getInsets();
            int n2 = container.getWidth() - (insets.left + insets.right);
            int n3 = container.getHeight() - (insets.top + insets.bottom);
            int n4 = container.getComponentCount();
            int n5 = insets.left;
            int n6 = insets.top;
            if (n4 < 3) {
                System.out.println("*** nComps < 3");
                return;
            }
            if (this.sizeUnknown) {
                this.setSizes(container);
            }
            int n7 = 0;
            for (n = 1; n < n4 - 1; ++n) {
                component = container.getComponent(n);
                Dimension dimension = component.getPreferredSize();
                n7 += dimension.width;
            }
            int n8 = (n2 - n7) / 2;
            component = container.getComponent(0);
            component.setBounds(n5, n6, n8, n3);
            n5 += n8;
            for (n = 1; n < n4 - 1; ++n) {
                component = container.getComponent(n);
                int n9 = component.getPreferredSize().width;
                component.setBounds(n5, n6, n9, n3);
                n5 += n9;
            }
            component = container.getComponent(n4 - 1);
            component.setBounds(n5, n6, n8, n3);
        }

        private Dimension getSize(Container container, int n, int n2) {
            Dimension dimension = new Dimension(0, 0);
            this.setSizes(container);
            Insets insets = container.getInsets();
            dimension.width = n + insets.left + insets.right;
            dimension.height = n2 + insets.top + insets.bottom;
            this.sizeUnknown = false;
            return dimension;
        }

        private void setSizes(Container container) {
            int n = container.getComponentCount();
            Dimension dimension = null;
            Dimension dimension2 = null;
            this.preferredWidth = 0;
            this.preferredHeight = 0;
            this.minWidth = 0;
            this.minHeight = 0;
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                dimension = component.getPreferredSize();
                dimension2 = component.getMinimumSize();
                this.preferredHeight = Math.max(this.preferredHeight, dimension.height);
                this.preferredWidth += dimension.width;
                this.minHeight = Math.max(this.minHeight, dimension2.height);
                this.minWidth += dimension2.height;
            }
        }
    }
}

