/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2Connection;
import com.mindbright.ssh2.SSH2SocksChannel;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class SSH2SocksListener
implements Runnable {
    private static final int LISTEN_QUEUE_SIZE = 32;
    private SSH2Connection connection;
    private ServerSocket listenSocket;
    private String listenAddr;
    private int listenPort;
    private Thread myListener;
    private boolean keepListening = true;

    public SSH2SocksListener(String string, int n, SSH2Connection sSH2Connection) throws IOException {
        this.connection = sSH2Connection;
        this.listenPort = n;
        this.listenAddr = string;
        sSH2Connection.getLog().debug("SSH2SocksListener", "creating listener on " + string + ":" + n);
        this.listenSocket = new ServerSocket(n, 32, InetAddress.getByName(string));
        this.myListener = new Thread((Runnable)this, "SSH2SocksListener_" + string + ":" + n);
        this.myListener.setDaemon(true);
        this.myListener.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.listenSocket != null && this.keepListening) {
            this.keepListening = false;
            Socket socket = null;
            try {
                String string = this.listenSocket.getInetAddress().getHostAddress();
                if (string.equals("0.0.0.0")) {
                    string = InetAddress.getLocalHost().getHostAddress();
                }
                socket = new Socket(string, this.listenSocket.getLocalPort());
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.connection.getLog().debug("SSH2SocksListener", "starting listener on " + this.listenAddr + ":" + this.listenPort);
            while (this.keepListening) {
                Socket socket = null;
                try {
                    socket = this.listenSocket.accept();
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (this.keepListening) continue;
                }
                if (!this.keepListening) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                    break;
                }
                this.doConnect(socket);
            }
        }
        catch (IOException iOException) {
            if (this.keepListening) {
                this.connection.getLog().error("SSH2SocksListener", "run", "Error in accept for listener " + this.listenAddr + ":" + this.listenPort + " : " + iOException.getMessage());
            }
        }
        finally {
            try {
                this.listenSocket.close();
                this.keepListening = false;
            }
            catch (IOException iOException) {}
            this.listenSocket = null;
            this.connection.getLog().debug("SSH2SocksListener", "stopping listener on " + this.listenAddr + ":" + this.listenPort);
        }
    }

    private void doConnect(Socket socket) {
        SSH2SocksChannel sSH2SocksChannel = new SSH2SocksChannel(socket, this.connection);
    }
}

