/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.jca.security.MessageDigest;
import com.mindbright.jca.security.NoSuchAlgorithmException;
import com.mindbright.jca.security.PublicKey;
import com.mindbright.ssh2.SSH2Exception;
import com.mindbright.ssh2.SSH2PublicKeyFile;
import com.mindbright.ssh2.SSH2Signature;
import com.mindbright.util.HexDump;

public final class SSH2KeyFingerprint {
    public static String md5Hex(PublicKey publicKey) throws SSH2Exception {
        SSH2PublicKeyFile sSH2PublicKeyFile = new SSH2PublicKeyFile(publicKey, null, null);
        SSH2Signature sSH2Signature = SSH2Signature.getEncodingInstance(sSH2PublicKeyFile.getAlgorithmName());
        return SSH2KeyFingerprint.md5Hex(sSH2Signature.encodePublicKey(publicKey));
    }

    public static String md5Hex(byte[] byArray) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error("SSH2KeyFingerprint.md5Hex: " + noSuchAlgorithmException);
        }
        byte[] byArray2 = messageDigest.digest();
        String string = HexDump.toString(byArray2);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); i += 2) {
            stringBuffer.append(string.substring(i, i + 2));
            if (i >= string.length() - 2) continue;
            stringBuffer.append(":");
        }
        return stringBuffer.toString();
    }

    public static String bubbleBabble(PublicKey publicKey) throws SSH2Exception {
        SSH2PublicKeyFile sSH2PublicKeyFile = new SSH2PublicKeyFile(publicKey, null, null);
        SSH2Signature sSH2Signature = SSH2Signature.getEncodingInstance(sSH2PublicKeyFile.getAlgorithmName());
        return SSH2KeyFingerprint.bubbleBabble(sSH2Signature.encodePublicKey(publicKey));
    }

    public static String bubbleBabble(byte[] byArray) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA1");
            messageDigest.update(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error("SSH2KeyFingerprint.bubbleBabble: " + noSuchAlgorithmException);
        }
        byte[] byArray2 = messageDigest.digest();
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[]{'b', 'c', 'd', 'f', 'g', 'h', 'k', 'l', 'm', 'n', 'p', 'r', 's', 't', 'v', 'z', 'x'};
        char[] cArray2 = new char[]{'a', 'e', 'i', 'o', 'u', 'y'};
        int n = byArray2.length / 2 + 1;
        int n2 = 1;
        stringBuffer.append('x');
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4;
            int n5;
            if (i + 1 < n || byArray2.length % 2 != 0) {
                n5 = (((byArray2[2 * i] & 0xFF) >>> 6 & 3) + n2) % 6;
                n4 = (byArray2[2 * i] & 0xFF) >>> 2 & 0xF;
                n3 = ((byArray2[2 * i] & 0xFF & 3) + n2 / 6) % 6;
                stringBuffer.append(cArray2[n5]);
                stringBuffer.append(cArray[n4]);
                stringBuffer.append(cArray2[n3]);
                if (i + 1 >= n) continue;
                int n6 = (byArray2[2 * i + 1] & 0xFF) >>> 4 & 0xF;
                int n7 = byArray2[2 * i + 1] & 0xFF & 0xF;
                stringBuffer.append(cArray[n6]);
                stringBuffer.append('-');
                stringBuffer.append(cArray[n7]);
                n2 = (n2 * 5 + ((byArray2[2 * i] & 0xFF) * 7 + (byArray2[2 * i + 1] & 0xFF))) % 36;
                continue;
            }
            n5 = n2 % 6;
            n4 = 16;
            n3 = n2 / 6;
            stringBuffer.append(cArray2[n5]);
            stringBuffer.append(cArray[n4]);
            stringBuffer.append(cArray2[n3]);
        }
        stringBuffer.append('x');
        return stringBuffer.toString();
    }
}

