/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2Connection;
import com.mindbright.ssh2.SSH2SessionChannel;
import com.mindbright.ssh2.SSH2TerminalAdapter;
import com.mindbright.sshcommon.SSHConsoleRemote;
import com.mindbright.sshcommon.TimeoutException;
import com.mindbright.terminal.TerminalWindow;
import java.io.InputStream;
import java.io.OutputStream;

public class SSH2ConsoleRemote
implements SSHConsoleRemote {
    protected SSH2Connection connection;
    protected SSH2SessionChannel session;
    protected OutputStream stdout;
    protected OutputStream stderr;

    public SSH2ConsoleRemote(SSH2Connection sSH2Connection) {
        this(sSH2Connection, null, null);
    }

    public SSH2ConsoleRemote(SSH2Connection sSH2Connection, OutputStream outputStream, OutputStream outputStream2) {
        this.connection = sSH2Connection;
        this.stdout = outputStream;
        this.stderr = outputStream2;
    }

    public boolean command(String string) {
        return this.command(string, this.stdout);
    }

    public boolean command(String string, boolean bl) {
        return this.command(string, this.stdout, bl);
    }

    public boolean command(String string, OutputStream outputStream) {
        return this.command(string, outputStream, this.stderr);
    }

    public boolean command(String string, OutputStream outputStream, boolean bl) {
        return this.command(string, outputStream, this.stderr, bl);
    }

    public boolean command(String string, OutputStream outputStream, OutputStream outputStream2) {
        return this.command(string, outputStream, outputStream2, false);
    }

    public boolean command(String string, OutputStream outputStream, OutputStream outputStream2, boolean bl) {
        return this.command(string, outputStream, outputStream2, bl, "dumb", 0, 0);
    }

    public boolean command(String string, OutputStream outputStream, OutputStream outputStream2, boolean bl, String string2, int n, int n2) {
        this.session = this.connection.newSession();
        if (this.session == null) {
            return false;
        }
        if (bl && !this.session.requestPTY(string2, n, n2, null)) {
            return false;
        }
        if (outputStream != null) {
            this.session.changeStdOut(outputStream);
        }
        if (outputStream2 != null) {
            this.session.changeStdErr(outputStream2);
        }
        return this.session.doSingleCommand(string);
    }

    public boolean shell() {
        return this.shell(false);
    }

    public boolean shell(boolean bl) {
        return this.shell(bl, "dumb", 0, 0);
    }

    public boolean shell(boolean bl, String string, int n, int n2) {
        this.session = this.connection.newSession();
        if (this.session == null) {
            return false;
        }
        if (bl && !this.session.requestPTY(string, n, n2, null)) {
            return false;
        }
        if (this.stdout != null) {
            this.session.changeStdOut(this.stdout);
        }
        if (this.stderr != null) {
            this.session.changeStdErr(this.stderr);
        }
        return this.session.doShell();
    }

    public boolean terminal(SSH2TerminalAdapter sSH2TerminalAdapter) {
        TerminalWindow terminalWindow = sSH2TerminalAdapter.getTerminal();
        this.session = this.connection.newTerminal(sSH2TerminalAdapter);
        if (this.session == null || !this.session.requestPTY(terminalWindow.terminalType(), terminalWindow.rows(), terminalWindow.cols(), null)) {
            return false;
        }
        return this.session.doShell();
    }

    public boolean commandWithTerminal(SSH2TerminalAdapter sSH2TerminalAdapter, String string) {
        TerminalWindow terminalWindow = sSH2TerminalAdapter.getTerminal();
        this.session = this.connection.newTerminal(sSH2TerminalAdapter);
        if (this.session == null || !this.session.requestPTY(terminalWindow.terminalType(), terminalWindow.rows(), terminalWindow.cols(), null)) {
            return false;
        }
        return this.session.doSingleCommand(string);
    }

    public int waitForExitStatus() {
        int n = this.session.waitForExit();
        if (this.session != null) {
            this.session.waitUntilClosed();
        }
        return n;
    }

    public int waitForExitStatus(long l) throws TimeoutException {
        int n = this.session.waitForExit(l);
        if (!this.session.isFinished()) {
            this.session.close();
            throw new TimeoutException("command did not finish after " + l + " milliseconds");
        }
        if (this.session != null) {
            this.session.waitUntilClosed();
        }
        return n;
    }

    public boolean sendBreak(int n) {
        return this.session != null ? this.session.doBreak(n) : false;
    }

    public void close() {
        this.close(false);
    }

    public void close(boolean bl) {
        if (this.session != null) {
            this.session.close();
            if (bl) {
                this.session.waitUntilClosed();
            }
        }
        this.session = null;
    }

    public void changeStdOut(OutputStream outputStream) {
        this.session.changeStdOut(outputStream);
    }

    public InputStream getStdOut() {
        return this.session.getStdOut();
    }

    public OutputStream getStdIn() {
        return this.session.getStdIn();
    }
}

