/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2AuthModule;
import com.mindbright.ssh2.SSH2DataBuffer;
import com.mindbright.ssh2.SSH2Exception;
import com.mindbright.ssh2.SSH2FatalException;
import com.mindbright.ssh2.SSH2ListUtil;
import com.mindbright.ssh2.SSH2TransportPDU;
import com.mindbright.ssh2.SSH2UserAuth;
import com.mindbright.util.Log;
import java.io.IOException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class SSH2AuthGSS
implements SSH2AuthModule,
PrivilegedAction {
    public static final String STANDARD_NAME = "gssapi-with-mic";
    private static Oid OID_KRBv5 = null;
    private String realm;
    private String kdc;
    private boolean isinit = false;
    private byte[] token = null;
    private String username;
    private SSH2UserAuth userauth;
    private SSH2FatalException saved_exc;
    private GSSContext gssctx;
    private LoginContext loginctx;
    private boolean dodispose = false;
    private String dnsfail;
    private Log log;
    static /* synthetic */ Class class$com$mindbright$ssh2$SSH2AuthGSS;

    public SSH2AuthGSS() {
        this(null, null);
    }

    public SSH2AuthGSS(String string, String string2) {
        try {
            OID_KRBv5 = new Oid("1.2.840.113554.1.2.2");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.realm = string;
        this.kdc = string2;
    }

    private static String getHostPortFromAttr(Attributes attributes) throws NamingException {
        if (attributes == null) {
            return null;
        }
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        while (namingEnumeration.hasMore()) {
            Attribute attribute = namingEnumeration.next();
            NamingEnumeration<?> namingEnumeration2 = attribute.getAll();
            while (namingEnumeration2.hasMore()) {
                String[] stringArray;
                Object obj = namingEnumeration2.next();
                if (!(obj instanceof String) || (stringArray = SSH2ListUtil.arrayFromList((String)obj, " ")) == null || stringArray.length != 4) continue;
                return stringArray[3] + ":" + stringArray[2];
            }
        }
        return null;
    }

    private static String lookupsrv(String string) throws NamingException, UnknownHostException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        hashtable.put("java.naming.authoritative", "true");
        InitialDirContext initialDirContext = new InitialDirContext(hashtable);
        String[] stringArray = new String[]{"SRV"};
        return SSH2AuthGSS.getHostPortFromAttr(initialDirContext.getAttributes(string, stringArray));
    }

    private void init() {
        Object object;
        int n;
        if (this.isinit) {
            return;
        }
        this.isinit = true;
        this.log = this.userauth.getTransport().getLog();
        if (this.realm == null) {
            this.realm = System.getProperty("java.security.krb5.realm");
        }
        if (this.realm == null && (n = ((String)(object = this.userauth.getTransport().getRemoteHostName())).indexOf(46)) != -1) {
            this.realm = ((String)object).substring(n + 1);
        }
        if (this.realm != null && this.kdc == null) {
            object = "_kerberos._udp." + this.realm;
            try {
                this.kdc = SSH2AuthGSS.lookupsrv((String)object);
            }
            catch (Throwable throwable) {
                this.dnsfail = object;
                throwable.printStackTrace();
            }
        }
        if (this.realm != null && this.kdc != null) {
            try {
                System.setProperty("java.security.krb5.realm", this.realm.toUpperCase());
                System.setProperty("java.security.krb5.kdc", this.kdc.toUpperCase());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        try {
            object = (class$com$mindbright$ssh2$SSH2AuthGSS == null ? (class$com$mindbright$ssh2$SSH2AuthGSS = SSH2AuthGSS.class$("com.mindbright.ssh2.SSH2AuthGSS")) : class$com$mindbright$ssh2$SSH2AuthGSS).getClassLoader().getResource("defaults/jaas.conf");
            System.setProperty("java.security.auth.login.config", ((URL)object).toExternalForm());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public String getStandardName() {
        return STANDARD_NAME;
    }

    public Object run() {
        try {
            Object object;
            Object object2;
            if (this.dodispose) {
                this.gssctx.dispose();
                this.dodispose = false;
                return null;
            }
            if (this.gssctx == null) {
                object2 = GSSManager.getInstance();
                object = System.getProperty("java.security.krb5.realm");
                if (object != null && !((String)object).equals("")) {
                    object = "@" + ((String)object).toUpperCase();
                }
                GSSName gSSName = ((GSSManager)object2).createName(this.userauth.user + (String)(object != null ? object : ""), null);
                GSSName gSSName2 = ((GSSManager)object2).createName("host/" + this.userauth.getTransport().getRemoteHostName() + (String)(object != null ? object : ""), null);
                GSSCredential gSSCredential = ((GSSManager)object2).createCredential(gSSName, 0, OID_KRBv5, 1);
                this.gssctx = ((GSSManager)object2).createContext(gSSName2, OID_KRBv5, gSSCredential, 0);
                this.gssctx.requestInteg(true);
                this.gssctx.requestCredDeleg(true);
                this.gssctx.requestMutualAuth(true);
                this.gssctx.requestReplayDet(false);
                this.gssctx.requestSequenceDet(false);
            }
            object2 = null;
            if (!this.gssctx.isEstablished()) {
                if (this.token == null) {
                    this.token = new byte[0];
                }
                this.token = this.gssctx.initSecContext(this.token, 0, this.token.length);
                if (this.token != null) {
                    object2 = SSH2TransportPDU.createOutgoingPacket(61);
                    ((SSH2DataBuffer)object2).writeString(this.token);
                    if (!this.gssctx.isEstablished()) {
                        return object2;
                    }
                    this.userauth.getTransport().transmit((SSH2TransportPDU)object2);
                } else if (!this.gssctx.isEstablished()) {
                    this.gssctx.dispose();
                    this.gssctx = null;
                    this.loginctx = null;
                    this.saved_exc = new SSH2FatalException("GSS API authentication - failed to initialize token");
                    return null;
                }
            }
            if (!this.gssctx.getIntegState()) {
                object2 = SSH2TransportPDU.createOutgoingPacket(63);
            } else {
                object = new SSH2DataBuffer(128);
                ((SSH2DataBuffer)object).writeRaw(this.userauth.getTransport().getSessionId());
                ((SSH2DataBuffer)object).writeByte(50);
                ((SSH2DataBuffer)object).writeString(this.userauth.user);
                ((SSH2DataBuffer)object).writeString("ssh-connection");
                ((SSH2DataBuffer)object).writeString(STANDARD_NAME);
                object2 = SSH2TransportPDU.createOutgoingPacket(66);
                ((SSH2DataBuffer)object2).writeString(this.gssctx.getMIC(((SSH2DataBuffer)object).getData(), 0, ((SSH2DataBuffer)object).getWPos(), new MessageProp(0, true)));
            }
            this.gssctx.dispose();
            this.gssctx = null;
            this.loginctx = null;
            return object2;
        }
        catch (GSSException gSSException) {
            gSSException.printStackTrace();
            String string = "failed to initialize GSS context";
            if (this.dnsfail != null) {
                string = string + "\nThis could be because DNS lookup failed for " + this.dnsfail;
            }
            this.saved_exc = new SSH2FatalException(string);
            if (this.gssctx != null) {
                try {
                    this.gssctx.dispose();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.gssctx = null;
            this.loginctx = null;
            return null;
        }
    }

    public SSH2TransportPDU processMethodMessage(SSH2UserAuth sSH2UserAuth, SSH2TransportPDU sSH2TransportPDU) throws SSH2Exception {
        this.saved_exc = null;
        this.log.debug2("SSH2AuthGSS", "processMethodMessage", "processing " + sSH2TransportPDU.getType());
        switch (sSH2TransportPDU.getType()) {
            case 61: 
            case 65: {
                this.token = sSH2TransportPDU.readString();
                this.userauth = sSH2UserAuth;
                sSH2TransportPDU = (SSH2TransportPDU)Subject.doAs(this.loginctx.getSubject(), this);
                break;
            }
            case 64: {
                this.dodispose = true;
                Subject.doAs(this.loginctx.getSubject(), this);
                this.gssctx = null;
                this.loginctx = null;
                throw new SSH2FatalException("GSS API authentication failed");
            }
            case 60: {
                try {
                    byte[] byArray = sSH2TransportPDU.readString();
                    if (byArray == null || !Arrays.equals(byArray, OID_KRBv5.getDER())) {
                        throw new SSH2FatalException("GSS API authentication - received unexpected OID");
                    }
                    try {
                        this.loginctx = new LoginContext("MindTerm");
                        this.loginctx.login();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    this.userauth = sSH2UserAuth;
                    sSH2TransportPDU = (SSH2TransportPDU)Subject.doAs(this.loginctx.getSubject(), this);
                    break;
                }
                catch (SSH2FatalException sSH2FatalException) {
                    this.loginctx = null;
                    this.gssctx = null;
                    this.saved_exc = sSH2FatalException;
                    break;
                }
                catch (Throwable throwable) {
                    this.loginctx = null;
                    this.gssctx = null;
                    throwable.printStackTrace();
                    throw new SSH2FatalException("GSS API authentication - failed to initialize GSS context");
                }
            }
            default: {
                this.log.warning("SSH2AuthGSS", "received unexpected packet of type: " + sSH2TransportPDU.getType());
                sSH2TransportPDU = null;
                throw new SSH2FatalException("SSH2AuthGSS: got unexpected packet of type: " + sSH2TransportPDU.getType());
            }
        }
        if (this.saved_exc != null) {
            throw this.saved_exc;
        }
        return sSH2TransportPDU;
    }

    public SSH2TransportPDU startAuthentication(SSH2UserAuth sSH2UserAuth) throws SSH2Exception {
        try {
            this.userauth = sSH2UserAuth;
            this.init();
            this.log.debug("SSH2AuthGSS", "Starting Kerberos authentication");
            this.log.debug("SSH2AuthGSS", "  realm: " + this.realm);
            this.log.debug("SSH2AuthGSS", "    kdc: " + this.kdc);
            return this.createRequest(sSH2UserAuth);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new SSH2FatalException("SSH2AuthGSS: got exception: " + throwable);
        }
    }

    private SSH2TransportPDU createRequest(SSH2UserAuth sSH2UserAuth) throws IOException, GSSException {
        SSH2TransportPDU sSH2TransportPDU = sSH2UserAuth.createUserAuthRequest(STANDARD_NAME);
        sSH2TransportPDU.writeInt(1);
        sSH2TransportPDU.writeString(OID_KRBv5.getDER());
        return sSH2TransportPDU;
    }

    public void clearSensitiveData() {
        this.gssctx = null;
        this.loginctx = null;
        this.username = null;
    }

    public boolean retryPointless() {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

