/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.mindbright.jca.security.interfaces.RSAPublicKey;
import com.mindbright.net.ProxyAuthenticator;
import com.mindbright.net.SocksProxySocket;
import com.mindbright.net.WebProxyTunnelSocket;
import com.mindbright.ssh.SSH;
import com.mindbright.ssh.SSHAccessDeniedException;
import com.mindbright.ssh.SSHAuthenticator;
import com.mindbright.ssh.SSHClient;
import com.mindbright.ssh.SSHClientUser;
import com.mindbright.ssh.SSHInteractiveClient;
import com.mindbright.ssh.SSHInteractor;
import com.mindbright.ssh.SSHListenChannel;
import com.mindbright.ssh.SSHProtocolPlugin;
import com.mindbright.ssh.SSHRSAKeyFile;
import com.mindbright.ssh.SSHRSAPublicKeyFile;
import com.mindbright.ssh.SSHStdIO;
import com.mindbright.ssh.Version;
import com.mindbright.ssh2.SSH2Exception;
import com.mindbright.ssh2.SSH2KeyFingerprint;
import com.mindbright.ssh2.SSH2Preferences;
import com.mindbright.ssh2.SSH2PublicKeyFile;
import com.mindbright.ssh2.SSH2Signature;
import com.mindbright.terminal.TerminalDefProps;
import com.mindbright.terminal.TerminalWin;
import com.mindbright.terminal.TerminalWindow;
import com.mindbright.util.EncryptedProperties;
import com.mindbright.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;

public final class SSHPropertyHandler
implements SSHClientUser,
SSHAuthenticator,
ProxyAuthenticator {
    public static final int PROP_NAME = 0;
    public static final int PROP_VALUE = 1;
    public static final String PROPS_FILE_EXT = ".mtp";
    public static final String DEF_IDFILE = "identity";
    public static String hostKeyAlgs = "ssh-rsa,ssh-dss";
    public static String macAlgs = "hmac-md5,hmac-sha1,hmac-sha1-96,hmac-md5-96,hmac-ripemd160";
    public static String ciphAlgsSort = "aes128-ctr,aes128-cbc,aes192-ctr,aes192-cbc,aes256-ctr,aes256-cbc,blowfish-ctr,blowfish-cbc,twofish128-ctr,twofish128-cbc,twofish192-ctr,twofish192-cbc,twofish256-ctr,twofish256-cbc,cast128-cbc,3des-ctr,3des-cbc,arcfour128,arcfour256,arcfour";
    public static final Properties defaultProperties = new Properties();
    public static final Hashtable defaultPropNames = new Hashtable();
    public static final Hashtable oldPropNames = new Hashtable();
    public static final String[][] defaultPropDesc = new String[][]{{"protocol", "auto"}, {"server", null}, {"real-server", null}, {"local-bind", "127.0.0.1"}, {"port", String.valueOf(22)}, {"connect-timeout", "60"}, {"hello-timeout", "10"}, {"kex-timeout", "180"}, {"proxy-type", "none"}, {"proxy-host", null}, {"proxy-port", null}, {"proxy-user", null}, {"proxy-timeout", "30"}, {"username", null}, {"auto-username", "false"}, {"password", null}, {"tispassword", null}, {"passphrase", null}, {"proxy-password", null}, {"ssh1-cipher", SSH.getCipherName(6)}, {"auth-method", "password,kbd-interact"}, {"private-key", "identity"}, {"private-host-key", null}, {"x11-display", "127.0.0.1:0"}, {"mtu", "0"}, {"alive", "30"}, {"compression", "0"}, {"x11-forward", "false"}, {"force-pty", "true"}, {"remfwd", "false"}, {"portftp", "false"}, {"sftpbridge-host", ""}, {"sftpbridge-port", ""}, {"sftpbridge-hosttype", null}, {"socksproxy-host", ""}, {"socksproxy-port", ""}, {"strict-hostid", "false"}, {"key-timing-noise", "false"}, {"kex-algorithms", "diffie-hellman-group-exchange-sha256,diffie-hellman-group-exchange-sha1,diffie-hellman-group14-sha1,diffie-hellman-group1-sha1"}, {"server-host-key-algorithms", hostKeyAlgs}, {"enc-algorithms-cli2srv", ciphAlgsSort}, {"enc-algorithms-srv2cli", ciphAlgsSort}, {"mac-algorithms-cli2srv", macAlgs}, {"mac-algorithms-srv2cli", macAlgs}, {"comp-algorithms-cli2srv", "none"}, {"comp-algorithms-srv2cli", "none"}, {"languages-cli2srv", ""}, {"languages-srv2cli", ""}, {"package-version", "MindTerm_" + Version.version}, {"filelist-remote-command", "ls -A -L -F -1\n"}, {"fingerprint", null}, {"allow-new-server", "true"}, {"jar-path", "."}, {"module0", "com.mindbright.application.ModuleTelnet"}, {"module1", "com.mindbright.application.ModuleSFTP"}, {"module2", "com.mindbright.application.ModuleSCP"}, {"module3", "com.mindbright.application.ModuleFTPOverSFTP"}, {"module4", "com.mindbright.application.ModuleSocksProxy"}, {"module5", "com.mindbright.application.ModuleTelnetProxy"}, {"module6", "com.mindbright.application.ModuleTerminal"}, {"module0.label", "Telnet Terminal"}, {"module1.label", "SFTP File Transfer..."}, {"module2.label", "SCP File Transfer..."}, {"module3.label", "FTP To SFTP Bridge..."}, {"module4.label", "SOCKS Proxy..."}, {"module5.label", "Telnet Proxy..."}, {"module.telnet.inhibit", "false"}, {"module.telnet.havemenus", "true"}, {"module.terminal.havemenus", "true"}, {"module.scp.cwd-local", null}, {"module.sftp.cwd-local", null}};
    String sshHomeDir;
    String knownHosts = "known_hosts";
    SSHRSAKeyFile keyFile;
    SSHInteractiveClient client;
    SSHInteractor interactor;
    boolean activeProps;
    private EncryptedProperties props;
    protected String currentPropsFile;
    protected String currentAlias;
    boolean autoSaveProps;
    boolean autoLoadProps;
    boolean savePasswords;
    boolean readonly;
    private String propertyPassword;
    public Properties initTermProps;
    protected boolean propsChanged;
    boolean kludgeSrvPrompt;

    public static String backwardCompatProp(String string) {
        String string2 = (String)oldPropNames.get(string);
        if (string2 != null) {
            string = string2;
        }
        return string;
    }

    public static void setAsDefault(Properties properties) {
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            string = SSHPropertyHandler.backwardCompatProp(string);
            ((Hashtable)defaultProperties).put(string, string2);
        }
    }

    public SSHPropertyHandler(Properties properties, boolean bl) {
        if (bl) {
            SSHPropertyHandler.setAsDefault(properties);
        }
        this.setProperties(properties);
        this.activeProps = false;
        this.propsChanged = false;
    }

    public SSHPropertyHandler(SSHPropertyHandler sSHPropertyHandler) {
        this(sSHPropertyHandler.props, false);
        this.sshHomeDir = sSHPropertyHandler.sshHomeDir;
        this.keyFile = sSHPropertyHandler.keyFile;
        this.initTermProps = sSHPropertyHandler.initTermProps;
        this.propertyPassword = sSHPropertyHandler.propertyPassword;
        this.readonly = true;
    }

    public static SSHPropertyHandler fromFile(String string, String string2) throws IOException {
        SSHPropertyHandler sSHPropertyHandler = new SSHPropertyHandler(new Properties(), false);
        sSHPropertyHandler.setPropertyPassword(string2);
        sSHPropertyHandler.loadAbsoluteFile(string, false);
        SSHPropertyHandler.setAsDefault(sSHPropertyHandler.props);
        return sSHPropertyHandler;
    }

    public void setInteractor(SSHInteractor sSHInteractor) {
        this.interactor = sSHInteractor;
    }

    public void setClient(SSHInteractiveClient sSHInteractiveClient) {
        this.client = sSHInteractiveClient;
    }

    public void setAutoLoadProps(boolean bl) {
        if (this.sshHomeDir != null) {
            this.autoLoadProps = bl;
        }
    }

    public void setAutoSaveProps(boolean bl) {
        if (this.sshHomeDir != null) {
            this.autoSaveProps = bl;
        }
    }

    public void setSavePasswords(boolean bl) {
        this.savePasswords = bl;
    }

    public void setReadOnly(boolean bl) {
        this.readonly = bl;
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public void setPropertyPassword(String string) {
        if (string != null) {
            this.propertyPassword = string;
        }
    }

    public boolean emptyPropertyPassword() {
        return this.propertyPassword == null;
    }

    public boolean setSSHHomeDir(String string) {
        if (string == null || string.trim().length() == 0) {
            return true;
        }
        if (string != null && !string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        try {
            File file = new File(string.substring(0, string.length() - 1));
            if (!file.exists()) {
                ByteArrayOutputStream byteArrayOutputStream = this.readResource("/defaults/license.txt");
                if (null == byteArrayOutputStream || !this.interactor.licenseDialog(byteArrayOutputStream.toString())) {
                    return false;
                }
                if (this.interactor.askConfirmation("MindTerm home directory: '" + string + "' does not exist, create it?", true)) {
                    try {
                        file.mkdir();
                    }
                    catch (Throwable throwable) {
                        this.interactor.alert("Could not create home directory, file operations disabled.");
                        string = null;
                    }
                } else {
                    this.interactor.report("No home directory, file operations disabled.");
                    string = null;
                }
            }
        }
        catch (Throwable throwable) {
            if (this.interactor != null && this.interactor.isVerbose()) {
                this.interactor.report("Can't access local file system, file operations disabled.");
            }
            string = null;
        }
        this.sshHomeDir = string;
        if (this.sshHomeDir == null) {
            this.autoSaveProps = false;
            this.autoLoadProps = false;
        }
        if (this.interactor != null) {
            this.interactor.propsStateChanged(this);
        }
        return true;
    }

    public String getSSHHomeDir() {
        return this.sshHomeDir;
    }

    public boolean hasHomeDir() {
        return this.sshHomeDir != null;
    }

    public void resetToDefaults() {
        Object object;
        this.clearServerSetting();
        this.clearAllForwards();
        Enumeration enumeration = defaultPropNames.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            String string = defaultProperties.getProperty((String)object);
            if (string != null) {
                this.setProperty((String)object, string);
                continue;
            }
            this.props.remove(object);
        }
        object = this.getTerminal();
        if (object != null) {
            object.resetToDefaults();
        }
    }

    public static boolean isProperty(String string) {
        string = SSHPropertyHandler.backwardCompatProp(string);
        Properties properties = SSH2Preferences.getDefaultProperties();
        return defaultPropNames.containsKey(string) || string.indexOf("local") == 0 || string.indexOf("remote") == 0 || string.indexOf("module") == 0 || ((Hashtable)properties).containsKey(string) || string.startsWith("fingerprint") || string.startsWith("socketoption.");
    }

    public String getProperty(String string) {
        string = SSHPropertyHandler.backwardCompatProp(string);
        return this.props.getProperty(string);
    }

    public boolean getPropertyB(String string) {
        string = this.getProperty(string);
        return Boolean.valueOf(string);
    }

    public int getPropertyI(String string) {
        string = this.getProperty(string);
        return Integer.valueOf(string);
    }

    public String getDefaultProperty(String string) {
        string = SSHPropertyHandler.backwardCompatProp(string);
        return (String)((Hashtable)defaultProperties).get(string);
    }

    public void setDefaultProperty(String string, String string2) {
        string = SSHPropertyHandler.backwardCompatProp(string);
        ((Hashtable)defaultProperties).put(string, string2);
    }

    public void resetProperty(String string) {
        string = SSHPropertyHandler.backwardCompatProp(string);
        this.setProperty(string, this.getDefaultProperty(string));
    }

    public void eraseProperty(String string) {
        string = SSHPropertyHandler.backwardCompatProp(string);
        this.props.remove(string);
    }

    public void setProperty(String string, boolean bl) throws IllegalArgumentException, NoSuchElementException {
        this.setProperty(string, String.valueOf(bl));
    }

    public void setProperty(String string, int n) throws IllegalArgumentException, NoSuchElementException {
        this.setProperty(string, String.valueOf(n));
    }

    public void setProperty(String string, String string2) throws IllegalArgumentException, NoSuchElementException {
        if (string2 == null) {
            return;
        }
        boolean bl = !string2.equals(this.getProperty(string = SSHPropertyHandler.backwardCompatProp(string)));
        this.validateProperty(string, string2);
        if (this.activeProps) {
            this.activateProperty(string, string2);
        }
        if (bl) {
            if (this.interactor != null) {
                this.interactor.propsStateChanged(this);
            }
            this.propsChanged = bl;
        }
        ((Hashtable)this.props).put(string, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void validateProperty(String string, String string2) throws IllegalArgumentException, NoSuchElementException {
        if (string.equals("auth-method")) {
            SSH.getAuthTypes(string2);
            return;
        } else {
            if (string.equals("x11-forward") || string.equals("force-pty") || string.equals("remfwd") || string.equals("strict-hostid") || string.equals("portftp") || string.equals("key-timing-noise")) {
                if (string2.equals("true") || string2.equals("false")) return;
                throw new IllegalArgumentException("Value for " + string + " must be 'true' or 'false'");
            }
            if (string.equals("port") || string.equals("proxy-port") || string.equals("mtu") || string.equals("alive") || string.equals("compression")) {
                try {
                    int n = Integer.valueOf(string2);
                    if ((string.equals("port") || string.equals("proxy-port")) && (n > 65535 || n < 0)) {
                        throw new IllegalArgumentException("Not a valid port number: " + string2);
                    }
                    if (string.equals("mtu") && n != 0 && (n > 262144 || n < 4096)) {
                        throw new IllegalArgumentException("Mtu must be between 4k and 256k");
                    }
                    if (string.equals("alive")) {
                        if (n >= 0 && n <= 600) return;
                        throw new IllegalArgumentException("Alive interval must be 0-600");
                    }
                    if (!string.equals("compression") || n >= 0 && n <= 9) return;
                    throw new IllegalArgumentException("Compression Level must be 0-9");
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Value for " + string + " must be an integer");
                }
            } else {
                if (string.equals("server")) {
                    if (this.client == null || !this.client.isOpened()) return;
                    throw new IllegalArgumentException("Server can only be set while not connected");
                }
                if (string.equals("real-server") || string.equals("local-bind")) {
                    try {
                        InetAddress.getByName(string2);
                        return;
                    }
                    catch (UnknownHostException unknownHostException) {
                        throw new IllegalArgumentException(string + " address must be a legal/known host name");
                    }
                } else if (string.equals("proxy-type")) {
                    SSH.getProxyType(string2);
                    return;
                } else if (string.startsWith("local") || string.startsWith("remote")) {
                    try {
                        if (string2.startsWith("/general/")) {
                            string2 = string2.substring(9);
                        }
                        if (string.startsWith("local")) {
                            this.addLocalPortForward(string2, false);
                            return;
                        }
                        this.addRemotePortForward(string2, false);
                        return;
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException("Not a valid port forward: " + string + " : " + string2);
                    }
                } else {
                    if (SSHPropertyHandler.isProperty(string)) return;
                    throw new NoSuchElementException("Unknown ssh property '" + string + "'");
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void activateProperty(String string, String string2) {
        if (string.equals("remfwd")) {
            try {
                SSHListenChannel.setAllowRemoteConnect(new Boolean(string2));
                return;
            }
            catch (Throwable throwable) {}
            return;
        }
        if (string.equals("portftp")) {
            this.client.havePORTFtp = new Boolean(string2);
            if (!this.client.havePORTFtp || SSHProtocolPlugin.getPlugin("ftp") == null) return;
            SSHProtocolPlugin.getPlugin("ftp").initiate(this.client);
            return;
        }
        if (string.equals("key-timing-noise")) {
            if (!this.client.isSSH2 || this.client.termAdapter == null) return;
            if ("true".equals(string2)) {
                this.client.termAdapter.startChaff();
                return;
            } else {
                this.client.termAdapter.stopChaff();
            }
            return;
        }
        if (string.equals("alive")) {
            if (!this.client.isConnected()) return;
            this.client.setAliveInterval(Integer.parseInt(string2));
            return;
        }
        if (string.equals("real-server")) {
            try {
                if (string2 != null && string2.length() > 0) {
                    this.client.setServerRealAddr(InetAddress.getByName(string2));
                    return;
                }
                this.client.setServerRealAddr(null);
                return;
            }
            catch (UnknownHostException unknownHostException) {}
            return;
        }
        if (string.equals("local-bind")) {
            try {
                this.client.setLocalAddr(string2);
                return;
            }
            catch (UnknownHostException unknownHostException) {
                throw new IllegalArgumentException("localhost address must be a legal/known host name");
            }
        }
        if (string.startsWith("local")) {
            int n = Integer.parseInt(string.substring(5));
            if (n > this.client.localForwards.size()) {
                throw new IllegalArgumentException("Port forwards must be given in unbroken sequence");
            }
            if (string2.startsWith("/general/")) {
                string2 = string2.substring(9);
            }
            try {
                this.addLocalPortForward(string2, true);
                return;
            }
            catch (IOException iOException) {
                if (this.interactor.askConfirmation("Error setting up tunnel '" + string2 + "', continue anyway?", true)) return;
                throw new IllegalArgumentException("Error creating tunnel: " + iOException.getMessage());
            }
        }
        if (!string.startsWith("remote")) return;
        try {
            int n = Integer.parseInt(string.substring(6));
            if (n > this.client.remoteForwards.size()) {
                throw new IllegalArgumentException("Port forwards must be given in unbroken sequence");
            }
            if (string2.startsWith("/general/")) {
                string2 = string2.substring(9);
            }
            this.addRemotePortForward(string2, true);
            return;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Not a valid port forward: " + string + " : " + string2);
        }
    }

    public void setProperties(Properties properties) throws IllegalArgumentException, NoSuchElementException {
        this.props = new EncryptedProperties(defaultProperties);
        this.mergeProperties(properties);
    }

    public Properties getProperties() {
        return this.props;
    }

    public void mergeProperties(Properties properties) throws IllegalArgumentException {
        String string;
        Enumeration enumeration = defaultPropNames.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            string = properties.getProperty(string2);
            if (string == null) continue;
            string2 = SSHPropertyHandler.backwardCompatProp(string2);
            ((Hashtable)this.props).put(string2, string);
        }
        int n = 0;
        while ((string = properties.getProperty("local" + n)) != null) {
            ((Hashtable)this.props).put("local" + n, string);
            ++n;
        }
        n = 0;
        while ((string = properties.getProperty("remote" + n)) != null) {
            ((Hashtable)this.props).put("remote" + n, string);
            ++n;
        }
    }

    public Properties getInitTerminalProperties() {
        return this.initTermProps;
    }

    public void activateProperties() {
        String string;
        if (this.activeProps) {
            return;
        }
        Enumeration enumeration = defaultPropNames.keys();
        this.activeProps = true;
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            string = this.props.getProperty(string2);
            if (string == null) continue;
            this.activateProperty(string2, string);
        }
        int n = 0;
        while ((string = this.props.getProperty("local" + n)) != null) {
            this.activateProperty("local" + n, string);
            ++n;
        }
        n = 0;
        while ((string = this.props.getProperty("remote" + n)) != null) {
            this.activateProperty("remote" + n, string);
            ++n;
        }
    }

    public void passivateProperties() {
        this.activeProps = false;
    }

    private void saveProperties(String string) throws IOException {
        String string2;
        String string3;
        Object object;
        Properties properties;
        TerminalWindow terminalWindow = this.getTerminal();
        Properties properties2 = properties = terminalWindow != null ? terminalWindow.getProperties() : null;
        if (properties != null) {
            object = ((Hashtable)properties).keys();
            while (object.hasMoreElements()) {
                string3 = (String)object.nextElement();
                string2 = properties.getProperty(string3);
                ((Hashtable)this.props).put(string3, string2);
            }
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        if (this.savePasswords) {
            if (this.propertyPassword == null) {
                this.propertyPassword = "";
            }
            this.props.save(fileOutputStream, "MindTerm ssh settings", this.propertyPassword, SSH.cipherClasses[6][0]);
        } else {
            string3 = this.props.getProperty("password");
            object = this.props.getProperty("proxy-password");
            string2 = this.props.getProperty("tispassword");
            String string4 = this.props.getProperty("passphrase");
            this.clearPasswords();
            this.props.save(fileOutputStream, "MindTerm ssh settings");
            if (string3 != null) {
                ((Hashtable)this.props).put("password", string3);
            }
            if (object != null) {
                ((Hashtable)this.props).put("proxy-password", object);
            }
            if (string2 != null) {
                ((Hashtable)this.props).put("tispassword", string2);
            }
            if (string4 != null) {
                ((Hashtable)this.props).put("passphrase", string4);
            }
        }
        fileOutputStream.close();
        this.propsChanged = false;
        if (terminalWindow != null) {
            terminalWindow.setPropsChanged(false);
        }
        this.interactor.propsStateChanged(this);
    }

    private void loadProperties(String string, boolean bl) throws IOException {
        TerminalWindow terminalWindow = this.getTerminal();
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[fileInputStream.available()];
        fileInputStream.read(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        fileInputStream.close();
        EncryptedProperties encryptedProperties = new EncryptedProperties();
        try {
            encryptedProperties.load(byteArrayInputStream, "");
        }
        catch (SSHAccessDeniedException sSHAccessDeniedException) {
            try {
                byteArrayInputStream.reset();
                encryptedProperties.load(byteArrayInputStream, this.propertyPassword);
            }
            catch (SSHAccessDeniedException sSHAccessDeniedException2) {
                try {
                    if (!bl) {
                        throw new SSHAccessDeniedException("");
                    }
                    byteArrayInputStream.reset();
                    this.propertyPassword = this.interactor.promptPassword("File " + string + " password: ");
                    encryptedProperties.load(byteArrayInputStream, this.propertyPassword);
                }
                catch (SSHAccessDeniedException sSHAccessDeniedException3) {
                    this.clearServerSetting();
                    throw new SSHClient.AuthFailException("Access denied for '" + string + "'");
                }
            }
        }
        this.savePasswords = !encryptedProperties.isNormalPropsFile();
        Properties properties = new Properties();
        Properties properties2 = new Properties();
        Enumeration enumeration = ((Hashtable)encryptedProperties).keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = encryptedProperties.getProperty(string2);
            if (SSHPropertyHandler.isProperty(string2)) {
                string2 = SSHPropertyHandler.backwardCompatProp(string2);
                ((Hashtable)properties).put(string2, string3);
                continue;
            }
            if (TerminalWin.isProperty(string2)) {
                string2 = TerminalDefProps.backwardCompatProp(string2);
                ((Hashtable)properties2).put(string2, string3);
                continue;
            }
            if (this.interactor != null) {
                this.interactor.report("Unknown property '" + string2 + "' found in file: " + string);
                continue;
            }
            System.out.println("Unknown property '" + string2 + "' found in file: " + string);
        }
        if (this.client != null) {
            this.client.clearAllForwards();
        }
        this.passivateProperties();
        this.setProperties(properties);
        this.initTermProps = properties2;
        if (terminalWindow != null) {
            terminalWindow.setProperties(this.initTermProps, false);
            terminalWindow.setPropsChanged(false);
        }
        this.propsChanged = false;
        if (this.interactor != null) {
            this.interactor.propsStateChanged(this);
        }
    }

    final void clearPasswords() {
        this.props.remove("password");
        this.props.remove("tispassword");
        this.props.remove("passphrase");
        this.props.remove("proxy-password");
    }

    final void clearServerSetting() {
        this.setProperty("server", "");
        this.currentPropsFile = null;
        this.currentAlias = null;
        if (this.interactor != null) {
            this.interactor.propsStateChanged(this);
        }
    }

    final void clearAllForwards() {
        String string;
        int n = 0;
        if (this.client != null) {
            this.client.clearAllForwards();
        }
        for (n = 0; n < 1024 && ((Hashtable)this.props).containsKey(string = "local" + n); ++n) {
            this.props.remove(string);
        }
        for (n = 0; n < 1024 && ((Hashtable)this.props).containsKey(string = "remote" + n); ++n) {
            this.props.remove(string);
        }
    }

    public boolean wantSave() {
        boolean bl = this.propsChanged || this.getTerminal() != null && this.getTerminal().getPropsChanged();
        return !this.isReadOnly() && bl && this.sshHomeDir != null;
    }

    public final void checkSave() throws IOException {
        if (this.autoSaveProps) {
            this.saveCurrentFile();
        }
    }

    public void saveCurrentFile() throws IOException {
        if (this.currentPropsFile != null && this.wantSave()) {
            this.saveProperties(this.currentPropsFile);
        }
    }

    public void saveAsCurrentFile(String string) throws IOException {
        this.propsChanged = true;
        this.currentPropsFile = string;
        this.saveCurrentFile();
        this.currentAlias = null;
    }

    public void loadAbsoluteFile(String string, boolean bl) throws IOException {
        this.currentAlias = null;
        this.currentPropsFile = string;
        this.loadProperties(this.currentPropsFile, bl);
        if (this.interactor != null) {
            this.interactor.propsStateChanged(this);
        }
    }

    public void setAlias(String string) {
        if (this.sshHomeDir == null) {
            return;
        }
        this.currentAlias = string;
        this.currentPropsFile = this.sshHomeDir + string + PROPS_FILE_EXT;
    }

    public String getAlias() {
        return this.currentAlias;
    }

    public void loadAliasFile(String string, boolean bl) throws IOException {
        String string2 = this.currentAlias;
        this.setAlias(string);
        if (string2 == null || !string2.equals(string)) {
            this.loadProperties(this.currentPropsFile, bl);
        }
    }

    public String[] availableAliases() {
        int n;
        if (this.sshHomeDir == null) {
            return null;
        }
        File file = new File(this.sshHomeDir.substring(0, this.sshHomeDir.length() - 1));
        int n2 = 0;
        String[] stringArray = file.list();
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].endsWith(PROPS_FILE_EXT)) continue;
            stringArray[n] = null;
            ++n2;
        }
        if (n2 == stringArray.length) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length - n2];
        n2 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] == null) continue;
            int n3 = stringArray[n].lastIndexOf(PROPS_FILE_EXT);
            stringArray2[n2++] = stringArray[n].substring(0, n3);
        }
        return stringArray2;
    }

    public boolean isAlias(String string) {
        String[] stringArray = this.availableAliases();
        boolean bl = false;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean isAbsolutFile(String string) {
        if (this.sshHomeDir == null) {
            return false;
        }
        File file = new File(string);
        return file.isFile() && file.exists();
    }

    public TerminalWindow getTerminal() {
        if (this.client == null || this.client.console == null) {
            return null;
        }
        TerminalWindow terminalWindow = this.client.console.getTerminal();
        return terminalWindow;
    }

    public void removeLocalTunnelAt(int n, boolean bl) {
        int n2 = this.client.localForwards.size();
        this.props.remove("local" + n);
        for (int i = n; i < n2 - 1; ++i) {
            ((Hashtable)this.props).put("local" + i, ((Hashtable)this.props).get("local" + (i + 1)));
            this.props.remove("local" + (i + 1));
        }
        this.propsChanged = true;
        if (bl) {
            SSHClient.LocalForward localForward = (SSHClient.LocalForward)this.client.localForwards.elementAt(n);
            this.client.delLocalPortForward(localForward.localHost, localForward.localPort);
        } else {
            this.client.localForwards.removeElementAt(n);
        }
    }

    public void removeRemoteTunnelAt(int n) {
        int n2 = this.client.remoteForwards.size();
        this.props.remove("remote" + n);
        for (int i = n; i < n2 - 1; ++i) {
            ((Hashtable)this.props).put("remote" + i, ((Hashtable)this.props).get("remote" + (i + 1)));
            this.props.remove("remote" + (i + 1));
        }
        this.propsChanged = true;
        if (this.client.isSSH2) {
            SSHClient.RemoteForward remoteForward = (SSHClient.RemoteForward)this.client.remoteForwards.elementAt(n);
            if (remoteForward != null) {
                this.client.delRemotePortForward(remoteForward.remoteHost, remoteForward.remotePort);
            }
        } else {
            this.client.remoteForwards.removeElementAt(n);
        }
    }

    public void addLocalPortForward(String string, boolean bl) throws IllegalArgumentException, IOException {
        Object[] objectArray = Util.parseForwardSpec(string, this.client.getLocalAddr().getHostAddress());
        if (bl) {
            this.client.addLocalPortForward((String)objectArray[1], (Integer)objectArray[2], (String)objectArray[3], (Integer)objectArray[4], (String)objectArray[0]);
        }
    }

    public void addRemotePortForward(String string, boolean bl) throws IllegalArgumentException {
        Object[] objectArray = Util.parseForwardSpec(string, this.client.getLocalAddr().getHostAddress());
        if (bl) {
            this.client.addRemotePortForward((String)objectArray[1], (Integer)objectArray[2], (String)objectArray[3], (Integer)objectArray[4], (String)objectArray[0]);
        }
    }

    public String getUsername(SSHClientUser sSHClientUser) throws IOException {
        String string = this.getProperty("username");
        if (this.interactor == null) {
            return string;
        }
        if (this.kludgeSrvPrompt || !this.interactor.quietPrompts() || string == null || string.equals("")) {
            String string2 = null;
            while (string2 == null) {
                string2 = this.interactor.promptLine(this.getProperty("server") + " login: ", string);
            }
            if (!string2.equals(string)) {
                this.clearPasswords();
                string = string2;
            }
            this.setProperty("username", string);
        }
        return string;
    }

    public String getPassword(SSHClientUser sSHClientUser) throws IOException {
        String string = this.getProperty("password");
        if (string == null) {
            string = this.interactor.promptPassword(this.getProperty("username") + "@" + this.getProperty("server") + "'s password: ");
            this.setProperty("password", string);
        }
        return string;
    }

    public String getChallengeResponse(SSHClientUser sSHClientUser, String string) throws IOException {
        String string2 = this.getProperty("tispassword");
        if (string2 == null) {
            string2 = this.interactor.promptPassword(string);
            this.setProperty("tispassword", string2);
        }
        return string2;
    }

    public int[] getAuthTypes(SSHClientUser sSHClientUser) {
        return SSH.getAuthTypes(this.getProperty("auth-method"));
    }

    public int getCipher(SSHClientUser sSHClientUser) {
        int n = SSH.getCipherType(this.getProperty("ssh1-cipher"));
        if (n == 8) {
            this.interactor.report("Cipher '" + this.getProperty("ssh1-cipher") + "' not supported in ssh1, using default");
            this.resetProperty("ssh1-cipher");
        }
        return SSH.getCipherType(this.getProperty("ssh1-cipher"));
    }

    public SSHRSAKeyFile getIdentityFile(SSHClientUser sSHClientUser) throws IOException {
        String string = this.getProperty("private-key");
        if (string.indexOf(File.separator) == -1) {
            string = this.sshHomeDir + string;
        }
        this.keyFile = new SSHRSAKeyFile(string);
        return this.keyFile;
    }

    public String getIdentityPassword(SSHClientUser sSHClientUser) throws IOException {
        String string = this.getProperty("passphrase");
        if (string == null) {
            string = this.interactor.promptPassword("key file '" + this.keyFile.getComment() + "' password: ");
            this.setProperty("passphrase", string);
        }
        return string;
    }

    public String getIdentityPassword(String string) throws IOException {
        String string2 = this.getProperty("passphrase");
        if (string2 == null) {
            string2 = this.interactor.promptPassword(string);
            this.setProperty("passphrase", string2);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyKnownHosts(RSAPublicKey rSAPublicKey) throws IOException {
        block46: {
            Object object;
            File file;
            String string = null;
            InputStream inputStream = null;
            int n = 0;
            boolean bl = true;
            boolean bl2 = this.strictHostKeyCheck();
            byte[] byArray = rSAPublicKey.getModulus().toByteArray();
            byte[] byArray2 = rSAPublicKey.getPublicExponent().toByteArray();
            int n2 = byArray[0] == 0 ? 1 : 0;
            int n3 = byArray2[0] == 0 ? 1 : 0;
            byte[] byArray3 = new byte[byArray.length + byArray2.length - n2 - n3];
            System.arraycopy(byArray, n2, byArray3, 0, byArray.length - n2);
            System.arraycopy(byArray2, n3, byArray3, byArray.length - n2, byArray2.length - n3);
            this.showFingerprint(byArray3, "rsa1");
            SSHRSAPublicKeyFile sSHRSAPublicKeyFile = null;
            inputStream = this.getClass().getResourceAsStream("/defaults/known_hosts.txt");
            boolean bl3 = true;
            while (bl3) {
                if (inputStream != null) {
                    string = "<resource>/defaults/known_hosts.txt";
                    if (this.interactor.isVerbose()) {
                        this.interactor.report("Found preinstalled 'known_hosts' file.");
                    }
                } else {
                    bl3 = false;
                    if (this.sshHomeDir == null && !bl2) {
                        if (this.interactor.isVerbose()) {
                            this.interactor.report("File operations disabled, server identity can't be verified");
                        }
                        boolean bl4 = true;
                        return bl4;
                    }
                    string = this.sshHomeDir + this.knownHosts;
                    file = new File(string);
                    if (!file.exists()) {
                        if (this.interactor.askConfirmation("File '" + string + "' not found, create it?", true)) {
                            object = new FileOutputStream(file);
                            ((FileOutputStream)object).close();
                        } else if (!bl2) {
                            this.interactor.report("Verification of server key disabled in this session.");
                            boolean bl5 = true;
                            return bl5;
                        }
                    }
                    inputStream = new FileInputStream(string);
                }
                if ((n = (sSHRSAPublicKeyFile = new SSHRSAPublicKeyFile(inputStream, string, true)).checkPublic(rSAPublicKey.getModulus(), this.getProperty("server"))) == 0) {
                    boolean bl6 = true;
                    return bl6;
                }
                if (bl3 && !this.interactor.askConfirmation("Host was not found in preinstalled 'known_hosts' file! Continue anyway?", false)) {
                    boolean bl7 = false;
                    return bl7;
                }
                inputStream = null;
            }
            if (bl2) {
                this.strictHostFailed();
                boolean bl8 = false;
                return bl8;
            }
            if (n == 1) {
                if (!this.askSaveKeyConfirmation(string)) {
                    boolean bl9 = true;
                    return bl9;
                }
                bl = true;
            } else {
                bl = this.askChangeKeyConfirmation();
                sSHRSAPublicKeyFile.removePublic(this.getProperty("server"));
            }
            if (bl) {
                sSHRSAPublicKeyFile.addPublic(this.getProperty("server"), null, rSAPublicKey.getPublicExponent(), rSAPublicKey.getModulus());
                file = new File(string + ".tmp");
                object = new File(string);
                ((File)object).renameTo(file);
                try {
                    sSHRSAPublicKeyFile.saveToFile(string);
                }
                catch (IOException iOException) {
                    object = new File(string);
                    file.renameTo((File)object);
                    throw iOException;
                }
                file.delete();
                break block46;
            }
            boolean bl10 = false;
            return bl10;
            finally {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    public boolean verifyKnownSSH2Hosts(SSHInteractiveClient sSHInteractiveClient, SSH2Signature sSH2Signature) throws IOException, SSH2Exception {
        Object object;
        String string = null;
        boolean bl = this.strictHostKeyCheck();
        if (!bl && this.sshHomeDir == null) {
            if (this.interactor.isVerbose()) {
                this.interactor.report("File operations disabled, server identity can't be verified");
            }
            return true;
        }
        string = this.sshHomeDir + "hostkeys";
        File file = new File(string);
        if (!bl && !file.exists() && this.interactor.askConfirmation("Known hosts directory: '" + string + "' does not exist, create it?", true)) {
            try {
                file.mkdir();
            }
            catch (Throwable throwable) {
                this.interactor.alert("Could not create known hosts directory.");
            }
        }
        if (!(bl || file.exists() && file.isDirectory())) {
            return this.interactor.askConfirmation("No hostkeys directory, can't verify host, continue anyway?", false);
        }
        file = new File(string = string + File.separator + "key_" + this.getProperty("port") + "_" + this.getProperty("server") + ".pub");
        if (!file.exists()) {
            if (bl) {
                this.strictHostFailed();
                return false;
            }
            if (!this.askSaveKeyConfirmation(string)) {
                return true;
            }
        } else {
            object = new SSH2PublicKeyFile();
            ((SSH2PublicKeyFile)object).load(string);
            if (((SSH2PublicKeyFile)object).sameAs(sSH2Signature.getPublicKey())) {
                return true;
            }
            if (!this.askChangeKeyConfirmation()) {
                return false;
            }
            file.delete();
        }
        if ((object = this.getProperty("username")) == null) {
            object = SSH.VER_MINDTERM;
        }
        SSH2PublicKeyFile sSH2PublicKeyFile = new SSH2PublicKeyFile(sSH2Signature.getPublicKey(), (String)object, "\"host key for " + this.getProperty("server") + ", accepted by " + (String)object + " " + new Date() + "\"");
        sSH2PublicKeyFile.store(string);
        return true;
    }

    boolean strictHostKeyCheck() {
        return this.getPropertyB("strict-hostid");
    }

    void strictHostFailed() {
        this.interactor.report("Strict host key checking enabled, please add host key.");
    }

    boolean hasKeyTimingNoise() {
        return this.getPropertyB("key-timing-noise");
    }

    boolean askSaveKeyConfirmation(String string) {
        if (this.interactor.isVerbose()) {
            this.interactor.report("Host key not found in '" + string + "'");
        }
        if (!this.interactor.askConfirmation("Do you want to add this host to your set of known hosts (check fingerprint)", true)) {
            this.interactor.report("Verification of server key disabled in this session.");
            return false;
        }
        return true;
    }

    boolean askChangeKeyConfirmation() {
        this.interactor.alert("WARNING: HOST IDENTIFICATION HAS CHANGED! IT IS POSSIBLE THAT SOMEONE IS DOING SOMETHING NASTY, ONLY PROCEED IF YOU KNOW WHAT YOU ARE DOING!");
        return this.interactor.askConfirmation("Do you want to replace the identification of this host?", false);
    }

    void showFingerprint(byte[] byArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\r\nServer's hostkey (" + string + ") fingerprint:\r\n");
        stringBuffer.append("openssh md5:  ");
        stringBuffer.append(SSH2KeyFingerprint.md5Hex(byArray));
        stringBuffer.append("\r\nbubblebabble: ");
        stringBuffer.append(SSH2KeyFingerprint.bubbleBabble(byArray));
        this.interactor.report(stringBuffer.toString());
    }

    public String getProxyUsername(String string, String string2) throws IOException {
        String string3 = this.getProperty("proxy-user");
        if (!this.interactor.quietPrompts() || string3 == null || string3.equals("")) {
            String string4 = string2 != null ? " '" + string2 + "'" : "";
            String string5 = null;
            while (string5 == null) {
                string5 = this.interactor.promptLine(string + string4 + " username: ", string3);
            }
            string3 = string5;
            this.setProperty("proxy-user", string3);
        }
        return string3;
    }

    public String getProxyPassword(String string, String string2) throws IOException {
        String string3 = this.getProperty("proxy-password");
        if (string3 == null) {
            String string4 = string2 != null ? " '" + string2 + "'" : "";
            string3 = this.interactor.promptPassword(string + string4 + " password: ");
            this.setProperty("proxy-password", string3);
        }
        return string3;
    }

    public String getSrvHost() throws IOException {
        String string = this.getProperty("server");
        this.kludgeSrvPrompt = false;
        if (!this.interactor.quietPrompts() || string == null || string.equals("")) {
            TerminalWindow terminalWindow;
            if (this.currentAlias != null) {
                string = this.currentAlias;
            }
            if ((terminalWindow = this.getTerminal()) != null) {
                terminalWindow.clearLine();
            }
            while ((string = this.interactor.promptLine("\rSSH Server/Alias: ", string)) == null) {
            }
            if ("".equals(string = string.trim())) {
                throw new SSHStdIO.SSHExternalMessage("");
            }
            this.client.hideLogo();
            String string2 = string;
            int n = Util.getPort(string, 22);
            string = Util.getHost(string);
            if (n != 22) {
                this.setProperty("port", String.valueOf(n));
                string2 = string + "_" + n;
            }
            if (this.autoLoadProps) {
                if (this.isAlias(string2)) {
                    this.loadAliasFile(string2, true);
                } else if (this.isAbsolutFile(string2)) {
                    this.loadAbsoluteFile(string2, true);
                } else if (this.sshHomeDir != null) {
                    String string3 = "";
                    try {
                        do {
                            String string4 = null;
                            while (string4 == null) {
                                string4 = this.interactor.promptLine("No settings file for " + string + " found.\n\r" + "(^C = cancel, ^D or empty = don't save)\n\r" + "Save as alias : ", string2);
                            }
                            string2 = string4;
                            if ((string2 = string2.trim()).length() <= 0 || !this.savePasswords || (string3 = this.interactor.promptPassword(string2 + " file password: ")).length() <= 0) continue;
                            this.propertyPassword = this.interactor.promptPassword(string2 + " password again: ");
                        } while (!string3.equals("") && !string3.equals(this.propertyPassword));
                    }
                    catch (SSHStdIO.SSHExternalMessage sSHExternalMessage) {
                        if (sSHExternalMessage.ctrlC) {
                            throw sSHExternalMessage;
                        }
                        string2 = "";
                    }
                    string2 = string2.trim();
                    this.setProperty("server", string);
                    if (string2.length() == 0) {
                        if (terminalWindow != null) {
                            terminalWindow.clearLine();
                        }
                        this.interactor.report("\rNo alias set, disabled automatic saving (use 'Save Settings As...' to save)");
                    } else {
                        this.setAlias(string2);
                    }
                    this.clearPasswords();
                    this.clearAllForwards();
                    this.propsChanged = true;
                }
                string = this.getProperty("server");
            } else {
                this.setProperty("server", string);
            }
            this.kludgeSrvPrompt = true;
        } else {
            this.interactor.report("");
            this.client.hideLogo();
        }
        this.activateProperties();
        if (this.currentPropsFile != null) {
            this.interactor.report("Current settings file: '" + this.currentPropsFile + "'");
        }
        return string;
    }

    public int getSrvPort() {
        return this.getPropertyI("port");
    }

    public Socket getProxyConnection() throws IOException {
        String string = this.getProperty("proxy-type");
        int n = 0;
        try {
            n = SSH.getProxyType(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.getMessage());
        }
        if (n == 0) {
            return null;
        }
        String string2 = this.getProperty("proxy-host");
        int n2 = -1;
        try {
            n2 = Integer.valueOf(this.getProperty("proxy-port"));
        }
        catch (Exception exception) {
            n2 = -1;
        }
        if (string2 == null || n2 == -1) {
            throw new IOException("When 'proxytype' is set, 'proxyhost' and 'proxyport' must also be set");
        }
        String string3 = this.getProperty("server");
        int n3 = this.getSrvPort();
        String string4 = this.getProperty("proxyproto");
        Socket socket = null;
        long l = this.getPropertyI("proxy-timeout") * 1000;
        if (SSH.DEBUG) {
            System.out.println("Connecting to " + string + " proxy " + string2 + ":" + n2);
        }
        switch (n) {
            case 1: {
                socket = WebProxyTunnelSocket.getProxy(string3, n3, string2, n2, l, string4, this, "MindTerm/" + Version.version);
                break;
            }
            case 2: {
                socket = SocksProxySocket.getSocks4Proxy(string3, n3, string2, n2, l, this.getProxyUsername("SOCKS4", null));
                break;
            }
            case 3: {
                socket = SocksProxySocket.getSocks5Proxy(string3, n3, string2, n2, l, false, this);
                break;
            }
            case 4: {
                socket = SocksProxySocket.getSocks5Proxy(string3, n3, string2, n2, l, true, this);
            }
        }
        return socket;
    }

    public ByteArrayOutputStream readResource(String string) {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        ByteArrayOutputStream byteArrayOutputStream = null;
        if (inputStream != null) {
            byteArrayOutputStream = new ByteArrayOutputStream(50000);
            try {
                int n;
                while ((n = inputStream.read()) >= 0) {
                    byteArrayOutputStream.write(n);
                }
            }
            catch (IOException iOException) {
                System.err.println("ERROR reading resource " + string + " : " + iOException);
            }
        }
        return byteArrayOutputStream;
    }

    public String getDisplay() {
        return this.getProperty("display");
    }

    public int getMaxPacketSz() {
        return this.getPropertyI("mtu");
    }

    public int getAliveInterval() {
        return this.getPropertyI("alive");
    }

    public int getCompressionLevel() {
        return this.getPropertyI("compression");
    }

    public boolean wantX11Forward() {
        return this.getPropertyB("x11-forward");
    }

    public boolean wantPTY() {
        return this.getPropertyB("force-pty");
    }

    public SSHInteractor getInteractor() {
        return this.interactor;
    }

    static {
        for (int i = 0; i < defaultPropDesc.length; ++i) {
            String string = defaultPropDesc[i][0];
            String string2 = defaultPropDesc[i][1];
            if (string2 != null) {
                ((Hashtable)defaultProperties).put(string, string2);
            }
            defaultPropNames.put(string, "");
        }
        oldPropNames.put("realsrv", "real-server");
        oldPropNames.put("localhst", "local-bind");
        oldPropNames.put("usrname", "username");
        oldPropNames.put("passwd", "password");
        oldPropNames.put("rsapassword", "passphrase");
        oldPropNames.put("proxytype", "proxy-type");
        oldPropNames.put("proxyhost", "proxy-host");
        oldPropNames.put("proxyport", "proxy-port");
        oldPropNames.put("proxyuser", "proxy-user");
        oldPropNames.put("prxpassword", "proxy-password");
        oldPropNames.put("cipher", "ssh1-cipher");
        oldPropNames.put("authtyp", "auth-method");
        oldPropNames.put("idfile", "private-key");
        oldPropNames.put("x11fwd", "x11-forward");
        oldPropNames.put("forcpty", "force-pty");
        oldPropNames.put("stricthostid", "strict-hostid");
        oldPropNames.put("display", "x11-display");
    }
}

