/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.mindbright.ssh.SSHAuthenticator;
import com.mindbright.ssh.SSHChannelController;
import com.mindbright.ssh.SSHCipher;
import com.mindbright.ssh.SSHClient;
import com.mindbright.ssh.SSHClientUser;
import com.mindbright.ssh.SSHClientUserAdaptor;
import com.mindbright.ssh.SSHConsole;
import com.mindbright.ssh.SSHInteractor;
import com.mindbright.sshcommon.SSHConsoleRemote;
import com.mindbright.sshcommon.TimeoutException;
import com.mindbright.terminal.TerminalWindow;
import com.mindbright.util.InputStreamPipe;
import com.mindbright.util.OutputStreamPipe;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class SSHConsoleClient
extends SSHClientUserAdaptor
implements SSHConsole,
SSHConsoleRemote {
    public static final int DEFAULT_COPY_BUFFER_SZ = 16384;
    protected SSHClient client;
    protected SSHClientUser proxyUser;
    protected String sshHost;
    protected InputStreamPipe inTop;
    protected OutputStreamPipe inBottom;
    protected OutputStream stdout;
    protected TerminalOutStream stdin;
    protected OutputStream stderr;

    public SSHConsoleClient(String string, int n, SSHAuthenticator sSHAuthenticator, SSHInteractor sSHInteractor) throws IOException {
        this(string, n, sSHAuthenticator, sSHInteractor, 16384);
    }

    public SSHConsoleClient(String string, int n, SSHAuthenticator sSHAuthenticator, SSHInteractor sSHInteractor, int n2) throws IOException {
        super(string, n);
        this.interactor = sSHInteractor;
        this.client = new SSHClient(sSHAuthenticator, this);
        this.inTop = new InputStreamPipe(n2);
        this.inBottom = new OutputStreamPipe(this.inTop);
        this.stdin = new TerminalOutStream();
        this.sshHost = string;
        this.stdout = this.inBottom;
        this.client.setConsole(this);
        this.client.activateTunnels = false;
    }

    public boolean command(String string) {
        try {
            this.client.doSingleCommand(string, true, 0L);
        }
        catch (IOException iOException) {
            if (this.interactor != null) {
                this.interactor.alert("Error connecting: " + iOException.getMessage());
            }
            return false;
        }
        return true;
    }

    public int command(String string, long l) throws TimeoutException, IOException {
        try {
            this.client.doSingleCommand(string, false, l);
            Integer n = this.client.getExitStatus();
            if (n != null) {
                return n;
            }
            throw new TimeoutException("command did not finish after " + l + " milliseconds");
        }
        catch (IOException iOException) {
            if (this.interactor != null) {
                this.interactor.alert("Error connecting: " + iOException.getMessage());
            }
            throw iOException;
        }
    }

    public boolean shell() {
        try {
            this.client.bootSSH(false, false);
        }
        catch (IOException iOException) {
            if (this.interactor != null) {
                this.interactor.alert("Error connecting: " + iOException.getMessage());
            }
            return false;
        }
        return true;
    }

    public void close() {
        this.close(false);
    }

    public void close(boolean bl) {
        this.interactor = null;
        this.client.forcedDisconnect();
        try {
            this.stdout.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void changeStdOut(OutputStream outputStream) {
        this.stdout = outputStream;
        this.inBottom = null;
        this.inTop = null;
    }

    public void changeStdErr(OutputStream outputStream) {
        this.stderr = outputStream;
    }

    public OutputStream getStdIn() {
        return this.stdin;
    }

    public InputStream getStdOut() {
        return this.inTop;
    }

    public void setClientUser(SSHClientUser sSHClientUser) {
        this.proxyUser = sSHClientUser;
    }

    public void stdoutWriteString(byte[] byArray) {
        block4: {
            try {
                this.stdout.write(byArray);
            }
            catch (IOException iOException) {
                try {
                    this.stdout.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                if (this.interactor == null) break block4;
                this.interactor.alert("Error writing data to stdout-pipe");
            }
        }
    }

    public void stderrWriteString(byte[] byArray) {
        block7: {
            if (this.stderr != null) {
                try {
                    this.stderr.write(byArray);
                }
                catch (IOException iOException) {
                    try {
                        this.stderr.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    if (this.interactor != null) {
                        this.interactor.alert("Error writing data to stderr-pipe");
                    }
                    break block7;
                }
            }
            if (this.interactor != null) {
                this.interactor.alert("Remote warning/error: " + new String(byArray));
            }
        }
    }

    public TerminalWindow getTerminal() {
        return null;
    }

    public void print(String string) {
    }

    public void println(String string) {
    }

    public void serverConnect(SSHChannelController sSHChannelController, SSHCipher sSHCipher) {
    }

    public void serverDisconnect(String string) {
        try {
            this.stdout.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean wantPTY() {
        return false;
    }

    public Socket getProxyConnection() throws IOException {
        if (this.proxyUser != null) {
            return this.proxyUser.getProxyConnection();
        }
        return null;
    }

    final class TerminalOutStream
    extends OutputStream {
        TerminalOutStream() {
        }

        public void write(int n) throws IOException {
            byte[] byArray = new byte[]{(byte)n};
            SSHConsoleClient.this.client.stdinWriteString(byArray);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            SSHConsoleClient.this.client.stdinWriteString(byArray, n, n2);
        }
    }
}

