/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.jca.security.KeyFactory;
import com.mindbright.jca.security.PublicKey;
import com.mindbright.jca.security.interfaces.RSAPublicKey;
import com.mindbright.jca.security.spec.RSAPublicKeySpec;
import com.mindbright.ssh2.am;
import com.mindbright.ssh2.bc;
import com.mindbright.ssh2.bz;
import com.mindbright.ssh2.r;
import java.math.BigInteger;

public final class SSH2RSA
extends am {
    public static final String SSH2_KEY_FORMAT = "ssh-rsa";

    public SSH2RSA() {
        super("SHA1withRSA", SSH2_KEY_FORMAT);
    }

    public byte[] encodePublicKey(PublicKey publicKey) throws bz {
        r r2 = new r(8192);
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new bc("SSH2RSA, invalid public key type: " + publicKey);
        }
        RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
        r2.a(SSH2_KEY_FORMAT);
        r2.a(rSAPublicKey.getPublicExponent());
        r2.a(rSAPublicKey.getModulus());
        return r2.a();
    }

    public PublicKey decodePublicKey(byte[] byArray) throws bz {
        r r2 = new r(byArray.length);
        r2.a(byArray);
        String string = r2.a();
        if (!string.equals(SSH2_KEY_FORMAT)) {
            throw new bc("SSH2RSA, keyblob type mismatch, got '" + string + ", (execpted + '" + SSH2_KEY_FORMAT + "')");
        }
        BigInteger bigInteger = r2.b();
        BigInteger bigInteger2 = r2.b();
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger2, bigInteger);
            return keyFactory.generatePublic(rSAPublicKeySpec);
        }
        catch (Exception exception) {
            throw new bc("SSH2RSA, error decoding public key blob: " + exception);
        }
    }
}

