/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.jca.security.KeyFactory;
import com.mindbright.jca.security.KeyPair;
import com.mindbright.jca.security.KeyPairGenerator;
import com.mindbright.jca.security.MessageDigest;
import com.mindbright.jce.crypto.KeyAgreement;
import com.mindbright.jce.crypto.interfaces.DHPrivateKey;
import com.mindbright.jce.crypto.interfaces.DHPublicKey;
import com.mindbright.jce.crypto.spec.DHParameterSpec;
import com.mindbright.jce.crypto.spec.DHPublicKeySpec;
import com.mindbright.security.publickey.ModPGroups;
import com.mindbright.ssh2.af;
import com.mindbright.ssh2.ag;
import com.mindbright.ssh2.ai;
import com.mindbright.ssh2.au;
import com.mindbright.ssh2.bc;
import com.mindbright.ssh2.bz;
import com.mindbright.ssh2.r;
import java.math.BigInteger;

public class SSH2KEXDHGroup1SHA1
extends au {
    public static final BigInteger group1P = ModPGroups.oakleyGroup2P;
    public static final BigInteger group1G = ModPGroups.oakleyGroup2G;
    protected ag transport;
    protected DHPublicKey dhPublicKey;
    protected DHPrivateKey dhPrivateKey;
    protected byte[] serverHostKey;
    protected BigInteger serverF;
    protected BigInteger clientE;
    protected byte[] sharedSecret_K;
    protected byte[] exchangeHash_H;
    protected MessageDigest sha1;

    public void init(ag ag2) throws bz {
        this.transport = ag2;
        this.sha1 = this.createHash();
        DHParameterSpec dHParameterSpec = new DHParameterSpec(group1P, group1G);
        this.generateDHKeyPair(dHParameterSpec);
        if (!ag2.a()) {
            this.sendDHINIT(30);
        }
    }

    public void processKEXMethodPDU(af af2) throws bz {
        if (af2.d() == 31) {
            if (this.transport.a()) {
                throw new ai("Unexpected KEXDH_REPLY");
            }
            this.serverHostKey = af2.c();
            this.serverF = af2.b();
            byte[] byArray = af2.c();
            DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(this.serverF, group1P, group1G);
            this.computeSharedSecret_K(dHPublicKeySpec);
            this.computeExchangeHash_H();
            this.transport.a(this.serverHostKey, byArray, this.exchangeHash_H);
            this.transport.a();
        } else if (af2.d() == 30) {
            // empty if block
        }
    }

    public MessageDigest getExchangeHashAlgorithm() {
        this.sha1.reset();
        return this.sha1;
    }

    public byte[] getSharedSecret_K() {
        r r2 = new r(1024);
        r2.b(this.sharedSecret_K);
        return r2.a();
    }

    public byte[] getExchangeHash_H() {
        return this.exchangeHash_H;
    }

    public String getHostKeyAlgorithms() {
        return "ssh-dss,ssh-rsa";
    }

    protected void computeExchangeHash_H() {
        r r2 = new r(65536);
        if (this.transport.a()) {
            this.serverF = this.dhPublicKey.getY();
        } else {
            this.clientE = this.dhPublicKey.getY();
        }
        r2.a(this.transport.c());
        r2.a(this.transport.b());
        r2.c(this.transport.a().b(), this.transport.a().f(), this.transport.a().c());
        r2.c(this.transport.b().b(), this.transport.b().f(), this.transport.b().c());
        r2.b(this.serverHostKey);
        r2.a(this.clientE);
        r2.a(this.serverF);
        r2.b(this.sharedSecret_K);
        this.sha1.reset();
        this.sha1.update(r2.b(), 0, r2.b());
        this.exchangeHash_H = this.sha1.digest();
        this.transport.a().a("SSH2KEXDHGroup1SHA1", "computeExchangeHash_H", "E: ", this.clientE.toByteArray());
        this.transport.a().a("SSH2KEXDHGroup1SHA1", "computeExchangeHash_H", "F: ", this.serverF.toByteArray());
        this.transport.a().a("SSH2KEXDHGroup1SHA1", "computeExchangeHash_H", "K: ", this.sharedSecret_K);
        this.transport.a().a("SSH2KEXDHGroup1SHA1", "computeExchangeHash_H", "Hash over: ", r2.b(), 0, r2.b());
        this.transport.a().a("SSH2KEXDHGroup1SHA1", "computeExchangeHash_H", "H: ", this.exchangeHash_H);
    }

    protected void computeSharedSecret_K(DHPublicKeySpec dHPublicKeySpec) throws bz {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("DH");
            KeyAgreement keyAgreement = KeyAgreement.getInstance("DH");
            DHPublicKey dHPublicKey = (DHPublicKey)keyFactory.generatePublic(dHPublicKeySpec);
            keyAgreement.init(this.dhPrivateKey);
            keyAgreement.doPhase(dHPublicKey, true);
            this.sharedSecret_K = keyAgreement.generateSecret();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new bc("Error computing shared secret: " + exception);
        }
    }

    protected void sendDHINIT(int n2) throws bz {
        af af2 = af.c(n2);
        af2.a(this.dhPublicKey.getY());
        this.transport.c(af2);
    }

    protected MessageDigest createHash() throws bz {
        try {
            return MessageDigest.getInstance("SHA1");
        }
        catch (Exception exception) {
            throw new ai("SHA1 not implemented", exception);
        }
    }

    protected void generateDHKeyPair(DHParameterSpec dHParameterSpec) throws bz {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DH");
            keyPairGenerator.initialize(dHParameterSpec, this.transport.a());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            this.dhPrivateKey = (DHPrivateKey)keyPair.getPrivate();
            this.dhPublicKey = (DHPublicKey)keyPair.getPublic();
        }
        catch (Exception exception) {
            throw new bc("Error generating DiffieHellman keys: " + exception);
        }
    }
}

