/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.jca.security.KeyFactory;
import com.mindbright.jca.security.PublicKey;
import com.mindbright.jca.security.interfaces.DSAParams;
import com.mindbright.jca.security.interfaces.DSAPublicKey;
import com.mindbright.jca.security.spec.DSAPublicKeySpec;
import com.mindbright.ssh2.am;
import com.mindbright.ssh2.bc;
import com.mindbright.ssh2.bz;
import com.mindbright.ssh2.r;
import java.math.BigInteger;

public final class SSH2DSS
extends am {
    public static final String SSH2_KEY_FORMAT = "ssh-dss";

    public SSH2DSS() {
        super("SHA1withRawDSA", SSH2_KEY_FORMAT);
    }

    public byte[] encodePublicKey(PublicKey publicKey) throws bz {
        r r2 = new r(8192);
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new bc("SSH2DSS, invalid public key type: " + publicKey);
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
        DSAParams dSAParams = dSAPublicKey.getParams();
        r2.a(SSH2_KEY_FORMAT);
        r2.a(dSAParams.getP());
        r2.a(dSAParams.getQ());
        r2.a(dSAParams.getG());
        r2.a(dSAPublicKey.getY());
        return r2.a();
    }

    public PublicKey decodePublicKey(byte[] byArray) throws bz {
        r r2 = new r(byArray.length);
        r2.a(byArray);
        String string = r2.a();
        if (!string.equals(SSH2_KEY_FORMAT)) {
            throw new bc("SSH2DSS, keyblob type mismatch, got '" + string + ", (execpted + '" + SSH2_KEY_FORMAT + "')");
        }
        BigInteger bigInteger = r2.b();
        BigInteger bigInteger2 = r2.b();
        BigInteger bigInteger3 = r2.b();
        BigInteger bigInteger4 = r2.b();
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(bigInteger4, bigInteger, bigInteger2, bigInteger3);
            return keyFactory.generatePublic(dSAPublicKeySpec);
        }
        catch (Exception exception) {
            throw new bc("SSH2DSS, error decoding public key blob: " + exception);
        }
    }
}

