/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.publickey;

import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.jca.security.SignatureException;
import com.mindbright.security.publickey.BaseSignature;
import com.mindbright.security.publickey.RSAAlgorithm;
import com.mindbright.security.publickey.RSAKey;
import com.mindbright.security.publickey.RSAPrivateCrtKey;
import com.mindbright.security.publickey.RSAPrivateKey;
import com.mindbright.security.publickey.RSAPublicKey;
import java.math.BigInteger;

public abstract class RSAWithAny
extends BaseSignature {
    private static final byte[] c = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
    private static final byte[] d = new byte[]{48, 33, 48, 9, 6, 5, 43, 36, 3, 2, 1, 5, 0, 4, 20};
    private static final byte[] e = new byte[]{48, 32, 48, 12, 6, 8, 42, -122, 72, -122, -9, 13, 2, 5, 5, 0, 4, 16};
    private static final byte[] b = new byte[]{48, 32, 48, 12, 6, 8, 42, -122, 72, -122, -9, 13, 2, 2, 5, 0, 4, 16};
    private byte[] a;

    protected RSAWithAny(String string) {
        super(string);
        if (string.equals("SHA") || string.equals("SHA1")) {
            this.a = c;
        } else if (string.equals("MD5")) {
            this.a = e;
        } else if (string.equals("MD2")) {
            this.a = b;
        } else if (string.equals("RIPEMD160")) {
            this.a = d;
        } else {
            throw new Error("Non supported digest algorithm: " + string);
        }
    }

    protected void initVerify() throws InvalidKeyException {
        if (this.publicKey == null || !(this.publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Wrong key for RSAWithAny verify: " + this.publicKey);
        }
    }

    protected void initSign() throws InvalidKeyException {
        if (this.privateKey == null || !(this.privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Wrong key for RSAWithAny sign: " + this.privateKey);
        }
    }

    protected byte[] sign(byte[] byArray) throws SignatureException {
        Object object;
        byte[] byArray2 = new byte[byArray.length + this.a.length];
        System.arraycopy(this.a, 0, byArray2, 0, this.a.length);
        System.arraycopy(byArray, 0, byArray2, this.a.length, byArray.length);
        byArray = byArray2;
        BigInteger bigInteger = new BigInteger(1, byArray);
        int n2 = (((RSAPrivateKey)this.privateKey).getModulus().bitLength() + 7) / 8;
        bigInteger = RSAAlgorithm.addPKCS1Pad(bigInteger, 1, n2, this.getRandom());
        BigInteger bigInteger2 = null;
        if (this.privateKey instanceof RSAPrivateCrtKey) {
            object = (RSAPrivateCrtKey)this.privateKey;
            BigInteger bigInteger3 = ((RSAPrivateCrtKey)object).getPrimeP();
            BigInteger bigInteger4 = ((RSAPrivateCrtKey)object).getPrimeQ();
            BigInteger bigInteger5 = ((RSAPrivateCrtKey)object).getPrimeExponentP();
            BigInteger bigInteger6 = ((RSAPrivateCrtKey)object).getPrimeExponentQ();
            BigInteger bigInteger7 = ((RSAPrivateCrtKey)object).getCrtCoefficient();
            bigInteger2 = RSAAlgorithm.doPrivateCrt(bigInteger, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7);
        } else {
            object = (RSAPrivateKey)this.privateKey;
            BigInteger bigInteger8 = ((RSAPrivateKey)object).getPrivateExponent();
            BigInteger bigInteger9 = ((RSAKey)object).getModulus();
            bigInteger2 = RSAAlgorithm.doPrivate(bigInteger, bigInteger9, bigInteger8);
        }
        object = RSAWithAny.a(bigInteger2, n2);
        return object;
    }

    protected boolean verify(byte[] byArray, byte[] byArray2) throws SignatureException {
        RSAPublicKey rSAPublicKey = (RSAPublicKey)this.publicKey;
        BigInteger bigInteger = rSAPublicKey.getPublicExponent();
        BigInteger bigInteger2 = rSAPublicKey.getModulus();
        BigInteger bigInteger3 = new BigInteger(1, byArray);
        bigInteger3 = RSAAlgorithm.doPublic(bigInteger3, bigInteger2, bigInteger);
        byArray = (bigInteger3 = RSAAlgorithm.stripPKCS1Pad(bigInteger3, 1)).toByteArray();
        if (byArray2.length != byArray.length - this.a.length) {
            return false;
        }
        byte[] byArray3 = this.a;
        int n2 = 0;
        int n3 = 0;
        while (n2 < byArray.length) {
            if (n2 == this.a.length) {
                byArray3 = byArray2;
                n3 = 0;
            }
            if (byArray[n2] != byArray3[n3]) {
                return false;
            }
            ++n2;
            ++n3;
        }
        return true;
    }

    private static byte[] a(BigInteger bigInteger, int n2) {
        byte[] byArray = bigInteger.toByteArray();
        byte[] byArray2 = null;
        if (byArray.length > n2) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, byArray.length - n2, byArray2, 0, n2);
        } else if (byArray.length < n2) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, n2 - byArray.length, byArray.length);
        } else {
            byArray2 = byArray;
        }
        return byArray2;
    }
}

