/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.publickey;

import com.mindbright.jca.security.SecureRandom;
import com.mindbright.jca.security.spec.DSAParameterSpec;
import com.mindbright.util.k;
import java.math.BigInteger;

public final class DSAAlgorithm {
    private static final BigInteger a = BigInteger.valueOf(1L);

    public static byte[] sign(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, byte[] byArray) {
        BigInteger bigInteger5 = new BigInteger(1, byArray);
        bigInteger5 = bigInteger5.mod(bigInteger3);
        BigInteger bigInteger6 = bigInteger4.modPow(bigInteger, bigInteger2).mod(bigInteger3);
        BigInteger bigInteger7 = bigInteger.modInverse(bigInteger3).multiply(bigInteger5.add(bigInteger.multiply(bigInteger6))).mod(bigInteger3);
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2 * 2];
        byte[] byArray3 = DSAAlgorithm.a(bigInteger6, n2);
        System.arraycopy(byArray3, 0, byArray2, 0, n2);
        byArray3 = DSAAlgorithm.a(bigInteger7, n2);
        System.arraycopy(byArray3, 0, byArray2, n2, n2);
        return byArray2;
    }

    public static boolean verify(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length / 2;
        byte[] byArray3 = new byte[n2];
        byte[] byArray4 = new byte[n2];
        System.arraycopy(byArray, 0, byArray3, 0, n2);
        System.arraycopy(byArray, n2, byArray4, 0, n2);
        BigInteger bigInteger5 = new BigInteger(1, byArray2);
        BigInteger bigInteger6 = new BigInteger(1, byArray3);
        BigInteger bigInteger7 = new BigInteger(1, byArray4);
        bigInteger5 = bigInteger5.mod(bigInteger3);
        BigInteger bigInteger8 = bigInteger7.modInverse(bigInteger3);
        BigInteger bigInteger9 = bigInteger5.multiply(bigInteger8).mod(bigInteger3);
        BigInteger bigInteger10 = bigInteger6.multiply(bigInteger8).mod(bigInteger3);
        BigInteger bigInteger11 = bigInteger4.modPow(bigInteger9, bigInteger2).multiply(bigInteger.modPow(bigInteger10, bigInteger2)).mod(bigInteger2).mod(bigInteger3);
        return bigInteger11.compareTo(bigInteger6) == 0;
    }

    private static byte[] a(BigInteger bigInteger, int n2) {
        byte[] byArray = bigInteger.toByteArray();
        byte[] byArray2 = null;
        if (byArray.length > n2) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, byArray.length - n2, byArray2, 0, n2);
        } else if (byArray.length < n2) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, n2 - byArray.length, byArray.length);
        } else {
            byArray2 = byArray;
        }
        return byArray2;
    }

    public static DSAParameterSpec generateParams(int n2, int n3, SecureRandom secureRandom) {
        BigInteger[] bigIntegerArray = k.a(n2, n3, secureRandom);
        BigInteger bigInteger = k.a(bigIntegerArray[1], bigIntegerArray[0], secureRandom);
        return new DSAParameterSpec(bigIntegerArray[0], bigIntegerArray[1], bigInteger);
    }

    public static BigInteger generatePrivateKey(BigInteger bigInteger, SecureRandom secureRandom) {
        BigInteger bigInteger2;
        while ((bigInteger2 = new BigInteger(bigInteger.bitLength(), secureRandom)).compareTo(a) < 0 || bigInteger2.compareTo(bigInteger) > 0) {
        }
        return bigInteger2;
    }

    public static BigInteger generatePublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return bigInteger.modPow(bigInteger3, bigInteger2);
    }
}

