/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.publickey;

import com.mindbright.jca.security.InvalidAlgorithmParameterException;
import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.jca.security.Key;
import com.mindbright.jca.security.NoSuchAlgorithmException;
import com.mindbright.jca.security.SecureRandom;
import com.mindbright.jca.security.spec.AlgorithmParameterSpec;
import com.mindbright.jce.crypto.KeyAgreementSpi;
import com.mindbright.jce.crypto.SecretKey;
import com.mindbright.jce.crypto.ShortBufferException;
import com.mindbright.security.publickey.DHPrivateKey;
import com.mindbright.security.publickey.DHPublicKey;
import com.mindbright.security.publickey.DiffieHellman;
import java.math.BigInteger;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class DHKeyAgreement
extends KeyAgreementSpi {
    private DHPrivateKey a;
    private SecureRandom a;
    private BigInteger a;
    private boolean a;

    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof DHPrivateKey)) {
            throw new InvalidKeyException("DHKeyAgreement got: " + key);
        }
        this.a = (DHPrivateKey)key;
        this.a = secureRandom;
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("DHKeyAgreement params not supported: " + algorithmParameterSpec);
    }

    protected Key engineDoPhase(Key key, boolean bl2) throws InvalidKeyException, IllegalStateException {
        if (!(key instanceof DHPublicKey)) {
            throw new InvalidKeyException("Invalid key: " + key);
        }
        this.a = bl2;
        BigInteger bigInteger = ((DHPublicKey)key).getY();
        this.a = DiffieHellman.computeKey(this.a.getX(), bigInteger, this.a.getP());
        return new DHPublicKey(this.a, this.a.getP(), this.a.getG());
    }

    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (!this.a) {
            throw new IllegalStateException("DHKeyAgreement not final");
        }
        byte[] byArray = this.a.toByteArray();
        this.a = false;
        this.a = null;
        return byArray;
    }

    protected int engineGenerateSecret(byte[] byArray, int n2) throws IllegalStateException, ShortBufferException {
        byte[] byArray2 = this.engineGenerateSecret();
        if (byArray2.length > byArray.length - n2) {
            throw new ShortBufferException("DHKeyAgreement, buffer too small");
        }
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        return byArray2.length;
    }

    protected SecretKey engineGenerateSecret(String string) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        throw new Error("DHKeyAgreement.engineGenerateSecret(String) not implemented");
    }
}

