/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.mac;

import com.mindbright.jca.security.DigestException;
import com.mindbright.jca.security.InvalidAlgorithmParameterException;
import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.jca.security.Key;
import com.mindbright.jca.security.MessageDigest;
import com.mindbright.jca.security.spec.AlgorithmParameterSpec;
import com.mindbright.jce.crypto.MacSpi;
import com.mindbright.jce.crypto.spec.SecretKeySpec;

public class HMAC
extends MacSpi {
    protected int macLength;
    protected int hashLength;
    protected int blockSize;
    protected byte[] k_ipad;
    protected byte[] k_opad;
    protected byte[] innerHash;
    protected byte[] outerHash;
    protected MessageDigest inner;
    protected MessageDigest outer;
    protected MessageDigest innerClone;
    protected MessageDigest outerClone;

    protected HMAC(String string) {
        try {
            this.inner = MessageDigest.getInstance(string);
            this.outer = MessageDigest.getInstance(string);
        }
        catch (Exception exception) {
            throw new Error("Error in HMAC: " + exception);
        }
        this.macLength = this.inner.getDigestLength();
        this.blockSize = 64;
        this.hashLength = this.macLength;
        this.innerHash = new byte[this.hashLength];
        this.outerHash = new byte[this.hashLength];
        this.k_ipad = new byte[this.blockSize];
        this.k_opad = new byte[this.blockSize];
    }

    private final void a(byte[] byArray) {
        this.inner.reset();
        this.outer.reset();
        int n2 = byArray.length;
        if (n2 > this.blockSize) {
            this.inner.update(byArray);
            byArray = this.inner.digest();
            this.inner.reset();
            n2 = this.blockSize;
        }
        System.arraycopy(byArray, 0, this.k_ipad, 0, n2);
        System.arraycopy(byArray, 0, this.k_opad, 0, n2);
        int n3 = 0;
        while (n3 < this.blockSize) {
            int n4 = n3;
            this.k_ipad[n4] = (byte)(this.k_ipad[n4] ^ 0x36);
            int n5 = n3++;
            this.k_opad[n5] = (byte)(this.k_opad[n5] ^ 0x5C);
        }
        this.a();
        if (this.inner instanceof Cloneable) {
            try {
                this.innerClone = (MessageDigest)this.inner.clone();
                this.outerClone = (MessageDigest)this.outer.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                this.innerClone = null;
                this.outerClone = null;
            }
        }
    }

    protected final byte[] engineDoFinal() {
        try {
            this.inner.digest(this.innerHash, 0, this.hashLength);
            this.outer.update(this.innerHash, 0, this.hashLength);
            this.outer.digest(this.outerHash, 0, this.hashLength);
        }
        catch (DigestException digestException) {
            throw new Error("Error/bug in HMAC, buffer too short");
        }
        byte[] byArray = new byte[this.macLength];
        System.arraycopy(this.outerHash, 0, byArray, 0, this.macLength);
        this.a();
        return byArray;
    }

    protected final int engineGetMacLength() {
        return this.macLength;
    }

    protected final void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.a(((SecretKeySpec)key).getEncoded());
    }

    protected final void engineReset() {
        this.a();
    }

    protected final void engineUpdate(byte by2) {
        this.engineUpdate(new byte[]{by2}, 0, 1);
    }

    protected final void engineUpdate(byte[] byArray, int n2, int n3) {
        this.inner.update(byArray, n2, n3);
    }

    private final void a() {
        if (this.innerClone != null) {
            try {
                this.inner = (MessageDigest)this.innerClone.clone();
                this.outer = (MessageDigest)this.outerClone.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                this.innerClone = null;
                this.outerClone = null;
                this.a();
            }
        } else {
            this.inner.reset();
            this.outer.reset();
            this.inner.update(this.k_ipad);
            this.outer.update(this.k_opad);
        }
    }
}

