/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.cipher;

import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.security.cipher.BlockCipher;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class Rijndael
extends BlockCipher {
    private int[][] a;
    private int[][] b;
    private int d;
    private static final int[] f;
    private static final int[] c;
    private static final byte[] c;
    private static final byte[] f;
    private static final int[] j;
    private static final int[] l;
    private static final int[] a;
    private static final int[] e;
    private static final int[] h;
    private static final int[] d;
    private static final int[] n;
    private static final int[] k;
    private static final int[] g;
    private static final int[] i;
    private static final int[] m;
    private static final int[] b;
    private static final byte[] e;

    public int getBlockSize() {
        return 16;
    }

    public synchronized void initializeKey(byte[] byArray) throws InvalidKeyException {
        int n2;
        if (byArray == null) {
            throw new InvalidKeyException("Empty key");
        }
        if (byArray.length != 16 && byArray.length != 24 && byArray.length != 32) {
            throw new InvalidKeyException("Incorrect key length");
        }
        this.d = Rijndael.getRounds(byArray.length, 16);
        this.a = new int[this.d + 1][4];
        this.b = new int[this.d + 1][4];
        int n3 = (this.d + 1) * 4;
        int n4 = byArray.length / 4;
        int[] nArray = new int[n4];
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4) {
            nArray[n5++] = (byArray[n6++] & 0xFF) << 24 | (byArray[n6++] & 0xFF) << 16 | (byArray[n6++] & 0xFF) << 8 | byArray[n6++] & 0xFF;
        }
        int n7 = 0;
        for (n6 = 0; n6 < n4 && n7 < n3; ++n6, ++n7) {
            this.a[n7 / 4][n7 % 4] = nArray[n6];
            this.b[this.d - n7 / 4][n7 % 4] = nArray[n6];
        }
        int n8 = 0;
        while (n7 < n3) {
            n2 = nArray[n4 - 1];
            nArray[0] = nArray[0] ^ ((c[n2 >>> 16 & 0xFF] & 0xFF) << 24 ^ (c[n2 >>> 8 & 0xFF] & 0xFF) << 16 ^ (c[n2 & 0xFF] & 0xFF) << 8 ^ c[n2 >>> 24 & 0xFF] & 0xFF ^ (e[n8++] & 0xFF) << 24);
            if (n4 != 8) {
                n5 = 1;
                n6 = 0;
                while (n5 < n4) {
                    int n9 = n5++;
                    nArray[n9] = nArray[n9] ^ nArray[n6++];
                }
            } else {
                n5 = 1;
                n6 = 0;
                while (n5 < n4 / 2) {
                    int n10 = n5++;
                    nArray[n10] = nArray[n10] ^ nArray[n6++];
                }
                n2 = nArray[n4 / 2 - 1];
                int n11 = n4 / 2;
                nArray[n11] = nArray[n11] ^ (c[n2 & 0xFF] & 0xFF ^ (c[n2 >>> 8 & 0xFF] & 0xFF) << 8 ^ (c[n2 >>> 16 & 0xFF] & 0xFF) << 16 ^ (c[n2 >>> 24 & 0xFF] & 0xFF) << 24);
                n6 = n4 / 2;
                n5 = n6 + 1;
                while (n5 < n4) {
                    int n12 = n5++;
                    nArray[n12] = nArray[n12] ^ nArray[n6++];
                }
            }
            for (n6 = 0; n6 < n4 && n7 < n3; ++n6, ++n7) {
                this.a[n7 / 4][n7 % 4] = nArray[n6];
                this.b[this.d - n7 / 4][n7 % 4] = nArray[n6];
            }
        }
        for (int i2 = 1; i2 < this.d; ++i2) {
            for (n6 = 0; n6 < 4; ++n6) {
                n2 = this.b[i2][n6];
                this.b[i2][n6] = g[n2 >>> 24 & 0xFF] ^ i[n2 >>> 16 & 0xFF] ^ m[n2 >>> 8 & 0xFF] ^ b[n2 & 0xFF];
            }
        }
    }

    public void blockEncrypt(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4;
        int[] nArray = this.a[0];
        int n5 = ((byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF) ^ nArray[0];
        int n6 = ((byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF) ^ nArray[1];
        int n7 = ((byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF) ^ nArray[2];
        int n8 = ((byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF) ^ nArray[3];
        for (n4 = 1; n4 < this.d; ++n4) {
            nArray = this.a[n4];
            int n9 = j[n5 >>> 24 & 0xFF] ^ l[n6 >>> 16 & 0xFF] ^ a[n7 >>> 8 & 0xFF] ^ e[n8 & 0xFF] ^ nArray[0];
            int n10 = j[n6 >>> 24 & 0xFF] ^ l[n7 >>> 16 & 0xFF] ^ a[n8 >>> 8 & 0xFF] ^ e[n5 & 0xFF] ^ nArray[1];
            int n11 = j[n7 >>> 24 & 0xFF] ^ l[n8 >>> 16 & 0xFF] ^ a[n5 >>> 8 & 0xFF] ^ e[n6 & 0xFF] ^ nArray[2];
            int n12 = j[n8 >>> 24 & 0xFF] ^ l[n5 >>> 16 & 0xFF] ^ a[n6 >>> 8 & 0xFF] ^ e[n7 & 0xFF] ^ nArray[3];
            n5 = n9;
            n6 = n10;
            n7 = n11;
            n8 = n12;
        }
        nArray = this.a[this.d];
        n4 = nArray[0];
        byArray2[n3 + 0] = (byte)(c[n5 >>> 24 & 0xFF] ^ n4 >>> 24);
        byArray2[n3 + 1] = (byte)(c[n6 >>> 16 & 0xFF] ^ n4 >>> 16);
        byArray2[n3 + 2] = (byte)(c[n7 >>> 8 & 0xFF] ^ n4 >>> 8);
        byArray2[n3 + 3] = (byte)(c[n8 & 0xFF] ^ n4);
        n4 = nArray[1];
        byArray2[n3 + 4] = (byte)(c[n6 >>> 24 & 0xFF] ^ n4 >>> 24);
        byArray2[n3 + 5] = (byte)(c[n7 >>> 16 & 0xFF] ^ n4 >>> 16);
        byArray2[n3 + 6] = (byte)(c[n8 >>> 8 & 0xFF] ^ n4 >>> 8);
        byArray2[n3 + 7] = (byte)(c[n5 & 0xFF] ^ n4);
        n4 = nArray[2];
        byArray2[n3 + 8] = (byte)(c[n7 >>> 24 & 0xFF] ^ n4 >>> 24);
        byArray2[n3 + 9] = (byte)(c[n8 >>> 16 & 0xFF] ^ n4 >>> 16);
        byArray2[n3 + 10] = (byte)(c[n5 >>> 8 & 0xFF] ^ n4 >>> 8);
        byArray2[n3 + 11] = (byte)(c[n6 & 0xFF] ^ n4);
        n4 = nArray[3];
        byArray2[n3 + 12] = (byte)(c[n8 >>> 24 & 0xFF] ^ n4 >>> 24);
        byArray2[n3 + 13] = (byte)(c[n5 >>> 16 & 0xFF] ^ n4 >>> 16);
        byArray2[n3 + 14] = (byte)(c[n6 >>> 8 & 0xFF] ^ n4 >>> 8);
        byArray2[n3 + 15] = (byte)(c[n7 & 0xFF] ^ n4);
    }

    public void blockDecrypt(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4;
        int[] nArray = this.b[0];
        int n5 = ((byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF) ^ nArray[0];
        int n6 = ((byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF) ^ nArray[1];
        int n7 = ((byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF) ^ nArray[2];
        int n8 = ((byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF) ^ nArray[3];
        for (n4 = 1; n4 < this.d; ++n4) {
            nArray = this.b[n4];
            int n9 = h[n5 >>> 24 & 0xFF] ^ d[n8 >>> 16 & 0xFF] ^ n[n7 >>> 8 & 0xFF] ^ k[n6 & 0xFF] ^ nArray[0];
            int n10 = h[n6 >>> 24 & 0xFF] ^ d[n5 >>> 16 & 0xFF] ^ n[n8 >>> 8 & 0xFF] ^ k[n7 & 0xFF] ^ nArray[1];
            int n11 = h[n7 >>> 24 & 0xFF] ^ d[n6 >>> 16 & 0xFF] ^ n[n5 >>> 8 & 0xFF] ^ k[n8 & 0xFF] ^ nArray[2];
            int n12 = h[n8 >>> 24 & 0xFF] ^ d[n7 >>> 16 & 0xFF] ^ n[n6 >>> 8 & 0xFF] ^ k[n5 & 0xFF] ^ nArray[3];
            n5 = n9;
            n6 = n10;
            n7 = n11;
            n8 = n12;
        }
        nArray = this.b[this.d];
        n4 = nArray[0];
        byArray2[n3 + 0] = (byte)(f[n5 >>> 24 & 0xFF] ^ n4 >>> 24);
        byArray2[n3 + 1] = (byte)(f[n8 >>> 16 & 0xFF] ^ n4 >>> 16);
        byArray2[n3 + 2] = (byte)(f[n7 >>> 8 & 0xFF] ^ n4 >>> 8);
        byArray2[n3 + 3] = (byte)(f[n6 & 0xFF] ^ n4);
        n4 = nArray[1];
        byArray2[n3 + 4] = (byte)(f[n6 >>> 24 & 0xFF] ^ n4 >>> 24);
        byArray2[n3 + 5] = (byte)(f[n5 >>> 16 & 0xFF] ^ n4 >>> 16);
        byArray2[n3 + 6] = (byte)(f[n8 >>> 8 & 0xFF] ^ n4 >>> 8);
        byArray2[n3 + 7] = (byte)(f[n7 & 0xFF] ^ n4);
        n4 = nArray[2];
        byArray2[n3 + 8] = (byte)(f[n7 >>> 24 & 0xFF] ^ n4 >>> 24);
        byArray2[n3 + 9] = (byte)(f[n6 >>> 16 & 0xFF] ^ n4 >>> 16);
        byArray2[n3 + 10] = (byte)(f[n5 >>> 8 & 0xFF] ^ n4 >>> 8);
        byArray2[n3 + 11] = (byte)(f[n8 & 0xFF] ^ n4);
        n4 = nArray[3];
        byArray2[n3 + 12] = (byte)(f[n8 >>> 24 & 0xFF] ^ n4 >>> 24);
        byArray2[n3 + 13] = (byte)(f[n7 >>> 16 & 0xFF] ^ n4 >>> 16);
        byArray2[n3 + 14] = (byte)(f[n6 >>> 8 & 0xFF] ^ n4 >>> 8);
        byArray2[n3 + 15] = (byte)(f[n5 & 0xFF] ^ n4);
    }

    public static int getRounds(int n2, int n3) {
        switch (n2) {
            case 16: {
                return n3 == 16 ? 10 : (n3 == 24 ? 12 : 14);
            }
            case 24: {
                return n3 != 32 ? 12 : 14;
            }
        }
        return 14;
    }

    private static final int a(int n2, int n3) {
        return n2 != 0 && n3 != 0 ? f[(c[n2 & 0xFF] + c[n3 & 0xFF]) % 255] : 0;
    }

    private static final int a(int n2, byte[] byArray) {
        if (n2 == 0) {
            return 0;
        }
        n2 = c[n2 & 0xFF];
        int n3 = byArray[0] != 0 ? f[(n2 + c[byArray[0] & 0xFF]) % 255] & 0xFF : 0;
        int n4 = byArray[1] != 0 ? f[(n2 + c[byArray[1] & 0xFF]) % 255] & 0xFF : 0;
        int n5 = byArray[2] != 0 ? f[(n2 + c[byArray[2] & 0xFF]) % 255] & 0xFF : 0;
        int n6 = byArray[3] != 0 ? f[(n2 + c[byArray[3] & 0xFF]) % 255] & 0xFF : 0;
        return n3 << 24 | n4 << 16 | n5 << 8 | n6;
    }

    static {
        int n2;
        int n3;
        f = new int[256];
        c = new int[256];
        c = new byte[256];
        f = new byte[256];
        j = new int[256];
        l = new int[256];
        a = new int[256];
        e = new int[256];
        h = new int[256];
        d = new int[256];
        n = new int[256];
        k = new int[256];
        g = new int[256];
        i = new int[256];
        m = new int[256];
        b = new int[256];
        e = new byte[30];
        int n4 = 283;
        int n5 = 0;
        Rijndael.f[0] = 1;
        for (n3 = 1; n3 < 256; ++n3) {
            n5 = f[n3 - 1] << 1 ^ f[n3 - 1];
            if ((n5 & 0x100) != 0) {
                n5 ^= n4;
            }
            Rijndael.f[n3] = n5;
        }
        for (n3 = 1; n3 < 255; ++n3) {
            Rijndael.c[Rijndael.f[n3]] = n3;
        }
        byte[][] byArrayArray = new byte[][]{{1, 1, 1, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0, 0}, {0, 0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 1, 1, 1}, {1, 0, 0, 0, 1, 1, 1, 1}, {1, 1, 0, 0, 0, 1, 1, 1}, {1, 1, 1, 0, 0, 0, 1, 1}, {1, 1, 1, 1, 0, 0, 0, 1}};
        byte[] byArray = new byte[]{0, 1, 1, 0, 0, 0, 1, 1};
        byte[][] byArray2 = new byte[256][8];
        byArray2[1][7] = 1;
        for (n3 = 2; n3 < 256; ++n3) {
            n5 = f[255 - c[n3]];
            for (n2 = 0; n2 < 8; ++n2) {
                byArray2[n3][n2] = (byte)(n5 >>> 7 - n2 & 1);
            }
        }
        byte[][] byArray3 = new byte[256][8];
        for (n3 = 0; n3 < 256; ++n3) {
            for (n2 = 0; n2 < 8; ++n2) {
                byArray3[n3][n2] = byArray[n2];
                for (n5 = 0; n5 < 8; ++n5) {
                    byte[] byArray4 = byArray3[n3];
                    int n6 = n2;
                    byArray4[n6] = (byte)(byArray4[n6] ^ byArrayArray[n2][n5] * byArray2[n3][n5]);
                }
            }
        }
        for (n3 = 0; n3 < 256; ++n3) {
            Rijndael.c[n3] = (byte)(byArray3[n3][0] << 7);
            for (n2 = 1; n2 < 8; ++n2) {
                int n7 = n3;
                c[n7] = (byte)(c[n7] ^ byArray3[n3][n2] << 7 - n2);
            }
            Rijndael.f[Rijndael.c[n3] & 0xFF] = (byte)n3;
        }
        byte[][] byArrayArray2 = new byte[][]{{2, 1, 1, 3}, {3, 2, 1, 1}, {1, 3, 2, 1}, {1, 1, 3, 2}};
        byte[][] byArray5 = new byte[4][8];
        for (n3 = 0; n3 < 4; ++n3) {
            for (n5 = 0; n5 < 4; ++n5) {
                byArray5[n3][n5] = byArrayArray2[n3][n5];
            }
            byArray5[n3][n3 + 4] = 1;
        }
        byte[][] byArray6 = new byte[4][4];
        for (n3 = 0; n3 < 4; ++n3) {
            byte by2 = byArray5[n3][n3];
            if (by2 == 0) {
                for (n2 = n3 + 1; byArray5[n2][n3] == 0 && n2 < 4; ++n2) {
                }
                if (n2 == 4) {
                    throw new RuntimeException("G matrix is not invertible");
                }
                for (n5 = 0; n5 < 8; ++n5) {
                    byte by3 = byArray5[n3][n5];
                    byArray5[n3][n5] = byArray5[n2][n5];
                    byArray5[n2][n5] = by3;
                }
                by2 = byArray5[n3][n3];
            }
            for (n5 = 0; n5 < 8; ++n5) {
                if (byArray5[n3][n5] == 0) continue;
                byArray5[n3][n5] = (byte)f[(255 + c[byArray5[n3][n5] & 0xFF] - c[by2 & 0xFF]) % 255];
            }
            for (n2 = 0; n2 < 4; ++n2) {
                if (n3 == n2) continue;
                for (n5 = n3 + 1; n5 < 8; ++n5) {
                    byte[] byArray7 = byArray5[n2];
                    int n8 = n5;
                    byArray7[n8] = (byte)(byArray7[n8] ^ Rijndael.a((int)byArray5[n3][n5], byArray5[n2][n3]));
                }
                byArray5[n2][n3] = 0;
            }
        }
        for (n3 = 0; n3 < 4; ++n3) {
            for (n5 = 0; n5 < 4; ++n5) {
                byArray6[n3][n5] = byArray5[n3][n5 + 4];
            }
        }
        for (n2 = 0; n2 < 256; ++n2) {
            byte by4 = c[n2];
            Rijndael.j[n2] = Rijndael.a((int)by4, byArrayArray2[0]);
            Rijndael.l[n2] = Rijndael.a((int)by4, byArrayArray2[1]);
            Rijndael.a[n2] = Rijndael.a((int)by4, byArrayArray2[2]);
            Rijndael.e[n2] = Rijndael.a((int)by4, byArrayArray2[3]);
            by4 = f[n2];
            Rijndael.h[n2] = Rijndael.a((int)by4, byArray6[0]);
            Rijndael.d[n2] = Rijndael.a((int)by4, byArray6[1]);
            Rijndael.n[n2] = Rijndael.a((int)by4, byArray6[2]);
            Rijndael.k[n2] = Rijndael.a((int)by4, byArray6[3]);
            Rijndael.g[n2] = Rijndael.a(n2, byArray6[0]);
            Rijndael.i[n2] = Rijndael.a(n2, byArray6[1]);
            Rijndael.m[n2] = Rijndael.a(n2, byArray6[2]);
            Rijndael.b[n2] = Rijndael.a(n2, byArray6[3]);
        }
        Rijndael.e[0] = 1;
        int n9 = 1;
        n2 = 1;
        while (n2 < 30) {
            int n10 = n2++;
            n9 = Rijndael.a(2, n9);
            Rijndael.e[n10] = (byte)n9;
        }
    }
}

