/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.jca.security;

import com.mindbright.jca.security.InvalidAlgorithmParameterException;
import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.jca.security.InvalidParameterException;
import com.mindbright.jca.security.NoSuchAlgorithmException;
import com.mindbright.jca.security.NoSuchProviderException;
import com.mindbright.jca.security.PrivateKey;
import com.mindbright.jca.security.Provider;
import com.mindbright.jca.security.ProviderLookup;
import com.mindbright.jca.security.PublicKey;
import com.mindbright.jca.security.SecureRandom;
import com.mindbright.jca.security.SignatureException;
import com.mindbright.jca.security.SignatureSpi;
import com.mindbright.jca.security.spec.AlgorithmParameterSpec;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Signature
extends SignatureSpi {
    protected static final int UNINITIALIZED = 0;
    protected static final int SIGN = 1;
    protected static final int VERIFY = 2;
    private final String[] a;
    protected int state;
    private SignatureSpi a;
    private Provider a;
    private String a = new String[]{"<uninitialized>", "<sign>", "<verify>"};

    protected Signature(String string) {
        this.a = string;
    }

    public static Signature getInstance(String string) throws NoSuchAlgorithmException {
        try {
            String string2 = ProviderLookup.findImplementingProvider("Signature", string);
            return Signature.getInstance(string, string2);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new Error("Error in Signature: " + noSuchProviderException);
        }
    }

    public static Signature getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        ProviderLookup providerLookup = ProviderLookup.getImplementation("Signature", string, string2);
        SignatureSpi signatureSpi = (SignatureSpi)providerLookup.getImpl();
        Signature signature = new Signature(string);
        signature.a = providerLookup.getProvider();
        signature.a = signatureSpi;
        return signature;
    }

    public final Provider getProvider() {
        return this.a;
    }

    public void initVerify(PublicKey publicKey) throws InvalidKeyException {
        this.a.engineInitVerify(publicKey);
        this.state = 2;
    }

    public void initSign(PrivateKey privateKey) throws InvalidKeyException {
        this.a.engineInitSign(privateKey);
        this.state = 1;
    }

    public void initSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.a.engineInitSign(privateKey, secureRandom);
        this.state = 1;
    }

    public byte[] sign() throws SignatureException {
        if (this.state != 1) {
            throw new SignatureException("Signature not initialized for signing");
        }
        return this.a.engineSign();
    }

    public int sign(byte[] byArray, int n2, int n3) throws SignatureException {
        if (this.state != 1) {
            throw new SignatureException("Signature not initialized for signing");
        }
        return this.a.engineSign(byArray, n2, n3);
    }

    public boolean verify(byte[] byArray) throws SignatureException {
        if (this.state != 2) {
            throw new SignatureException("Signature not initialized for verification");
        }
        return this.a.engineVerify(byArray);
    }

    public void update(byte by2) throws SignatureException {
        if (this.state == 0) {
            throw new SignatureException("Signature not initialized");
        }
        this.a.engineUpdate(by2);
    }

    public final void update(byte[] byArray) throws SignatureException {
        this.update(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n2, int n3) throws SignatureException {
        if (this.state == 0) {
            throw new SignatureException("Signature not initialized");
        }
        this.a.engineUpdate(byArray, n2, n3);
    }

    public final String getAlgorithm() {
        return this.a;
    }

    public final String toString() {
        return "Signature " + this.getAlgorithm() + " " + this.a[this.state] + " (" + this.a.getName() + ")";
    }

    public void setParameter(String string, Object object) throws InvalidParameterException {
        this.a.engineSetParameter(string, object);
    }

    public void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.a.engineSetParameter(algorithmParameterSpec);
    }

    public Object getParameter(String string) throws InvalidParameterException {
        return this.a.engineGetParameter(string);
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.a();
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.a();
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.a();
    }

    protected void engineUpdate(byte by2) throws SignatureException {
        this.a();
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        this.a();
    }

    protected byte[] engineSign() throws SignatureException {
        this.a();
        return null;
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        this.a();
        return false;
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        this.a();
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        this.a();
        return null;
    }

    private final void a() {
        throw new Error("Abstract method in SignatureSpi implementation missing");
    }
}

