/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.jca.security;

import com.mindbright.jca.security.NoSuchAlgorithmException;
import com.mindbright.jca.security.NoSuchProviderException;
import com.mindbright.jca.security.Provider;
import com.mindbright.jca.security.ProviderLookup;
import com.mindbright.jca.security.SecureRandomSpi;
import com.mindbright.security.prng.BlumBlumShub;
import com.mindbright.util.h;
import java.util.Random;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class SecureRandom
extends Random {
    SecureRandomSpi a;
    Provider a;

    public SecureRandom() {
        this(new BlumBlumShub(), null);
    }

    public SecureRandom(byte[] byArray) {
        this(new BlumBlumShub(byArray), null);
    }

    protected SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider) {
        super(0L);
        this.a = secureRandomSpi;
        this.a = provider;
    }

    public byte[] generateSeed(int n2) {
        return this.a.engineGenerateSeed(n2);
    }

    public static SecureRandom getInstance(String string) throws NoSuchAlgorithmException {
        try {
            String string2 = ProviderLookup.findImplementingProvider("SecureRandom", string);
            return SecureRandom.getInstance(string, string2);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new Error("Error in SecureRandom: " + noSuchProviderException);
        }
    }

    public static SecureRandom getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        ProviderLookup providerLookup = ProviderLookup.getImplementation("SecureRandom", string, string2);
        return new SecureRandom((SecureRandomSpi)providerLookup.getImpl(), providerLookup.getProvider());
    }

    public Provider getProvider() {
        return this.a;
    }

    public static byte[] getSeed(int n2) {
        h h2 = new h("/dev/random", "/dev/urandom");
        return h2.b(n2);
    }

    protected final int next(int n2) {
        int n3 = (n2 + 7) / 8;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        this.nextBytes(byArray);
        for (int i2 = 0; i2 < n3; ++i2) {
            n4 = (n4 << 8) + (byArray[i2] & 0xFF);
        }
        return n4 >>> n3 * 8 - n2;
    }

    public void nextBytes(byte[] byArray) {
        this.a.engineNextBytes(byArray);
    }

    public void setSeed(byte[] byArray) {
        this.a.engineSetSeed(byArray);
    }

    public void setSeed(long l2) {
        if (l2 == 0L) {
            return;
        }
        byte[] byArray = new byte[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            byArray[i2] = (byte)(l2 & 0xFFL);
            l2 >>= 8;
        }
        this.setSeed(byArray);
    }
}

