/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.util;

import com.mindbright.util.OutputStreamPipe;
import java.io.IOException;
import java.io.InputStream;

public final class InputStreamPipe
extends InputStream {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private OutputStreamPipe source;
    private byte[] circBuf;
    private int rOffset;
    private int wOffset;
    private boolean isWaitGet;
    private boolean isWaitPut;
    private boolean eof;
    private boolean closed;

    public InputStreamPipe(int n) {
        this.circBuf = new byte[n];
        this.isWaitGet = false;
        this.isWaitPut = false;
        this.rOffset = 0;
        this.wOffset = 0;
    }

    public InputStreamPipe() {
        this(8192);
    }

    public InputStreamPipe(OutputStreamPipe outputStreamPipe) throws IOException {
        this();
        this.connect(outputStreamPipe);
    }

    public void connect(OutputStreamPipe outputStreamPipe) throws IOException {
        if (this.source == outputStreamPipe) {
            return;
        }
        if (this.source != null) {
            throw new IOException("Pipe already connected");
        }
        this.source = outputStreamPipe;
        outputStreamPipe.connect(this);
    }

    public synchronized int read() throws IOException {
        while (this.isEmpty()) {
            if (this.closed) {
                throw new IOException("InputStreamPipe closed");
            }
            if (this.eof) {
                return -1;
            }
            this.isWaitGet = true;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.isWaitGet = false;
        int n = this.circBuf[this.rOffset++] & 0xFF;
        if (this.rOffset == this.circBuf.length) {
            this.rOffset = 0;
        }
        if (this.isWaitPut) {
            this.notifyAll();
            this.isWaitPut = false;
        }
        return n;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        while (this.isEmpty()) {
            if (this.closed) {
                throw new IOException("InputStreamPipe closed");
            }
            if (this.eof) {
                return -1;
            }
            this.isWaitGet = true;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.isWaitGet = false;
        int n3 = this.available();
        int n4 = n3 = n3 > n2 ? n2 : n3;
        if (this.rOffset < this.wOffset) {
            System.arraycopy(this.circBuf, this.rOffset, byArray, n, n3);
        } else {
            int n5 = this.circBuf.length - this.rOffset;
            if (n5 < n3) {
                System.arraycopy(this.circBuf, this.rOffset, byArray, n, n5);
                System.arraycopy(this.circBuf, 0, byArray, n + n5, n3 - n5);
            } else {
                System.arraycopy(this.circBuf, this.rOffset, byArray, n, n3);
            }
        }
        this.rOffset += n3;
        if (this.rOffset >= this.circBuf.length) {
            this.rOffset -= this.circBuf.length;
        }
        if (this.isWaitPut) {
            this.notifyAll();
            this.isWaitPut = false;
        }
        return n3;
    }

    public synchronized int available() {
        return this.circBuf.length - this.freeSpace() - 1;
    }

    public synchronized void close() throws IOException {
        this.closed = true;
        this.notifyAll();
    }

    public synchronized void flush() {
        this.notifyAll();
    }

    protected synchronized void put(int n) throws IOException {
        this.putFlowControl();
        this.circBuf[this.wOffset++] = (byte)n;
        if (this.wOffset == this.circBuf.length) {
            this.wOffset = 0;
        }
        if (this.isWaitGet) {
            this.notify();
        }
    }

    protected synchronized void put(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            this.putFlowControl();
            int n3 = this.freeSpace();
            int n4 = n3 = n3 > n2 ? n2 : n3;
            if (this.wOffset < this.rOffset) {
                System.arraycopy(byArray, n, this.circBuf, this.wOffset, n3);
            } else {
                int n5 = this.circBuf.length - this.wOffset;
                if (n5 < n3) {
                    System.arraycopy(byArray, n, this.circBuf, this.wOffset, n5);
                    System.arraycopy(byArray, n + n5, this.circBuf, 0, n3 - n5);
                } else {
                    System.arraycopy(byArray, n, this.circBuf, this.wOffset, n3);
                }
            }
            this.wOffset += n3;
            if (this.wOffset >= this.circBuf.length) {
                this.wOffset -= this.circBuf.length;
            }
            n2 -= n3;
            n += n3;
            if (!this.isWaitGet) continue;
            this.notify();
        }
    }

    protected synchronized void eof() {
        this.eof = true;
        this.notifyAll();
    }

    private int freeSpace() {
        int n = this.rOffset - this.wOffset;
        if (n <= 0) {
            n += this.circBuf.length;
        }
        return --n;
    }

    private synchronized boolean isEmpty() {
        return this.rOffset == this.wOffset || this.closed;
    }

    private void putFlowControl() throws IOException {
        if (this.eof) {
            throw new IOException("InputStreamPipe already got eof");
        }
        if (this.closed) {
            throw new IOException("InputStreamPipe closed");
        }
        while (this.freeSpace() == 0) {
            this.isWaitPut = true;
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.eof) {
                throw new IOException("InputStreamPipe already got eof");
            }
            if (!this.closed) continue;
            throw new IOException("InputStreamPipe closed");
        }
    }
}

