/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2Connection;
import com.mindbright.ssh2.SSH2Exception;
import com.mindbright.ssh2.SSH2FatalException;
import com.mindbright.ssh2.SSH2SFTP;
import com.mindbright.ssh2.SSH2SFTPClient;
import com.mindbright.sshcommon.SSHFileTransfer;
import com.mindbright.sshcommon.SSHFileTransferProgress;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SSH2SFTPTransfer
implements SSHFileTransfer,
SSH2SFTP.AsyncListener {
    private SSHFileTransferProgress progress = null;
    private SSH2SFTPClient client;
    private File cwd;

    public SSH2SFTPTransfer(File file, SSH2Connection sSH2Connection) throws SSH2Exception {
        try {
            this.cwd = file;
            this.client = new SSH2SFTPClient(sSH2Connection, false);
        }
        catch (SSH2SFTP.SFTPException sFTPException) {
            throw new SSH2FatalException("Could not start sftp session", sFTPException);
        }
    }

    public void setProgress(SSHFileTransferProgress sSHFileTransferProgress) {
        this.progress = sSHFileTransferProgress;
    }

    public void copyToRemote(String[] stringArray, String string, boolean bl) throws IOException {
        if (string == null || string.equals("")) {
            string = "./";
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(stringArray[i]);
            if (!file.isAbsolute()) {
                file = new File(this.cwd, stringArray[i]);
            }
            if (!file.isFile() && !file.isDirectory()) {
                throw new IOException("File: " + file.getName() + " is not a regular file or directory");
            }
            try {
                this.writeFileToRemote(file, string, bl);
                continue;
            }
            catch (SSH2SFTP.SFTPException sFTPException) {
                throw new IOException("Error writing file: " + sFTPException.getMessage());
            }
        }
    }

    public void copyToLocal(String string, String[] stringArray, boolean bl) throws IOException {
        File file;
        if (string == null || string.equals("")) {
            string = ".";
        }
        if (!(file = new File(string)).isAbsolute()) {
            file = new File(this.cwd, string);
        }
        if (file.exists() && !file.isFile() && !file.isDirectory()) {
            throw new IOException("File: " + string + " is not a regular file or directory");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            try {
                this.readFileFromRemote(string2, string, bl);
                continue;
            }
            catch (SSH2SFTP.SFTPException sFTPException) {
                sFTPException.printStackTrace();
                throw new IOException(sFTPException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileToRemote(File file, String string, boolean bl) throws IOException, SSH2SFTP.SFTPException {
        String string2 = file.getName();
        if (file.isDirectory() && bl) {
            this.writeDirToRemote(file, string);
        } else if (file.isFile()) {
            String string3;
            if (this.progress != null) {
                this.progress.startFile(string2, file.length());
            }
            SSH2SFTP.FileAttributes fileAttributes = null;
            try {
                fileAttributes = this.client.stat(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (fileAttributes != null && fileAttributes.isDirectory()) {
                if (!string.endsWith("/")) {
                    string = string + "/";
                }
                string3 = string + string2;
            } else {
                string3 = string;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            SSH2SFTP.FileHandle fileHandle = null;
            try {
                fileHandle = this.client.open(string3, 26, new SSH2SFTP.FileAttributes());
                fileHandle.addAsyncListener(this);
                this.client.writeFully(fileHandle, fileInputStream);
            }
            finally {
                fileInputStream.close();
            }
            if (this.progress != null) {
                this.progress.endFile();
            }
        } else {
            throw new IOException("Not ordinary file: " + string2);
        }
    }

    private void writeDirToRemote(File file, String string) throws IOException, SSH2SFTP.SFTPException {
        if (this.progress != null) {
            this.progress.startDir(file.getAbsolutePath());
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        string = string + file.getName();
        try {
            this.client.stat(string);
        }
        catch (SSH2SFTP.SFTPException sFTPException) {
            this.client.mkdir(string, new SSH2SFTP.FileAttributes());
        }
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            this.writeFileToRemote(file2, string, true);
        }
        if (this.progress != null) {
            this.progress.endDir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readFileFromRemote(String string, String string2, boolean bl) throws IOException, SSH2SFTP.SFTPException {
        int n;
        SSH2SFTP.FileAttributes[] fileAttributesArray;
        SSH2SFTP.FileAttributes fileAttributes = this.client.stat(string);
        SSH2SFTP.FileHandle fileHandle = null;
        File file = new File(string2);
        if (file.isDirectory()) {
            fileAttributesArray = string;
            n = string.lastIndexOf(47);
            if (n != -1) {
                fileAttributesArray = string.substring(n + 1);
            }
            file = new File(file, (String)fileAttributesArray);
        }
        if (fileAttributes.isDirectory() && bl) {
            if (file.exists()) {
                if (!file.isDirectory()) {
                    throw new IOException("Invalid target " + file.getName() + ", must be a directory");
                }
            } else if (!file.mkdir()) {
                throw new IOException("Could not create directory: " + file.getName());
            }
            fileHandle = this.client.opendir(string);
            fileAttributesArray = this.client.readdir(fileHandle);
            for (n = 0; n < fileAttributesArray.length; ++n) {
                String string3 = fileAttributesArray[n].name;
                if ("..".equals(string3) || ".".equals(string3)) continue;
                this.readFileFromRemote(string + "/" + string3, file.getAbsolutePath(), bl);
            }
            return;
        } else {
            if (!fileAttributes.isFile()) throw new IOException("Not ordinary file: " + string);
            fileAttributesArray = new FileOutputStream(file);
            try {
                fileHandle = this.client.open(string, 1, new SSH2SFTP.FileAttributes());
                if (this.progress != null) {
                    this.progress.startFile(file.getName(), fileAttributes.hasSize ? fileAttributes.size : -1L);
                }
                fileHandle.addAsyncListener(this);
                this.client.readFully(fileHandle, (OutputStream)fileAttributesArray);
                if (this.progress == null) return;
                this.progress.endFile();
                return;
            }
            finally {
                fileAttributesArray.close();
            }
        }
    }

    public void abort() {
        if (this.client != null) {
            this.client.terminate();
        }
    }

    public void progress(long l) {
        if (this.progress != null) {
            this.progress.progress((int)l);
        }
    }
}

