/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2Channel;
import com.mindbright.ssh2.SSH2ConnectException;
import com.mindbright.ssh2.SSH2Connection;
import com.mindbright.ssh2.SSH2StreamFilterFactory;
import com.mindbright.ssh2.SSH2TCPChannel;
import com.mindbright.ssh2.SSH2TransportPDU;
import com.mindbright.ssh2.SSH2X11Filter;
import com.mindbright.util.Queue;
import java.io.IOException;
import java.net.Socket;

public final class SSH2Connector
implements Runnable {
    private Queue openQueue;
    private Thread myThread;
    private SSH2Connection connection;
    private volatile boolean keepRunning;

    public SSH2Connector(SSH2Connection sSH2Connection) {
        this.connection = sSH2Connection;
        this.openQueue = new Queue();
        this.keepRunning = true;
        this.myThread = new Thread((Runnable)this, "SSH2Connector");
        this.myThread.setDaemon(true);
        this.myThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.keepRunning) {
            SSH2TransportPDU sSH2TransportPDU = null;
            SSH2Channel sSH2Channel = null;
            String string = "<unknown>";
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            String string2 = "<unknown>";
            int n4 = -1;
            String string3 = "<unknown>";
            int n5 = -1;
            try {
                String string4;
                sSH2TransportPDU = (SSH2TransportPDU)this.openQueue.getFirst();
                if (sSH2TransportPDU == null) {
                    this.keepRunning = false;
                    continue;
                }
                string = sSH2TransportPDU.readJavaString();
                n = sSH2TransportPDU.readInt();
                n2 = sSH2TransportPDU.readInt();
                n3 = sSH2TransportPDU.readInt();
                if (string.equals("forwarded-tcpip")) {
                    string4 = sSH2TransportPDU.readJavaString();
                    int n6 = sSH2TransportPDU.readInt();
                    string3 = sSH2TransportPDU.readJavaString();
                    n5 = sSH2TransportPDU.readInt();
                    this.connection.getLog().debug("SSH2Connection", "run", "remote connect on " + string4 + ":" + n6 + " (orig. " + string3 + ":" + n5 + ")");
                    String[] stringArray = this.connection.getForwardTarget(string4, n6);
                    SSH2StreamFilterFactory sSH2StreamFilterFactory = this.connection.getForwardFilterFactory(string4, n6);
                    if (stringArray == null) {
                        throw new IOException("Unsolicited forward attempted");
                    }
                    string2 = stringArray[0];
                    n4 = Integer.valueOf(stringArray[1]);
                    this.connection.getLog().notice("SSH2Connector", "connect: " + stringArray[0] + ":" + stringArray[1] + " (peerid: " + n + ")");
                    sSH2Channel = this.connect(string, n, n2, n3, string4, n6, string2, n4, string3, n5, sSH2StreamFilterFactory);
                    this.connection.getEventHandler().remoteForwardedConnect(this.connection, string4, n6, sSH2Channel);
                    continue;
                }
                if (string.equals("direct-tcpip")) {
                    string2 = sSH2TransportPDU.readJavaString();
                    n4 = sSH2TransportPDU.readInt();
                    string3 = sSH2TransportPDU.readJavaString();
                    n5 = sSH2TransportPDU.readInt();
                    sSH2Channel = this.connect(string, n, n2, n3, string2, n4, string3, n5, null);
                    this.connection.getEventHandler().remoteDirectConnect(this.connection, sSH2Channel);
                    continue;
                }
                if (string.equals("x11")) {
                    string4 = this.connection.getPreferences().getPreference("x11-display");
                    int n7 = string4.indexOf(":");
                    if (n7 != -1) {
                        string2 = string4.substring(0, n7);
                        n4 = Integer.parseInt(string4.substring(n7 + 1));
                    } else {
                        string2 = string4;
                        n4 = 6000;
                    }
                    if (n4 <= 10) {
                        n4 += 6000;
                    }
                    string3 = sSH2TransportPDU.readJavaString();
                    n5 = sSH2TransportPDU.readInt();
                    if (!this.connection.hasX11Mapping()) {
                        throw new IOException("Unexpected X11 channel open");
                    }
                    sSH2Channel = this.connect(string, n, n2, n3, string2, n4, string3, n5, SSH2X11Filter.getFilterFactory());
                    this.connection.getEventHandler().remoteX11Connect(this.connection, sSH2Channel);
                    continue;
                }
                if (string.equals("session")) {
                    throw new IOException("Unexpected session channel open");
                }
                if (string.equals("auth-agent")) {
                    throw new IOException("Agent forwarding not supported");
                }
                throw new IOException("Unknown channel type: " + string);
            }
            catch (IOException iOException) {
                String string5 = "open failed: " + iOException.getMessage();
                this.connection.getLog().error("SSH2Connector", "run", string5);
                this.sendOpenFailure(n, 2, string5);
                this.connection.getEventHandler().remoteChannelOpenFailure(this.connection, string, string2, n4, string3, n5, new SSH2ConnectException("Failed in SSH2Connector", iOException));
            }
            finally {
                if (sSH2TransportPDU == null) continue;
                sSH2TransportPDU.release();
            }
        }
    }

    public void channelOpen(SSH2TransportPDU sSH2TransportPDU) {
        this.openQueue.putLast(sSH2TransportPDU);
    }

    public void setThreadPriority(int n) {
        this.myThread.setPriority(n);
    }

    public void stop() {
        this.keepRunning = false;
        this.openQueue.setBlocking(false);
    }

    private SSH2Channel connect(String string, int n, int n2, int n3, String string2, int n4, String string3, int n5, SSH2StreamFilterFactory sSH2StreamFilterFactory) throws IOException {
        return this.connect(string, n, n2, n3, "<N/A>", 0, string2, n4, string3, n5, sSH2StreamFilterFactory);
    }

    private SSH2Channel connect(String string, int n, int n2, int n3, String string2, int n4, String string3, int n5, String string4, int n6, SSH2StreamFilterFactory sSH2StreamFilterFactory) throws IOException {
        Socket socket = new Socket(string3, n5);
        int n7 = 0;
        for (n7 = 0; n7 < SSH2Connection.channelTypes.length && !SSH2Connection.channelTypes[n7].equals(string); ++n7) {
        }
        if (n7 == SSH2Connection.channelTypes.length) {
            throw new IOException("Invalid channelType: " + string);
        }
        SSH2TCPChannel sSH2TCPChannel = new SSH2TCPChannel(n7, this.connection, this, socket, string2, n4, string4, n6);
        sSH2TCPChannel.init(n, n2, n3);
        this.connection.setSocketOptions("remote." + string2 + "." + n4, socket);
        this.connection.getEventHandler().channelConnect(this, sSH2TCPChannel, socket);
        if (sSH2StreamFilterFactory != null) {
            sSH2TCPChannel.applyFilter(sSH2StreamFilterFactory.createFilter(this.connection, sSH2TCPChannel));
        }
        this.sendOpenConfirmation(sSH2TCPChannel);
        sSH2TCPChannel.startStreams();
        return sSH2TCPChannel;
    }

    private void sendOpenConfirmation(SSH2Channel sSH2Channel) {
        SSH2TransportPDU sSH2TransportPDU = SSH2TransportPDU.createOutgoingPacket(91);
        sSH2TransportPDU.writeInt(sSH2Channel.peerChanId);
        sSH2TransportPDU.writeInt(sSH2Channel.channelId);
        sSH2TransportPDU.writeInt(sSH2Channel.rxInitWinSz);
        sSH2TransportPDU.writeInt(sSH2Channel.rxMaxPktSz);
        this.connection.transmit(sSH2TransportPDU);
    }

    private void sendOpenFailure(int n, int n2, String string) {
        SSH2TransportPDU sSH2TransportPDU = SSH2TransportPDU.createOutgoingPacket(92);
        sSH2TransportPDU.writeInt(n);
        sSH2TransportPDU.writeInt(n2);
        if (!this.connection.getTransport().incompatibleChannelOpenFail) {
            sSH2TransportPDU.writeString(string);
            sSH2TransportPDU.writeString("");
        }
        this.connection.transmit(sSH2TransportPDU);
    }
}

